/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class CifReader
extends AtomSetCollectionReader {
    private RidiculousFileFormatTokenizer tokenizer = new RidiculousFileFormatTokenizer();
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private Hashtable htHetero;
    public static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"};
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    private String key;
    private String data;
    private Hashtable atomTypes;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_U11 = 21;
    private static final byte ANISO_U22 = 22;
    private static final byte ANISO_U33 = 23;
    private static final byte ANISO_U12 = 24;
    private static final byte ANISO_U13 = 25;
    private static final byte ANISO_U23 = 26;
    private static final byte ANISO_MMCIF_U11 = 27;
    private static final byte ANISO_MMCIF_U22 = 28;
    private static final byte ANISO_MMCIF_U33 = 29;
    private static final byte ANISO_MMCIF_U12 = 30;
    private static final byte ANISO_MMCIF_U13 = 31;
    private static final byte ANISO_MMCIF_U23 = 32;
    private static final byte U_ISO_OR_EQUIV = 33;
    private static final byte ANISO_B11 = 34;
    private static final byte ANISO_B22 = 35;
    private static final byte ANISO_B33 = 36;
    private static final byte ANISO_B12 = 37;
    private static final byte ANISO_B13 = 38;
    private static final byte ANISO_B23 = 39;
    private static final byte ANISO_Beta_11 = 40;
    private static final byte ANISO_Beta_22 = 41;
    private static final byte ANISO_Beta_33 = 42;
    private static final byte ANISO_Beta_12 = 43;
    private static final byte ANISO_Beta_13 = 44;
    private static final byte ANISO_Beta_23 = 45;
    private static final byte ADP_TYPE = 46;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_Cartn_x", "_atom_site_Cartn_y", "_atom_site_Cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_PDB_ins_code", "_atom_site_label_alt_id", "_atom_site_group_PDB", "_atom_site_pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_aniso_U_11", "_atom_site_aniso_U_22", "_atom_site_aniso_U_33", "_atom_site_aniso_U_12", "_atom_site_aniso_U_13", "_atom_site_aniso_U_23", "_atom_site_anisotrop_U[1][1]", "_atom_site_anisotrop_U[2][2]", "_atom_site_anisotrop_U[3][3]", "_atom_site_anisotrop_U[1][2]", "_atom_site_anisotrop_U[1][3]", "_atom_site_anisotrop_U[2][3]", "_atom_site_U_iso_or_equiv", "_atom_site_aniso_B_11", "_atom_site_aniso_B_22", "_atom_site_aniso_B_33", "_atom_site_aniso_B_12", "_atom_site_aniso_B_13", "_atom_site_aniso_B_23", "_atom_site_aniso_Beta_11", "_atom_site_aniso_Beta_22", "_atom_site_aniso_Beta_33", "_atom_site_aniso_Beta_12", "_atom_site_aniso_Beta_13", "_atom_site_aniso_Beta_23", "_atom_site_adp_type"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_SITE_SYMMETRY_2 = 2;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2"};
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_PDB_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_PDB_ins_code"};
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_PDB_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_PDB_ins_code"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private int siteNum;
    private Hashtable htSites;
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
    int fieldCount;
    String[] loopData;
    String field;
    private char firstChar;
    private int[] propertyOf = new int[100];
    private byte[] fieldOf = new byte[atomFields.length];
    private int propertyCount;

    public void readAtomSetCollection(BufferedReader reader) {
        int nAtoms = 0;
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("cif");
        this.line = "";
        boolean skipping = false;
        try {
            while ((this.key = this.tokenizer.peekToken()) != null) {
                if (this.key.startsWith("data_")) {
                    if (this.iHaveDesiredModel) break;
                    boolean bl = skipping = !this.doGetModel(++this.modelNumber);
                    if (skipping) {
                        this.tokenizer.getTokenPeeked();
                        continue;
                    }
                    this.chemicalName = "";
                    this.thisStructuralFormula = "";
                    this.thisFormula = "";
                    if (nAtoms == this.atomSetCollection.getAtomCount()) {
                        this.atomSetCollection.removeAtomSet();
                    } else {
                        this.applySymmetryAndSetTrajectory();
                    }
                    this.processDataParameter();
                    this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
                    nAtoms = this.atomSetCollection.getAtomCount();
                    continue;
                }
                if (this.key.startsWith("loop_")) {
                    if (skipping) {
                        this.tokenizer.getTokenPeeked();
                        this.skipLoop();
                        continue;
                    }
                    this.processLoopBlock();
                    continue;
                }
                if (this.key.indexOf("_") != 0) {
                    Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
                    this.tokenizer.getTokenPeeked();
                } else if (!this.getData()) continue;
                if (skipping) continue;
                this.key = this.key.replace('.', '_');
                if (this.key.startsWith("_chemical_name")) {
                    this.processChemicalInfo("name");
                    continue;
                }
                if (this.key.startsWith("_chemical_formula_structural")) {
                    this.processChemicalInfo("structuralFormula");
                    continue;
                }
                if (this.key.startsWith("_chemical_formula_sum")) {
                    this.processChemicalInfo("formula");
                    continue;
                }
                if (this.key.startsWith("_cell_")) {
                    this.processCellParameter();
                    continue;
                }
                if (this.key.startsWith("_symmetry_space_group_name_H-M") || this.key.startsWith("_symmetry_space_group_name_Hall")) {
                    this.processSymmetrySpaceGroupName();
                    continue;
                }
                if (this.key.startsWith("_atom_sites_fract_tran")) {
                    this.processUnitCellTransformMatrix();
                    continue;
                }
                if (!this.key.startsWith("_pdbx_entity_nonpoly")) continue;
                this.processNonpolyData();
            }
            if (this.atomSetCollection.getAtomCount() == nAtoms) {
                this.atomSetCollection.removeAtomSet();
            } else {
                this.applySymmetryAndSetTrajectory();
            }
            if (this.htSites != null) {
                this.addSites(this.htSites);
            }
            this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.getAtomSetCount() + " models>");
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void processDataParameter() {
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
                this.atomSetCollection.newAtomSet();
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        Logger.debug(this.key);
    }

    private void processChemicalInfo(String type) throws Exception {
        if (type.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
        } else if (type.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (type.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug(type + " = " + this.data);
        }
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        this.setSpaceGroupName(this.data);
    }

    private void processCellParameter() throws Exception {
        int i = cellParamNames.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(this.key, cellParamNames[i])) continue;
            this.setUnitCellItem(i, this.parseFloat(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float v = this.parseFloat(this.data);
        if (Float.isNaN(v)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, v);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String str = this.tokenizer.peekToken();
        if (str == null) {
            return;
        }
        if (str.startsWith("_atom_site_") || str.startsWith("_atom_site.")) {
            if (!this.processAtomSiteLoopBlock()) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (str.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (str.startsWith("_geom_bond")) {
            if (this.doApplySymmetry && !this.applySymmetryToBonds) {
                this.skipLoop();
            } else {
                this.processGeomBondLoopBlock();
            }
            return;
        }
        if (str.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (str.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (str.startsWith("_struct_conf") && !str.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (str.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (str.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (str.startsWith("_symmetry_equiv_pos") || str.startsWith("space_group_symop")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (str.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        this.skipLoop();
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.fieldOf[i] != -1) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String atomTypeSymbol = null;
            float oxidationNumber = Float.NaN;
            block7: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                switch (this.fieldProperty(i2)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        atomTypeSymbol = this.field;
                        continue block7;
                    }
                    case 1: {
                        oxidationNumber = this.parseFloat(this.field);
                    }
                }
            }
            if (atomTypeSymbol == null || Float.isNaN(oxidationNumber)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable();
            }
            this.atomTypes.put(atomTypeSymbol, new Float(oxidationNumber));
        }
    }

    boolean processAtomSiteLoopBlock() throws Exception {
        int currentModelNO = -1;
        boolean isPDB = false;
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[6] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] == -1) {
            this.skipLoop();
            return false;
        }
        while (this.tokenizer.getData()) {
            Atom atom = new Atom();
            block24: for (int i = 0; i < this.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block24;
                    }
                    case 0: {
                        char ch1;
                        String elementSymbol = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol(this.firstChar, ch1 = Character.toLowerCase(this.field.charAt(1))) ? "" + this.firstChar + ch1 : "" + this.firstChar);
                        atom.elementSymbol = elementSymbol;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block24;
                        float charge = ((Float)this.atomTypes.get(this.field)).floatValue();
                        atom.formalCharge = (int)((double)charge + (charge < 0.0f ? -0.5 : 0.5));
                        if (!((double)Math.abs((float)atom.formalCharge - charge) > 0.1) || !Logger.debugging) continue block24;
                        Logger.debug("CIF charge on " + this.field + " was " + charge + "; rounded to " + atom.formalCharge);
                        continue block24;
                    }
                    case 1: 
                    case 2: {
                        atom.atomName = this.field;
                        continue block24;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(this.field);
                        continue block24;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(this.field);
                        continue block24;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(this.field);
                        continue block24;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloat(this.field);
                        if (Float.isNaN(floatOccupancy)) continue block24;
                        atom.occupancy = (int)(floatOccupancy * 100.0f);
                        continue block24;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(this.field) * 100.0f;
                        continue block24;
                    }
                    case 11: {
                        atom.group3 = this.field;
                        continue block24;
                    }
                    case 12: {
                        if (this.field.length() > 1) {
                            Logger.warn("Don't know how to deal with chains more than 1 char: " + this.field);
                        }
                        atom.chainID = this.firstChar;
                        continue block24;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(this.field);
                        continue block24;
                    }
                    case 14: {
                        atom.chainID = this.firstChar;
                        continue block24;
                    }
                    case 15: 
                    case 19: {
                        atom.alternateLocationID = this.firstChar;
                        continue block24;
                    }
                    case 16: {
                        isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block24;
                        atom.isHetero = true;
                        continue block24;
                    }
                    case 17: {
                        int modelNO = this.parseInt(this.field);
                        if (modelNO == currentModelNO) continue block24;
                        this.atomSetCollection.newAtomSet();
                        currentModelNO = modelNO;
                        continue block24;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block24;
                        atom.x = Float.NaN;
                        continue block24;
                    }
                    case 46: {
                        byte j;
                        if (!this.field.equalsIgnoreCase("Uiso") || (j = this.fieldOf[33]) == -1) continue block24;
                        if (atom.anisoBorU == null) {
                            atom.anisoBorU = new float[8];
                        }
                        atom.anisoBorU[7] = this.parseFloat(this.loopData[j]);
                        atom.anisoBorU[6] = 8.0f;
                        continue block24;
                    }
                    case 20: {
                        int iAtom = this.atomSetCollection.getAtomNameIndex(this.field);
                        if (iAtom < 0) {
                            return false;
                        }
                        atom = this.atomSetCollection.getAtom(iAtom);
                        continue block24;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: {
                        if (atom.anisoBorU == null) {
                            atom.anisoBorU = new float[8];
                        }
                        int iType = (this.propertyOf[i] - 21) % 6;
                        atom.anisoBorU[iType] = this.parseFloat(this.field);
                        atom.anisoBorU[6] = 8.0f;
                        continue block24;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        if (atom.anisoBorU == null) {
                            atom.anisoBorU = new float[8];
                        }
                        int iTypeB = (this.propertyOf[i] - 34) % 6;
                        atom.anisoBorU[iTypeB] = this.parseFloat(this.field);
                        atom.anisoBorU[6] = 4.0f;
                        continue block24;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        if (atom.anisoBorU == null) {
                            atom.anisoBorU = new float[8];
                        }
                        int iTypeBeta = (this.propertyOf[i] - 40) % 6;
                        atom.anisoBorU[iTypeBeta] = this.parseFloat(this.field);
                        atom.anisoBorU[6] = 0.0f;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (this.fieldOf[20] != -1 || this.filter != null && !this.filterAtom(atom)) continue;
            this.setAtomCoord(atom);
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (isPDB) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        return true;
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.fieldOf[i] != -1) continue;
            Logger.warn("?que? missing _geom_bond property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            int atomIndex1 = -1;
            int atomIndex2 = -1;
            block7: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                switch (this.fieldProperty(i2)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        atomIndex1 = this.atomSetCollection.getAtomNameIndex(this.field);
                        continue block7;
                    }
                    case 1: {
                        atomIndex2 = this.atomSetCollection.getAtomNameIndex(this.field);
                        continue block7;
                    }
                }
            }
            if (atomIndex1 < 0 || atomIndex2 < 0) continue;
            Bond bond = new Bond();
            bond.atomIndex1 = atomIndex1;
            bond.atomIndex2 = atomIndex2;
            this.atomSetCollection.addBond(bond);
        }
    }

    private void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int i = nonpolyFields.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[i])) continue;
            this.hetatmData[i] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String groupName = null;
            String hetName = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        groupName = this.field;
                        continue block6;
                    }
                    case 1: {
                        hetName = this.field;
                    }
                }
            }
            if (groupName == null || hetName == null) {
                return;
            }
            this.addHetero(groupName, hetName);
        }
    }

    private void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String groupName = null;
            String hetName = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        groupName = this.field;
                        continue block6;
                    }
                    case 1: {
                        hetName = this.field;
                    }
                }
            }
            if (groupName == null || hetName == null) {
                return;
            }
            this.addHetero(groupName, hetName);
        }
    }

    private void addHetero(String groupName, String hetName) {
        if (!JmolAdapter.isHetero(groupName)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        this.htHetero.put(groupName, hetName);
        if (Logger.debugging) {
            Logger.debug("hetero: " + groupName + " = " + hetName);
        }
    }

    private void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.fieldOf[i] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            block12: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                switch (this.fieldProperty(i2)) {
                    case -1: {
                        continue block12;
                    }
                    case 0: {
                        if (this.field.startsWith("HELX")) {
                            structure.structureType = "helix";
                            continue block12;
                        }
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = "turn";
                            continue block12;
                        }
                        structure.structureType = "none";
                        continue block12;
                    }
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.fieldOf[i] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            structure.structureType = "sheet";
            block10: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                switch (this.fieldProperty(i2)) {
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block10;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block10;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block10;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block10;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block10;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int i = 3;
        while (--i >= 0) {
            if (this.fieldOf[i] != -1) continue;
            Logger.warn("?que? missing _struct_site property:" + i);
            this.skipLoop();
            return;
        }
        String siteID = "";
        String seqNum = "";
        String insCode = "";
        String chainID = "";
        String resID = "";
        String group = "";
        Hashtable<String, String> htSite = null;
        this.htSites = new Hashtable();
        while (this.tokenizer.getData()) {
            for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                switch (this.fieldProperty(i2)) {
                    case 0: {
                        if (group != "") {
                            String groups = (String)htSite.get("groups");
                            groups = groups + (groups.length() == 0 ? "" : ",") + group;
                            group = "";
                            htSite.put("groups", groups);
                        }
                        if ((htSite = (Hashtable)this.htSites.get(siteID = this.field)) == null) {
                            htSite = new Hashtable<String, String>();
                            htSite.put("seqNum", "site_" + ++this.siteNum);
                            htSite.put("groups", "");
                            this.htSites.put(siteID, htSite);
                        }
                        seqNum = "";
                        insCode = "";
                        chainID = "";
                        resID = "";
                        break;
                    }
                    case 1: {
                        resID = this.field;
                        break;
                    }
                    case 2: {
                        chainID = this.field;
                        break;
                    }
                    case 3: {
                        seqNum = this.field;
                        break;
                    }
                    case 4: {
                        insCode = this.field;
                    }
                }
                if (seqNum == "" || resID == "") continue;
                group = "[" + resID + "]" + seqNum + (insCode.length() > 0 ? "^" + insCode : "") + (chainID.length() > 0 ? ":" + chainID : "");
            }
        }
        if (group != "") {
            String groups = (String)htSite.get("groups");
            groups = groups + (groups.length() == 0 ? "" : ",") + group;
            group = "";
            htSite.put("groups", groups);
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int nRefs = 0;
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.fieldOf[i] == -1) continue;
            ++nRefs;
        }
        if (nRefs != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (i = 0; i < this.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: 
                    case 1: {
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
    }

    private int fieldProperty(int i) {
        this.field = this.loopData[i];
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[i] : -1;
    }

    private void parseLoopParameters(String[] fields) throws Exception {
        this.fieldCount = 0;
        int i = fields.length;
        while (--i >= 0) {
            this.fieldOf[i] = -1;
        }
        this.propertyCount = fields.length;
        while (true) {
            String str;
            if ((str = this.tokenizer.peekToken()) == null) {
                this.fieldCount = 0;
                break;
            }
            if (str.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.propertyOf[this.fieldCount] = -1;
            int i2 = fields.length;
            while (--i2 >= 0) {
                if (!CifReader.isMatch(str, fields[i2])) continue;
                this.propertyOf[this.fieldCount] = i2;
                this.fieldOf[i2] = (byte)this.fieldCount;
                break;
            }
            ++this.fieldCount;
        }
        if (this.fieldCount > 0) {
            this.loopData = new String[this.fieldCount];
        }
    }

    private void disableField(int fieldIndex) {
        byte i = this.fieldOf[fieldIndex];
        if (i != -1) {
            this.propertyOf[i] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String str;
        while ((str = this.tokenizer.peekToken()) != null && str.charAt(0) == '_') {
            str = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    private static boolean isMatch(String str1, String str2) {
        int cch = str1.length();
        if (str2.length() != cch) {
            return false;
        }
        int i = cch;
        while (--i >= 0) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i)) || (ch1 == '_' || ch1 == '.') && (ch2 == '_' || ch2 == '.')) continue;
            if (ch1 <= 'Z' && ch1 >= 'A') {
                ch1 = (char)(ch1 + 32);
            } else if (ch2 <= 'Z' && ch2 >= 'A') {
                ch2 = (char)(ch2 + 32);
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    class RidiculousFileFormatTokenizer {
        String str;
        int ich;
        int cch;
        boolean wasUnQuoted;
        String strPeeked;
        int ichPeeked;

        RidiculousFileFormatTokenizer() {
        }

        private void setString(String str) {
            this.str = str;
            this.cch = str == null ? 0 : str.length();
            this.ich = 0;
        }

        String setStringNextLine() throws Exception {
            this.setString(CifReader.this.readLine());
            if (CifReader.this.line == null || CifReader.this.line.length() == 0 || CifReader.this.line.charAt(0) != ';') {
                return CifReader.this.line;
            }
            this.ich = 1;
            String str = '\u0001' + CifReader.this.line.substring(1) + '\n';
            while (CifReader.this.readLine() != null) {
                if (CifReader.this.line.startsWith(";")) {
                    str = str.substring(0, str.length() - 1) + '\u0001' + CifReader.this.line.substring(1);
                    break;
                }
                str = str + CifReader.this.line + '\n';
            }
            this.setString(str);
            CifReader.this.line = str;
            return CifReader.this.line;
        }

        boolean hasMoreTokens() {
            if (this.str == null) {
                return false;
            }
            int ch = 35;
            while (this.ich < this.cch) {
                char c = this.str.charAt(this.ich);
                ch = c;
                if (c != ' ' && ch != 9) break;
                ++this.ich;
            }
            if (this.str.indexOf("#jmolscript:") >= 0) {
                CifReader.this.checkLineForScript();
            }
            return this.ich < this.cch && ch != 35;
        }

        String nextToken() {
            if (this.ich == this.cch) {
                return null;
            }
            int ichStart = this.ich;
            char ch = this.str.charAt(ichStart);
            if (ch != '\'' && ch != '\"' && ch != '\u0001') {
                this.wasUnQuoted = true;
                while (this.ich < this.cch && (ch = this.str.charAt(this.ich)) != ' ' && ch != '\t') {
                    ++this.ich;
                }
                if (this.ich == ichStart + 1 && (this.str.charAt(ichStart) == '.' || this.str.charAt(ichStart) == '?')) {
                    return "\u0000";
                }
                return this.str.substring(ichStart, this.ich);
            }
            this.wasUnQuoted = false;
            char chOpeningQuote = ch;
            boolean previousCharacterWasQuote = false;
            while (++this.ich < this.cch) {
                ch = this.str.charAt(this.ich);
                if (previousCharacterWasQuote && (ch == ' ' || ch == '\t')) break;
                previousCharacterWasQuote = ch == chOpeningQuote;
            }
            if (this.ich == this.cch) {
                if (previousCharacterWasQuote) {
                    return this.str.substring(ichStart + 1, this.ich - 1);
                }
                return this.str.substring(ichStart, this.ich);
            }
            ++this.ich;
            return this.str.substring(ichStart + 1, this.ich - 2);
        }

        boolean getData() throws Exception {
            for (int i = 0; i < CifReader.this.fieldCount; ++i) {
                CifReader.this.loopData[i] = this.getNextDataToken();
                if (CifReader.this.loopData[i] != null) continue;
                return false;
            }
            return true;
        }

        String getNextDataToken() throws Exception {
            String str = this.peekToken();
            if (str == null) {
                return null;
            }
            if (this.wasUnQuoted && (str.charAt(0) == '_' || str.startsWith("loop_") || str.startsWith("data_") || str.startsWith("stop_") || str.startsWith("global_"))) {
                return null;
            }
            return this.getTokenPeeked();
        }

        String getNextToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            return this.nextToken();
        }

        String peekToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            int ich = this.ich;
            this.strPeeked = this.nextToken();
            this.ichPeeked = this.ich;
            this.ich = ich;
            return this.strPeeked;
        }

        String getTokenPeeked() {
            this.ich = this.ichPeeked;
            return this.strPeeked;
        }

        String fullTrim(String str) {
            int pt0;
            int pt1 = str.length();
            for (pt0 = 0; pt0 < pt1 && "\n\t ".indexOf(str.charAt(pt0)) >= 0; ++pt0) {
            }
            while (pt0 < pt1 && "\n\t ".indexOf(str.charAt(pt1 - 1)) >= 0) {
                --pt1;
            }
            return str.substring(pt0, pt1);
        }
    }
}

