/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    String header = "";
    private static final String isotopeMap0 = "H1 H2 ";
    private static final String isotopeMap1 = "D  T  ";

    public void readAtomSetCollection(BufferedReader reader) {
        this.atomSetCollection = new AtomSetCollection("mol");
        this.reader = reader;
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("$MDL")) {
                    this.processRgHeader();
                    this.discardLinesUntilStartsWith("$CTAB");
                    this.processCtab();
                } else if (this.doGetModel(++this.modelNumber)) {
                    this.processMolSdHeader();
                    this.processCtab();
                    if (this.isLastModel(this.modelNumber)) break;
                }
                this.flushLines();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void processMolSdHeader() throws Exception {
        String thisDataSetName = this.line;
        this.header = this.header + this.line + "\n";
        this.atomSetCollection.setCollectionName(this.line);
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", this.header);
        this.newAtomSet(thisDataSetName);
    }

    void processRgHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$HDR")) {
        }
        if (this.line == null) {
            Logger.warn("$HDR not found in MDL RG file");
            return;
        }
        this.readLine();
        this.processMolSdHeader();
    }

    void processCtab() throws Exception {
        this.readLine();
        if (this.line == null) {
            return;
        }
        int atomCount = this.parseInt(this.line, 0, 3);
        int bondCount = this.parseInt(this.line, 3, 6);
        int atom0 = this.atomSetCollection.getAtomCount();
        this.readAtoms(atomCount);
        this.readBonds(atom0, bondCount);
        this.applySymmetryAndSetTrajectory();
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }

    void readAtoms(int atomCount) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            this.readLine();
            String elementSymbol = "";
            elementSymbol = this.line.length() > 34 ? this.line.substring(31, 34).trim().intern() : this.line.substring(31).trim().intern();
            float x = this.parseFloat(this.line, 0, 10);
            float y = this.parseFloat(this.line, 10, 20);
            float z = this.parseFloat(this.line, 20, 30);
            int charge = 0;
            if (this.line.length() >= 39) {
                int code = this.parseInt(this.line, 36, 39);
                if (code >= 1 && code <= 7) {
                    charge = 4 - code;
                }
                if ((code = this.parseInt(this.line, 34, 36)) != 0 && code >= -3 && code <= 4) {
                    int ptr = isotopeMap0.indexOf(elementSymbol + code);
                    if (ptr >= 0) {
                        elementSymbol = isotopeMap1.substring(ptr, ptr + 3).trim();
                    } else if (elementSymbol == "C") {
                        elementSymbol = 12 + code + "C";
                    } else if (elementSymbol == "N") {
                        elementSymbol = 14 + code + "N";
                    }
                }
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.formalCharge = charge;
            this.setAtomCoord(atom, x, y, z);
        }
    }

    void readBonds(int atom0, int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            this.readLine();
            int atomIndex1 = this.parseInt(this.line, 0, 3);
            int atomIndex2 = this.parseInt(this.line, 3, 6);
            int order = this.parseInt(this.line, 6, 9);
            switch (order) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    order = 515;
                    break;
                }
                case 5: {
                    order = 66;
                    break;
                }
                case 6: {
                    order = 513;
                    break;
                }
                case 7: {
                    order = 514;
                    break;
                }
                case 8: {
                    order = 33;
                }
            }
            this.atomSetCollection.addBond(new Bond(atom0 + atomIndex1 - 1, atom0 + atomIndex2 - 1, order));
        }
    }
}

