/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("xyz");
        try {
            int modelAtomCount;
            while ((modelAtomCount = this.readAtomCount()) > 0) {
                if (this.doGetModel(++this.modelNumber)) {
                    this.readAtomSetName();
                    this.readAtoms(modelAtomCount);
                    this.applySymmetryAndSetTrajectory();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.skipAtomSet(modelAtomCount);
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void skipAtomSet(int modelAtomCount) throws Exception {
        this.readLine();
        int i = modelAtomCount;
        while (--i >= 0) {
            this.readLine();
        }
    }

    int readAtomCount() throws Exception {
        int atomCount;
        this.readLine();
        if (this.line != null && (atomCount = this.parseInt(this.line)) > 0) {
            return atomCount;
        }
        return 0;
    }

    void readAtomSetName() throws Exception {
        this.readLineTrimmed();
        this.checkLineForScript();
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.line);
    }

    void readAtoms(int modelAtomCount) throws Exception {
        block4: for (int i = 0; i < modelAtomCount; ++i) {
            this.readLine();
            String[] tokens = this.getTokens();
            if (tokens.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                continue;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            String str = tokens[0];
            int isotope = this.parseInt(str);
            if (isotope == Integer.MIN_VALUE) {
                atom.elementSymbol = str;
            } else {
                str = str.substring(("" + isotope).length());
                atom.elementNumber = (short)((isotope << 7) + JmolAdapter.getElementNumber(str));
                this.atomSetCollection.setFileTypeName("xyzi");
            }
            atom.x = this.parseFloat(tokens[1]);
            atom.y = this.parseFloat(tokens[2]);
            atom.z = this.parseFloat(tokens[3]);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                atom.set(0.0f, 0.0f, 0.0f);
            }
            int vpt = 4;
            this.setAtomCoord(atom);
            switch (tokens.length) {
                case 4: 
                case 6: {
                    continue block4;
                }
                case 5: 
                case 8: {
                    str = tokens[4];
                    if (str.indexOf(".") >= 0) {
                        atom.partialCharge = this.parseFloat(str);
                    } else {
                        int charge = this.parseInt(str);
                        if (charge != Integer.MIN_VALUE) {
                            atom.formalCharge = charge;
                        }
                    }
                    if (tokens.length == 5) continue block4;
                }
                default: {
                    int n = ++vpt;
                    float vx = this.parseFloat(tokens[n]);
                    int n2 = ++vpt;
                    float vy = this.parseFloat(tokens[n2]);
                    int n3 = ++vpt;
                    ++vpt;
                    float vz = this.parseFloat(tokens[n3]);
                    if (Float.isNaN(vx) || Float.isNaN(vy) || Float.isNaN(vz)) continue block4;
                    atom.vectorX = vx;
                    atom.vectorY = vy;
                    atom.vectorZ = vz;
                }
            }
        }
    }
}

