/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AlchemyReader
extends AtomSetCollectionReader {
    int atomCount;
    int bondCount;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("Alchemy");
        try {
            this.atomSetCollection.newAtomSet();
            String[] tokens = AlchemyReader.getTokens(this.readLine());
            this.atomCount = this.parseInt(tokens[0]);
            this.bondCount = this.parseInt(tokens[2]);
            this.readAtoms();
            this.readBonds();
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readAtoms() throws Exception {
        i = this.atomCount;
        while (--i >= 0) {
            tokens = AlchemyReader.getTokens(this.readLine());
            atom = new Atom();
            atom.atomSerial = this.parseInt(tokens[0]);
            name = atom.atomName = tokens[1];
            atom.elementSymbol = name.substring(0, 1);
            c1 = name.charAt(0);
            c2 = ' ';
            if (name.length() != 2) ** GOTO lbl-1000
            v0 = Character.toLowerCase(name.charAt(1));
            c2 = v0;
            if (Atom.isValidElementSymbol(c1, v0) || name.equals("Du")) {
                v1 = 2;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            nChar = v1;
            atom.elementSymbol = nChar == 1 ? "" + c1 : "" + c1 + c2;
            this.setAtomCoord(atom, this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            atom.partialCharge = tokens.length >= 6 ? this.parseFloat(tokens[5]) : 0.0f;
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
    }

    private void readBonds() throws Exception {
        int i = this.bondCount;
        while (--i >= 0) {
            String[] tokens = AlchemyReader.getTokens(this.readLine());
            int atomSerial1 = this.parseInt(tokens[1]);
            int atomSerial2 = this.parseInt(tokens[2]);
            String sOrder = tokens.length < 4 ? "1" : tokens[3].toUpperCase();
            int order = 0;
            switch (sOrder.charAt(0)) {
                default: {
                    order = 1;
                    break;
                }
                case '2': 
                case 'D': {
                    order = 2;
                    break;
                }
                case '3': 
                case 'T': {
                    order = 3;
                    break;
                }
                case 'A': {
                    order = 515;
                    break;
                }
                case 'H': {
                    order = 2048;
                }
            }
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(atomSerial1, atomSerial2, order);
        }
    }
}

