/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GamessUKReader
extends GamessReader {
    private Vector symmetries;
    private Vector occupancies;

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "gamessUK");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("BASIS OPTIONS")) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.contains("$CONTRL OPTIONS")) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("contracted primitive functions") >= 0) {
            this.readGaussianBasis("======================================================", "======");
            return false;
        }
        if (this.line.indexOf("molecular geometry") >= 0) {
            if (this.doGetModel(++this.modelNumber)) {
                this.atomNames = new Vector();
                this.readAtomsInBohrCoordinates();
                this.iHaveAtoms = true;
                return true;
            }
            if (this.isLastModel(this.modelNumber) && this.iHaveAtoms) {
                this.continuing = false;
                return false;
            }
            this.iHaveAtoms = false;
        }
        if (!this.iHaveAtoms) {
            return true;
        }
        if (this.line.indexOf("FREQUENCY_INFO_WOULD_BE_HERE") >= 0) {
            return true;
        }
        if (this.line.indexOf("SYMMETRY ASSIGNMENT") >= 0) {
            this.readOrbitalSymmetryAndOccupancy();
            return false;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("eigenvectors") >= 0) {
            this.readMolecularOrbitals(3);
            this.setOrbitalSymmetryAndOccupancy();
            return false;
        }
        return this.checkNboLine();
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        this.discardLinesUntilContains("*****");
        this.discardLinesUntilContains("atom");
        this.discardLinesUntilContains("*****");
        this.atomSetCollection.newAtomSet();
        while (this.readLine() != null && this.line.indexOf("*****") < 0) {
            if (this.line.charAt(14) == ' ') continue;
            String[] tokens = this.getTokens();
            String atomName = tokens[1];
            int atomicNumber = (int)this.parseFloat(tokens[2]);
            float x = this.parseFloat(tokens[3]);
            float y = this.parseFloat(tokens[4]);
            float z = this.parseFloat(tokens[5]);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName;
            atom.set(x, y, z);
            atom.scale(0.5291772f);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(atomicNumber);
            this.atomNames.addElement(atomName);
        }
    }

    protected String fixShellTag(String tag) {
        return tag.substring(1).toUpperCase();
    }

    private void readOrbitalSymmetryAndOccupancy() throws Exception {
        this.discardLines(4);
        this.symmetries = new Vector();
        this.occupancies = new Vector();
        while (this.readLine() != null && this.line.indexOf("====") < 0) {
            String[] tokens = GamessUKReader.getTokens(this.line.substring(20));
            this.symmetries.addElement(tokens[0] + " " + tokens[1]);
            this.occupancies.addElement(new Float(this.parseFloat(tokens[5])));
        }
    }

    private void setOrbitalSymmetryAndOccupancy() {
        if (this.symmetries.size() < this.orbitals.size()) {
            return;
        }
        int i = this.orbitals.size();
        while (--i >= 0) {
            Hashtable mo = (Hashtable)this.orbitals.elementAt(i);
            mo.put("symmetry", this.symmetries.elementAt(i));
            mo.put("occupancy", this.occupancies.elementAt(i));
        }
    }
}

