/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GhemicalMMReader
extends AtomSetCollectionReader {
    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("ghemicalMM");
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("!Header")) {
                    this.processHeader();
                    continue;
                }
                if (this.line.startsWith("!Info")) {
                    this.processInfo();
                    continue;
                }
                if (this.line.startsWith("!Atoms")) {
                    this.processAtoms();
                    continue;
                }
                if (this.line.startsWith("!Bonds")) {
                    this.processBonds();
                    continue;
                }
                if (this.line.startsWith("!Coord")) {
                    this.processCoord();
                    continue;
                }
                if (this.line.startsWith("!Charges")) {
                    this.processCharges();
                    continue;
                }
                if (!this.line.startsWith("!End")) continue;
                return;
            }
        }
        catch (Exception e) {
            this.setError(e);
            return;
        }
        this.setError(new Exception("unexpected end of file"));
    }

    void processHeader() {
    }

    void processInfo() {
    }

    void processAtoms() throws Exception {
        int atomCount = this.parseInt(this.line, 6);
        for (int i = 0; i < atomCount; ++i) {
            if (this.atomSetCollection.getAtomCount() != i) {
                throw new Exception("GhemicalMMReader error #1");
            }
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Atomsexpected: " + i + " saw:" + atomIndex);
            }
            int elementNumber = this.parseInt();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)elementNumber;
        }
    }

    void processBonds() throws Exception {
        int bondCount = this.parseInt(this.line, 6);
        for (int i = 0; i < bondCount; ++i) {
            this.readLine();
            int atomIndex1 = this.parseInt(this.line);
            int atomIndex2 = this.parseInt();
            String orderCode = this.parseToken();
            int order = 0;
            switch (orderCode.charAt(0)) {
                case 'C': {
                    order = 515;
                    break;
                }
                case 'T': {
                    order = 3;
                    break;
                }
                case 'D': {
                    order = 2;
                    break;
                }
                default: {
                    order = 1;
                }
            }
            this.atomSetCollection.addNewBond(atomIndex1, atomIndex2, order);
        }
    }

    void processCoord() throws Exception {
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int atomCount = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Coordexpected: " + i + " saw:" + atomIndex);
            }
            atoms[i].set(this.parseFloat() * 10.0f, this.parseFloat() * 10.0f, this.parseFloat() * 10.0f);
        }
    }

    void processCharges() throws Exception {
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int atomCount = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            this.readLine();
            int atomIndex = this.parseInt(this.line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Chargesexpected: " + i + " saw:" + atomIndex);
            }
            atoms[i].partialCharge = this.parseFloat();
        }
    }
}

