/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class JaguarReader
extends MOReader {
    int moCount = 0;
    float lumoEnergy = Float.MAX_VALUE;

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "jaguar");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Input geometry:") || this.line.startsWith(" Symmetrized geometry:") || this.line.startsWith("  final geometry:")) {
            this.readAtoms();
            return true;
        }
        if (this.line.startsWith("  Atomic charges from electrostatic potential:")) {
            this.readCharges();
            return true;
        }
        if (this.line.startsWith("  number of basis functions....")) {
            this.moCount = this.parseInt(this.line.substring(32).trim());
            return true;
        }
        if (this.line.startsWith("  basis set:")) {
            this.moData.put("energyUnits", "");
            this.calculationType = this.line.substring(13).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("Shell information") >= 0) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Normalized coefficients") >= 0) {
            this.readBasisNormalized();
            return true;
        }
        if (this.line.startsWith(" LUMO energy:")) {
            this.lumoEnergy = this.parseFloat(this.line.substring(13));
            return true;
        }
        if (this.line.indexOf("final wvfn") >= 0) {
            this.readJaguarMolecularOrbitals();
            return true;
        }
        if (this.line.startsWith("  harmonic frequencies in")) {
            this.readFrequencies();
            this.continuing = false;
            return false;
        }
        return this.checkNboLine();
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.discardLines(2);
        int atomCount = 0;
        while (this.readLine() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String[] tokens = this.getTokens();
            String atomName = tokens[0];
            float x = this.parseFloat(tokens[1]);
            float y = this.parseFloat(tokens[2]);
            float z = this.parseFloat(tokens[3]);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z) || atomName.length() < 2) {
                return;
            }
            char ch2 = atomName.charAt(1);
            String elementSymbol = ch2 >= 'a' && ch2 <= 'z' ? atomName.substring(0, 2) : atomName.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.set(x, y, z);
            ++atomCount;
        }
    }

    private void readCharges() throws Exception {
        int iAtom = 0;
        while (this.readLine() != null && this.line.indexOf("sum") < 0) {
            if (this.line.indexOf("Charge") < 0) continue;
            String[] tokens = this.getTokens();
            for (int i = 1; i < tokens.length; ++i) {
                this.atomSetCollection.getAtom((int)iAtom++).partialCharge = this.parseFloat(tokens[i]);
            }
        }
    }

    void readBasis() throws Exception {
        String[] tokens;
        String lastAtom = "";
        int iAtom = -1;
        int[][] sdata = new int[this.moCount][4];
        Vector[] sgdata = new Vector[this.moCount];
        this.gaussianCount = 0;
        this.discardLinesUntilContains("--------");
        while (this.readLine() != null && (tokens = this.getTokens()).length == 9) {
            int jCont = this.parseInt(tokens[2]);
            if (jCont <= 0) continue;
            if (!tokens[0].equals(lastAtom)) {
                ++iAtom;
            }
            lastAtom = tokens[0];
            int iFunc = this.parseInt(tokens[5]);
            int iType = this.parseInt(tokens[4]);
            if (iType <= 2) {
                --iType;
            }
            if (sgdata[iFunc] == null) {
                sdata[iFunc][0] = iAtom;
                sdata[iFunc][1] = iType;
                sdata[iFunc][2] = 0;
                sdata[iFunc][3] = 0;
                sgdata[iFunc] = new Vector();
            }
            float factor = 1.0f;
            sgdata[iFunc].addElement(new float[]{this.parseFloat(tokens[6]), this.parseFloat(tokens[8]) * factor});
            this.gaussianCount += jCont;
            int i = jCont - 1;
            while (--i >= 0) {
                tokens = JaguarReader.getTokens(this.readLine());
                sgdata[iFunc].addElement(new float[]{this.parseFloat(tokens[6]), this.parseFloat(tokens[8]) * factor});
            }
        }
        float[][] garray = new float[this.gaussianCount][];
        Vector<int[]> sarray = new Vector<int[]>();
        this.gaussianCount = 0;
        for (int i = 0; i < this.moCount; ++i) {
            if (sgdata[i] == null) continue;
            int n = sgdata[i].size();
            sdata[i][2] = this.gaussianCount;
            sdata[i][3] = n;
            for (int j = 0; j < n; ++j) {
                garray[this.gaussianCount++] = (float[])sgdata[i].get(j);
            }
            sarray.addElement(sdata[i]);
        }
        this.moData.put("shells", sarray);
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(sarray.size() + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    void readBasisNormalized() throws Exception {
    }

    private void readJaguarMolecularOrbitals() throws Exception {
        String[][] dataBlock = new String[this.moCount][];
        this.readLine();
        this.readLine();
        this.readLine();
        int nMo = 0;
        while (this.line != null) {
            this.readLine();
            this.readLine();
            this.readLine();
            if (this.line == null || this.line.indexOf("eigenvalues-") < 0) break;
            String[] eigenValues = this.getTokens();
            int n = eigenValues.length - 1;
            this.fillDataBlock(dataBlock);
            for (int iOrb = 0; iOrb < n; ++iOrb) {
                float[] coefs = new float[this.moCount];
                Hashtable<String, Object> mo = new Hashtable<String, Object>();
                float energy = this.parseFloat(eigenValues[iOrb + 1]);
                mo.put("energy", new Float(energy));
                if ((double)Math.abs(energy - this.lumoEnergy) < 1.0E-4) {
                    this.moData.put("HOMO", new Integer(nMo));
                    this.lumoEnergy = Float.MAX_VALUE;
                }
                ++nMo;
                for (int i = 0; i < this.moCount; ++i) {
                    coefs[i] = this.parseFloat(dataBlock[i][iOrb + 3]);
                }
                mo.put("coefficients", coefs);
                this.orbitals.addElement(mo);
            }
        }
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        int iModel = 1;
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        this.discardLinesUntilStartsWith("  frequencies ");
        while (this.line != null && this.line.startsWith("  frequencies ")) {
            String[] frequencies = this.getTokens();
            int freqCount = frequencies.length - 1;
            String[] symmetries = null;
            while (this.line != null && !this.line.startsWith("  intensities ") && !this.line.startsWith("  force ")) {
                this.readLine();
                if (this.line.indexOf("symmetries") < 0) continue;
                symmetries = this.getTokens();
            }
            block2: for (int i = 0; i < atomCount; ++i) {
                String[] tokensX = JaguarReader.getTokens(this.readLine());
                String[] tokensY = JaguarReader.getTokens(this.readLine());
                String[] tokensZ = JaguarReader.getTokens(this.readLine());
                for (int j = 0; j < freqCount; ++j) {
                    if (i == 0) {
                        this.atomSetCollection.cloneFirstAtomSet();
                        this.atomSetCollection.setAtomSetName(frequencies[j + 1] + " cm-1" + (symmetries == null ? "" : " (" + symmetries[j + 1] + ")"));
                        this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[j + 1] + " cm-1");
                    }
                    int iAtom = (iModel + j) * atomCount + i;
                    float x = this.parseFloat(tokensX[j + 2]);
                    float y = this.parseFloat(tokensY[j + 2]);
                    float z = this.parseFloat(tokensZ[j + 2]);
                    if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
                        Logger.info("Error reading frequency line: " + this.line);
                        continue block2;
                    }
                    Atom atom = this.atomSetCollection.getAtom(iAtom);
                    atom.vectorX = x;
                    atom.vectorY = y;
                    atom.vectorZ = z;
                }
            }
            iModel += freqCount;
            this.readLine();
            this.readLine();
        }
    }
}

