/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

public class MopacData {
    private static final int[] principalQuantumNumber = new int[]{0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] pnqD = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7};
    private static final float[] fact = new float[20];
    private static final float fourPi = (float)Math.PI * 4;
    private static final float[] factorDs;

    private static final boolean isNoble(int atomicNumber) {
        switch (atomicNumber) {
            case 2: 
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    private static final int getNPQ(int atomicNumber) {
        return atomicNumber < principalQuantumNumber.length ? principalQuantumNumber[atomicNumber] : 0;
    }

    public static final int getNPQs(int atomicNumber) {
        return MopacData.getNPQ(atomicNumber) + (atomicNumber > 2 && MopacData.isNoble(atomicNumber) ? 1 : 0);
    }

    public static final int getNPQp(int atomicNumber) {
        return MopacData.getNPQ(atomicNumber) + (atomicNumber == 2 ? 1 : 0);
    }

    public static final int getNPQd(int atomicNumber) {
        return atomicNumber < pnqD.length ? pnqD[atomicNumber] : 0;
    }

    public static final float getMopacConstS(int atomicNumber, float zeta) {
        int n = MopacData.getNPQs(atomicNumber);
        return (float)(Math.pow(2.0f * zeta, (double)n + 0.5) * Math.sqrt(0.07957747f / fact[2 * n]));
    }

    public static final float getMopacConstP(int atomicNumber, float zeta) {
        int n = MopacData.getNPQp(atomicNumber);
        return (float)(Math.pow(2.0f * zeta, (double)n + 0.5) * Math.sqrt(0.23873241f / fact[2 * n]));
    }

    public static float getFactorD(int n) {
        return factorDs[n];
    }

    public static final float getMopacConstD(int atomicNumber, float zeta) {
        int n = MopacData.getNPQd(atomicNumber);
        return (float)(Math.pow(2.0f * zeta, (double)n + 0.5) * Math.sqrt(1.193662f / fact[2 * n]));
    }

    static {
        MopacData.fact[0] = 1.0f;
        for (int n = 1; n < fact.length; ++n) {
            MopacData.fact[n] = fact[n - 1] * (float)n;
        }
        factorDs = new float[]{0.5f, 1.0f, (float)(0.5 / Math.sqrt(3.0)), 1.0f, 1.0f};
    }
}

