/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.MopacData;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacDataReader {
    int[] atomicNumbers;
    int atomCount;
    float[][] invMatrix;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mopacGraphf");
        try {
            this.readAtoms();
            this.readSlaterBasis();
            this.readMOs(false);
            if (this.readKeywords()) {
                this.readMOs(true);
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseInt(this.readLine());
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseInt(this.line.substring(0, 4));
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.x = this.parseFloat(this.line.substring(4, 17));
            atom.y = this.parseFloat(this.line.substring(17, 29));
            atom.z = this.parseFloat(this.line.substring(29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloat(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.atomicNumbers[i]);
        }
    }

    void readSlaterBasis() throws Exception {
        this.nOrbitals = 0;
        float[] values = new float[3];
        for (int iAtom = 0; iAtom < this.atomCount; ++iAtom) {
            float coef;
            int d;
            MopacGraphfReader.getTokensFloat(this.readLine(), values, 3);
            int atomicNumber = this.atomicNumbers[iAtom];
            float zeta = values[0];
            if (zeta != 0.0f) {
                this.addSlater(iAtom, 0, 0, 0, MopacData.getNPQs(atomicNumber) - 1, zeta, MopacData.getMopacConstS(atomicNumber, zeta));
            }
            if ((zeta = values[1]) != 0.0f) {
                d = MopacData.getNPQp(atomicNumber) - 2;
                coef = MopacData.getMopacConstP(atomicNumber, zeta);
                this.addSlater(iAtom, 1, 0, 0, d, zeta, coef);
                this.addSlater(iAtom, 0, 1, 0, d, zeta, coef);
                this.addSlater(iAtom, 0, 0, 1, d, zeta, coef);
            }
            if ((zeta = values[2]) == 0.0f) continue;
            d = MopacData.getNPQd(atomicNumber) - 3;
            coef = MopacData.getMopacConstD(atomicNumber, zeta);
            int dpt = 0;
            for (int i = 0; i < 5; ++i) {
                this.addSlater(iAtom, dValues[dpt++], dValues[dpt++], dValues[dpt++], d, zeta, coef * MopacData.getFactorD(i));
            }
        }
        this.nOrbitals = this.intinfo.size();
        this.setSlaters();
    }

    void readMOs(boolean isBeta) throws Exception {
        int i;
        int n;
        int iMo;
        float[][] list = new float[this.nOrbitals][this.nOrbitals];
        for (iMo = 0; iMo < this.nOrbitals; ++iMo) {
            n = -1;
            for (i = 0; i < this.nOrbitals; ++i) {
                if ((n = (n + 1) % 5) == 0) {
                    this.readLine();
                }
                list[iMo][i] = this.parseFloat(this.line.substring(n * 15, (n + 1) * 15));
            }
        }
        if (!isBeta) {
            this.invMatrix = new float[this.nOrbitals][this.nOrbitals];
            for (iMo = 0; iMo < this.nOrbitals; ++iMo) {
                n = -1;
                for (i = 0; i < iMo + 1; ++i) {
                    if ((n = (n + 1) % 5) == 0) {
                        this.readLine();
                    }
                    float f = this.parseFloat(this.line.substring(n * 15, (n + 1) * 15));
                    this.invMatrix[i][iMo] = f;
                    this.invMatrix[iMo][i] = f;
                }
            }
        }
        float[][] list2 = new float[this.nOrbitals][this.nOrbitals];
        for (int i2 = 0; i2 < this.nOrbitals; ++i2) {
            for (int j = 0; j < this.nOrbitals; ++j) {
                for (int k = 0; k < this.nOrbitals; ++k) {
                    float[] fArray = list2[i2];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + list[i2][k] * this.invMatrix[k][j];
                }
                if (!(Math.abs(list2[i2][j]) < 1.0E-4f)) continue;
                list2[i2][j] = 0.0f;
            }
        }
        float[] values = new float[2];
        for (int iMo2 = 0; iMo2 < this.nOrbitals; ++iMo2) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            MopacGraphfReader.getTokensFloat(this.readLine(), values, 2);
            mo.put("energy", new Float(values[0]));
            mo.put("occupancy", new Float(values[1]));
            mo.put("coefficients", list2[iMo2]);
            if (isBeta) {
                mo.put("type", "beta");
            }
            this.orbitals.addElement(mo);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean isUHF;
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl = isUHF = this.line.indexOf("UHF") >= 0;
        if (isUHF) {
            int i = this.orbitals.size();
            while (--i >= 0) {
                ((Hashtable)this.orbitals.get(i)).put("type", "alpha");
            }
        }
        return isUHF;
    }
}

