/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacReader
extends AtomSetCollectionReader {
    int baseAtomIndex;
    private boolean chargesFound = false;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mopac");
        try {
            while (this.readLine() != null && !this.line.startsWith(" ---")) {
                if (this.line.indexOf("MOLECULAR POINT GROUP") >= 0 || !this.line.trim().equals("CARTESIAN COORDINATES")) continue;
                this.processCoordinates();
                this.atomSetCollection.setAtomSetName("Input Structure");
            }
            while (this.readLine() != null) {
                if (this.line.indexOf("TOTAL ENERGY") >= 0) {
                    this.processTotalEnergy();
                    continue;
                }
                if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
                    this.processAtomicCharges();
                    continue;
                }
                if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                    this.processCoordinates();
                    continue;
                }
                if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
                    this.processCoordinates();
                    this.atomSetCollection.setAtomSetName("Orientation in Force Field");
                    continue;
                }
                if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") < 0) continue;
                this.readFrequencies();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void processTotalEnergy() {
    }

    void processAtomicCharges() throws Exception {
        int atomNumber;
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        int expectedAtomNumber = 0;
        while (this.readLine() != null && (atomNumber = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = this.parseToken();
            atom.partialCharge = this.parseFloat();
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int atomNumber;
        this.discardLines(3);
        int expectedAtomNumber = 0;
        if (!this.chargesFound) {
            this.atomSetCollection.newAtomSet();
            this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        } else {
            this.chargesFound = false;
        }
        Atom[] atoms = this.atomSetCollection.getAtoms();
        while (this.readLine() != null && (atomNumber = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in coordinates");
            }
            String elementSymbol = this.parseToken();
            Atom atom = atoms[this.baseAtomIndex + atomNumber - 1];
            if (atom == null) {
                atom = this.atomSetCollection.addNewAtom();
            }
            atom.atomSerial = atomNumber;
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            int atno = this.parseInt(elementSymbol);
            if (atno != Integer.MIN_VALUE) {
                elementSymbol = MopacReader.getElementSymbol(atno);
            }
            atom.elementSymbol = elementSymbol;
        }
    }

    private void readFrequencies() throws Exception {
        Vector freqs = new Vector();
        Vector vibrations = new Vector();
        int nAtoms = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null && this.line.indexOf("DESCRIPTION") < 0) {
            if (this.line.indexOf("ROOT") < 0) continue;
            int frequencyCount = this.getTokens().length - 2;
            String[][] data = new String[nAtoms * 3 + 1][];
            this.fillDataBlock(data);
            for (int i = 0; i < frequencyCount; ++i) {
                float freq = this.parseFloat(data[0][i]);
                Hashtable<String, Object> info = new Hashtable<String, Object>();
                info.put("freq", new Float(freq));
                info.put("label", "");
                freqs.addElement(info);
                this.baseAtomIndex = this.atomSetCollection.getAtomCount();
                this.atomSetCollection.cloneLastAtomSet();
                Atom[] atoms = this.atomSetCollection.getAtoms();
                this.atomSetCollection.setAtomSetName(freq + " cm^-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
                Vector vib = new Vector();
                int dataPt = 1;
                for (int iatom = 0; iatom < nAtoms; ++iatom) {
                    float dx = this.parseFloat(data[dataPt++][i + 1]);
                    float dy = this.parseFloat(data[dataPt++][i + 1]);
                    float dz = this.parseFloat(data[dataPt++][i + 1]);
                    atoms[this.baseAtomIndex + iatom].addVibrationVector(dx, dy, dz);
                    Vector<Float> vibatom = new Vector<Float>();
                    vibatom.addElement(new Float(dx));
                    vibatom.addElement(new Float(dy));
                    vibatom.addElement(new Float(dz));
                    vib.addElement(vibatom);
                }
                vibrations.addElement(vib);
            }
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }
}

