/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;

public class NWChemReader
extends MOReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "nwchem");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("          Step")) {
            this.init();
            return true;
        }
        if (this.line.startsWith("      Symmetry information")) {
            this.readSymmetry();
            return true;
        }
        if (this.line.indexOf("Total") >= 0) {
            this.readTotal();
            return true;
        }
        if (this.line.indexOf("@") >= 0) {
            this.readAtSign();
            return true;
        }
        if (this.line.startsWith("      Optimization converged")) {
            this.converged = true;
            return true;
        }
        if (this.line.indexOf("Output coordinates in angstroms") >= 0) {
            ++this.equivalentAtomSets;
            this.readAtoms();
            return true;
        }
        if (this.line.indexOf("ENERGY GRADIENTS") >= 0) {
            ++this.equivalentAtomSets;
            this.readGradients();
            return true;
        }
        if (this.line.indexOf("NWChem Nuclear Hessian and Frequency Analysis") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" Task  times")) {
            this.init();
            ++this.taskNumber;
            return true;
        }
        if (this.line.trim().startsWith("NWChem")) {
            this.readNWChemLine();
            return true;
        }
        if (this.line.startsWith("  Mulliken analysis of the total density")) {
            if (this.equivalentAtomSets > 0) {
                this.readPartialCharges();
            }
            return true;
        }
        return true;
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String key, String value, int nAtomSets) {
        this.energyKey = key;
        this.energyValue = value;
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyValue, this.equivalentAtomSets);
        this.haveEnergy = true;
    }

    private void setEnergy(String key, String value) {
        this.energyKey = key;
        this.energyValue = value;
        this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyValue);
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        this.discardLines(2);
        if (this.readLine() == null) {
            return;
        }
        String[] tokens = this.getTokens();
        this.atomSetCollection.setAtomSetProperties("Symmetry group name", tokens[tokens.length - 1], this.equivalentAtomSets);
    }

    private void readNWChemLine() {
        this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
    }

    private void readTotal() {
        String[] tokens = this.getTokens();
        try {
            if (tokens[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + tokens[1] + ")", tokens[tokens.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S') {
            this.discardLines(1);
            if (this.readLine() == null) {
                return;
            }
        }
        String[] tokens = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", tokens[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.atomSetCollection.setAtomSetProperties("Step", tokens[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void readAtoms() throws Exception {
        String[] tokens;
        this.discardLines(3);
        this.haveEnergy = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        while (this.readLine() != null && this.line.length() > 0 && (tokens = this.getTokens()).length >= 6) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(tokens[1]);
            atom.set(this.parseFloat(tokens[3]), this.parseFloat(tokens[4]), this.parseFloat(tokens[5]));
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.atomSetCollection.setAtomSetProperty("Step", "converged");
        } else if (this.inInput) {
            this.atomSetCollection.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        String[] tokens;
        this.discardLines(3);
        this.atomSetCollection.newAtomSet();
        if (this.equivalentAtomSets > 1) {
            this.atomSetCollection.cloneLastAtomSetProperties();
        }
        this.atomSetCollection.setAtomSetProperty("vector", "gradient");
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        while (this.readLine() != null && this.line.length() > 0 && (tokens = this.getTokens()).length >= 8) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(tokens[1]);
            atom.set(this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            atom.scale(0.5291772f);
            atom.vectorX = -this.parseFloat(tokens[5]);
            atom.vectorY = -this.parseFloat(tokens[6]);
            atom.vectorZ = -this.parseFloat(tokens[7]);
        }
    }

    private void readFrequencies() throws Exception {
        String[] tokens;
        String path = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetProperty(".PATH", path);
        while (this.readLine() != null && this.line.indexOf("---") < 0) {
            tokens = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(tokens[0]);
            atom.set(this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            atom.scale(0.5291772f);
        }
        int firstFrequencyAtomSetIndex = this.atomSetCollection.getCurrentAtomSetIndex();
        int totalFrequencies = 0;
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        boolean firstTime = true;
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.discardLines(3);
        while (this.readLine() != null && this.line.indexOf("P.Frequency") >= 0) {
            int fIndex;
            tokens = NWChemReader.getTokens(this.line, 12);
            int nFreq = tokens.length;
            int n = fIndex = firstTime ? 1 : 0;
            while (fIndex < nFreq) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetProperty(".PATH", path);
                ++fIndex;
            }
            firstTime = false;
            for (int i = 0; i < nFreq; ++i) {
                int idx = firstFrequencyAtomSetIndex + totalFrequencies + i;
                String frequencyString = tokens[i] + " cm**-1";
                this.atomSetCollection.setAtomSetName(frequencyString, idx);
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencyString, idx);
            }
            int firstModelAtom = this.atomSetCollection.getAtomCount() - nFreq * atomCount;
            this.discardLines(1);
            Atom[] atoms = this.atomSetCollection.getAtoms();
            for (int i = 0; i < atomCount * 3; ++i) {
                if (this.readLine() == null) {
                    return;
                }
                tokens = this.getTokens();
                block12: for (int j = 0; j < nFreq; ++j) {
                    Atom atom = atoms[firstModelAtom + j * atomCount + i / 3];
                    float val = this.parseFloat(tokens[j + 1]);
                    switch (i % 3) {
                        case 0: {
                            atom.vectorX = val;
                            continue block12;
                        }
                        case 1: {
                            atom.vectorY = val;
                            continue block12;
                        }
                        case 2: {
                            atom.vectorZ = val;
                        }
                    }
                }
            }
            totalFrequencies += nFreq;
            this.discardLines(3);
        }
        try {
            this.discardLinesUntilContains("Projected Infra Red Intensities");
            this.discardLines(2);
            int i = totalFrequencies;
            int idx = firstFrequencyAtomSetIndex;
            while (--i >= 0) {
                if (this.readLine() == null) {
                    return;
                }
                tokens = this.getTokens();
                String frequencyString = tokens[1] + " cm**-1";
                this.atomSetCollection.setAtomSetName(frequencyString, idx);
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencyString, idx);
                this.atomSetCollection.setAtomSetProperty("IR Intensity", tokens[5] + " KM/mol", idx);
                ++idx;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void readPartialCharges() throws Exception {
        this.discardLines(4);
        int atomCount = this.atomSetCollection.getAtomCount();
        int i0 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        for (int i = i0; i < atomCount; ++i) {
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            if (this.readLine() == null) {
                return;
            }
            String[] tokens = this.getTokens();
            atoms[i].partialCharge = (float)this.parseInt(tokens[2]) - this.parseFloat(tokens[3]);
        }
    }

    private String fixTag(String tag) {
        String lctag = tag.toLowerCase();
        if (lctag.equals("bq")) {
            return "X";
        }
        if (lctag.startsWith("bq")) {
            return tag.substring(2) + "-Bq";
        }
        return tag;
    }
}

