/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PsiReader
extends MOReader {
    Vector atomNames = new Vector();
    Vector shellsByUniqueAtom = new Vector();
    Hashtable uniqueAtomMap = new Hashtable();

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "psi");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("-Geometry after Center-of-Mass shift and reorientation (a.u.):") >= 0) {
            this.readAtoms(true);
            this.iHaveAtoms = true;
        }
        if (this.line.indexOf("-Unique atoms in the canonical coordinate system (a.u.):") >= 0) {
            this.readUniqueAtoms();
        }
        if (!this.iHaveAtoms) {
            return true;
        }
        if (this.line.indexOf("New Cartesian Geometry in a.u.") >= 0) {
            this.readAtoms(false);
            return true;
        }
        if (this.line.startsWith("  label        = ")) {
            this.calculationType = this.line.substring(17).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.startsWith("molecular orbitals for ")) {
            this.moData.put("energyUnits", "");
            return true;
        }
        if (this.line.startsWith("  -BASIS SETS:")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (this.filterMO()) {
                this.readPsiMolecularOrbitals();
            }
            return true;
        }
        if (this.line.indexOf("SCF total energy   =") >= 0) {
            this.readSCFDone();
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        this.atomSetCollection.setAtomSetName(this.line);
    }

    private void readAtoms(boolean isInitial) throws Exception {
        if (isInitial) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName("");
            this.discardLinesUntilContains("----");
        }
        int atomPt = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            Atom atom;
            String[] tokens = this.getTokens();
            Atom atom2 = atom = isInitial ? this.atomSetCollection.addNewAtom() : this.atomSetCollection.getAtom(atomPt++);
            if (isInitial) {
                this.atomNames.addElement(tokens[0]);
            } else {
                atom.elementNumber = (byte)this.parseInt(tokens[0]);
            }
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            atom.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
            atom.scale(0.5291772f);
        }
    }

    void readBasis() throws Exception {
        String[] tokens;
        Vector<String[]> gdata = new Vector<String[]>();
        this.gaussianCount = 0;
        this.shellCount = 0;
        int[] slater = null;
        Vector<int[]> slatersByUniqueAtom = null;
        this.readLine();
        while (this.readLine() != null && this.line.startsWith("   -Basis set on")) {
            slatersByUniqueAtom = new Vector<int[]>();
            int nGaussians = 0;
            while (this.readLine() != null && !this.line.startsWith("       )")) {
                this.line = this.line.replace('(', ' ').replace(')', ' ');
                tokens = this.getTokens();
                int ipt = 0;
                switch (tokens.length) {
                    case 3: {
                        if (slater != null) {
                            slatersByUniqueAtom.addElement(slater);
                        }
                        ipt = 1;
                        slater = new int[3];
                        slater[0] = JmolAdapter.getQuantumShellTagID(tokens[0]);
                        slater[1] = this.gaussianCount;
                        ++this.shellCount;
                        break;
                    }
                }
                gdata.addElement(new String[]{tokens[ipt], tokens[ipt + 1]});
                slater[2] = ++nGaussians;
            }
            if (slater != null) {
                slatersByUniqueAtom.addElement(slater);
            }
            this.shellsByUniqueAtom.addElement(slatersByUniqueAtom);
            this.gaussianCount += nGaussians;
            this.readLine();
        }
        float[][] garray = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            garray[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                garray[i][j] = this.parseFloat(tokens[j]);
            }
        }
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readUniqueAtoms() throws Exception {
        Vector<int[]> sdata = new Vector<int[]>();
        this.discardLinesUntilContains("----");
        int n = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            String[] tokens = this.getTokens();
            this.uniqueAtomMap.put(tokens[0], new Integer(n++));
        }
        int atomCount = this.atomNames.size();
        for (int i = 0; i < atomCount; ++i) {
            String atomType = (String)this.atomNames.elementAt(i);
            int iUnique = (Integer)this.uniqueAtomMap.get(atomType);
            Vector slaters = (Vector)this.shellsByUniqueAtom.elementAt(iUnique);
            if (slaters == null) {
                Logger.error("slater for atom " + i + " atomType " + atomType + " was not found in listing. Ignoring molecular orbitals");
                return;
            }
            for (int j = 0; j < slaters.size(); ++j) {
                int[] slater = (int[])slaters.elementAt(j);
                sdata.addElement(new int[]{i, slater[0], slater[1], slater[2]});
            }
        }
        this.moData.put("shells", sdata);
    }

    void readPsiMolecularOrbitals() throws Exception {
        Hashtable[] mos = new Hashtable[5];
        Vector[] data = new Vector[5];
        int nThisLine = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int i;
            int ptData;
            String[] tokens = this.getTokens();
            int n = ptData = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(nThisLine, data, mos);
                nThisLine = tokens.length;
                tokens = PsiReader.getTokens(this.readLine());
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Vector();
                    mos[i].put("symmetry", tokens[i]);
                }
                tokens = PsiReader.getStrings(this.readLine().substring(21), nThisLine, 10);
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", new Float(tokens[i]));
                }
                continue;
            }
            try {
                for (i = 0; i < nThisLine; ++i) {
                    data[i].addElement(tokens[i + ptData]);
                }
            }
            catch (Exception e) {
                Logger.error("Error reading Psi3 file molecular orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(nThisLine, data, mos);
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
    }
}

