/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

abstract class SpartanInputReader
extends AtomSetCollectionReader {
    protected String modelName;
    protected int atomCount;
    protected int bondCount;
    protected String bondData = "";
    int modelAtomCount;
    int atomCount0;

    SpartanInputReader() {
    }

    protected void readInputRecords() {
        int atomCount0 = this.atomCount;
        try {
            String[] tokens;
            this.readInputHeader();
            while (this.readLine() != null && ((tokens = this.getTokens()).length != 2 || this.parseInt(tokens[0]) == Integer.MIN_VALUE || this.parseInt(tokens[1]) < 0)) {
            }
            if (this.line == null) {
                return;
            }
            this.readInputAtoms();
            this.discardLinesUntilContains("ATOMLABELS");
            if (this.line != null) {
                this.readAtomNames();
            }
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds(atomCount0);
            }
            while (this.line != null && this.line.indexOf("END ") < 0 && this.line.indexOf("MOLSTATE") < 0) {
                this.readLine();
            }
            if (this.line != null && this.line.indexOf("MOLSTATE") >= 0) {
                this.readTransform();
            }
            if (this.atomSetCollection.getAtomCount() > 0) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void readTransform() throws Exception {
        this.readLine();
        String[] tokens = SpartanInputReader.getTokens(this.readLine() + " " + this.readLine());
        this.setTransform(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[4]), this.parseFloat(tokens[5]), this.parseFloat(tokens[6]), this.parseFloat(tokens[8]), this.parseFloat(tokens[9]), this.parseFloat(tokens[10]));
    }

    private void readInputHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith(" ")) {
        }
        this.readLine();
        this.modelName = this.line + ";";
        this.modelName = this.modelName.substring(0, this.modelName.indexOf(";")).trim();
    }

    private void readInputAtoms() throws Exception {
        this.modelAtomCount = 0;
        this.atomCount0 = this.atomCount;
        while (this.readLine() != null && !this.line.startsWith("ENDCART")) {
            String[] tokens = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = SpartanInputReader.getElementSymbol(this.parseInt(tokens[0]));
            atom.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
            ++this.modelAtomCount;
        }
        this.atomCount = this.atomSetCollection.getAtomCount();
        if (Logger.debugging) {
            Logger.debug(this.atomCount + " atoms read");
        }
    }

    private void readAtomNames() throws Exception {
        int atom0 = this.atomCount - this.modelAtomCount;
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String name;
            this.line = this.readLine().trim();
            this.atomSetCollection.getAtom((int)(atom0 + i)).atomName = name = this.line.substring(1, this.line.length() - 1);
        }
    }

    private void readBonds(int atomCount0) throws Exception {
        int nAtoms = this.modelAtomCount;
        this.bondData = "";
        while (this.readLine() != null && !this.line.startsWith("ENDHESS")) {
            String[] tokens = this.getTokens();
            this.bondData = this.bondData + this.line + " ";
            if (nAtoms == 0) {
                int sourceIndex = this.parseInt(tokens[0]) - 1 + atomCount0;
                int targetIndex = this.parseInt(tokens[1]) - 1 + atomCount0;
                int bondOrder = this.parseInt(tokens[2]);
                if (bondOrder <= 0) continue;
                this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : (bondOrder == 5 ? 515 : 1)));
                continue;
            }
            nAtoms -= tokens.length;
        }
        this.bondCount = this.atomSetCollection.getBondCount();
        if (Logger.debugging) {
            Logger.debug(this.bondCount + " bonds read");
        }
    }
}

