/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;

public class V3000Reader
extends AtomSetCollectionReader {
    int headerAtomCount;
    int headerBondCount;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("v3000");
        try {
            while (this.readLine() != null) {
                if (this.doGetModel(++this.modelNumber)) {
                    this.processCtab();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.flushLines();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void processCtab() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$") && !this.line.startsWith("M  END")) {
            if (this.line.startsWith("M  V30 BEGIN ATOM")) {
                this.processAtomBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN BOND")) {
                this.processBondBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN CTAB")) {
                this.newAtomSet("");
                continue;
            }
            if (!this.line.startsWith("M  V30 COUNTS")) continue;
            this.headerAtomCount = this.parseInt(this.line, 13);
            this.headerBondCount = this.parseInt();
        }
        if (this.line != null && !this.line.startsWith("$$$$")) {
            this.flushLines();
        }
    }

    String processAtomBlock() throws Exception {
        int i = this.headerAtomCount;
        while (--i >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized atom");
            }
            Atom atom = new Atom();
            String[] tokens = this.getTokens();
            atom.atomSerial = this.parseInt(tokens[2]);
            atom.elementSymbol = tokens[3];
            atom.set(this.parseFloat(tokens[4]), this.parseFloat(tokens[5]), this.parseFloat(tokens[6]));
            for (int j = 8; j < tokens.length; ++j) {
                String token = tokens[j];
                if (token.startsWith("CHG=")) {
                    int charge = this.parseInt(token, 4);
                    atom.formalCharge = charge > 3 ? 4 - charge : charge;
                    break;
                }
                if (!token.startsWith("MASS=")) continue;
                int isotope = this.parseInt(token, 5);
                atom.elementNumber = (short)((isotope << 7) + JmolAdapter.getElementNumber(atom.elementSymbol));
            }
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END ATOM")) {
            throw new Exception("M  V30 END ATOM not found");
        }
        return this.line;
    }

    void processBondBlock() throws Exception {
        int i = this.headerBondCount;
        while (--i >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized bond");
            }
            this.parseInt(this.line, 7);
            int order = this.parseInt();
            int atomSerial1 = this.parseInt();
            int atomSerial2 = this.parseInt();
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(atomSerial1, atomSerial2, order);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END BOND")) {
            throw new Exception("M  V30 END BOND not found");
        }
    }

    void readLineWithContinuation() throws Exception {
        this.readLine();
        if (this.line != null && this.line.length() > 7) {
            while (this.line.charAt(this.line.length() - 1) == '-') {
                String line2 = this.readLine();
                if (line2 == null || !this.line.startsWith("M  V30 ")) {
                    throw new Exception("Invalid line continuation");
                }
                this.line = this.line + line2.substring(7);
            }
        }
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }
}

