/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Hashtable;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlChem3dReader
extends XmlReader {
    String[] chem3dImplementedAttributes = new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatDat", "calcPartialCharges", "calcAtoms"};

    XmlChem3dReader() {
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        new Chem3dHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.chem3dImplementedAttributes;
        new Chem3dHandler().walkDOMTree(DOMNode);
    }

    public void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        String[] tokens;
        if ("model".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.atom = new Atom();
            this.atom.atomName = (String)atts.get("id");
            this.atom.elementSymbol = (String)atts.get("symbol");
            if (atts.containsKey("cartCoords")) {
                String xyz = (String)atts.get("cartCoords");
                String[] tokens2 = XmlChem3dReader.getTokens(xyz);
                this.atom.set(this.parseFloat(tokens2[0]), this.parseFloat(tokens2[1]), this.parseFloat(tokens2[2]));
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)atts.get("bondAtom1");
            String atom2 = (String)atts.get("bondAtom2");
            int order = 1;
            if (atts.containsKey("bondOrder")) {
                order = this.parseInt((String)atts.get("bondOrder"));
            }
            this.atomSetCollection.addNewBond(atom1, atom2, order);
            return;
        }
        if ("electronicStructureCalculation".equals(localName)) {
            tokens = XmlChem3dReader.getTokens((String)atts.get("calcPartialCharges"));
            String[] tokens2 = XmlChem3dReader.getTokens((String)atts.get("calcAtoms"));
            int i = this.parseInt(tokens[0]);
            while (--i >= 0) {
                this.atomSetCollection.mapPartialCharge(tokens2[i + 1], this.parseFloat(tokens[i + 1]));
            }
        }
        if ("gridData".equals(localName)) {
            this.atomSetCollection.newVolumeData();
            int nPointsX = this.parseInt((String)atts.get("gridDatXDim"));
            int nPointsY = this.parseInt((String)atts.get("gridDatYDim"));
            int nPointsZ = this.parseInt((String)atts.get("gridDatZDim"));
            this.atomSetCollection.setVoxelCounts(nPointsX, nPointsY, nPointsZ);
            float xStep = this.parseFloat((String)atts.get("gridDatXSize")) / (float)nPointsX;
            float yStep = this.parseFloat((String)atts.get("gridDatYSize")) / (float)nPointsY;
            float zStep = this.parseFloat((String)atts.get("gridDatZSize")) / (float)nPointsZ;
            this.atomSetCollection.setVolumetricVector(0, xStep, 0.0f, 0.0f);
            this.atomSetCollection.setVolumetricVector(1, 0.0f, yStep, 0.0f);
            this.atomSetCollection.setVolumetricVector(2, 0.0f, 0.0f, zStep);
            tokens = XmlChem3dReader.getTokens((String)atts.get("gridDatOrigin"));
            this.atomSetCollection.setVolumetricOrigin(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
            tokens = XmlChem3dReader.getTokens((String)atts.get("gridDatData"));
            int nData = this.parseInt(tokens[0]);
            int pt = 1;
            float[][][] voxelData = new float[nPointsX][nPointsY][nPointsZ];
            for (int z = 0; z < nPointsZ; ++z) {
                for (int y = 0; y < nPointsY; ++y) {
                    for (int x = 0; x < nPointsX; ++x) {
                        voxelData[x][y][z] = this.parseFloat(tokens[pt++]);
                    }
                }
            }
            this.atomSetCollection.setVoxelData(voxelData);
            Hashtable<String, Object> surfaceInfo = new Hashtable<String, Object>();
            surfaceInfo.put("surfaceDataType", "mo");
            surfaceInfo.put("defaultCutoff", new Float(0.01));
            surfaceInfo.put("nCubeData", new Integer(nData));
            surfaceInfo.put("volumeData", this.atomSetCollection.getVolumeData());
            this.atomSetCollection.setAtomSetAuxiliaryInfo("jmolSurfaceInfo", surfaceInfo);
            Logger.debug("Chem3D molecular orbital data displayable using:  isosurface sign \"\" ");
            return;
        }
    }

    public void processEndElement(String uri, String localName, String qName) {
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class Chem3dHandler
    extends XmlReader.JmolXmlHandler {
        Chem3dHandler() {
            super(XmlChem3dReader.this);
        }

        Chem3dHandler(XMLReader xmlReader) {
            super(XmlChem3dReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

