/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.vecmath.Point3f;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlOdysseyReader
extends XmlReader {
    String[] odysseyImplementedAttributes = new String[]{"id", "label", "xyz", "element", "hybrid", "a", "b", "order", "boundary"};
    String modelName = null;
    String formula = null;
    String phase = null;

    XmlOdysseyReader() {
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        new OdysseyHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.odysseyImplementedAttributes;
        new OdysseyHandler().walkDOMTree(DOMNode);
    }

    protected void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        if ("structure".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.atom = new Atom();
            this.atom.atomName = atts.containsKey("label") ? (String)atts.get("label") : (String)atts.get("id");
            if (atts.containsKey("xyz")) {
                String xyz = (String)atts.get("xyz");
                String[] tokens = XmlOdysseyReader.getTokens(xyz);
                this.parent.setAtomCoord(this.atom, this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
            }
            if (atts.containsKey("element")) {
                this.atom.elementSymbol = (String)atts.get("element");
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)atts.get("a");
            String atom2 = (String)atts.get("b");
            int order = 1;
            if (atts.containsKey("order")) {
                order = this.parseBondToken((String)atts.get("order"));
            }
            this.atomSetCollection.addNewBond(atom1, atom2, order);
            return;
        }
        if ("boundary".equals(localName)) {
            String[] boxDim = XmlOdysseyReader.getTokens((String)atts.get("box"));
            float x = this.parseFloat(boxDim[0]);
            float y = this.parseFloat(boxDim[1]);
            float z = this.parseFloat(boxDim[2]);
            this.parent.setUnitCellItem(0, x);
            this.parent.setUnitCellItem(1, y);
            this.parent.setUnitCellItem(2, z);
            this.parent.setUnitCellItem(3, 90.0f);
            this.parent.setUnitCellItem(4, 90.0f);
            this.parent.setUnitCellItem(5, 90.0f);
            Point3f pt = new Point3f(-x / 2.0f, -y / 2.0f, -z / 2.0f);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("periodicOriginXyz", pt);
            Atom[] atoms = this.atomSetCollection.getAtoms();
            int i = this.atomSetCollection.getAtomCount();
            while (--i >= 0) {
                atoms[i].sub(pt);
                this.parent.setAtomCoord(atoms[i]);
            }
            if (this.parent.latticeCells[0] == 0) {
                this.parent.latticeCells[2] = 1;
                this.parent.latticeCells[1] = 1;
                this.parent.latticeCells[0] = 1;
            }
            this.parent.setSymmetryOperator("x,y,z");
            this.parent.setSpaceGroupName("P1");
            this.applySymmetryAndSetTrajectory();
            return;
        }
        if ("odyssey_simulation".equals(localName)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.formula);
            }
        }
        if ("title".equals(localName) || "formula".equals(localName) || "phase".equals(localName)) {
            this.keepChars = true;
        }
    }

    public void applySymmetryAndSetTrajectory() {
        try {
            this.parent.applySymmetryAndSetTrajectory();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error("applySymmetry failed: " + e);
        }
    }

    int parseBondToken(String str) {
        if (str.length() >= 1) {
            switch (str.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 515;
                }
            }
            return this.parseInt(str);
        }
        return 1;
    }

    protected void processEndElement(String uri, String localName, String qName) {
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        if ("title".equals(localName)) {
            this.modelName = this.chars;
        }
        if ("formula".equals(localName)) {
            this.formula = this.chars;
        }
        if ("phase".equals(localName)) {
            this.phase = this.chars;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class OdysseyHandler
    extends XmlReader.JmolXmlHandler {
        OdysseyHandler() {
            super(XmlOdysseyReader.this);
        }

        OdysseyHandler(XMLReader xmlReader) {
            super(XmlOdysseyReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

