/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import javax.vecmath.Point3f;

public class Atom
extends Point3f
implements Cloneable {
    public int atomSetIndex;
    public int atomIndex;
    public BitSet bsSymmetry;
    public int atomSite;
    public String elementSymbol;
    public short elementNumber = (short)-1;
    public String atomName;
    public int formalCharge = Integer.MIN_VALUE;
    public float partialCharge;
    public float vectorX;
    public float vectorY;
    public float vectorZ;
    public float bfactor;
    public int occupancy;
    public float radius;
    public boolean isHetero;
    public int atomSerial;
    public char chainID;
    public char alternateLocationID;
    public String group3;
    public int sequenceNumber;
    public char insertionCode;
    public float[] anisoBorU;
    public Object[] ellipsoid;
    static final int[] elementCharMasks = new int[]{1972292, -2147351151, -2146019271, -2130706430, 0x160000, -2147348464, 25, -2147205008, -2147344384, 0, -2147352576, 0x120101, 548936, -2147434213, -2147221504, -2145759221, 0, 1056947, -2147339946, -2147477097, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x800010, -2147483646, 139264};

    public Atom() {
        this.set(Float.NaN, Float.NaN, Float.NaN);
        this.partialCharge = Float.NaN;
        this.vectorX = Float.NaN;
        this.vectorY = Float.NaN;
        this.vectorZ = Float.NaN;
        this.bfactor = Float.NaN;
        this.occupancy = 100;
        this.radius = Float.NaN;
        this.atomSerial = Integer.MIN_VALUE;
        this.chainID = '\u0000';
        this.alternateLocationID = '\u0000';
        this.sequenceNumber = Integer.MIN_VALUE;
        this.insertionCode = '\u0000';
    }

    public Atom cloneAtom() throws Exception {
        try {
            return (Atom)super.clone();
        }
        catch (Exception cnse) {
            throw new Exception("cloneAtom error: " + cnse.getMessage(), cnse);
        }
    }

    public String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int ichFirst;
            int len = this.atomName.length();
            char chFirst = '\u0000';
            for (ichFirst = 0; ichFirst < len && !Atom.isValidFirstSymbolChar(chFirst = this.atomName.charAt(ichFirst)); ++ichFirst) {
            }
            switch (len - ichFirst) {
                case 0: {
                    break;
                }
                default: {
                    char chSecond = this.atomName.charAt(ichFirst + 1);
                    if (Atom.isValidElementSymbolNoCaseSecondChar(chFirst, chSecond)) {
                        this.elementSymbol = "" + chFirst + chSecond;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidElementSymbol(chFirst)) break;
                    this.elementSymbol = "" + chFirst;
                }
            }
        }
        return this.elementSymbol;
    }

    public void addVibrationVector(float vectorX, float vectorY, float vectorZ) {
        this.vectorX = vectorX;
        this.vectorY = vectorY;
        this.vectorZ = vectorZ;
    }

    public static boolean isValidElementSymbol(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] < 0;
    }

    public static boolean isValidElementSymbol(char chFirst, char chSecond) {
        if (chFirst < 'A' || chFirst > 'Z' || chSecond < 'a' || chSecond > 'z') {
            return false;
        }
        return (elementCharMasks[chFirst - 65] >> chSecond - 97 & 1) != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(char chFirst, char chSecond) {
        if (chSecond >= 'A' && chSecond <= 'Z') {
            chSecond = (char)(chSecond + 32);
        }
        if (chFirst < 'A' || chFirst > 'Z' || chSecond < 'a' || chSecond > 'z') {
            return false;
        }
        return (elementCharMasks[chFirst - 65] >> chSecond - 97 & 1) != 0;
    }

    public static boolean isValidFirstSymbolChar(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        char chFirst = str.charAt(0);
        if (length == 1) {
            return Atom.isValidElementSymbol(chFirst);
        }
        if (length > 2) {
            return false;
        }
        char chSecond = str.charAt(1);
        return Atom.isValidElementSymbolNoCaseSecondChar(chFirst, chSecond);
    }
}

