/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "isPDB"};
    static final int GLOBAL_FRACTCOORD = 0;
    static final int GLOBAL_SYMMETRY = 1;
    static final int GLOBAL_latticeCells = 2;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    int[] atomSetBondCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    int[] latticeCells;
    public String errorMessage;
    boolean coordinatesAreFractional;
    private boolean isTrajectory;
    int trajectoryStepCount = 0;
    Point3f[] trajectoryStep;
    Vector trajectorySteps;
    float[] notionalUnitCell = new float[6];
    private boolean noAutoBond;
    Vector vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    float symmetryRange;
    SymmetryInterface symmetry;
    boolean doNormalize = true;
    boolean doPackUnitCell = false;
    boolean isLatticeRange = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final Point3f ptOffset = new Point3f();
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    boolean checkSpecial = true;
    private final Point3f ptTemp = new Point3f();
    private final Point3f ptTemp1 = new Point3f();
    private final Point3f ptTemp2 = new Point3f();
    Hashtable atomSymbolicMap = new Hashtable();
    boolean haveMappedSerials;
    VolumeDataInterface vd;

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int i) {
        return this.atoms[i];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int i) {
        return this.bonds[i];
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public boolean isTrajectory() {
        return this.isTrajectory;
    }

    public AtomSetCollection(String fileTypeName) {
        this.fileTypeName = fileTypeName;
        this.atomSetCollectionProperties.put("PATH_KEY", ".PATH");
        this.atomSetCollectionProperties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    public AtomSetCollection(AtomSetCollection[] array) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < array.length; ++i) {
            this.appendAtomSetCollection(i, array[i]);
        }
    }

    public AtomSetCollection(Vector list) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        this.appendAtomSetCollection(list);
    }

    private void appendAtomSetCollection(Vector list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object o = list.elementAt(i);
            if (o instanceof Vector) {
                this.appendAtomSetCollection((Vector)o);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)o);
        }
    }

    public void setFileTypeName(String type) {
        this.fileTypeName = type;
    }

    public boolean setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectorySteps = new Vector();
        }
        this.isTrajectory = true;
        return true;
    }

    protected void appendAtomSetCollection(int collectionIndex, AtomSetCollection collection) {
        int existingAtomsCount = this.atomCount;
        int clonedAtoms = 0;
        for (int atomSetNum = 0; atomSetNum < collection.atomSetCount; ++atomSetNum) {
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = collection.atomSetAuxiliaryInfo[atomSetNum];
            this.setAtomSetAuxiliaryInfo("title", collection.collectionName);
            this.setAtomSetName(collection.getAtomSetName(atomSetNum));
            Properties properties = collection.getAtomSetProperties(atomSetNum);
            if (properties != null) {
                Enumeration<Object> props = properties.keys();
                while (props != null && props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    this.setAtomSetProperty(key, properties.getProperty(key));
                }
            }
            for (int atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; ++atomNum) {
                try {
                    this.newCloneAtom(collection.atoms[clonedAtoms]);
                }
                catch (Exception e) {
                    this.errorMessage = "appendAtomCollection error: " + e;
                }
                ++clonedAtoms;
            }
            for (int i = 0; i < collection.structureCount; ++i) {
                if (collection.structures[i].modelIndex != atomSetNum && collection.structures[i].modelIndex != -1) continue;
                this.addStructure(collection.structures[i]);
            }
            this.atomSetNames[this.currentAtomSetIndex] = collection.atomSetNames[atomSetNum];
            this.atomSetNumbers[this.currentAtomSetIndex] = (collectionIndex + 1) * 1000000 + collection.atomSetNumbers[atomSetNum];
        }
        for (int bondNum = 0; bondNum < collection.bondCount; ++bondNum) {
            Bond bond = collection.bonds[bondNum];
            this.addNewBond(bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
        }
        int i = globalBooleans.length;
        while (--i >= 0) {
            if (!Boolean.TRUE.equals(collection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[i]))) continue;
            this.setGlobalBoolean(i);
        }
    }

    void setNoAutoBond() {
        this.noAutoBond = true;
    }

    void finish() {
        for (int i = 0; i < this.atomSetCount; ++i) {
            if (this.noAutoBond) {
                this.setAtomSetAuxiliaryInfo("noAutoBond", Boolean.TRUE, i);
            }
            this.setAtomSetAuxiliaryInfo("initialAtomCount", new Integer(this.atomSetAtomCounts[i]), i);
            this.setAtomSetAuxiliaryInfo("initialBondCount", new Integer(this.atomSetBondCounts[i]), i);
        }
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetCollectionProperties = new Properties();
        this.atomSetCollectionAuxiliaryInfo = new Hashtable();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSetNames = new String[16];
        this.atomSetProperties = new Properties[16];
        this.atomSymbolicMap = new Hashtable();
        this.bonds = null;
        this.cartesians = null;
        this.connectLast = null;
        this.currentAtomSetIndex = -1;
        this.latticeCells = null;
        this.notionalUnitCell = null;
        this.symmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectoryStep = null;
        this.trajectorySteps = null;
        this.vConnect = null;
        this.vd = null;
    }

    void freeze() {
        if (this.isTrajectory) {
            this.finalizeTrajectory(true);
        }
        this.getAltLocLists();
        this.getInsertionLists();
    }

    public void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.clearSymbolicMap();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        i = this.atomSetNames.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetNames[i] = null;
        }
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    public void cloneFirstAtomSet() throws Exception {
        this.newAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int i = 0; i < firstCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int nBonds) throws Exception {
        this.cloneFirstAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int bondNum = 0; bondNum < nBonds; ++bondNum) {
            Bond bond = this.bonds[this.bondCount - nBonds];
            this.addNewBond(bond.atomIndex1 + firstCount, bond.atomIndex2 + firstCount, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--count >= 0) {
            this.newCloneAtom(this.atoms[atomIndex]);
            ++atomIndex;
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    public Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        if (atomIndex1 < 0 || atomIndex1 >= this.atomCount || atomIndex2 < 0 || atomIndex2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    public Bond addNewBondWithMappedSerialNumbers(int atomSerial1, int atomSerial2, int order) {
        return this.addNewBond(this.getAtomSerialNumberIndex(atomSerial1), this.getAtomSerialNumberIndex(atomSerial2), order);
    }

    public void addConnection(int[] is) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new Vector();
        }
        if (this.connectLast != null && is[0] == this.connectLast[0] && is[1] == this.connectLast[1] && is[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = is;
        this.vConnect.addElement(is);
    }

    public void connectAll(int maxSerial) {
        if (this.vConnect == null) {
            return;
        }
        int firstAtom = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetCollectionAuxiliaryInfo("someModelsHaveCONECT", Boolean.TRUE);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{firstAtom, this.atomSetAtomCounts[i], maxSerial}, i);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_bonds", this.vConnect, i);
            firstAtom += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = firstAtom;
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.currentAtomSetIndex;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
    }

    void setAtomSetSpaceGroupName(String spaceGroupName) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", spaceGroupName + "");
    }

    void setCoordinatesAreFractional(boolean coordinatesAreFractional) {
        this.coordinatesAreFractional = coordinatesAreFractional;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", coordinatesAreFractional);
        if (coordinatesAreFractional) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float factor) {
        this.symmetryRange = factor;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", new Float(factor));
    }

    void setLatticeCells(int[] latticeCells, boolean applySymmetryToBonds, boolean doPackUnitCell) {
        this.latticeCells = latticeCells;
        this.isLatticeRange = (latticeCells[2] == 0 || latticeCells[2] == 1 || latticeCells[2] == -1) && latticeCells[0] <= 555 && latticeCells[1] >= 555;
        this.doNormalize = !this.isLatticeRange || latticeCells[2] == 1;
        this.doPackUnitCell = doPackUnitCell;
        this.setApplySymmetryToBonds(applySymmetryToBonds);
    }

    private SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    boolean setNotionalUnitCell(float[] info) {
        this.notionalUnitCell = new float[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.notionalUnitCell[i] = info[i];
        }
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        return true;
    }

    void setGlobalBoolean(int globalIndex) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[globalIndex], Boolean.TRUE);
    }

    boolean addSpaceGroupOperation(String xyz) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(xyz);
    }

    public void setLatticeParameter(int latt) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(latt);
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    void applySymmetry(SymmetryInterface symmetry) throws Exception {
        this.getSymmetry().setSpaceGroup(symmetry);
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    void applySymmetry(int maxX, int maxY, int maxZ) throws Exception {
        if (this.coordinatesAreFractional && this.getSymmetry().haveSpaceGroup()) {
            this.applyAllSymmetry(maxX, maxY, maxZ);
        }
    }

    private void setSymmetryMinMax(Point3f c) {
        if (this.rminx > c.x) {
            this.rminx = c.x;
        }
        if (this.rminy > c.y) {
            this.rminy = c.y;
        }
        if (this.rminz > c.z) {
            this.rminz = c.z;
        }
        if (this.rmaxx < c.x) {
            this.rmaxx = c.x;
        }
        if (this.rmaxy < c.y) {
            this.rmaxy = c.y;
        }
        if (this.rmaxz < c.z) {
            this.rmaxz = c.z;
        }
    }

    private boolean isInSymmetryRange(Point3f c) {
        return c.x >= this.rminx && c.y >= this.rminy && c.z >= this.rminz && c.x <= this.rmaxx && c.y <= this.rmaxy && c.z <= this.rmaxz;
    }

    private static boolean isWithinCell(Point3f pt, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        float slop = 0.02f;
        return pt.x > (float)minX - slop && pt.x < (float)maxX + slop && pt.y > (float)minY - slop && pt.y < (float)maxY + slop && pt.z > (float)minZ - slop && pt.z < (float)maxZ + slop;
    }

    private void applyAllSymmetry(int maxX, int maxY, int maxZ) throws Exception {
        int tz;
        int ty;
        int tx;
        boolean checkRange111;
        int iAtomFirst;
        int noSymmetryCount = this.getLastAtomSetAtomCount();
        for (int i = iAtomFirst = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            this.atoms[i].ellipsoid = this.symmetry.getEllipsoid(this.atoms[i].anisoBorU);
        }
        this.bondCount0 = this.bondCount;
        this.symmetry.setFinalOperations(this.atoms, iAtomFirst, noSymmetryCount, this.doNormalize);
        int operationCount = this.symmetry.getSpaceGroupOperationCount();
        this.minX = 0;
        this.minY = 0;
        this.minZ = 0;
        if (this.isLatticeRange) {
            this.minX = maxX / 100 - 5;
            this.minY = maxX % 100 / 10 - 5;
            this.minZ = maxX % 10 - 5;
            maxX = maxY / 100 - 4;
            maxZ = maxY % 10 - 4;
            maxY = maxY % 100 / 10 - 4;
        }
        if (this.doPackUnitCell) {
            --this.minX;
            ++maxX;
            --this.minY;
            ++maxY;
            --this.minZ;
            ++maxZ;
        }
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        int nCells = (maxX - this.minX) * (maxY - this.minY) * (maxZ - this.minZ);
        int cartesianCount = this.checkSpecial ? noSymmetryCount * operationCount * nCells : (this.symmetryRange > 0.0f ? noSymmetryCount * operationCount : (this.symmetryRange < 0.0f ? 1 : 1));
        this.cartesians = new Point3f[cartesianCount];
        for (int i = 0; i < noSymmetryCount; ++i) {
            this.atoms[i + iAtomFirst].bsSymmetry = new BitSet(operationCount * (nCells + 1));
        }
        int pt = 0;
        int[] unitCells = new int[nCells];
        int iCell = 0;
        int cell555Count = 0;
        float absRange = Math.abs(this.symmetryRange);
        boolean checkSymmetryRange = this.symmetryRange != 0.0f;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean bl = checkRange111 = this.symmetryRange > 0.0f;
        if (checkSymmetryRange) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        Matrix4f op = this.symmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (tx = this.minX; tx < maxX; ++tx) {
            for (ty = this.minY; ty < maxY; ++ty) {
                for (tz = this.minZ; tz < maxZ; ++tz) {
                    unitCells[iCell++] = 555 + tx * 100 + ty * 10 + tz;
                    if (tx != 0 || ty != 0 || tz != 0 || this.cartesians.length == 0) continue;
                    for (pt = 0; pt < noSymmetryCount; ++pt) {
                        Atom atom = this.atoms[iAtomFirst + pt];
                        Point3f c = new Point3f(atom);
                        op.transform(c);
                        this.symmetry.toCartesian(c);
                        if (this.doPackUnitCell) {
                            this.symmetry.toUnitCell(c, this.ptOffset);
                            atom.set(c);
                            this.symmetry.toFractional(atom);
                        }
                        atom.bsSymmetry.set(iCell * operationCount);
                        atom.bsSymmetry.set(0);
                        if (checkSymmetryRange) {
                            this.setSymmetryMinMax(c);
                        }
                        if (pt >= cartesianCount) continue;
                        this.cartesians[pt] = c;
                    }
                    if (checkRangeNoSymmetry) {
                        this.rminx -= absRange;
                        this.rminy -= absRange;
                        this.rminz -= absRange;
                        this.rmaxx += absRange;
                        this.rmaxy += absRange;
                        this.rmaxz += absRange;
                    }
                    cell555Count = pt = this.symmetryAddAtoms(iAtomFirst, noSymmetryCount, 0, 0, 0, 0, pt, iCell * operationCount);
                }
            }
        }
        if (checkRange111) {
            this.rminx -= absRange;
            this.rminy -= absRange;
            this.rminz -= absRange;
            this.rmaxx += absRange;
            this.rmaxy += absRange;
            this.rmaxz += absRange;
        }
        iCell = 0;
        for (tx = this.minX; tx < maxX; ++tx) {
            for (ty = this.minY; ty < maxY; ++ty) {
                for (tz = this.minZ; tz < maxZ; ++tz) {
                    ++iCell;
                    if (tx == 0 && ty == 0 && tz == 0) continue;
                    pt = this.symmetryAddAtoms(iAtomFirst, noSymmetryCount, tx, ty, tz, cell555Count, pt, iCell * operationCount);
                }
            }
        }
        if (operationCount > 0) {
            String[] symmetryList = new String[operationCount];
            for (int i = 0; i < operationCount; ++i) {
                symmetryList[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", symmetryList);
        }
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(iAtomFirst));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(noSymmetryCount));
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(operationCount));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.symmetry.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", unitCells);
        this.symmetry.setSpaceGroup(null);
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    public void setCheckSpecial(boolean TF) {
        this.checkSpecial = TF;
    }

    void setApplySymmetryToBonds(boolean TF) {
        this.applySymmetryToBonds = TF;
    }

    private int symmetryAddAtoms(int iAtomFirst, int noSymmetryCount, int transX, int transY, int transZ, int baseCount, int pt, int iCellOpPt) throws Exception {
        boolean addCartesian;
        int[] atomMap;
        boolean isBaseCell = baseCount == 0;
        boolean addBonds = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray = atomMap = addBonds ? new int[noSymmetryCount] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(transX, transY, transZ);
        }
        float range2 = this.symmetryRange * this.symmetryRange;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean checkRange111 = this.symmetryRange > 0.0f;
        boolean checkSymmetryMinMax = isBaseCell && checkRange111;
        boolean checkSymmetryRange = checkRangeNoSymmetry || (checkRange111 &= !isBaseCell);
        boolean checkDistances = this.checkSpecial || checkSymmetryRange;
        boolean bl = addCartesian = this.checkSpecial || checkSymmetryMinMax;
        if (checkRangeNoSymmetry) {
            baseCount = noSymmetryCount;
        }
        int nOperations = this.symmetry.getSpaceGroupOperationCount();
        int atomMax = iAtomFirst + noSymmetryCount;
        Point3f ptAtom = new Point3f();
        for (int iSym = 0; iSym < nOperations; ++iSym) {
            if (isBaseCell && this.symmetry.getSpaceGroupXyz(iSym, true).equals("x,y,z")) continue;
            int pt0 = this.checkSpecial ? pt : (checkRange111 ? baseCount : 0);
            for (int i = iAtomFirst; i < atomMax; ++i) {
                this.symmetry.newSpaceGroupPoint(iSym, this.atoms[i], ptAtom, transX, transY, transZ);
                Atom special = null;
                Point3f cartesian = new Point3f(ptAtom);
                this.symmetry.toCartesian(cartesian);
                if (this.doPackUnitCell) {
                    this.symmetry.toUnitCell(cartesian, this.ptOffset);
                    ptAtom.set(cartesian);
                    this.symmetry.toFractional(ptAtom);
                    if (!AtomSetCollection.isWithinCell(ptAtom, this.minX + 1, this.maxX - 1, this.minY + 1, this.maxY - 1, this.minZ + 1, this.maxZ - 1)) continue;
                }
                if (checkSymmetryMinMax) {
                    this.setSymmetryMinMax(cartesian);
                }
                if (checkDistances) {
                    float minDist2 = Float.MAX_VALUE;
                    if (checkSymmetryRange && !this.isInSymmetryRange(cartesian)) continue;
                    int j = pt0;
                    while (--j >= 0) {
                        float d2 = cartesian.distanceSquared(this.cartesians[j]);
                        if (this.checkSpecial && (double)d2 < 1.0E-4) {
                            special = this.atoms[iAtomFirst + j];
                            break;
                        }
                        if (!checkRange111 || j >= baseCount || !(d2 < minDist2)) continue;
                        minDist2 = d2;
                    }
                    if (checkRange111 && minDist2 > range2) continue;
                }
                int atomSite = this.atoms[i].atomSite;
                if (special != null) {
                    if (addBonds) {
                        atomMap[atomSite] = special.atomIndex;
                    }
                    special.bsSymmetry.set(iCellOpPt + iSym);
                    special.bsSymmetry.set(iSym);
                    continue;
                }
                if (addBonds) {
                    atomMap[atomSite] = this.atomCount;
                }
                Atom atom1 = this.newCloneAtom(this.atoms[i]);
                atom1.set(ptAtom);
                atom1.atomSite = atomSite;
                atom1.bsSymmetry = new BitSet(1);
                atom1.bsSymmetry.set(iCellOpPt + iSym);
                atom1.bsSymmetry.set(iSym);
                if (addCartesian) {
                    this.cartesians[pt++] = cartesian;
                }
                if (this.atoms[i].ellipsoid == null) continue;
                Object axes = this.atoms[i].ellipsoid[0];
                Object lengths = this.atoms[i].ellipsoid[1];
                if (axes != null) {
                    if (addCartesian) {
                        this.ptTemp.set(this.cartesians[i - iAtomFirst]);
                    } else {
                        this.ptTemp.set(this.atoms[i]);
                        this.symmetry.toCartesian(this.ptTemp);
                    }
                    axes = this.symmetry.rotateEllipsoid(iSym, this.ptTemp, (Vector3f[])axes, this.ptTemp1, this.ptTemp2);
                }
                atom1.ellipsoid = new Object[]{axes, lengths};
            }
            if (!addBonds) continue;
            for (int bondNum = this.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                Bond bond = this.bonds[bondNum];
                int iAtom1 = atomMap[this.atoms[bond.atomIndex1].atomSite];
                int iAtom2 = atomMap[this.atoms[bond.atomIndex2].atomSite];
                if (iAtom1 < atomMax && iAtom2 < atomMax) continue;
                this.addNewBond(iAtom1, iAtom2, bond.order);
            }
        }
        return pt;
    }

    public void applySymmetry(Vector biomts, boolean applySymmetryToBonds, String filter) {
        int len = biomts.size();
        this.setApplySymmetryToBonds(applySymmetryToBonds);
        this.bondCount0 = this.bondCount;
        boolean addBonds = this.bondCount0 > this.bondIndex0 && applySymmetryToBonds;
        int[] atomMap = addBonds ? new int[this.atomCount] : null;
        int iAtomFirst = this.getLastAtomSetAtomIndex();
        int atomMax = this.atomCount;
        for (int iAtom = iAtomFirst; iAtom < atomMax; ++iAtom) {
            this.atoms[iAtom].bsSymmetry = new BitSet(1);
            this.atoms[iAtom].bsSymmetry.set(0);
        }
        for (int i = 1; i < len; ++i) {
            if (filter.indexOf("!#") >= 0 ? filter.toUpperCase().indexOf("!#" + (i + 1) + ";") >= 0 : filter.indexOf("#") >= 0 && filter.toUpperCase().indexOf("#" + (i + 1) + ";") < 0) continue;
            Matrix4f mat = new Matrix4f();
            mat.set((float[])biomts.get(i));
            for (int iAtom = iAtomFirst; iAtom < atomMax; ++iAtom) {
                try {
                    int atomSite = this.atoms[i].atomSite;
                    if (addBonds) {
                        atomMap[atomSite] = this.atomCount;
                    }
                    Atom atom1 = this.newCloneAtom(this.atoms[iAtom]);
                    atom1.atomSite = atomSite;
                    mat.transform(atom1);
                    atom1.bsSymmetry = new BitSet(1);
                    atom1.bsSymmetry.set(i);
                    if (!addBonds) continue;
                    for (int bondNum = this.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                        Bond bond = this.bonds[bondNum];
                        int iAtom1 = atomMap[this.atoms[bond.atomIndex1].atomSite];
                        int iAtom2 = atomMap[this.atoms[bond.atomIndex2].atomSite];
                        if (iAtom1 < atomMax && iAtom2 < atomMax) continue;
                        this.addNewBond(iAtom1, iAtom2, bond.order);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.errorMessage = "appendAtomCollection error: " + e;
                }
            }
            this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(iAtomFirst));
            this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(atomMax - iAtomFirst));
            this.setAtomSetAuxiliaryInfo("biosymmetryCount", new Integer(len));
            this.symmetry = null;
            this.notionalUnitCell = new float[6];
            this.coordinatesAreFractional = false;
            this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
            this.setGlobalBoolean(1);
        }
    }

    public void setCollectionName(String collectionName) {
        if (collectionName != null) {
            if ((collectionName = collectionName.trim()).length() == 0) {
                return;
            }
            this.collectionName = collectionName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomSymbolicMap.put(atomName, new Integer(index));
            }
        }
    }

    public void clearSymbolicMap() {
        this.atomSymbolicMap.clear();
        this.haveMappedSerials = false;
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount == 0) {
            return;
        }
        int index = this.atomCount - 1;
        int atomSerial = this.atoms[index].atomSerial;
        if (atomSerial != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put(new Integer(atomSerial), new Integer(index));
        }
        this.haveMappedSerials = true;
    }

    public void createAtomSerialMap() {
        if (this.haveMappedSerials || this.currentAtomSetIndex < 0) {
            return;
        }
        for (int i = this.getLastAtomSetAtomCount(); i < this.atomCount; ++i) {
            int atomSerial = this.atoms[i].atomSerial;
            if (atomSerial == Integer.MIN_VALUE) continue;
            this.atomSymbolicMap.put(new Integer(atomSerial), new Integer(i));
        }
        this.haveMappedSerials = true;
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomSymbolicMap.put(atomName, new Integer(atomIndex));
    }

    public int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    public int getAtomSerialNumberIndex(int serialNumber) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(new Integer(serialNumber));
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    public void setAtomSetCollectionProperty(String key, String value) {
        this.atomSetCollectionProperties.put(key, value);
    }

    String getAtomSetCollectionProperty(String key) {
        return (String)this.atomSetCollectionProperties.get(key);
    }

    public void setAtomSetCollectionAuxiliaryInfo(String key, Object value) {
        this.atomSetCollectionAuxiliaryInfo.put(key, value);
    }

    public boolean setAtomSetCollectionPartialCharges(String auxKey) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.atomSetCollectionAuxiliaryInfo.get(auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    public void mapPartialCharge(String atomName, float charge) {
        this.atoms[this.getAtomNameIndex((String)atomName)].partialCharge = charge;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String key) {
        return this.atomSetCollectionAuxiliaryInfo.get(key);
    }

    private void addTrajectoryStep() {
        if (this.trajectoryStep.length == 0 || this.trajectoryStep.length < this.atomCount) {
            this.trajectoryStep = new Point3f[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            this.trajectoryStep[i] = new Point3f(this.atoms[i]);
        }
        this.trajectorySteps.addElement(this.trajectoryStep);
        ++this.trajectoryStepCount;
    }

    void finalizeTrajectory(Vector trajectorySteps) {
        this.trajectorySteps = trajectorySteps;
        this.trajectoryStepCount = trajectorySteps.size();
        this.finalizeTrajectory(false);
    }

    private void finalizeTrajectory(boolean addStep) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        if (addStep) {
            if (this.trajectoryStep == null || this.trajectoryStep.length == 0) {
                return;
            }
            this.addTrajectoryStep();
        }
        Point3f[] trajectory = (Point3f[])this.trajectorySteps.get(0);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].set(trajectory[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
    }

    public void newAtomSet() {
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            if (this.trajectoryStep == null && this.atomCount > 0) {
                this.trajectoryStep = new Point3f[0];
            }
            if (this.trajectoryStep != null) {
                this.addTrajectoryStep();
            }
            this.trajectoryStep = new Point3f[this.atomCount];
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNames = ArrayUtil.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetBondCounts = ArrayUtil.doubleLength(this.atomSetBondCounts);
            this.atomSetProperties = (Properties[])ArrayUtil.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public void setAtomSetName(String atomSetName) {
        this.setAtomSetName(atomSetName, this.currentAtomSetIndex);
    }

    public void setAtomSetName(String atomSetName, int atomSetIndex) {
        this.atomSetNames[atomSetIndex] = atomSetName;
    }

    public void setAtomSetNames(String atomSetName, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(atomSetName, idx);
            --idx;
        }
    }

    public void setAtomSetNumber(int atomSetNumber) {
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = atomSetNumber;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = atomSetNumber;
        }
    }

    public void setAtomSetProperty(String key, String value) {
        this.setAtomSetProperty(key, value, this.currentAtomSetIndex);
    }

    public void setAtomSetAuxiliaryInfo(String key, Object value) {
        this.setAtomSetAuxiliaryInfo(key, value, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String auxKey) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    Object getAtomSetAuxiliaryInfo(int index, String key) {
        return this.atomSetAuxiliaryInfo[index].get(key);
    }

    public void setAtomSetProperty(String key, String value, int atomSetIndex) {
        if (this.atomSetProperties[atomSetIndex] == null) {
            this.atomSetProperties[atomSetIndex] = new Properties();
        }
        this.atomSetProperties[atomSetIndex].put(key, value);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value, int atomSetIndex) {
        if (atomSetIndex < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[atomSetIndex] == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex] = new Hashtable();
        }
        if (value == null) {
            return;
        }
        this.atomSetAuxiliaryInfo[atomSetIndex].put(key, value);
    }

    public void setAtomSetProperties(String key, String value, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(key, value, idx);
            --idx;
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int index) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)this.atomSetProperties[index].clone();
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex >= this.atomSetCount ? 0 : atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        if (atomSetIndex >= this.atomSetCount) {
            atomSetIndex = this.atomSetCount - 1;
        }
        return this.atomSetNames[atomSetIndex];
    }

    Properties getAtomSetProperties(int atomSetIndex) {
        if (atomSetIndex >= this.atomSetCount) {
            atomSetIndex = this.atomSetCount - 1;
        }
        return this.atomSetProperties[atomSetIndex];
    }

    Hashtable getAtomSetAuxiliaryInfo(int atomSetIndex) {
        if (atomSetIndex >= this.atomSetCount) {
            atomSetIndex = this.atomSetCount - 1;
        }
        return this.atomSetAuxiliaryInfo[atomSetIndex];
    }

    boolean hasAlternateLocations() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int i;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].alternateLocationID;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", lists[i], i);
        }
    }

    boolean hasInsertions() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int i;
        if (!this.hasInsertions()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].insertionCode;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", lists[i], i);
        }
    }

    public void newVolumeData() {
        this.vd = (VolumeDataInterface)Interface.getOptionInterface("jvxl.data.VolumeData");
    }

    public void setVoxelCounts(int nPointsX, int nPointsY, int nPointsZ) {
        this.vd.setVoxelCounts(nPointsX, nPointsY, nPointsZ);
    }

    public void setVolumetricVector(int i, float x, float y, float z) {
        this.vd.setVolumetricVector(i, x, y, z);
    }

    public void setVolumetricOrigin(float x, float y, float z) {
        this.vd.setVolumetricOrigin(x, y, z);
    }

    public void setVoxelData(float[][][] voxelData) {
        this.vd.setVoxelData(voxelData);
    }

    public Object getVolumeData() {
        VolumeDataInterface v = this.vd;
        this.vd = null;
        return v;
    }

    public Properties setAtomNames(Properties atomIdNames) {
        if (atomIdNames == null) {
            return null;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            String s = atomIdNames.getProperty(this.atoms[i].atomName);
            if (s == null) continue;
            this.atoms[i].atomName = s;
        }
        return null;
    }
}

