/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;

public class Resolver {
    private static final String classBase = "org.jmol.adapter.readers.";
    private static final String[] readerSets = new String[]{"cifpdb.", "Cif;Pdb;", "molxyz.", "Mol;Xyz;", "xml.", "Xml;"};
    private static final String CML_NAMESPACE_URI = "http://www.xml-cml.org/schema";
    private static final int SPECIAL_JME = 0;
    private static final int SPECIAL_MOPACGRAPHF = 1;
    private static final int SPECIAL_V3000 = 2;
    private static final int SPECIAL_ODYSSEY = 3;
    private static final int SPECIAL_MOL = 4;
    private static final int SPECIAL_XYZ = 5;
    private static final int SPECIAL_FOLDINGXYZ = 6;
    private static final int SPECIAL_CUBE = 7;
    private static final int SPECIAL_ALCHEMY = 8;
    private static final int SPECIAL_WIEN = 9;
    public static final int SPECIAL_ARGUS_XML = 10;
    public static final int SPECIAL_CML_XML = 11;
    public static final int SPECIAL_CHEM3D_XML = 12;
    public static final int SPECIAL_MOLPRO_XML = 13;
    public static final int SPECIAL_ODYSSEY_XML = 14;
    public static final int SPECIAL_XSD_XML = 15;
    public static final int SPECIAL_ARGUS_DOM = 16;
    public static final int SPECIAL_CML_DOM = 17;
    public static final int SPECIAL_CHEM3D_DOM = 18;
    public static final int SPECIAL_MOLPRO_DOM = 19;
    public static final int SPECIAL_ODYSSEY_DOM = 20;
    public static final int SPECIAL_XSD_DOM = 21;
    public static final String[][] specialTags = new String[][]{{"Jme"}, {"MopacGraphf"}, {"V3000"}, {"Odyssey"}, {"Mol"}, {"Xyz"}, {"FoldingXyz"}, {"Cube"}, {"Alchemy"}, {"Wien2k"}, {"XmlArgus"}, {"XmlCml"}, {"XmlChem3d"}, {"XmlMolpro"}, {"XmlOdyssey"}, {"XmlXsd"}, {"XmlArgus(DOM)"}, {"XmlCml(DOM)"}, {"XmlChem3d(DOM)"}, {"XmlMolpro(DOM)"}, {"XmlOdyssey(DOM)"}, {"XmlXsd(DOM)"}, {"MdCrd"}};
    private static final int LEADER_CHAR_MAX = 20;
    private static final String[] cubeFileStartRecords = new String[]{"Cube", "JVXL", "#JVXL"};
    private static final String[] mol2Records = new String[]{"Mol2", "mol2", "@<TRIPOS>"};
    private static final String[] webmoFileStartRecords = new String[]{"WebMO", "[HEADER]"};
    private static final String[] moldenFileStartRecords = new String[]{"Molden", "[Molden"};
    private static final String[][] fileStartsWithRecords = new String[][]{cubeFileStartRecords, mol2Records, webmoFileStartRecords, moldenFileStartRecords};
    private static final String[] pqrLineStartRecords = new String[]{"Pqr", "REMARK   1 PQR"};
    private static final String[] pdbLineStartRecords = new String[]{"Pdb", "HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    private static final String[] shelxLineStartRecords = new String[]{"Shelx", "TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    private static final String[] cifLineStartRecords = new String[]{"Cif", "data_", "_publ"};
    private static final String[] ghemicalMMLineStartRecords = new String[]{"GhemicalMM", "!Header mm1gp", "!Header gpr"};
    private static final String[] jaguarLineStartRecords = new String[]{"Jaguar", "  |  Jaguar version"};
    private static final String[] hinLineStartRecords = new String[]{"Hin", "mol "};
    private static final String[] mdlLineStartRecords = new String[]{"Mol", "$MDL "};
    private static final String[] spartanSmolLineStartRecords = new String[]{"SpartanSmol", "INPUT="};
    private static final String[] csfLineStartRecords = new String[]{"Csf", "local_transform"};
    private static final String[] mdTopLineStartRecords = new String[]{"MdTop", "%FLAG TITLE"};
    private static final String[][] lineStartsWithRecords = new String[][]{cifLineStartRecords, pqrLineStartRecords, pdbLineStartRecords, shelxLineStartRecords, ghemicalMMLineStartRecords, jaguarLineStartRecords, hinLineStartRecords, mdlLineStartRecords, spartanSmolLineStartRecords, csfLineStartRecords, mol2Records, mdTopLineStartRecords};
    private static final String[] xmlContainsRecords = new String[]{"Xml", "<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    private static final String[] gaussianContainsRecords = new String[]{"Gaussian", "Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    private static final String[] mopacContainsRecords = new String[]{"Mopac", "MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)"};
    private static final String[] qchemContainsRecords = new String[]{"Qchem", "Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    private static final String[] gamessUKContainsRecords = new String[]{"GamessUK", "GAMESS-UK", "G A M E S S - U K"};
    private static final String[] gamessUSContainsRecords = new String[]{"GamessUS", "GAMESS"};
    private static final String[] spartanBinaryContainsRecords = new String[]{"SpartanSmol", "|PropertyArchive", "_spartan", "spardir"};
    private static final String[] spartanContainsRecords = new String[]{"Spartan", "Spartan"};
    private static final String[] adfContainsRecords = new String[]{"Adf", "Amsterdam Density Functional"};
    private static final String[] psiContainsRecords = new String[]{"Psi", "    PSI  3"};
    private static final String[] nwchemContainsRecords = new String[]{"NWChem", " argument  1 = "};
    private static final String[] uicrcifContainsRecords = new String[]{"Cif", "Crystallographic Information File"};
    private static final String[][] containsRecords = new String[][]{xmlContainsRecords, gaussianContainsRecords, mopacContainsRecords, qchemContainsRecords, gamessUKContainsRecords, gamessUSContainsRecords, spartanBinaryContainsRecords, spartanContainsRecords, mol2Records, adfContainsRecords, psiContainsRecords, nwchemContainsRecords, uicrcifContainsRecords};

    static String getFileType(BufferedReader br) {
        try {
            return Resolver.determineAtomSetCollectionReader(br, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String[] specialLoad(String name, String type) {
        int pt = name.lastIndexOf(".spardir");
        boolean isPreliminary = type.equals("filesNeeded?");
        if (isPreliminary) {
            if (name.endsWith(".spt")) {
                return new String[]{null, null, null};
            }
            if (name.endsWith(".spardir.zip")) {
                return new String[]{"SpartanSmol", "Directory Entry ", "?|output"};
            }
            if (!(name = name.replace('\\', '/')).endsWith(".spardir") && name.indexOf(".spardir/") < 0) {
                return null;
            }
            if (pt < 0) {
                return null;
            }
            if (name.lastIndexOf("/") > pt) {
                return new String[]{"SpartanSmol", "Directory Entry ", name + "/input", name + "/archive", name + "/Molecule:asBinaryString", name + "/proparc"};
            }
            return new String[]{"SpartanSmol", "Directory Entry ", name + "/output"};
        }
        String[] dirNums = Resolver.getSpartanDirs(type);
        if (dirNums.length == 0 && name.endsWith(".spardir.zip") && type.indexOf(".zip|output") >= 0) {
            String sname = name.replace('\\', '/');
            pt = sname.lastIndexOf("/");
            sname = name + "|" + name.substring(pt + 1, name.length() - 4);
            return new String[]{"SpartanSmol", sname, sname + "/output"};
        }
        return Resolver.getSpartanFileList(name, dirNums);
    }

    static String[] checkSpecialInZip(String[] zipDirectory) {
        String[] stringArray;
        if (zipDirectory.length < 2) {
            stringArray = null;
        } else {
            String name = zipDirectory[1];
            if (name.endsWith(".spardir/") || zipDirectory.length == 2) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "";
                stringArray = stringArray2;
                stringArray2[1] = name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
            } else {
                stringArray = null;
            }
        }
        return stringArray;
    }

    static StringBuffer checkSpecialData(InputStream is, String[] zipDirectory) {
        boolean isSpartan = false;
        for (int i = 1; i < zipDirectory.length; ++i) {
            if (!zipDirectory[i].endsWith(".spardir/") && zipDirectory[i].indexOf("_spartandir") < 0) continue;
            isSpartan = true;
            break;
        }
        if (!isSpartan) {
            return null;
        }
        StringBuffer data = new StringBuffer();
        data.append("Zip File Directory: ").append("\n").append(Escape.escape(zipDirectory)).append("\n");
        Hashtable fileData = new Hashtable();
        ZipUtil.getAllData(is, new String[0], "", "Molecule", fileData);
        String prefix = "|";
        String outputData = (String)fileData.get(prefix + "output");
        if (outputData == null) {
            prefix = "|" + zipDirectory[1];
            outputData = (String)fileData.get(prefix + "output");
        }
        data.append(outputData);
        String[] files = Resolver.getSpartanFileList(prefix, Resolver.getSpartanDirs(outputData));
        for (int i = 2; i < files.length; ++i) {
            String name = files[i];
            if (fileData.containsKey(name)) {
                data.append(fileData.get(name));
                continue;
            }
            data.append(name + "\n");
        }
        return data;
    }

    static Object getAtomCollectionAndCloseReader(String fullName, String type, BufferedReader bufferedReader, Hashtable htParams, int ptFile) throws Exception {
        String atomSetCollectionReaderName;
        AtomSetCollectionReader atomSetCollectionReader = null;
        fullName = fullName.replace('\\', '/');
        String errMsg = null;
        if (type != null) {
            atomSetCollectionReaderName = Resolver.getReaderFromType(type);
            if (atomSetCollectionReaderName == null) {
                errMsg = "unrecognized file format type " + type;
            } else {
                Logger.info("The Resolver assumes " + atomSetCollectionReaderName);
            }
        } else {
            atomSetCollectionReaderName = Resolver.determineAtomSetCollectionReader(bufferedReader, true);
            if (atomSetCollectionReaderName.indexOf("\n") >= 0) {
                errMsg = "unrecognized file format for file " + fullName + "\n" + atomSetCollectionReaderName;
            } else if (atomSetCollectionReaderName.equals("spt")) {
                errMsg = "NOTE: file recognized as a script file: " + fullName + "\n";
            } else {
                Logger.info("The Resolver thinks " + atomSetCollectionReaderName);
            }
        }
        if (errMsg != null) {
            bufferedReader.close();
            return errMsg;
        }
        if (htParams == null) {
            htParams = new Hashtable<String, Integer>();
        }
        htParams.put("ptFile", new Integer(ptFile));
        if (ptFile <= 0) {
            htParams.put("readerName", (Integer)((Object)atomSetCollectionReaderName));
        }
        if (atomSetCollectionReaderName.indexOf("Xml") == 0) {
            atomSetCollectionReaderName = "Xml";
        }
        String className = null;
        String err = null;
        try {
            className = Resolver.getReaderClassBase(atomSetCollectionReaderName);
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            atomSetCollectionReader = (AtomSetCollectionReader)atomSetCollectionReaderClass.newInstance();
            return atomSetCollectionReader.readData(fullName, htParams, bufferedReader);
        }
        catch (Exception e) {
            err = "File reader was not found:" + className;
            Logger.error(err);
            return err;
        }
    }

    static Object DOMResolve(Object DOMNode) throws Exception {
        String className = null;
        Hashtable<String, String> htParams = new Hashtable<String, String>();
        String atomSetCollectionReaderName = Resolver.getXmlType((JSObject)DOMNode);
        if (Logger.debugging) {
            Logger.debug("The Resolver thinks " + atomSetCollectionReaderName);
        }
        htParams.put("readerName", atomSetCollectionReaderName);
        try {
            className = "org.jmol.adapter.readers.xml.XmlReader";
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            AtomSetCollectionReader atomSetCollectionReader = (AtomSetCollectionReader)atomSetCollectionReaderClass.newInstance();
            return atomSetCollectionReader.readData("DOM node", htParams, DOMNode);
        }
        catch (Exception e) {
            String err = "File reader was not found:" + className;
            Logger.error(err, e);
            return err;
        }
    }

    public static final String getReaderClassBase(String type) {
        String base = type.startsWith("Xml") ? "xml." : "more.";
        for (int i = 1; i < readerSets.length; i += 2) {
            if (readerSets[i].indexOf(type + ";") < 0) continue;
            base = readerSets[i - 1];
            break;
        }
        return classBase + base + type + "Reader";
    }

    private static String[] getSpartanFileList(String name, String[] dirNums) {
        String[] files = new String[2 + dirNums.length * 5];
        files[0] = "SpartanSmol";
        files[1] = "Directory Entry ";
        int pt = 2;
        if ((name = name.replace('\\', '/')).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        for (int i = 0; i < dirNums.length; ++i) {
            String path = name + (Character.isDigit(dirNums[i].charAt(0)) ? "/Profile." + dirNums[i] : "/" + dirNums[i]);
            files[pt++] = path + "/#JMOL_MODEL " + dirNums[i];
            files[pt++] = path + "/input";
            files[pt++] = path + "/archive";
            files[pt++] = path + "/Molecule:asBinaryString";
            files[pt++] = path + "/proparc";
        }
        return files;
    }

    private static String[] getSpartanDirs(String outputFileData) {
        if (outputFileData == null) {
            return new String[0];
        }
        if (outputFileData.startsWith("java.io.FileNotFoundException") || outputFileData.startsWith("FILE NOT FOUND") || outputFileData.indexOf("<html") >= 0) {
            return new String[]{"M0001"};
        }
        Vector<String> v = new Vector<String>();
        String lasttoken = "";
        try {
            StringTokenizer tokens = new StringTokenizer(outputFileData, " \t\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals(")")) {
                    v.add(lasttoken);
                } else if (token.equals("Start-") && tokens.nextToken().equals("Molecule")) {
                    v.add(TextFormat.split(tokens.nextToken(), '\"')[1]);
                }
                lasttoken = token;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] dirs = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            dirs[i] = (String)v.get(i);
        }
        return dirs;
    }

    private static String getXmlType(JSObject DOMNode) {
        String namespaceURI = (String)DOMNode.getMember("namespaceURI");
        String localName = (String)DOMNode.getMember("localName");
        if (namespaceURI.startsWith("http://www.molpro.net/")) {
            return specialTags[19][0];
        }
        if ("odyssey_simulation".equals(localName)) {
            return specialTags[20][0];
        }
        if ("arguslab".equals(localName)) {
            return specialTags[16][0];
        }
        if (namespaceURI.startsWith(CML_NAMESPACE_URI) || "cml".equals(localName)) {
            return specialTags[17][0];
        }
        return "unidentified " + specialTags[17][0];
    }

    private static String determineAtomSetCollectionReader(BufferedReader bufferedReader, boolean returnLines) throws Exception {
        String recordTag;
        int j;
        String[] recordTags;
        int i;
        String[] lines = new String[16];
        LimitedLineReader llr = new LimitedLineReader(bufferedReader, 16384);
        int nLines = 0;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = llr.readLineWithNewline();
            if (lines[i2].length() <= 0) continue;
            ++nLines;
        }
        String readerName = Resolver.checkSpecial(nLines, lines);
        if (readerName != null) {
            return readerName;
        }
        String leader = llr.getHeader(20);
        for (i = 0; i < fileStartsWithRecords.length; ++i) {
            recordTags = fileStartsWithRecords[i];
            for (j = 1; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                if (!leader.startsWith(recordTag)) continue;
                return recordTags[0];
            }
        }
        for (i = 0; i < lineStartsWithRecords.length; ++i) {
            recordTags = lineStartsWithRecords[i];
            for (j = 1; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                for (int k = 0; k < lines.length; ++k) {
                    if (!lines[k].startsWith(recordTag)) continue;
                    return recordTags[0];
                }
            }
        }
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf("# Jmol state") < 0) continue;
            return "spt";
        }
        String header = llr.getHeader(0);
        String type = null;
        block7: for (int i3 = 0; i3 < containsRecords.length; ++i3) {
            String[] recordTags2 = containsRecords[i3];
            for (int j2 = 1; j2 < recordTags2.length; ++j2) {
                String recordTag2 = recordTags2[j2];
                if (header.indexOf(recordTag2) == -1) continue;
                type = recordTags2[0];
                if (type.equals("Xml")) {
                    if (header.indexOf("XHTML") >= 0 || header.indexOf("xhtml") >= 0) continue block7;
                    type = Resolver.getXmlType(header);
                }
                return type;
            }
        }
        return returnLines ? "\n" + lines[0] + "\n" + lines[1] + "\n" + lines[2] + "\n" : null;
    }

    private static String getXmlType(String header) throws Exception {
        if (header.indexOf("http://www.molpro.net/") >= 0) {
            return specialTags[13][0];
        }
        if (header.indexOf("odyssey") >= 0) {
            return specialTags[14][0];
        }
        if (header.indexOf("C3XML") >= 0) {
            return specialTags[12][0];
        }
        if (header.indexOf("arguslab") >= 0) {
            return specialTags[10][0];
        }
        if (header.indexOf(CML_NAMESPACE_URI) >= 0 || header.indexOf("cml:") >= 0) {
            return specialTags[11][0];
        }
        if (header.indexOf("XSD") >= 0) {
            return specialTags[15][0];
        }
        return "unidentified " + specialTags[11][0];
    }

    private static final String checkSpecial(int nLines, String[] lines) {
        if (nLines == 1 && lines[0].length() > 0 && Character.isDigit(lines[0].charAt(0))) {
            return specialTags[0][0];
        }
        if (Resolver.checkMopacGraphf(lines)) {
            return specialTags[1][0];
        }
        if (Resolver.checkV3000(lines)) {
            return specialTags[2][0];
        }
        if (Resolver.checkOdyssey(lines)) {
            return specialTags[3][0];
        }
        if (Resolver.checkMol(lines)) {
            return specialTags[4][0];
        }
        if (Resolver.checkXyz(lines)) {
            return specialTags[5][0];
        }
        if (Resolver.checkAlchemy(lines[0])) {
            return specialTags[8][0];
        }
        if (Resolver.checkFoldingXyz(lines)) {
            return specialTags[6][0];
        }
        if (Resolver.checkCube(lines)) {
            return specialTags[7][0];
        }
        if (Resolver.checkWien2k(lines)) {
            return specialTags[9][0];
        }
        return null;
    }

    private static boolean checkWien2k(String[] lines) {
        return lines[2].startsWith("MODE OF CALC=") || lines[2].startsWith("             RELA") || lines[2].startsWith("             NREL");
    }

    private static final String getReaderFromType(String type) {
        type = type.toLowerCase();
        String base = null;
        base = Resolver.checkType(specialTags, type);
        if (base != null) {
            return base;
        }
        base = Resolver.checkType(fileStartsWithRecords, type);
        if (base != null) {
            return base;
        }
        base = Resolver.checkType(lineStartsWithRecords, type);
        if (base != null) {
            return base;
        }
        return Resolver.checkType(containsRecords, type);
    }

    private static final String checkType(String[][] typeTags, String type) {
        for (int i = 0; i < typeTags.length; ++i) {
            if (!typeTags[i][0].toLowerCase().equals(type)) continue;
            return typeTags[i][0];
        }
        return null;
    }

    private static boolean checkOdyssey(String[] lines) {
        int i;
        for (i = 0; i < lines.length && (lines[i].startsWith("C ") || lines[i].length() == 0); ++i) {
        }
        if (i >= lines.length || lines[i].charAt(0) != ' ' || (i += 2) + 1 >= lines.length) {
            return false;
        }
        try {
            int spin = Integer.parseInt(lines[i].substring(2).trim());
            int charge = Integer.parseInt(lines[i].substring(0, 2).trim());
            int atom1 = Integer.parseInt(lines[++i].substring(0, 2).trim());
            if (spin < 0 || spin > 5 || atom1 <= 0 || charge > 5) {
                return false;
            }
            float[] atomline = new float[5];
            AtomSetCollectionReader.getTokensFloat(lines[i], atomline, 5);
            return !Float.isNaN(atomline[1]) && !Float.isNaN(atomline[2]) && !Float.isNaN(atomline[3]) && Float.isNaN(atomline[4]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkV3000(String[] lines) {
        String line4trimmed;
        return lines[3].length() >= 6 && (line4trimmed = lines[3].trim()).endsWith("V3000");
    }

    private static boolean checkMol(String[] lines) {
        if (lines[3].length() >= 6) {
            String line4trimmed = lines[3].trim();
            if (line4trimmed.endsWith("V2000") || line4trimmed.endsWith("v2000")) {
                return true;
            }
            try {
                Integer.parseInt(lines[3].substring(0, 3).trim());
                Integer.parseInt(lines[3].substring(3, 6).trim());
                return lines[0].indexOf("@<TRIPOS>") != 0 && lines[1].indexOf("@<TRIPOS>") != 0 && lines[2].indexOf("@<TRIPOS>") != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkAlchemy(String line) {
        int pt = line.indexOf("ATOMS");
        if (pt >= 0 && line.indexOf("BONDS") > pt) {
            try {
                int n = Integer.parseInt(line.substring(0, pt).trim());
                return n > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkXyz(String[] lines) {
        try {
            Integer.parseInt(lines[0].trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean checkFoldingXyz(String[] lines) {
        StringTokenizer tokens = new StringTokenizer(lines[0].trim(), " \t");
        if (tokens.countTokens() < 2) {
            return false;
        }
        try {
            Integer.parseInt(tokens.nextToken().trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        String secondLine = lines[1].trim();
        if (secondLine.length() == 0) {
            secondLine = lines[2].trim();
        }
        if ((tokens = new StringTokenizer(secondLine, " \t")).countTokens() == 0) {
            return false;
        }
        try {
            Integer.parseInt(tokens.nextToken().trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean checkMopacGraphf(String[] lines) {
        return lines[0].indexOf("MOPAC-Graphical data") > 2;
    }

    private static boolean checkCube(String[] lines) {
        try {
            StringTokenizer tokens2 = new StringTokenizer(lines[2]);
            if (tokens2 == null || tokens2.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens2.nextToken());
            int i = 3;
            while (--i >= 0) {
                new Float(tokens2.nextToken());
            }
            StringTokenizer tokens3 = new StringTokenizer(lines[3]);
            if (tokens3 == null || tokens3.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens3.nextToken());
            int i2 = 3;
            while (--i2 >= 0) {
                Float f = new Float(tokens3.nextToken());
                if (!(f.floatValue() < 0.0f)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

