/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.modelset.Group;
import org.jmol.viewer.JmolConstants;

public abstract class JmolAdapter {
    public static final short ORDER_COVALENT_SINGLE = 1;
    public static final short ORDER_COVALENT_DOUBLE = 2;
    public static final short ORDER_COVALENT_TRIPLE = 3;
    public static final short ORDER_AROMATIC = 515;
    public static final short ORDER_AROMATIC_SINGLE = 513;
    public static final short ORDER_AROMATIC_DOUBLE = 514;
    public static final short ORDER_HBOND = 2048;
    public static final short ORDER_STEREO_NEAR = 1025;
    public static final short ORDER_STEREO_FAR = 1026;
    public static final short ORDER_PARTIAL01 = 33;
    public static final short ORDER_PARTIAL12 = 66;
    public static final short ORDER_PARTIAL23 = 97;
    public static final short ORDER_PARTIAL32 = 100;
    public static final short ORDER_UNSPECIFIED = 7;
    public static final int SHELL_S = 0;
    public static final int SHELL_P = 1;
    public static final int SHELL_SP = 2;
    public static final int SHELL_L = 2;
    public static final int SHELL_D_CARTESIAN = 3;
    public static final int SHELL_D_SPHERICAL = 4;
    public static final int SHELL_F_CARTESIAN = 5;
    public static final int SHELL_F_SPHERICAL = 6;
    String adapterName;

    public static String getElementSymbol(int elementNumber) {
        return JmolConstants.elementSymbolFromNumber(elementNumber);
    }

    public static int getElementNumber(String elementSymbol) {
        return JmolConstants.elementNumberFromSymbol(elementSymbol);
    }

    public static boolean isHetero(String group3) {
        return JmolConstants.isHetero(group3);
    }

    public static int getQuantumShellTagID(String tag) {
        return JmolConstants.getQuantumShellTagID(tag);
    }

    public static int getQuantumShellTagIDSpherical(String tag) {
        return JmolConstants.getQuantumShellTagIDSpherical(tag);
    }

    public static final int getQuantumSubshellTagID(int shell, String tag) {
        return JmolConstants.getQuantumSubshellTagID(shell, tag);
    }

    public static final String getQuantumSubshellTag(int shell, int subshell) {
        return JmolConstants.getQuantumSubshellTag(shell, subshell);
    }

    public static final String canonicalizeQuantumSubshellTag(String tag) {
        return JmolConstants.canonicalizeQuantumSubshellTag(tag);
    }

    public static final short lookupGroupID(String group3) {
        return Group.lookupGroupID(group3);
    }

    public JmolAdapter(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public abstract Object getAtomSetCollectionFromReader(String var1, String var2, BufferedReader var3, Hashtable var4);

    public abstract Object getAtomSetCollectionFromReaders(JmolFileReaderInterface var1, String[] var2, String[] var3, Hashtable[] var4);

    public abstract Object getAtomSetCollectionOrBufferedReaderFromZip(InputStream var1, String var2, String[] var3, Hashtable var4, boolean var5);

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(name, null, bufferedReader, null);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader, Hashtable htParams) {
        return this.getAtomSetCollectionFromReader(name, null, bufferedReader, htParams);
    }

    public Object openBufferedReader(String name, String type, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(name, type, bufferedReader, null);
    }

    public abstract Object getAtomSetCollectionFromDOM(Object var1);

    public void finish(Object atomSetCollection) {
    }

    public abstract String getFileTypeName(Object var1);

    public abstract String getAtomSetCollectionName(Object var1);

    public abstract Properties getAtomSetCollectionProperties(Object var1);

    public abstract Hashtable getAtomSetCollectionAuxiliaryInfo(Object var1);

    public abstract int getAtomSetCount(Object var1);

    public abstract int getAtomSetNumber(Object var1, int var2);

    public abstract String getAtomSetName(Object var1, int var2);

    public abstract Properties getAtomSetProperties(Object var1, int var2);

    public abstract Hashtable getAtomSetAuxiliaryInfo(Object var1, int var2);

    public abstract int getEstimatedAtomCount(Object var1);

    public abstract boolean coordinatesAreFractional(Object var1);

    public abstract float[] getNotionalUnitcell(Object var1);

    public abstract float[] getPdbScaleMatrix(Object var1);

    public abstract float[] getPdbScaleTranslate(Object var1);

    public abstract String getClientAtomStringProperty(Object var1, String var2);

    public abstract AtomIterator getAtomIterator(Object var1);

    public abstract BondIterator getBondIterator(Object var1);

    public abstract StructureIterator getStructureIterator(Object var1);

    public static final char canonizeAlphaDigit(char ch) {
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
            return ch;
        }
        return '\u0000';
    }

    public static final char canonizeChainID(char chainID) {
        return JmolAdapter.canonizeAlphaDigit(chainID);
    }

    public static final char canonizeInsertionCode(char insertionCode) {
        return JmolAdapter.canonizeAlphaDigit(insertionCode);
    }

    public static final char canonizeAlternateLocationID(char altLoc) {
        return JmolAdapter.canonizeAlphaDigit(altLoc);
    }

    public String[] specialLoad(String name, String type) {
        return null;
    }

    public abstract class StructureIterator {
        public abstract boolean hasNext();

        public abstract int getModelIndex();

        public abstract String getStructureType();

        public abstract char getStartChainID();

        public abstract int getStartSequenceNumber();

        public abstract char getStartInsertionCode();

        public abstract char getEndChainID();

        public abstract int getEndSequenceNumber();

        public abstract char getEndInsertionCode();
    }

    public abstract class BondIterator {
        public abstract boolean hasNext();

        public abstract Object getAtomUniqueID1();

        public abstract Object getAtomUniqueID2();

        public abstract int getEncodedOrder();
    }

    public abstract class AtomIterator {
        public abstract boolean hasNext();

        public int getAtomSetIndex() {
            return 0;
        }

        public BitSet getAtomSymmetry() {
            return null;
        }

        public int getAtomSite() {
            return Integer.MIN_VALUE;
        }

        public abstract Object getUniqueID();

        public int getElementNumber() {
            return -1;
        }

        public String getElementSymbol() {
            return null;
        }

        public String getAtomName() {
            return null;
        }

        public int getFormalCharge() {
            return 0;
        }

        public float getPartialCharge() {
            return Float.NaN;
        }

        public Object[] getEllipsoid() {
            return null;
        }

        public float getRadius() {
            return Float.NaN;
        }

        public abstract float getX();

        public abstract float getY();

        public abstract float getZ();

        public float getVectorX() {
            return Float.NaN;
        }

        public float getVectorY() {
            return Float.NaN;
        }

        public float getVectorZ() {
            return Float.NaN;
        }

        public float getBfactor() {
            return Float.NaN;
        }

        public int getOccupancy() {
            return 100;
        }

        public boolean getIsHetero() {
            return false;
        }

        public int getAtomSerial() {
            return Integer.MIN_VALUE;
        }

        public char getChainID() {
            return '\u0000';
        }

        public char getAlternateLocationID() {
            return '\u0000';
        }

        public String getGroup3() {
            return null;
        }

        public int getSequenceNumber() {
            return Integer.MIN_VALUE;
        }

        public char getInsertionCode() {
            return '\u0000';
        }

        public Object getClientAtomReference() {
            return null;
        }
    }
}

