/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    CubeIterator[] cubeIterators;

    public Bspf(int dimMax) {
        this.dimMax = dimMax;
        this.bspts = new Bspt[0];
        this.cubeIterators = new CubeIterator[0];
    }

    public int getBsptCount() {
        return this.bspts.length;
    }

    public void clearBspt(int bsptIndex) {
        this.bspts[bsptIndex] = null;
    }

    public boolean isInitialized(int bsptIndex) {
        return this.bspts.length > bsptIndex && this.bspts[bsptIndex] != null;
    }

    public void addTuple(int bsptIndex, Point3f tuple) {
        Bspt bspt;
        if (bsptIndex >= this.bspts.length) {
            Bspt[] t = new Bspt[bsptIndex + 1];
            System.arraycopy(this.bspts, 0, t, 0, this.bspts.length);
            this.bspts = t;
        }
        if ((bspt = this.bspts[bsptIndex]) == null) {
            bspt = this.bspts[bsptIndex] = new Bspt(this.dimMax);
        }
        bspt.addTuple(tuple);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            if (this.bspts[i] == null) continue;
            this.bspts[i].stats();
        }
    }

    public CubeIterator getCubeIterator(int bsptIndex) {
        if (bsptIndex >= this.cubeIterators.length) {
            CubeIterator[] t = new CubeIterator[bsptIndex + 1];
            System.arraycopy(this.cubeIterators, 0, t, 0, this.cubeIterators.length);
            this.cubeIterators = t;
        }
        if (this.cubeIterators[bsptIndex] == null && this.bspts[bsptIndex] != null) {
            this.cubeIterators[bsptIndex] = this.bspts[bsptIndex].allocateCubeIterator();
        }
        return this.cubeIterators[bsptIndex];
    }

    public void initialize(int modelIndex, Point3f[] atoms, BitSet modelAtomBitSet) {
        int i = atoms.length;
        while (--i >= 0) {
            if (!modelAtomBitSet.get(i)) continue;
            this.addTuple(modelIndex, atoms[i]);
        }
    }
}

