/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;

public class CubeIterator {
    Bspt bspt;
    Element[] stack;
    int sp;
    int leafIndex;
    Leaf leaf;
    float radius;
    float[] centerValues;
    private float cx;
    private float cy;
    private float cz;
    protected float dx;
    protected float dy;
    protected float dz;
    boolean tHemisphere;

    CubeIterator(Bspt bspt) {
        this.bspt = bspt;
        this.centerValues = new float[bspt.dimMax];
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(Point3f center, float radius) {
        this.radius = radius;
        this.tHemisphere = false;
        this.cx = this.centerValues[0] = center.x;
        this.cy = this.centerValues[1] = center.y;
        this.cz = this.centerValues[2] = center.z;
        this.leaf = null;
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
    }

    public void initializeHemisphere(Point3f center, float radius) {
        this.initialize(center, radius);
        this.tHemisphere = true;
    }

    public void release() {
        int i = this.bspt.treeDepth;
        while (--i >= 0) {
            this.stack[i] = null;
        }
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public Point3f nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element ele = this.stack[--this.sp];
        while (ele instanceof Node) {
            Node node = (Node)ele;
            float centerValue = this.centerValues[node.dim];
            float maxValue = centerValue + this.radius;
            float minValue = centerValue;
            if (!this.tHemisphere || node.dim != 0) {
                minValue -= this.radius;
            }
            if (minValue <= node.maxLeft && maxValue >= node.minLeft) {
                if (maxValue >= node.minRight && minValue <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                ele = node.eleLeft;
                continue;
            }
            if (maxValue >= node.minRight && minValue <= node.maxRight) {
                ele = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            ele = this.stack[--this.sp];
        }
        this.leaf = (Leaf)ele;
        this.leafIndex = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isWithinRadius(Point3f t) {
        float f;
        float f2;
        float f3;
        this.dx = t.x - this.cx;
        if (this.tHemisphere) {
            if (!(this.dx >= 0.0f)) return false;
        }
        this.dx = Math.abs(this.dx);
        if (!(f3 <= this.radius)) return false;
        this.dy = Math.abs(t.y - this.cy);
        if (!(f2 <= this.radius)) return false;
        this.dz = Math.abs(t.z - this.cz);
        if (!(f <= this.radius)) return false;
        return true;
    }
}

