/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.shape.ShapeRenderer;

public final class Export3D
implements JmolRendererInterface {
    private Graphics3D g3d;
    private short colix;
    private Hermite3D hermite3d;
    private int width;
    private int height;
    private int slab;
    private JmolExportInterface exporter;
    private Point3f ptA = new Point3f();
    private Point3f ptB = new Point3f();
    private Point3f ptC = new Point3f();
    private Point3f ptD = new Point3f();
    private Point3i ptAi = new Point3i();
    private Point3i ptBi = new Point3i();

    public JmolExportInterface getExporter() {
        return this.exporter;
    }

    public Export3D() {
        this.hermite3d = new Hermite3D(this);
    }

    public void setg3dExporter(Graphics3D g3d, JmolExportInterface exporter) {
        this.g3d = g3d;
        this.width = g3d.getRenderWidth();
        this.height = g3d.getRenderHeight();
        this.slab = g3d.getSlab();
        this.exporter = exporter;
        exporter.setRenderer(this);
    }

    public boolean canDoTriangles() {
        return this.exporter.canDoTriangles();
    }

    public void setSlab(int slabValue) {
        this.slab = slabValue;
        this.g3d.setSlab(slabValue);
    }

    public void setRenderer(ShapeRenderer shapeRenderer) {
    }

    public void renderBackground() {
        this.exporter.renderBackground();
    }

    public void fillScreenedCircleCentered(short colixFill, int diameter, int x, int y, int z) {
        if (this.isClippedZ(z)) {
            return;
        }
        this.exporter.fillScreenedCircleCentered(colixFill, diameter, x, y, z);
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z, boolean doFill) {
        if (this.isClippedZ(z)) {
            return;
        }
        this.exporter.drawCircleCentered(colix, diameter, x, y, z, doFill);
    }

    public void fillSphereCentered(int diameter, int x, int y, int z) {
        this.ptA.set(x, y, z);
        this.fillSphereCentered(diameter, this.ptA);
    }

    public void fillSphereCentered(int diameter, Point3i center) {
        this.ptA.set(center.x, center.y, center.z);
        this.fillSphereCentered(diameter, this.ptA);
    }

    public void fillSphereCentered(int diameter, Point3f center) {
        if (diameter == 0) {
            return;
        }
        this.exporter.fillSphereCentered(this.colix, diameter, center);
    }

    public void drawRect(int x, int y, int z, int zSlab, int rWidth, int rHeight) {
        if (zSlab != 0 && this.isClippedZ(zSlab)) {
            return;
        }
        int w = rWidth - 1;
        int h = rHeight - 1;
        int xRight = x + w;
        int yBottom = y + h;
        if (y >= 0 && y < this.height) {
            this.drawHLine(x, y, z, w);
        }
        if (yBottom >= 0 && yBottom < this.height) {
            this.drawHLine(x, yBottom, z, w);
        }
        if (x >= 0 && x < this.width) {
            this.drawVLine(x, y, z, h);
        }
        if (xRight >= 0 && xRight < this.width) {
            this.drawVLine(xRight, y, z, h);
        }
    }

    private void drawHLine(int x, int y, int z, int w) {
        int argbCurrent = this.g3d.getColixArgb(this.colix);
        if (w < 0) {
            x += w;
            w = -w;
        }
        for (int i = 0; i <= w; ++i) {
            this.exporter.drawTextPixel(argbCurrent, x + i, y, z);
        }
    }

    private void drawVLine(int x, int y, int z, int h) {
        int argbCurrent = this.g3d.getColixArgb(this.colix);
        if (h < 0) {
            y += h;
            h = -h;
        }
        for (int i = 0; i <= h; ++i) {
            this.exporter.drawTextPixel(argbCurrent, x, y + i, z);
        }
    }

    public void fillRect(int x, int y, int z, int zSlab, int widthFill, int heightFill) {
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.ptA.set(x, y, z);
        this.ptB.set(x + widthFill, y, z);
        this.ptC.set(x + widthFill, y + heightFill, z);
        this.ptD.set(x, y + heightFill, z);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD);
    }

    public void drawString(String str, Font3D font3d, int xBaseline, int yBaseline, int z, int zSlab) {
        if (str == null) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.drawStringNoSlab(str, font3d, xBaseline, yBaseline, z);
    }

    public void drawStringNoSlab(String str, Font3D font3d, int xBaseline, int yBaseline, int z) {
        if (str == null) {
            return;
        }
        z = Math.max(this.slab, z);
        if (font3d == null) {
            font3d = this.g3d.getFont3DCurrent();
        } else {
            this.g3d.setFont(font3d);
        }
        this.exporter.plotText(xBaseline, yBaseline, z, this.getColixArgb(this.colix), str, font3d);
    }

    public void drawImage(Image image, int x, int y, int z, int zSlab, short bgcolix, int width, int height) {
        if (image == null || width == 0 || height == 0) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        z = Math.max(this.slab, z);
        this.exporter.plotImage(x, y, z, image, bgcolix, width, height);
    }

    public void drawPixel(int x, int y, int z) {
        this.plotPixelClipped(x, y, z);
    }

    void plotPixelClipped(int x, int y, int z) {
        if (this.g3d.isClipped(x, y, z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, x, y, z);
    }

    public void plotPixelClippedNoSlab(int argb, int x, int y, int z) {
        z = Math.max(this.slab, z);
        this.exporter.drawTextPixel(argb, x, y, z);
    }

    public void plotPixelClipped(Point3i screen) {
        if (this.g3d.isClipped(screen.x, screen.y, screen.z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, screen.x, screen.y, screen.z);
    }

    public void drawPoints(int count, int[] coordinates) {
        int i = count * 3;
        while (i > 0) {
            int y;
            int x;
            int z = coordinates[--i];
            --i;
            if (this.g3d.isClipped(x = coordinates[--i], y = coordinates[i], z)) continue;
            this.exporter.drawPixel(this.colix, x, y, z);
        }
    }

    public void drawDashedLine(int run, int rise, Point3i pointA, Point3i pointB) {
        this.drawLine(pointA, pointB);
    }

    public void drawDottedLine(Point3i pointA, Point3i pointB) {
        this.drawLine(pointA, pointB);
    }

    public void drawLine(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.ptAi.set(x1, y1, z1);
        this.ptBi.set(x2, y2, z2);
        this.drawLine(this.ptAi, this.ptBi);
    }

    public void drawLine(short colixA, short colixB, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.fillCylinder(colixA, colixB, (byte)2, 2, xA, yA, zA, xB, yB, zB);
    }

    public void drawLine(Point3i pointA, Point3i pointB) {
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.exporter.fillCylinder(this.colix, (byte)2, 1, this.ptA, this.ptB);
    }

    public void fillCylinder(short colixA, short colixB, byte endcaps, int mad, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.ptA.set(xA, yA, zA);
        this.ptB.set(xB, yB, zB);
        this.exporter.fillCylinder(this.ptA, this.ptB, colixA, colixB, endcaps, mad, 1);
    }

    public void fillCylinder(byte endcaps, int mad, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.fillCylinder(this.colix, this.colix, endcaps, mad, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinder(byte endcaps, int diameter, Point3i pointA, Point3i pointB) {
        if (diameter <= 0) {
            return;
        }
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.exporter.fillCylinder(this.colix, endcaps, diameter, this.ptA, this.ptB);
    }

    public void fillCylinderBits(byte endcaps, int diameter, Point3f pointA, Point3f pointB) {
        if (diameter <= 0) {
            return;
        }
        this.exporter.fillCylinder(this.colix, endcaps, diameter, pointA, pointB);
    }

    public void fillCone(byte endcap, int diameter, Point3i pointBase, Point3i screenTip) {
        this.ptA.set(pointBase.x, pointBase.y, pointBase.z);
        this.ptB.set(screenTip.x, screenTip.y, screenTip.z);
        this.fillCone(endcap, diameter, this.ptA, this.ptB);
    }

    public void fillCone(byte endcap, int diameter, Point3f pointBase, Point3f screenTip) {
        this.exporter.fillCone(this.colix, endcap, diameter, pointBase, screenTip);
    }

    public void drawHermite(int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(false, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    public void drawHermite(boolean fill, boolean border, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3, Point3i s4, Point3i s5, Point3i s6, Point3i s7, int aspectRatio) {
        this.hermite3d.render2(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio);
    }

    public void fillHermite(int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(true, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    public void drawTriangle(Point3i pointA, short colixA, Point3i pointB, short colixB, Point3i pointC, short colixC, int check) {
        int xA = pointA.x;
        int yA = pointA.y;
        int zA = pointA.z;
        int xB = pointB.x;
        int yB = pointB.y;
        int zB = pointB.z;
        int xC = pointC.x;
        int yC = pointC.y;
        int zC = pointC.z;
        if ((check & 1) == 1) {
            this.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        }
        if ((check & 2) == 2) {
            this.drawLine(colixB, colixC, xB, yB, zB, xC, yC, zC);
        }
        if ((check & 4) == 4) {
            this.drawLine(colixA, colixC, xA, yA, zA, xC, yC, zC);
        }
    }

    public void drawTriangle(Point3i pointA, Point3i pointB, Point3i pointC, int check) {
    }

    public void drawCylinderTriangle(int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC, int diameter) {
        this.fillCylinder((byte)3, diameter, xA, yA, zA, xB, yB, zB);
        this.fillCylinder((byte)3, diameter, xA, yA, zA, xC, yC, zC);
        this.fillCylinder((byte)3, diameter, xB, yB, zB, xC, yC, zC);
    }

    public void drawfillTriangle(int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        this.ptA.set(xA, yA, zA);
        this.ptB.set(xB, yB, zB);
        this.ptC.set(xC, yC, zC);
        this.fillTriangle(this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i pointA, int intensityA, Point3i pointB, int intensityB, Point3i pointC, int intensityC) {
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.ptC.set(pointC.x, pointC.y, pointC.z);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i pointA, short colixA, short normixA, Point3i pointB, short colixB, short normixB, Point3i pointC, short colixC, short normixC) {
        if (colixA != colixB || colixB != colixC) {
            return;
        }
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.ptC.set(pointC.x, pointC.y, pointC.z);
        this.exporter.fillTriangle(colixA, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(short normix, int xpointA, int ypointA, int zpointA, int xpointB, int ypointB, int zpointB, int xpointC, int ypointC, int zpointC) {
        this.ptA.set(xpointA, ypointA, zpointA);
        this.ptB.set(xpointB, ypointB, zpointB);
        this.ptC.set(xpointC, ypointC, zpointC);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3f pointA, Point3f pointB, Point3f pointC) {
        this.exporter.fillTriangle(this.colix, pointA, pointB, pointC);
    }

    public void fillTriangle(Point3i pointA, Point3i pointB, Point3i pointC) {
        this.ptA.set(pointA.x, pointA.y, pointA.z);
        this.ptB.set(pointB.x, pointB.y, pointB.z);
        this.ptC.set(pointC.x, pointC.y, pointC.z);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i pointA, short colixA, short normixA, Point3i pointB, short colixB, short normixB, Point3i pointC, short colixC, short normixC, float factor) {
        this.fillTriangle(pointA, colixA, normixA, pointB, colixB, normixB, pointC, colixC, normixC);
    }

    public void drawQuadrilateral(short colix, Point3i pointA, Point3i pointB, Point3i pointC, Point3i screenD) {
        this.setColix(colix);
        this.drawLine(pointA, pointB);
        this.drawLine(pointB, pointC);
        this.drawLine(pointC, screenD);
        this.drawLine(screenD, pointA);
    }

    public void fillQuadrilateral(Point3f pointA, Point3f pointB, Point3f pointC, Point3f pointD) {
        this.exporter.fillTriangle(this.colix, pointA, pointB, pointC);
        this.exporter.fillTriangle(this.colix, pointA, pointC, pointD);
    }

    public void fillQuadrilateral(Point3i pointA, short colixA, short normixA, Point3i pointB, short colixB, short normixB, Point3i pointC, short colixC, short normixC, Point3i screenD, short colixD, short normixD) {
        this.fillTriangle(pointA, colixA, normixA, pointB, colixB, normixB, pointC, colixC, normixC);
        this.fillTriangle(pointA, colixA, normixA, pointC, colixC, normixC, screenD, colixD, normixD);
    }

    public void renderIsosurface(Point3f[] vertices, short colix, short[] colixes, Vector3f[] normals, int[][] indices, BitSet bsFaces, int nVertices, int faceVertexMax, short[] polygonColixes, int nPolygons) {
        this.exporter.renderIsosurface(vertices, colix, colixes, normals, indices, bsFaces, nVertices, faceVertexMax, null, nPolygons);
    }

    public void startShapeBuffer() {
        this.exporter.startShapeBuffer();
    }

    public void endShapeBuffer() {
        this.exporter.endShapeBuffer();
    }

    public void renderEllipsoid(int x, int y, int z, int diameter, Matrix3f mToEllipsoidal, double[] coef, Matrix4f mDeriv, int selectedOctant, Point3i[] octantPoints) {
        this.exporter.renderEllipsoid(this.colix, x, y, z, diameter, coef, octantPoints);
    }

    public boolean isAntialiased() {
        return false;
    }

    public boolean checkTranslucent(boolean isAlphaTranslucent) {
        return true;
    }

    public boolean haveTranslucentObjects() {
        return true;
    }

    public int getRenderWidth() {
        return this.g3d.getRenderWidth();
    }

    public int getRenderHeight() {
        return this.g3d.getRenderHeight();
    }

    public int getSlab() {
        return this.g3d.getSlab();
    }

    public int getDepth() {
        return this.g3d.getDepth();
    }

    public boolean setColix(short colix) {
        this.colix = colix;
        this.g3d.setColix(colix);
        return true;
    }

    public void setFont(byte fid) {
        this.g3d.setFont(fid);
    }

    public Font3D getFont3DCurrent() {
        return this.g3d.getFont3DCurrent();
    }

    public boolean isInDisplayRange(int x, int y) {
        return this.g3d.isInDisplayRange(x, y);
    }

    public boolean isClippedZ(int z) {
        return this.g3d.isClippedZ(z);
    }

    public boolean isClippedXY(int diameter, int x, int y) {
        return this.g3d.isClippedXY(diameter, x, y);
    }

    public int getColixArgb(short colix) {
        return this.g3d.getColixArgb(colix);
    }

    public String getHexColorFromIndex(short colix) {
        return this.g3d.getHexColorFromIndex(colix);
    }

    public int calcSurfaceShade(Point3i pointA, Point3i pointB, Point3i pointC) {
        return this.g3d.calcSurfaceShade(pointA, pointB, pointC);
    }

    public byte getFontFid(String fontFace, float fontSize) {
        return this.g3d.getFontFid(fontFace, fontSize);
    }

    public boolean isDirectedTowardsCamera(short normix) {
        return this.g3d.isDirectedTowardsCamera(normix);
    }

    public short getNormix(Vector3f vector) {
        return this.g3d.getNormix(vector);
    }

    public short getInverseNormix(short normix) {
        return this.g3d.getInverseNormix(normix);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.g3d.getTransformedVertexVectors();
    }

    public Vector3f getNormixVector(short normix) {
        return this.g3d.getNormixVector(normix);
    }

    public Font3D getFont3DScaled(Font3D font, float scale) {
        return this.g3d.getFont3DScaled(font, scale);
    }

    public byte getFontFid(float fontSize) {
        return this.g3d.getFontFid(fontSize);
    }
}

