/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Viewer;

public abstract class _Exporter
implements JmolExportInterface {
    protected Viewer viewer;
    protected JmolRendererInterface jmolRenderer;
    protected StringBuffer output;
    protected BufferedWriter bw;
    private FileOutputStream os;
    protected String fileName;
    protected String commandLineOptions;
    protected boolean isToFile;
    protected Graphics3D g3d;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    boolean use2dBondOrderCalculation = false;
    protected Point3f center = new Point3f();
    protected Point3f tempP1 = new Point3f();
    protected Point3f tempP2 = new Point3f();
    protected Point3f tempP3 = new Point3f();
    protected Vector3f tempV1 = new Vector3f();
    protected Vector3f tempV2 = new Vector3f();
    protected Vector3f tempV3 = new Vector3f();
    protected AxisAngle4f tempA = new AxisAngle4f();
    protected static final float degreesPerRadian = 57.29578f;

    public void setRenderer(JmolRendererInterface jmolRenderer) {
        this.jmolRenderer = jmolRenderer;
    }

    public boolean initializeOutput(Viewer viewer, Graphics3D g3d, Object output) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.center.set(viewer.getRotationCenter());
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = viewer.getScreenWidth();
            this.screenHeight = viewer.getScreenHeight();
        }
        this.slabZ = g3d.getSlab();
        this.depthZ = g3d.getDepth();
        this.isToFile = output instanceof String;
        if (this.isToFile) {
            this.fileName = (String)output;
            int pt = this.fileName.indexOf(":::");
            if (pt > 0) {
                this.commandLineOptions = this.fileName.substring(pt + 3);
                this.fileName = this.fileName.substring(0, pt);
            }
            viewer.writeTextFile(this.fileName + ".spt", viewer.getSavedState("_Export"));
            try {
                this.os = new FileOutputStream(this.fileName);
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
            catch (FileNotFoundException e) {
                return false;
            }
        } else {
            this.output = (StringBuffer)output;
        }
        return true;
    }

    public String finalizeOutput() {
        if (!this.isToFile) {
            return this.output.toString();
        }
        try {
            this.bw.flush();
            this.bw.close();
            this.os = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected static String getExportDate() {
        return new SimpleDateFormat("yyyy-MM-dd', 'HH:mm").format(new Date());
    }

    protected Vector3f getRotation(Vector3f v) {
        this.tempV3.set(v);
        this.tempV3.normalize();
        float r = (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
        float rX = (float)Math.acos(v.y / r) * 57.29578f;
        if (v.x < 0.0f) {
            rX += 180.0f;
        }
        float rY = (float)Math.atan2(v.x, v.z) * 57.29578f;
        this.tempV3.set(rX, rY, 0.0f);
        return this.tempV3;
    }

    protected AxisAngle4f getAxisAngle(Vector3f v) {
        this.tempV3.set(0.0f, 1.0f, 0.0f);
        this.tempV2.set(v);
        this.tempV2.normalize();
        this.tempV3.add(this.tempV2);
        this.tempA.set(this.tempV3.x, this.tempV3.y, this.tempV3.z, 3.14159f);
        return this.tempA;
    }

    protected String rgbFromColix(short colix, char sep) {
        int argb = this.g3d.getColixArgb(colix);
        return "" + (argb >> 16 & 0xFF) + sep + (argb >> 8 & 0xFF) + sep + (argb & 0xFF);
    }

    protected String rgbFractionalFromColix(short colix, char sep) {
        return this.rgbFractionalFromArgb(this.g3d.getColixArgb(colix), sep);
    }

    protected String rgbFractionalFromArgb(int argb, char sep) {
        return "" + (float)(argb >> 16 & 0xFF) / 255.0f + sep + (float)(argb >> 8 & 0xFF) / 255.0f + sep + (float)(argb & 0xFF) / 255.0f;
    }

    protected String translucencyFractionalFromColix(short colix) {
        int translevel = Graphics3D.getColixTranslucencyLevel(colix);
        if (Graphics3D.isColixTranslucent(colix)) {
            return "" + (float)translevel / 255.0f;
        }
        return "" + 0.0f;
    }

    protected Vector getColorList(int i0, short[] colixes, int nVertices, BitSet bsSelected, Hashtable htColixes) {
        int nColix = 0;
        Vector<Short> list = new Vector<Short>();
        for (int i = 0; i < nVertices; ++i) {
            String color;
            if (bsSelected != null && !bsSelected.get(i) || htColixes.containsKey(color = "" + colixes[i])) continue;
            list.add(new Short(colixes[i]));
            htColixes.put(color, "" + (i0 + nColix++));
        }
        return list;
    }
}

