/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;

public class _MayaExporter
extends _Exporter {
    private int nBalls = 0;
    private int nCyl = 0;
    private String name;
    private String id;

    public _MayaExporter() {
        this.use2dBondOrderCalculation = false;
    }

    public void getHeader() {
        this.output.append("//  Maya ASCII 8.5 scene\n");
        this.output.append("//  Name: ball_stripped.ma\n");
        this.output.append("//  Last modified: Thu, Jul 5, 2007 10:25:55 PM\n");
        this.output.append("//  Codeset: UTF-8\n");
        this.output.append("requires maya \"8.5\";\n");
        this.output.append("currentUnit -l centimeter -a degree -t film;\n");
        this.output.append("fileInfo \"application\" \"maya\";\n");
        this.output.append("fileInfo \"product\" \"Maya Unlimited 8.5\";\n");
        this.output.append("fileInfo \"version\" \"8.5\";\n");
        this.output.append("fileInfo \"cutIdentifier\" \"200612170012-692032\";\n");
        this.output.append("fileInfo \"osv\" \"Mac OS X 10.4.9\";  \n");
    }

    public void getFooter() {
    }

    public void renderAtom(Atom atom, short colix) {
        ++this.nBalls;
        this.name = "nurbsSphere" + this.nBalls;
        this.id = "nurbsSphereShape" + this.nBalls;
        this.output.append("createNode transform -n \"" + this.name + "\";\n");
        this.setAttr("t", atom);
        this.output.append("createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output.append("createNode makeNurbSphere -n \"make" + this.name + "\";\n");
        this.output.append(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", (float)atom.getMadAtom() / 2000.0f);
        this.setAttr("s", 4);
        this.setAttr("nsp", 3);
        this.addConnect();
    }

    public void fillCylinder(Point3f atom1, Point3f atom2, short colix1, short colix2, byte endcaps, int madBond, int bondOrder) {
        if (colix1 == colix2) {
            this.renderCylinder(atom1, atom2, colix1, endcaps, madBond);
            return;
        }
        this.tempV2.set(atom2);
        this.tempV2.add(atom1);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderCylinder(atom1, this.tempP1, colix1, endcaps, madBond);
        this.renderCylinder(this.tempP1, atom2, colix2, endcaps, madBond);
    }

    public void renderCylinder(Point3f pt1, Point3f pt2, short colix, byte endcaps, int madBond) {
        ++this.nCyl;
        this.name = "nurbsCylinder" + this.nCyl;
        this.id = "nurbsCylinderShape" + this.nCyl;
        this.output.append(" createNode transform -n \"" + this.name + "\";\n");
        float length = pt1.distance(pt2);
        this.tempV1.set(pt2);
        this.tempV1.add(pt1);
        this.tempV1.scale(0.5f);
        this.setAttr("t", this.tempV1);
        this.tempV1.sub(pt1);
        this.setAttr("r", this.getRotation(this.tempV1));
        this.output.append(" createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output.append("createNode makeNurbCylinder -n \"make" + this.name + "\";\n");
        this.output.append(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        float radius = (float)madBond / 2000.0f;
        this.setAttr("r", radius);
        this.setAttr("s", 4);
        this.setAttr("hr", length / radius);
        this.addConnect();
    }

    private void setAttr(String attr, float val) {
        this.output.append(" setAttr \"." + attr + "\" " + val + ";\n");
    }

    private void setAttr(String attr, int val) {
        this.output.append(" setAttr \"." + attr + "\" " + val + ";\n");
    }

    private void setAttr(String attr, Tuple3f pt) {
        this.output.append(" setAttr \"." + attr + "\" -type \"double3\" " + pt.x + " " + pt.y + " " + pt.z + ";\n");
    }

    private void addAttr() {
        this.output.append(" setAttr -k off \".v\";\n");
        this.output.append(" setAttr \".vir\" yes;\n");
        this.output.append(" setAttr \".vif\" yes;\n");
        this.output.append(" setAttr \".tw\" yes;\n");
        this.output.append(" setAttr \".covm[0]\"  0 1 1;\n");
        this.output.append(" setAttr \".cdvm[0]\"  0 1 1;\n");
    }

    private void addConnect() {
        this.output.append(" connectAttr \"make" + this.name + ".os\" \"" + this.id + ".cr\";\n");
        this.output.append("connectAttr \"" + this.id + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
    }

    public void renderIsosurface(Point3f[] vertices, short colix, short[] colixes, Vector3f[] normals, int[][] indices, BitSet bsFaces, int nVertices, int faceVertexMax, short[] polygonColixes, int nPolygons) {
    }

    public void renderText(Text t) {
    }

    public void drawString(short colix, String str, Font3D font3d, int xBaseline, int yBaseline, int z, int zSlab) {
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, Point3f screenA, Point3f screenB) {
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z, boolean doFill) {
    }

    public void fillScreenedCircleCentered(short colixFill, int diameter, int x, int y, int z) {
    }

    public void drawPixel(short colix, int x, int y, int z) {
    }

    public void drawTextPixel(int argb, int x, int y, int z) {
    }

    public void fillTriangle(short colix, Point3f ptA, Point3f ptB, Point3f ptC) {
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3f screenBase, Point3f screenTip) {
    }

    public void fillSphereCentered(short colix, int diameter, Point3f pt) {
    }

    public void plotText(int x, int y, int z, int argb, String text, Font3D font3d) {
    }

    public void fillHermite(short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, boolean fill, boolean border, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3, Point3f s4, Point3f s5, Point3f s6, Point3f s7, int aspectRatio) {
    }

    public void renderEllipsoid(short colix, int x, int y, int z, int diameter, double[] coef, Point3i[] selectedPoints) {
    }

    public void plotImage(int x, int y, int z, Image image, short bgcolix, int width, int height) {
    }

    public void renderBackground() {
    }

    public void endShapeBuffer() {
    }

    public void startShapeBuffer() {
    }

    public boolean canDoTriangles() {
        return false;
    }
}

