/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class _PovrayExporter
extends _Exporter {
    private int nBytes;
    private boolean isSlabEnabled;
    int nText;
    int nImage;

    public _PovrayExporter() {
        this.use2dBondOrderCalculation = true;
    }

    private void output(String data) {
        this.nBytes += data.length();
        try {
            this.bw.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String finalizeOutput() {
        super.finalizeOutput();
        return this.getAuxiliaryFileData();
    }

    public void getHeader() {
        this.nBytes = 0;
        this.isSlabEnabled = this.viewer.getSlabEnabled();
        float zoom = this.viewer.getRotationRadius() * 2.0f;
        zoom *= 1.1f;
        zoom /= this.viewer.getZoomPercentFloat() / 100.0f;
        int minScreenDimension = Math.min(this.screenWidth, this.screenHeight);
        this.output("// ******************************************************\n");
        this.output("// Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("//\n");
        this.output("// This script was generated on " + _PovrayExporter.getExportDate() + "\n");
        this.output("// ******************************************************\n");
        this.output("\n/* **** Jmol Embedded Script **** \n");
        this.output(TextFormat.simpleReplace(this.viewer.getSavedState("_Export"), "/*file*/", ""));
        this.output("\n*/\n");
        this.output("\n");
        this.output("// ******************************************************\n");
        this.output("// Declare the resolution, camera, and light sources.\n");
        this.output("// ******************************************************\n");
        this.output("\n");
        this.output("// NOTE: if you plan to render at a different resolution,\n");
        this.output("// be sure to update the following two lines to maintain\n");
        this.output("// the correct aspect ratio.\n\n");
        this.output("#declare Width = " + this.screenWidth + ";\n");
        this.output("#declare Height = " + this.screenHeight + ";\n");
        this.output("#declare minScreenDimension = " + minScreenDimension + ";\n");
        this.output("#declare showAtoms = true;\n");
        this.output("#declare showBonds = true;\n");
        this.output("#declare noShadows = true;\n");
        this.output("camera{\n");
        this.output("  orthographic\n");
        this.output("  location < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 0>\n" + "\n");
        this.output("  // Negative right for a right hand coordinate system.\n");
        this.output("\n");
        this.output("  sky < 0, -1, 0 >\n");
        this.output("  right < -" + this.screenWidth + ", 0, 0>\n");
        this.output("  up < 0, " + this.screenHeight + ", 0 >\n");
        this.output("  look_at < " + (float)this.screenWidth / 2.0f + ", " + (float)this.screenHeight / 2.0f + ", 1000 >\n");
        this.output("}\n");
        this.output("\n");
        this.output("background { color rgb <" + this.rgbFractionalFromColix(this.viewer.getObjectColix(0), ',') + "> }\n");
        this.output("\n");
        this.tempP1.set(Graphics3D.getLightSource());
        this.output("// " + this.tempP1 + " \n");
        float distance = Math.max(this.screenWidth, this.screenHeight);
        this.output("light_source { <" + this.tempP1.x * distance + "," + this.tempP1.y * distance + ", " + -1.0f * this.tempP1.z * distance + "> " + " rgb <0.6,0.6,0.6> }\n");
        this.output("\n");
        this.output("\n");
        this.output("// ***********************************************\n");
        this.output("// macros for common shapes\n");
        this.output("// ***********************************************\n");
        this.output("\n");
        this.writeMacros();
    }

    private void writeMacros() {
        this.output("#default { finish {\n  ambient " + (float)Graphics3D.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)Graphics3D.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)Graphics3D.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n  metallic\n  phong 0.9\n  phong_size 120\n}}" + "\n\n");
        this.output("#macro check_shadow()\n #if (noShadows)\n  no_shadow \n #end\n#end\n\n");
        this.output("#declare slabZ = " + this.slabZ + ";\n" + "#declare depthZ = " + this.depthZ + ";\n" + "#declare dzSlab = 10;\n" + "#declare dzDepth = dzSlab;\n" + "#declare dzStep = 0.001;\n\n");
        this.output("#macro clip()\n  clipped_by { box {<0,0,slabZ>,<Width,Height,depthZ>} }\n#end\n\n");
        this.output("#macro circleCap(Z,RADIUS,R,G,B,T)\n// cap for lower clip\n #local cutDiff = Z - slabZ;\n #local cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzSlab > 0)\n   #declare dzSlab = dzSlab - dzStep;\n  #end\n  cylinder{<X,Y,slabZ-dzSlab>,<X,Y,(slabZ+1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n// cap for upper clip\n #declare cutDiff = Z - depthZ;\n #declare cutRadius2 = (RADIUS*RADIUS) - (cutDiff*cutDiff);\n #if (cutRadius2 > 0)\n  #local cutRadius = sqrt(cutRadius2);\n  #if (dzDepth > 0)\n   #declare dzDepth = dzDepth - dzStep;\n  #end\n  cylinder{<X,Y,depthZ+dzDepth>,<X,Y,(depthZ-1)>,cutRadius\n   pigment{rgbt<R,G,B,T>}\n   translucentFinish(T)\n   check_shadow()}\n #end\n#end\n\n");
        this.writeMacrosFinish();
        this.writeMacrosAtom();
        this.writeMacrosBond();
        this.writeMacrosTriangle();
        this.writeMacrosTextPixel();
    }

    private void writeMacrosFinish() {
        this.output("#macro translucentFinish(T)\n #local shineFactor = T;\n #if (T <= 0.25)\n  #declare shineFactor = (1.0-4*T);\n #end\n #if (T > 0.25)\n  #declare shineFactor = 0;\n #end\n finish {\n  ambient " + (float)Graphics3D.getAmbientPercent() / 100.0f + "\n" + "  diffuse " + (float)Graphics3D.getDiffusePercent() / 100.0f + "\n" + "  specular " + (float)Graphics3D.getSpecularPercent() / 100.0f + "\n" + "  roughness .00001\n" + "  metallic shineFactor\n" + "  phong 0.9*shineFactor\n" + "  phong_size 120*shineFactor\n}" + "#end\n\n");
    }

    private void writeMacrosAtom() {
        this.output("#macro a(X,Y,Z,RADIUS,R,G,B,T)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n" + (this.isSlabEnabled ? " circleCap(Z,RADIUS,R,G,B,T)\n" : "") + "#end\n\n");
        this.output("#macro q(XX,YY,ZZ,XY,XZ,YZ,X,Y,Z,J,R,G,B,T)\n quadric{<XX,YY,ZZ>,<XY,XZ,YZ>,<X,Y,Z>,J\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosBond() {
        this.output("#macro b(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
        this.output("#macro c(X1,Y1,Z1,RADIUS1,X2,Y2,Z2,RADIUS2,R,G,B,T)\n cone{<X1,Y1,Z1>,RADIUS1,<X2,Y2,Z2>,RADIUS2 open\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosTriangle() {
        this.output("#macro r(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,R,G,B,T)\n triangle{<X1,Y1,Z1>,<X2,Y2,Z2>,<X3,Y3,Z3>\n  pigment{rgbt<R,G,B,T>}\n  translucentFinish(T)\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private void writeMacrosTextPixel() {
        this.output("#macro p(X,Y,Z,R,G,B)\n box{<X,Y,Z>,<X+1,Y+1,Z+1>\n  pigment{rgb<R,G,B>}\n  clip()\n  check_shadow()}\n#end\n\n");
    }

    private String triad(Tuple3f pt) {
        if (Float.isNaN(pt.x)) {
            return "0,0,0";
        }
        return pt.x + "," + pt.y + "," + pt.z;
    }

    private String triad(int[] i) {
        return i[0] + "," + i[1] + "," + i[2];
    }

    private String color4(short colix) {
        return this.rgbFractionalFromColix(colix, ',') + "," + this.translucencyFractionalFromColix(colix);
    }

    public void getFooter() {
    }

    private String getAuxiliaryFileData() {
        return "; Created by: Jmol " + Viewer.getJmolVersion() + "\n; Creation date: " + _PovrayExporter.getExportDate() + "\n; File created: " + this.fileName + " (" + this.nBytes + " bytes)\n\n" + (this.commandLineOptions != null ? this.commandLineOptions : "\n; Jmol state: " + this.fileName + ".spt" + "\nInput_File_Name=" + this.fileName + "\nOutput_to_File=true" + "\nOutput_File_Type=N" + "\nOutput_File_Name=" + this.fileName + ".png" + "\nWidth=" + this.screenWidth + "\nHeight=" + this.screenHeight + "\nAntialias=true" + "\nAntialias_Threshold=0.1" + "\nDisplay=true" + "\nPause_When_Done=true" + "\nWarning_Level=5" + "\nVerbose=false" + "\n");
    }

    public void renderAtom(Atom atom, short colix) {
        this.fillSphereCentered(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ, colix);
    }

    public void fillCylinder(Point3f atom1, Point3f atom2, short colix1, short colix2, byte endcaps, int madBond, int bondOrder) {
        if (colix1 == colix2) {
            this.renderJoint(atom1, colix1, endcaps, madBond);
            this.renderCylinder(atom1, atom2, colix1, endcaps, madBond);
            this.renderJoint(atom2, colix2, endcaps, madBond);
            return;
        }
        this.tempV2.set(atom2);
        this.tempV2.add(atom1);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderJoint(atom1, colix1, endcaps, madBond);
        this.renderCylinder(atom1, this.tempP1, colix1, endcaps, madBond);
        this.renderCylinder(this.tempP1, atom2, colix2, endcaps, madBond);
        this.renderJoint(atom2, colix2, endcaps, madBond);
    }

    public void renderCylinder(Point3f pt1, Point3f pt2, short colix, byte endcaps, int madBond) {
        short d = this.viewer.scaleToScreen((int)pt1.z, madBond);
        if (pt1.distance(pt2) == 0.0f) {
            this.fillSphereCentered(colix, d, pt1);
            return;
        }
        float radius1 = (float)d / 2.0f;
        float radius2 = this.viewer.scaleToScreen((int)pt2.z, madBond / 2);
        this.output("b(" + this.triad(pt1) + "," + radius1 + "," + this.triad(pt2) + "," + radius2 + "," + this.color4(colix) + ")\n");
    }

    private void renderJoint(Point3f pt, short colix, byte endcaps, int madBond) {
        if (endcaps == 3) {
            float radius = this.viewer.scaleToScreen((int)pt.z, madBond / 2);
            this.output("a(" + this.triad(pt) + "," + radius + "," + this.color4(colix) + ")\n");
        }
    }

    public void renderIsosurface(Point3f[] vertices, short colix, short[] colixes, Vector3f[] normals, int[][] indices, BitSet bsFaces, int nVertices, int faceVertexMax, short[] polygonColixes, int nPolygons) {
        boolean haveNormals;
        if (nVertices == 0) {
            return;
        }
        int nFaces = 0;
        int i = nPolygons;
        while (--i >= 0) {
            if (!bsFaces.get(i)) continue;
            nFaces += faceVertexMax == 4 && indices[i].length == 4 ? 2 : 1;
        }
        if (nFaces == 0) {
            return;
        }
        if (polygonColixes != null) {
            i = nPolygons;
            while (--i >= 0) {
                if (!bsFaces.get(i)) continue;
                this.output("polygon { 4\n");
                for (int j = 0; j <= 3; ++j) {
                    this.viewer.transformPoint(vertices[indices[i][j % 3]], this.tempP1);
                    this.output(", <" + this.triad(this.tempP1) + ">");
                }
                this.output("\n");
                colix = polygonColixes[i];
                this.output("pigment{rgbt<" + this.color4(colix) + ">}\n");
                this.output("  translucentFinish(" + this.translucencyFractionalFromColix(colix) + ")\n");
                this.output("  check_shadow()\n");
                this.output("  clip()\n");
                this.output("}\n");
            }
            return;
        }
        this.output("mesh2 {\n");
        this.output("vertex_vectors { " + nVertices);
        for (i = 0; i < nVertices; ++i) {
            this.viewer.transformPoint(vertices[i], this.tempP1);
            this.output(", <" + this.triad(this.tempP1) + ">");
            this.output(" //" + i + "\n");
        }
        this.output("\n}\n");
        boolean bl = haveNormals = normals != null;
        if (haveNormals) {
            this.output("normal_vectors { " + nVertices);
            for (int i2 = 0; i2 < nVertices; ++i2) {
                this.output(", <" + this.triad(this.getNormal(vertices[i2], normals[i2])) + ">");
                this.output(" //" + i2 + "\n");
            }
            this.output("\n}\n");
        }
        Hashtable htColixes = new Hashtable();
        if (colixes != null) {
            Vector list = this.getColorList(0, colixes, nVertices, null, htColixes);
            int nColix = list.size();
            this.output("texture_list { " + nColix);
            String finish = ">} translucentFinish(" + this.translucencyFractionalFromColix(colixes[0]) + ")}";
            for (int i3 = 0; i3 < nColix; ++i3) {
                this.output("\n, texture{pigment{rgbt<" + this.color4((Short)list.get(i3)) + finish);
            }
            this.output("\n}\n");
        }
        this.output("face_indices { " + nFaces);
        int i4 = nPolygons;
        while (--i4 >= 0) {
            if (!bsFaces.get(i4)) continue;
            this.output(", <" + this.triad(indices[i4]) + ">");
            if (colixes != null) {
                this.output("," + htColixes.get("" + colixes[indices[i4][0]]));
                this.output("," + htColixes.get("" + colixes[indices[i4][1]]));
                this.output("," + htColixes.get("" + colixes[indices[i4][2]]));
            }
            if (faceVertexMax == 4 && indices[i4].length == 4) {
                this.output(", <" + indices[i4][0] + "," + indices[i4][2] + "," + indices[i4][3] + ">");
                if (colixes != null) {
                    this.output("," + htColixes.get("" + colixes[indices[i4][0]]));
                    this.output("," + htColixes.get("" + colixes[indices[i4][2]]));
                    this.output("," + htColixes.get("" + colixes[indices[i4][3]]));
                }
            }
            this.output("\n");
        }
        this.output("\n}\n");
        if (colixes == null) {
            this.output("pigment{rgbt<" + this.color4(colix) + ">}\n");
            this.output("  translucentFinish(" + this.translucencyFractionalFromColix(colix) + ")\n");
        }
        this.output("  check_shadow()\n");
        this.output("  clip()\n");
        this.output("}\n");
    }

    private Point3f getNormal(Point3f pt, Vector3f normal) {
        this.tempP1.set(pt);
        this.tempP1.add(normal);
        this.viewer.transformPoint(pt, this.tempP2);
        this.viewer.transformPoint(this.tempP1, this.tempP3);
        this.tempP3.sub(this.tempP2);
        return this.tempP3;
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, Point3f screenA, Point3f screenB) {
        float radius1;
        if (screenA.distance(screenB) == 0.0f) {
            this.fillSphereCentered(diameter, screenA.x, screenA.y, screenA.z, colix);
            return;
        }
        float radius2 = radius1 = (float)diameter / 2.0f;
        String color = this.color4(colix);
        this.output((endcaps == 2 ? "b(" : "c(") + this.triad(screenA) + "," + radius1 + "," + this.triad(screenB) + "," + radius2 + "," + color + ")\n");
        if (endcaps != 3) {
            return;
        }
        this.output("a(" + this.triad(screenA) + "," + radius1 + "," + color + ")\n");
        this.output("a(" + this.triad(screenB) + "," + radius2 + "," + color + ")\n");
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z, boolean doFill) {
        float r = (float)diameter / 2.0f;
        this.output((doFill ? "b(" : "c(") + x + "," + y + "," + z + "," + r + "," + x + "," + y + "," + (z + 1) + "," + (r + 2.0f) + "," + this.color4(colix) + ")\n");
    }

    public void fillScreenedCircleCentered(short colix, int diameter, int x, int y, int z) {
        float r = (float)diameter / 2.0f;
        this.output("b(" + x + "," + y + "," + z + "," + r + "," + x + "," + y + "," + (z + 1) + "," + r + "," + this.rgbFractionalFromColix(colix, ',') + ",0.8)\n");
    }

    public void drawPixel(short colix, int x, int y, int z) {
        this.fillSphereCentered(1.5f, x, y, z, colix);
    }

    public void drawTextPixel(int argb, int x, int y, int z) {
        this.output("p(" + x + "," + y + "," + z + "," + this.rgbFractionalFromArgb(argb, ',') + ")\n");
    }

    public void fillTriangle(short colix, Point3f ptA, Point3f ptB, Point3f ptC) {
        this.output("r(" + this.triad(ptA) + "," + this.triad(ptB) + "," + this.triad(ptC) + "," + this.color4(colix) + ")\n");
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3f screenBase, Point3f screenTip) {
        this.output("b(" + this.triad(screenBase) + "," + (float)diameter / 2.0f + "," + this.triad(screenTip) + ",0" + "," + this.color4(colix) + ")\n");
    }

    public void fillSphereCentered(short colix, int diameter, Point3f pt) {
        this.output("a(" + this.triad(pt) + "," + (float)diameter / 2.0f + "," + this.color4(colix) + ")\n");
    }

    private void fillSphereCentered(float diameter, float x, float y, float z, short colix) {
        this.output("a(" + x + "," + y + "," + z + "," + diameter / 2.0f + "," + this.color4(colix) + ")\n");
    }

    public void plotText(int x, int y, int z, int argb, String text, Font3D font3d) {
        this.output("// start text " + ++this.nText + ": " + text + "\n");
        this.g3d.plotText(x, y, z, argb, text, font3d, this.jmolRenderer);
        this.output("// end text " + this.nText + ": " + text + "\n");
    }

    public void plotImage(int x, int y, int z, Image image, short bgcolix, int width, int height) {
        this.output("// start image " + ++this.nImage + "\n");
        this.g3d.plotImage(x, y, z, image, this.jmolRenderer, bgcolix, width, height);
        this.output("// end image " + this.nImage + "\n");
    }

    public void fillHermite(short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, boolean fill, boolean border, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3, Point3f s4, Point3f s5, Point3f s6, Point3f s7, int aspectRatio) {
    }

    public void renderText(Text t) {
    }

    public void drawString(short colix, String str, Font3D font3d, int xBaseline, int yBaseline, int z, int zSlab) {
    }

    public void renderEllipsoid(short colix, int ix, int iy, int iz, int diameter, double[] coef, Point3i[] selectedPoints) {
        String s = coef[0] + "," + coef[1] + "," + coef[2] + "," + coef[3] + "," + coef[4] + "," + coef[5] + "," + coef[6] + "," + coef[7] + "," + coef[8] + "," + coef[9] + "," + this.color4(colix);
        this.output("q(" + s + ")\n");
    }

    public void renderBackground() {
        this.g3d.renderBackground(this.jmolRenderer);
    }

    public void endShapeBuffer() {
    }

    public void startShapeBuffer() {
    }

    public boolean canDoTriangles() {
        return true;
    }
}

