/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends _Exporter {
    private final Point3f pt = new Point3f();
    private final Point3f ptAtom = new Point3f();

    public _VrmlExporter() {
        this.use2dBondOrderCalculation = false;
    }

    private void output(String data) {
        this.output.append(data);
    }

    public void getHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title \" \" \n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + _VrmlExporter.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor " + this.rgbFractionalFromColix(this.viewer.getObjectColix(0), ' ') + " } \n");
        this.output("Transform {\n");
        this.output("translation " + -this.center.x + " " + -this.center.y + " " + -this.center.z + "\n");
        this.output("children [\n\n");
    }

    public void getFooter() {
        this.output("\n]\n");
        this.output("}\n");
    }

    public void renderAtom(Atom atom, short colix) {
        float r = (float)atom.getMadAtom() / 2000.0f;
        this.outputSphere(atom, r, colix);
    }

    private void outputSphere(Point3f pt, float radius, short colix) {
        String color = this.rgbFractionalFromColix(colix, ' ');
        String translu = this.translucencyFractionalFromColix(colix);
        this.output("Transform {\n");
        this.output(" translation " + pt.x + " " + pt.y + " " + pt.z + "\n");
        this.output(" children [\n");
        this.output("  Shape {\n");
        this.output("   geometry Sphere { radius " + radius + " }\n");
        this.output("   appearance Appearance {\n");
        this.output("    material Material { diffuseColor " + color + " transparency " + translu + " }\n");
        this.output("   }\n");
        this.output("  }\n");
        this.output(" ]\n");
        this.output("}\n");
    }

    public void fillCylinder(Point3f atom1, Point3f atom2, short colix1, short colix2, byte endcaps, int madBond, int bondOrder) {
        if (colix1 == colix2) {
            this.renderCylinder(atom1, atom2, colix1, endcaps, madBond);
            return;
        }
        this.tempV2.set(atom2);
        this.tempV2.add(atom1);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderCylinder(atom1, this.tempP1, colix1, endcaps, madBond);
        this.renderCylinder(this.tempP1, atom2, colix2, endcaps, madBond);
    }

    public void renderCylinder(Point3f pt1, Point3f pt2, short colix, byte endcaps, int madBond) {
        String color = this.rgbFractionalFromColix(colix, ' ');
        String translu = this.translucencyFractionalFromColix(colix);
        float length = pt1.distance(pt2);
        float r = (float)madBond / 2000.0f;
        this.tempV1.set(pt2);
        this.tempV1.add(pt1);
        this.tempV1.scale(0.5f);
        this.output("Transform {\n");
        this.output(" translation " + this.tempV1.x + " " + this.tempV1.y + " " + this.tempV1.z + "\n");
        this.tempV1.sub(pt1);
        this.getAxisAngle(this.tempV1);
        this.output(" rotation " + this.tempA.x + " " + this.tempA.y + " " + this.tempA.z + " " + this.tempA.angle + "\n");
        this.output(" children [\n");
        this.output("  Shape {\n");
        this.output("   geometry Cylinder { height " + length + " radius " + r + " }\n");
        this.output("   appearance Appearance {\n");
        this.output("    material Material { diffuseColor " + color + " transparency " + translu + " }\n");
        this.output("   }\n");
        this.output("  }\n");
        this.output(" ]\n");
        this.output("}\n");
    }

    public void renderIsosurface(Point3f[] vertices, short colix, short[] colixes, Vector3f[] normals, int[][] indices, BitSet bsFaces, int nVertices, int faceVertexMax, short[] polygonColixes, int nPolygons) {
        int i;
        if (nVertices == 0) {
            return;
        }
        int nFaces = 0;
        int i2 = nPolygons;
        while (--i2 >= 0) {
            if (!bsFaces.get(i2)) continue;
            nFaces += faceVertexMax == 4 && indices[i2].length == 4 ? 2 : 1;
        }
        if (nFaces == 0) {
            return;
        }
        Vector colorList = null;
        Hashtable htColixes = new Hashtable();
        if (polygonColixes != null) {
            colorList = this.getColorList(0, polygonColixes, nPolygons, bsFaces, htColixes);
        } else if (colixes != null) {
            colorList = this.getColorList(0, colixes, nVertices, null, htColixes);
        }
        String color = this.rgbFractionalFromColix(colix, ' ');
        String translu = this.translucencyFractionalFromColix(colix);
        this.output("Shape {\n");
        if (polygonColixes != null) {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output(" appearance Appearance {\n");
        this.output("  material Material { diffuseColor " + color + " transparency " + translu + " }\n");
        this.output(" }\n");
        this.output(" geometry IndexedFaceSet {\n");
        this.output("coord Coordinate {\n   point [\n");
        for (i = 0; i < nVertices; ++i) {
            this.output(vertices[i].x + " " + vertices[i].y + " " + vertices[i].z + "\n");
        }
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        i = nPolygons;
        while (--i >= 0) {
            if (!bsFaces.get(i)) continue;
            this.output(indices[i][0] + " " + indices[i][1] + " " + indices[i][2] + " -1\n");
            if (faceVertexMax != 4 || indices[i].length != 4) continue;
            this.output("," + indices[i][0] + " " + indices[i][2] + " " + indices[i][3] + " -1\n");
        }
        this.output("  ]\n");
        if (normals != null) {
            this.output("  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            for (i = 0; i < nVertices; ++i) {
                this.output(normals[i].x + " " + normals[i].y + " " + normals[i].z + "\n");
            }
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            i = nPolygons;
            while (--i >= 0) {
                if (!bsFaces.get(i)) continue;
                this.output(indices[i][0] + " " + indices[i][1] + " " + indices[i][2] + " -1\n");
                if (faceVertexMax != 4 || indices[i].length != 4) continue;
                this.output("," + indices[i][0] + " " + indices[i][2] + " " + indices[i][3] + " -1\n");
            }
            this.output("  ]\n");
        }
        if (colorList != null) {
            int i3;
            this.output("  color Color { color [\n");
            int nColors = colorList.size();
            for (i3 = 0; i3 < nColors; ++i3) {
                color = this.rgbFractionalFromColix((Short)colorList.get(i3), ' ');
                this.output(" ");
                this.output(color);
                this.output("\n");
            }
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            i3 = nPolygons;
            while (--i3 >= 0) {
                if (!bsFaces.get(i3)) continue;
                if (polygonColixes == null) {
                    this.output(htColixes.get("" + colixes[indices[i3][0]]) + " " + htColixes.get("" + colixes[indices[i3][1]]) + " " + htColixes.get("" + colixes[indices[i3][2]]) + " -1\n");
                    if (faceVertexMax != 4 || indices[i3].length != 4) continue;
                    this.output(htColixes.get("" + colixes[indices[i3][0]]) + " " + htColixes.get("" + colixes[indices[i3][2]]) + " " + htColixes.get("" + colixes[indices[i3][3]]) + " -1\n");
                    continue;
                }
                this.output(htColixes.get("" + polygonColixes[i3]) + "\n");
            }
            this.output("  ]\n");
        }
        this.output(" }\n");
        this.output("}\n");
    }

    public void renderText(Text t) {
    }

    public void drawString(short colix, String str, Font3D font3d, int xBaseline, int yBaseline, int z, int zSlab) {
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, Point3f screenA, Point3f screenB) {
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z, boolean doFill) {
    }

    public void fillScreenedCircleCentered(short colix, int diameter, int x, int y, int z) {
    }

    public void drawPixel(short colix, int x, int y, int z) {
    }

    public void drawTextPixel(int argb, int x, int y, int z) {
    }

    public void fillTriangle(short colix, Point3f ptA, Point3f ptB, Point3f ptC) {
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3f screenBase, Point3f screenTip) {
    }

    public void fillSphereCentered(short colix, int diameter, Point3f pt) {
        this.outputSphere(pt, (float)diameter / 2.0f, colix);
    }

    public void plotText(int x, int y, int z, int argb, String text, Font3D font3d) {
        String color = this.rgbFractionalFromArgb(argb, ' ');
        String useFontStyle = font3d.fontStyle.toUpperCase();
        String preFontFace = font3d.fontFace.toUpperCase();
        String useFontFace = preFontFace.equals("MONOSPACED") ? "TYPEWRITER" : (preFontFace.equals("SERIF") ? "SERIF" : "SANS");
        this.output("Transform {\n");
        this.pt.set(x, y, z);
        this.viewer.unTransformPoint(this.pt, this.ptAtom);
        this.output(" translation " + this.ptAtom.x + " " + this.ptAtom.y + " " + this.ptAtom.z + "\n");
        this.output(" children Billboard {\n");
        this.output("  axisOfRotation 0 0 0 \n");
        this.output("  children [\n");
        this.output("   Transform {\n");
        this.output("    translation 0.0 0.0 0.0 \n");
        this.output("    children Shape {\n");
        this.output("     appearance Appearance {\n");
        this.output("      material Material { diffuseColor 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + color + " }\n");
        this.output("     }\n");
        this.output("     geometry Text {\n");
        this.output("      fontStyle FontStyle { size 0.4 family \"" + useFontFace + "\" style \"" + useFontStyle + "\" } \n");
        this.output("      string\t\"" + text + "\" \n");
        this.output("     }\n");
        this.output("    }\n");
        this.output("   }\n");
        this.output("  ]\n");
        this.output(" }\n");
        this.output("}\n");
    }

    public void fillHermite(short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3) {
    }

    public void drawHermite(short colix, boolean fill, boolean border, int tension, Point3f s0, Point3f s1, Point3f s2, Point3f s3, Point3f s4, Point3f s5, Point3f s6, Point3f s7, int aspectRatio) {
    }

    public void renderEllipsoid(short colix, int x, int y, int z, int diameter, double[] coef, Point3i[] selectedPoints) {
    }

    public void plotImage(int x, int y, int z, Image image, short bgcolix, int width, int height) {
    }

    public void renderBackground() {
    }

    public void startShapeBuffer() {
    }

    public void endShapeBuffer() {
    }

    public boolean canDoTriangles() {
        return false;
    }
}

