/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.viewer.FileManager;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active = null;
    JCheckBox append = null;
    JFileChooser chooser = null;
    private FPPanel display = null;

    public FilePreview(JFileChooser fileChooser, JmolAdapter modelAdapter, boolean allowAppend, String appletContext) {
        this.chooser = fileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FilePreview.this.active.isSelected()) {
                    FilePreview.this.updatePreview(FilePreview.this.chooser.getSelectedFile());
                } else {
                    FilePreview.this.updatePreview(null);
                }
            }
        });
        box.add(this.active);
        this.display = new FPPanel(modelAdapter, appletContext);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        if (allowAppend) {
            this.append = new JCheckBox(GT._("Append models"), false);
            box.add(this.append);
        }
        this.add(box);
        fileChooser.setAccessory(this);
        fileChooser.addPropertyChangeListener(this);
    }

    public boolean isAppendSelected() {
        if (this.append != null) {
            return this.append.isSelected();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(prop = evt.getPropertyName())) {
            this.updatePreview((File)evt.getNewValue());
        }
    }

    void updatePreview(File file) {
        String script;
        if (file == null) {
            script = "zap";
        } else {
            String fileName = file.getAbsolutePath();
            String url = FileManager.getLocalUrl(file);
            if (url != null) {
                fileName = url;
            }
            script = " \"" + fileName + "\"";
            script = fileName.indexOf(".spt") >= 0 ? "script " + script : "zap;set echo top left;echo loading...;refresh;load " + script + ";if({1-10000}.size);cartoons only;color structure;endif";
        }
        this.display.getViewer().evalStringQuiet(script);
    }

    private static class FPPanel
    extends JPanel {
        JmolViewer viewer;
        final Dimension currentSize = new Dimension();

        FPPanel(JmolAdapter modelAdapter, String appletContext) {
            this.viewer = JmolViewer.allocateViewer(this, modelAdapter, "", null, null, "#previewOnly " + appletContext, null);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        public void paint(Graphics g) {
            this.viewer.setScreenDimension(this.getSize(this.currentSize));
            Rectangle rectClip = new Rectangle();
            g.getClipBounds(rectClip);
            this.viewer.renderScreenImage(g, this.currentSize, rectClip);
        }
    }
}

