/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import org.jmol.g3d.Platform3D;

public final class Font3D {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final float fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final float fontSize;
    public final Font font;
    public final FontMetrics fontMetrics;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount = 1;
    private static int[] fontkeys = new int[8];
    private static Font3D[] font3ds = new Font3D[8];
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};

    private Font3D(byte fid, int idFontFace, int idFontStyle, float fontSize, float fontSizeNominal, Font font, FontMetrics fontMetrics) {
        this.fid = fid;
        this.fontFace = fontFaces[idFontFace];
        this.fontStyle = fontStyles[idFontStyle];
        this.idFontFace = idFontFace;
        this.idFontStyle = idFontStyle;
        this.fontSize = fontSize;
        this.fontSizeNominal = fontSizeNominal;
        this.font = font;
        this.fontMetrics = fontMetrics;
    }

    static synchronized Font3D getFont3D(int fontface, int fontstyle, float fontsize, float fontsizeNominal, Platform3D platform) {
        Font3D font3d;
        int fontIndexNext;
        if (platform == null) {
            return null;
        }
        if (fontsize > 255.0f) {
            fontsize = 255.0f;
        }
        int fontsizeX16 = (int)fontsize << 4;
        int fontkey = fontface & 3 | (fontstyle & 3) << 2 | fontsizeX16 << 4;
        int i = fontkeyCount;
        while (--i > 0) {
            if (fontkey != fontkeys[i] || Font3D.font3ds[i].fontSizeNominal != fontsizeNominal) continue;
            return font3ds[i];
        }
        if ((fontIndexNext = fontkeyCount++) == fontkeys.length) {
            int[] t0 = new int[fontIndexNext + 8];
            System.arraycopy(fontkeys, 0, t0, 0, fontIndexNext);
            fontkeys = t0;
            Font3D[] t1 = new Font3D[fontIndexNext + 8];
            System.arraycopy(font3ds, 0, t1, 0, fontIndexNext);
            font3ds = t1;
        }
        Font font = new Font(Font3D.getFontMap(fontFaces[fontface], fontstyle, fontsize));
        FontMetrics fontMetrics = platform.graphicsOffscreen.getFontMetrics(font);
        Font3D.font3ds[fontIndexNext] = font3d = new Font3D((byte)fontIndexNext, fontface, fontstyle, fontsize, fontsizeNominal, font, fontMetrics);
        Font3D.fontkeys[fontIndexNext] = fontkey;
        return font3d;
    }

    private static Hashtable getFontMap(String fontFace, int idFontStyle, float fontSize) {
        Hashtable<TextAttribute, Object> fontMap = new Hashtable<TextAttribute, Object>();
        fontMap.put(TextAttribute.FAMILY, fontFace);
        if ((idFontStyle & 1) == 1) {
            fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((idFontStyle & 2) == 2) {
            fontMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        fontMap.put(TextAttribute.SIZE, new Float(fontSize));
        return fontMap;
    }

    public static int getFontFaceID(String fontface) {
        if ("Monospaced".equalsIgnoreCase(fontface)) {
            return 2;
        }
        if ("Serif".equalsIgnoreCase(fontface)) {
            return 1;
        }
        return 0;
    }

    public static int getFontStyleID(String fontstyle) {
        int i = 4;
        while (--i > 0 && !fontStyles[i].equalsIgnoreCase(fontstyle)) {
        }
        return i;
    }

    public static Font3D getFont3D(byte fontID) {
        return font3ds[fontID & 0xFF];
    }
}

