/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Circle3D;
import org.jmol.g3d.Colix3D;
import org.jmol.g3d.Cylinder3D;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Normix3D;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.Rgb16;
import org.jmol.g3d.Shade3D;
import org.jmol.g3d.Sphere3D;
import org.jmol.g3d.Text3D;
import org.jmol.g3d.Triangle3D;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public final class Graphics3D
implements JmolRendererInterface {
    Platform3D platform;
    Line3D line3d;
    Circle3D circle3d;
    Sphere3D sphere3d;
    Triangle3D triangle3d;
    Cylinder3D cylinder3d;
    Hermite3D hermite3d;
    Normix3D normix3d;
    boolean isFullSceneAntialiasingEnabled;
    private boolean antialiasThisFrame;
    private boolean antialias2;
    private boolean antialiasEnabled;
    boolean inGreyscaleMode;
    byte[] anaglyphChannelBytes;
    boolean twoPass = false;
    boolean isPass2;
    boolean addAllPixels;
    boolean haveTranslucentObjects;
    int windowWidth;
    int windowHeight;
    int width;
    int height;
    int displayMinX;
    int displayMaxX;
    int displayMinY;
    int displayMaxY;
    int slab;
    int depth;
    boolean zShade;
    int xLast;
    int yLast;
    private int[] pbuf;
    private int[] pbufT;
    int[] zbuf;
    private int[] zbufT;
    int bufferSize;
    short colixCurrent;
    int[] shadesCurrent;
    int argbCurrent;
    boolean isTranslucent;
    boolean isScreened;
    int translucencyMask;
    int argbNoisyUp;
    int argbNoisyDn;
    Font3D font3dCurrent;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_OPEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    public static final byte ENDCAPS_OPENEND = 4;
    public static final byte shadeMax = 64;
    public static final byte shadeLast = 63;
    public static final byte shadeNormal = Shade3D.shadeNormal;
    public static final byte intensitySpecularSurfaceLimit = Shade3D.intensitySpecularSurfaceLimit;
    public static final short INHERIT_ALL = 0;
    public static final short USE_PALETTE = 2;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;
    int newWindowWidth;
    int newWindowHeight;
    boolean newAntialiasing;
    public double random;
    int anaglyphLength;
    public Image backgroundImage;
    public int bgcolor;
    private int currentIntensity;
    int zMargin;
    boolean currentlyRendering;
    private static final short CHANGEABLE_MASK = Short.MIN_VALUE;
    private static final short UNMASK_CHANGEABLE_TRANSLUCENT = 2047;
    private static final int TRANSLUCENT_SHIFT = 11;
    private static final int ALPHA_SHIFT = 13;
    private static final int TRANSLUCENT_MASK = 30720;
    private static final int TRANSLUCENT_SCREENED = 30720;
    private static final int TRANSPARENT = 16384;
    static final int TRANSLUCENT_50 = 8192;
    public static final short OPAQUE_MASK = -30721;
    private static final short INHERIT_COLOR = 1;
    static final short UNUSED_OPTION3 = 3;
    static final short SPECIAL_COLIX_MAX = 4;
    private short[] changeableColixMap = new short[16];
    static final float[] lighting = Shade3D.lighting;
    private final Vector3f vectorAB = new Vector3f();
    private final Vector3f vectorAC = new Vector3f();
    private final Vector3f vectorNormal = new Vector3f();
    private static final String[] colorNames = new String[]{"black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint"};
    private static final int[] colorArgbs = new int[]{-16777216, -1, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267};
    private static final Hashtable mapJavaScriptColors = new Hashtable();

    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
    }

    public boolean isDisplayAntialiased() {
        return this.antialiasEnabled;
    }

    public boolean isAntialiased() {
        return this.antialiasThisFrame;
    }

    public Graphics3D(Component awtComponent) {
        this.platform = Platform3D.createInstance(awtComponent);
        this.line3d = new Line3D(this);
        this.circle3d = new Circle3D(this);
        this.sphere3d = new Sphere3D(this);
        this.triangle3d = new Triangle3D(this);
        this.cylinder3d = new Cylinder3D(this);
        this.hermite3d = new Hermite3D(this);
        this.normix3d = new Normix3D();
    }

    public void setg3dExporter(Graphics3D g3d, JmolExportInterface exporter) {
    }

    public JmolExportInterface getExporter() {
        return null;
    }

    public void setRenderer(ShapeRenderer shapeRenderer) {
    }

    public boolean currentlyRendering() {
        return this.currentlyRendering;
    }

    public void setWindowParameters(int width, int height, boolean antialias) {
        this.newWindowWidth = width;
        this.newWindowHeight = height;
        this.newAntialiasing = antialias;
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    private void setWidthHeight(boolean isAntialiased) {
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (isAntialiased) {
            this.width <<= 1;
            this.height <<= 1;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.displayMinX = -(this.width >> 1);
        this.displayMaxX = this.width - this.displayMinX;
        this.displayMinY = -(this.height >> 1);
        this.displayMaxY = this.height - this.displayMinY;
        this.bufferSize = this.width * this.height;
    }

    public boolean checkTranslucent(boolean isAlphaTranslucent) {
        if (isAlphaTranslucent) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == isAlphaTranslucent;
    }

    public void beginRendering(Matrix3f rotationMatrix) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.normix3d.setRotationMatrix(rotationMatrix);
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        this.twoPass = true;
        this.isPass2 = false;
        this.colixCurrent = 0;
        this.haveTranslucentObjects = false;
        this.addAllPixels = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
        }
        this.setWidthHeight(this.antialiasThisFrame);
        this.platform.obtainScreenBuffer();
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, null, (short)0, 0, 0);
        }
        this.random = Math.random();
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.platform.releaseBuffers();
    }

    public boolean setPass2(boolean antialiasTranslucent) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.colixCurrent = 0;
        this.addAllPixels = true;
        if (this.pbufT == null || this.antialias2 != antialiasTranslucent) {
            this.platform.allocateTBuffers(antialiasTranslucent);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = antialiasTranslucent;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        return true;
    }

    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2) {
                this.mergeOpaqueAndTranslucentBuffers();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.setBackgroundColor(this.bgcolor);
        this.platform.notifyEndOfRendering();
        this.currentlyRendering = false;
    }

    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int i = this.anaglyphLength;
        while (--i >= 0) {
            this.anaglyphChannelBytes[i] = (byte)this.pbuf[i];
        }
    }

    public void applyCustomAnaglyph(int[] stereoColors) {
        int color1 = stereoColors[0];
        int color2 = stereoColors[1] & 0xFFFFFF;
        int i = this.anaglyphLength;
        while (--i >= 0) {
            int a = this.anaglyphChannelBytes[i] & 0xFF;
            a = (a | (a | a << 8) << 8) & color2;
            this.pbuf[i] = this.pbuf[i] & color1 | a;
        }
    }

    public void applyGreenAnaglyph() {
        int i = this.anaglyphLength;
        while (--i >= 0) {
            int green = (this.anaglyphChannelBytes[i] & 0xFF) << 8;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | green;
        }
    }

    public void applyBlueAnaglyph() {
        int i = this.anaglyphLength;
        while (--i >= 0) {
            int blue = this.anaglyphChannelBytes[i] & 0xFF;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | blue;
        }
    }

    public void applyCyanAnaglyph() {
        int i = this.anaglyphLength;
        while (--i >= 0) {
            int blue = this.anaglyphChannelBytes[i] & 0xFF;
            int cyan = blue << 8 | blue;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | cyan;
        }
    }

    public Image getScreenImage() {
        return this.platform.imagePixelBuffer;
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    public int getSlab() {
        return this.slab;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setBackgroundTransparent(boolean TF) {
        if (this.platform != null) {
            this.platform.setBackgroundTransparent(TF);
        }
    }

    public void setBackgroundArgb(int argb) {
        this.bgcolor = argb;
        this.backgroundImage = null;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setGreyscaleMode(boolean greyscaleMode) {
        this.inGreyscaleMode = greyscaleMode;
    }

    public void setSlabAndDepthValues(int slabValue, int depthValue, boolean zShade) {
        this.slab = slabValue < 0 ? 0 : slabValue;
        this.depth = depthValue < 0 ? 0 : depthValue;
        this.zShade = zShade;
    }

    public void setSlab(int slabValue) {
        this.slab = slabValue;
    }

    int getZShift(int z) {
        return this.zShade ? (z - this.slab) * 5 / (this.depth - this.slab) : 0;
    }

    private void downsampleFullSceneAntialiasing(boolean downsampleZBuffer) {
        int j;
        int i;
        int width4 = this.width;
        int offset1 = 0;
        int offset4 = 0;
        int bgcheck = this.bgcolor;
        if (downsampleZBuffer) {
            bgcheck += (bgcheck & 0xFF) == 255 ? -1 : 1;
        }
        for (i = 0; i < this.pbuf.length; ++i) {
            if (this.pbuf[i] != 0) continue;
            this.pbuf[i] = bgcheck;
        }
        bgcheck &= 0xFFFFFF;
        i = this.windowHeight;
        while (--i >= 0) {
            j = this.windowWidth;
            while (--j >= 0) {
                int argb = this.pbuf[offset4] >> 2 & 0x3F3F3F3F;
                argb += this.pbuf[offset4++ + width4] >> 2 & 0x3F3F3F3F;
                argb += this.pbuf[offset4] >> 2 & 0x3F3F3F3F;
                argb += this.pbuf[offset4++ + width4] >> 2 & 0x3F3F3F3F;
                argb += (argb & 0xC0C0C0C0) >> 6;
                this.pbuf[offset1] = argb & 0xFFFFFF;
                ++offset1;
            }
            offset4 += width4;
        }
        if (downsampleZBuffer) {
            offset4 = 0;
            offset1 = 0;
            i = this.windowHeight;
            while (--i >= 0) {
                j = this.windowWidth;
                while (--j >= 0) {
                    int z = Math.min(this.zbuf[offset4], this.zbuf[offset4 + width4]);
                    z = Math.min(z, this.zbuf[++offset4]);
                    if ((z = Math.min(z, this.zbuf[offset4 + width4])) != Integer.MAX_VALUE) {
                        z >>= 1;
                    }
                    this.zbuf[offset1] = this.pbuf[offset1] == bgcheck ? Integer.MAX_VALUE : z;
                    ++offset1;
                    ++offset4;
                }
                offset4 += width4;
            }
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    void mergeOpaqueAndTranslucentBuffers() {
        if (this.pbufT == null) {
            return;
        }
        for (int offset = 0; offset < this.bufferSize; ++offset) {
            Graphics3D.mergeBufferPixel(this.pbuf, this.pbufT[offset], offset, this.bgcolor);
        }
    }

    static void averageBufferPixel(int[] pIn, int[] pOut, int pt, int dp) {
        int argbA = pIn[pt - dp];
        int argbB = pIn[pt + dp];
        if (argbA == 0 || argbB == 0) {
            return;
        }
        pOut[pt] = ((argbA & 0xFF000000) >> 1) + ((argbB & 0xFF000000) >> 1) << 1 | (argbA & 0xFF00FF) + (argbB & 0xFF00FF) >> 1 & 0xFF00FF | (argbA & 0xFF00) + (argbB & 0xFF00) >> 1 & 0xFF00;
    }

    static void mergeBufferPixel(int[] pbuf, int argbB, int pt, int bgcolor) {
        if (argbB == 0) {
            return;
        }
        int argbA = pbuf[pt];
        if (argbA == argbB) {
            return;
        }
        if (argbA == 0) {
            argbA = bgcolor;
        }
        int rbA = argbA & 0xFF00FF;
        int gA = argbA & 0xFF00;
        int rbB = argbB & 0xFF00FF;
        int gB = argbB & 0xFF00;
        int logAlpha = argbB >> 24 & 7;
        switch (logAlpha) {
            case 1: {
                rbA = (rbB << 2) + (rbB << 1) + rbB + rbA >> 3 & 0xFF00FF;
                gA = (gB << 2) + (gB << 1) + gB + gA >> 3 & 0xFF00;
                break;
            }
            case 2: {
                rbA = (rbB << 1) + rbB + rbA >> 2 & 0xFF00FF;
                gA = (gB << 1) + gB + gA >> 2 & 0xFF00;
                break;
            }
            case 3: {
                rbA = (rbB << 2) + rbB + (rbA << 1) + rbA >> 3 & 0xFF00FF;
                gA = (gB << 2) + gB + (gA << 1) + gA >> 3 & 0xFF00;
                break;
            }
            case 4: {
                rbA = rbA + rbB >> 1 & 0xFF00FF;
                gA = gA + gB >> 1 & 0xFF00;
                break;
            }
            case 5: {
                rbA = (rbB << 1) + rbB + (rbA << 2) + rbA >> 3 & 0xFF00FF;
                gA = (gB << 1) + gB + (gA << 2) + gA >> 3 & 0xFF00;
                break;
            }
            case 6: {
                rbA = (rbA << 1) + rbA + rbB >> 2 & 0xFF00FF;
                gA = (gA << 1) + gA + gB >> 2 & 0xFF00;
                break;
            }
            case 7: {
                rbA = (rbA << 2) + (rbA << 1) + rbA + rbB >> 3 & 0xFF00FF;
                gA = (gA << 2) + (gA << 1) + gA + gB >> 3 & 0xFF00;
            }
        }
        pbuf[pt] = 0xFF000000 | rbA | gA;
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    private void setColixAndIntensity(short colix, int intensity) {
        if (colix == this.colixCurrent && this.currentIntensity == intensity) {
            return;
        }
        this.currentIntensity = -1;
        this.setColix(colix);
        this.setColorNoisy(intensity);
    }

    public boolean setColix(short colix) {
        if (colix == this.colixCurrent && this.currentIntensity == -1) {
            return true;
        }
        int mask = colix & 0x7800;
        if (mask == 16384) {
            return false;
        }
        this.isTranslucent = mask != 0;
        this.isScreened = this.isTranslucent && mask == 30720;
        if (!this.checkTranslucent(this.isTranslucent && !this.isScreened)) {
            return false;
        }
        boolean bl = this.addAllPixels = this.isPass2 || !this.isTranslucent;
        if (this.isPass2) {
            this.translucencyMask = mask << 13 | 0xFFFFFF;
        }
        this.colixCurrent = colix;
        this.shadesCurrent = this.getShades(colix);
        this.currentIntensity = -1;
        this.argbNoisyUp = this.argbNoisyDn = this.getColixArgb(colix);
        this.argbCurrent = this.argbNoisyDn;
        return true;
    }

    void setColorNoisy(int intensity) {
        this.currentIntensity = intensity;
        this.argbCurrent = this.shadesCurrent[intensity];
        this.argbNoisyUp = this.shadesCurrent[intensity < 63 ? intensity + 1 : 63];
        this.argbNoisyDn = this.shadesCurrent[intensity > 0 ? intensity - 1 : 0];
    }

    void setZMargin(int dz) {
        this.zMargin = dz;
    }

    void addPixel(int offset, int z, int p) {
        Graphics3D.addPixelT(offset, z, p, this.zbuf, this.pbuf, this.zbufT, this.pbufT, this.translucencyMask, this.isPass2, this.zMargin, this.bgcolor);
    }

    static final void addPixelT(int offset, int z, int p, int[] zbuf, int[] pbuf, int[] zbufT, int[] pbufT, int translucencyMask, boolean isPass2, int zMargin, int bgcolor) {
        if (!isPass2) {
            zbuf[offset] = z;
            pbuf[offset] = p;
            return;
        }
        int zT = zbufT[offset];
        if (z < zT) {
            int argb = pbufT[offset];
            if (argb != 0 && zT - z > zMargin) {
                Graphics3D.mergeBufferPixel(pbuf, argb, offset, bgcolor);
            }
            zbufT[offset] = z;
            pbufT[offset] = p & translucencyMask;
        } else if (z != zT && z - zT > zMargin) {
            Graphics3D.mergeBufferPixel(pbuf, p & translucencyMask, offset, bgcolor);
        }
    }

    public void drawCircleCentered(short colix, int diameter, int x, int y, int z, boolean doFill) {
        boolean isClipped;
        if (this.isClippedZ(z)) {
            return;
        }
        int r = (diameter + 1) / 2;
        boolean bl = isClipped = x < r || x + r >= this.width || y < r || y + r >= this.height;
        if (!isClipped) {
            this.circle3d.plotCircleCenteredUnclipped(x, y, z, diameter);
        } else if (!this.isClippedXY(diameter, x, y)) {
            this.circle3d.plotCircleCenteredClipped(x, y, z, diameter);
        }
        if (!doFill) {
            return;
        }
        if (!isClipped) {
            this.circle3d.plotFilledCircleCenteredUnclipped(x, y, z, diameter);
        } else if (!this.isClippedXY(diameter, x, y)) {
            this.circle3d.plotFilledCircleCenteredClipped(x, y, z, diameter);
        }
    }

    public void fillScreenedCircleCentered(short colixFill, int diameter, int x, int y, int z) {
        boolean isClipped;
        if (this.isClippedZ(z)) {
            return;
        }
        int r = (diameter + 1) / 2;
        boolean bl = isClipped = x < r || x + r >= this.width || y < r || y + r >= this.height;
        if (this.setColix(Graphics3D.getColixTranslucent(colixFill, false, 0.0f))) {
            if (!isClipped) {
                this.circle3d.plotCircleCenteredUnclipped(x, y, z, diameter);
            } else if (!this.isClippedXY(diameter, x, y)) {
                this.circle3d.plotCircleCenteredClipped(x, y, z, diameter);
            }
        }
        if (!this.setColix(Graphics3D.getColixTranslucent(colixFill, true, 0.5f))) {
            return;
        }
        if (!isClipped) {
            this.circle3d.plotFilledCircleCenteredUnclipped(x, y, z, diameter);
        } else if (!this.isClippedXY(diameter, x, y)) {
            this.circle3d.plotFilledCircleCenteredClipped(x, y, z, diameter);
        }
    }

    public void fillSphereCentered(int diameter, int x, int y, int z) {
        switch (diameter) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, x, y, z);
                return;
            }
            case 0: {
                return;
            }
        }
        if (diameter <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, diameter, x, y, z, null, null, null, -1, null);
        }
    }

    public void fillSphereCentered(int diameter, Point3i center) {
        this.fillSphereCentered(diameter, center.x, center.y, center.z);
    }

    public void fillSphereCentered(int diameter, Point3f center) {
        this.fillSphereCentered(diameter, (int)center.x, (int)center.y, (int)center.z);
    }

    public void renderEllipsoid(int x, int y, int z, int diameter, Matrix3f mToEllipsoidal, double[] coef, Matrix4f mDeriv, int selectedOctant, Point3i[] octantPoints) {
        switch (diameter) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, x, y, z);
                return;
            }
            case 0: {
                return;
            }
        }
        if (diameter <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, diameter, x, y, z, mToEllipsoidal, coef, mDeriv, selectedOctant, octantPoints);
        }
    }

    public void drawRect(int x, int y, int z, int zSlab, int rWidth, int rHeight) {
        if (zSlab != 0 && this.isClippedZ(zSlab)) {
            return;
        }
        int w = rWidth - 1;
        int h = rHeight - 1;
        int xRight = x + w;
        int yBottom = y + h;
        if (y >= 0 && y < this.height) {
            this.drawHLine(x, y, z, w);
        }
        if (yBottom >= 0 && yBottom < this.height) {
            this.drawHLine(x, yBottom, z, w);
        }
        if (x >= 0 && x < this.width) {
            this.drawVLine(x, y, z, h);
        }
        if (xRight >= 0 && xRight < this.width) {
            this.drawVLine(xRight, y, z, h);
        }
    }

    private void drawHLine(int x, int y, int z, int w) {
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (x + w >= this.width) {
            w = this.width - 1 - x;
        }
        int offset = x + this.width * y;
        if (this.addAllPixels) {
            for (int i = 0; i <= w; ++i) {
                if (z < this.zbuf[offset]) {
                    this.addPixel(offset, z, this.argbCurrent);
                }
                ++offset;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= w; ++i) {
            if ((flipflop = !flipflop) && z < this.zbuf[offset]) {
                this.addPixel(offset, z, this.argbCurrent);
            }
            ++offset;
        }
    }

    private void drawVLine(int x, int y, int z, int h) {
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (y + h >= this.height) {
            h = this.height - 1 - y;
        }
        int offset = x + this.width * y;
        if (this.addAllPixels) {
            for (int i = 0; i <= h; ++i) {
                if (z < this.zbuf[offset]) {
                    this.addPixel(offset, z, this.argbCurrent);
                }
                offset += this.width;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= h; ++i) {
            if ((flipflop = !flipflop) && z < this.zbuf[offset]) {
                this.addPixel(offset, z, this.argbCurrent);
            }
            offset += this.width;
        }
    }

    public void fillRect(int x, int y, int z, int zSlab, int widthFill, int heightFill) {
        if (this.isClippedZ(zSlab)) {
            return;
        }
        if (x < 0) {
            if ((widthFill += x) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + widthFill > this.width && (widthFill = this.width - x) <= 0) {
            return;
        }
        if (y < 0) {
            if ((heightFill += y) <= 0) {
                return;
            }
            y = 0;
        }
        if (y + heightFill > this.height) {
            heightFill = this.height - y;
        }
        while (--heightFill >= 0) {
            this.plotPixelsUnclipped(widthFill, x, y++, z);
        }
    }

    public void drawString(String str, Font3D font3d, int xBaseline, int yBaseline, int z, int zSlab) {
        if (str == null) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.drawStringNoSlab(str, font3d, xBaseline, yBaseline, z);
    }

    public void drawStringNoSlab(String str, Font3D font3d, int xBaseline, int yBaseline, int z) {
        if (str == null) {
            return;
        }
        if (font3d != null) {
            this.font3dCurrent = font3d;
        }
        this.plotText(xBaseline, yBaseline, z, this.argbCurrent, str, this.font3dCurrent, null);
    }

    public void plotText(int x, int y, int z, int argb, String text, Font3D font3d, JmolRendererInterface jmolRenderer) {
        Text3D.plot(x, y, z, argb, text, font3d, this, jmolRenderer, this.antialiasThisFrame);
    }

    public void drawImage(Image image, int x, int y, int z, int zSlab, short bgcolix, int width, int height) {
        if (image == null || width == 0 || height == 0) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.plotImage(x, y, z, image, null, bgcolix, width, height);
    }

    public void plotImage(int x, int y, int z, Image image, JmolRendererInterface jmolRenderer, short bgcolix, int width, int height) {
        this.setColix(bgcolix);
        if (bgcolix == 0) {
            this.argbCurrent = 0;
        }
        Text3D.plotImage(x, y, z, image, this, jmolRenderer, this.antialiasThisFrame, this.argbCurrent, width, height);
    }

    public void setFont(byte fid) {
        this.font3dCurrent = Font3D.getFont3D(fid);
    }

    public void setFont(Font3D font3d) {
        this.font3dCurrent = font3d;
    }

    public Font3D getFont3DCurrent() {
        return this.font3dCurrent;
    }

    public void drawPixel(int x, int y, int z) {
        this.plotPixelClipped(x, y, z);
    }

    public void drawPoints(int count, int[] coordinates) {
        this.plotPoints(count, coordinates);
    }

    public void drawDashedLine(int run, int rise, Point3i pointA, Point3i pointB) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, run, rise, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z, true);
    }

    public void drawDottedLine(Point3i pointA, Point3i pointB) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, 2, 1, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z, true);
    }

    public void drawLine(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, x1, y1, z1, x2, y2, z2, true);
    }

    public void drawLine(short colixA, short colixB, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (!this.setColix(colixA)) {
            colixA = 0;
        }
        boolean isScreenedA = !this.addAllPixels;
        int argbA = this.argbCurrent;
        if (!this.setColix(colixB)) {
            colixB = 0;
        }
        if (colixA == 0 && colixB == 0) {
            return;
        }
        this.line3d.plotLine(argbA, isScreenedA, this.argbCurrent, !this.addAllPixels, x1, y1, z1, x2, y2, z2, true);
    }

    public void drawLine(Point3i pointA, Point3i pointB) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z, true);
    }

    public void fillCylinder(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        boolean isScreenedA;
        if (!this.setColix(colixA)) {
            colixA = 0;
        }
        boolean bl = isScreenedA = !this.addAllPixels;
        if (!this.setColix(colixB)) {
            colixB = 0;
        }
        if (colixA == 0 && colixB == 0) {
            return;
        }
        this.cylinder3d.render(colixA, colixB, isScreenedA, !this.addAllPixels, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinder(byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinder(byte endcaps, int diameter, Point3i screenA, Point3i screenB) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
    }

    public void fillCylinderBits(byte endcaps, int diameter, Point3f screenA, Point3f screenB) {
        this.cylinder3d.renderBits(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
    }

    public void fillCone(byte endcap, int diameter, Point3i screenBase, Point3i screenTip) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, endcap, diameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z, false);
    }

    public void fillCone(byte endcap, int diameter, Point3f screenBase, Point3f screenTip) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, endcap, diameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z, true);
    }

    public void drawHermite(int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(false, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    public void drawHermite(boolean fill, boolean border, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3, Point3i s4, Point3i s5, Point3i s6, Point3i s7, int aspectRatio) {
        this.hermite3d.render2(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio);
    }

    public void fillHermite(int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(true, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    public static void getHermiteList(int tension, Tuple3f s0, Tuple3f s1, Tuple3f s2, Tuple3f s3, Tuple3f s4, Tuple3f[] list, int index0, int n) {
        Hermite3D.getHermiteList(tension, s0, s1, s2, s3, s4, list, index0, n);
    }

    public void drawTriangle(Point3i screenA, short colixA, Point3i screenB, short colixB, Point3i screenC, short colixC, int check) {
        int xA = screenA.x;
        int yA = screenA.y;
        int zA = screenA.z;
        int xB = screenB.x;
        int yB = screenB.y;
        int zB = screenB.z;
        int xC = screenC.x;
        int yC = screenC.y;
        int zC = screenC.z;
        if ((check & 1) == 1) {
            this.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        }
        if ((check & 2) == 2) {
            this.drawLine(colixB, colixC, xB, yB, zB, xC, yC, zC);
        }
        if ((check & 4) == 4) {
            this.drawLine(colixA, colixC, xA, yA, zA, xC, yC, zC);
        }
    }

    public void drawTriangle(Point3i screenA, Point3i screenB, Point3i screenC, int check) {
        int xA = screenA.x;
        int yA = screenA.y;
        int zA = screenA.z;
        int xB = screenB.x;
        int yB = screenB.y;
        int zB = screenB.z;
        int xC = screenC.x;
        int yC = screenC.y;
        int zC = screenC.z;
        if ((check & 1) == 1) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xA, yA, zA, xB, yB, zB, true);
        }
        if ((check & 2) == 2) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xB, yB, zB, xC, yC, zC, true);
        }
        if ((check & 4) == 4) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xA, yA, zA, xC, yC, zC, true);
        }
    }

    public void drawCylinderTriangle(int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC, int diameter) {
        this.fillCylinder((byte)3, diameter, xA, yA, zA, xB, yB, zB);
        this.fillCylinder((byte)3, diameter, xA, yA, zA, xC, yC, zC);
        this.fillCylinder((byte)3, diameter, xB, yB, zB, xC, yC, zC);
    }

    public void drawfillTriangle(int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xA, yA, zA, xB, yB, zB, true);
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xA, yA, zA, xC, yC, zC, true);
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, xB, yB, zB, xC, yC, zC, true);
        this.triangle3d.fillTriangle(xA, yA, zA, xB, yB, zB, xC, yC, zC, false);
    }

    public void fillTriangle(Point3i screenA, int intensityA, Point3i screenB, int intensityB, Point3i screenC, int intensityC) {
        this.triangle3d.setGouraud(intensityA, intensityB, intensityC);
        this.triangle3d.fillTriangle(screenA, screenB, screenC, true);
    }

    public void fillTriangle(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC) {
        boolean useGouraud;
        if (normixA == normixB && normixA == normixC && colixA == colixB && colixA == colixC) {
            this.setColixAndIntensity(colixA, this.normix3d.getIntensity(normixA));
            useGouraud = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(colixA)[this.normix3d.getIntensity(normixA)], this.getShades(colixB)[this.normix3d.getIntensity(normixB)], this.getShades(colixC)[this.normix3d.getIntensity(normixC)]);
            int translucentCount = 0;
            if (Graphics3D.isColixTranslucent(colixA)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixB)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixC)) {
                ++translucentCount;
            }
            this.isTranslucent = translucentCount >= 2;
            useGouraud = true;
        }
        this.triangle3d.fillTriangle(screenA, screenB, screenC, useGouraud);
    }

    public void fillTriangle(short normix, int xScreenA, int yScreenA, int zScreenA, int xScreenB, int yScreenB, int zScreenB, int xScreenC, int yScreenC, int zScreenC) {
        this.setColorNoisy(this.normix3d.getIntensity(normix));
        this.triangle3d.fillTriangle(xScreenA, yScreenA, zScreenA, xScreenB, yScreenB, zScreenB, xScreenC, yScreenC, zScreenC, false);
    }

    public void fillTriangle(Point3f screenA, Point3f screenB, Point3f screenC) {
        this.setColorNoisy(this.calcIntensityScreen(screenA, screenB, screenC));
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
    }

    public void fillTriangle(Point3i screenA, Point3i screenB, Point3i screenC) {
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
    }

    public void fillTriangle(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC, float factor) {
        boolean useGouraud;
        if (normixA == normixB && normixA == normixC && colixA == colixB && colixA == colixC) {
            this.setColixAndIntensity(colixA, this.normix3d.getIntensity(normixA));
            useGouraud = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(colixA)[this.normix3d.getIntensity(normixA)], this.getShades(colixB)[this.normix3d.getIntensity(normixB)], this.getShades(colixC)[this.normix3d.getIntensity(normixC)]);
            int translucentCount = 0;
            if (Graphics3D.isColixTranslucent(colixA)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixB)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixC)) {
                ++translucentCount;
            }
            this.isTranslucent = translucentCount >= 2;
            useGouraud = true;
        }
        this.triangle3d.fillTriangle(screenA, screenB, screenC, factor, useGouraud);
    }

    public void drawQuadrilateral(short colix, Point3i screenA, Point3i screenB, Point3i screenC, Point3i screenD) {
        this.setColix(colix);
        this.drawLine(screenA, screenB);
        this.drawLine(screenB, screenC);
        this.drawLine(screenC, screenD);
        this.drawLine(screenD, screenA);
    }

    public void fillQuadrilateral(Point3f screenA, Point3f screenB, Point3f screenC, Point3f screenD) {
        this.setColorNoisy(this.calcIntensityScreen(screenA, screenB, screenC));
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
        this.triangle3d.fillTriangle(screenA, screenC, screenD, false);
    }

    public void fillQuadrilateral(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC, Point3i screenD, short colixD, short normixD) {
        this.fillTriangle(screenA, colixA, normixA, screenB, colixB, normixB, screenC, colixC, normixC);
        this.fillTriangle(screenA, colixA, normixA, screenC, colixC, normixC, screenD, colixD, normixD);
    }

    public void renderIsosurface(Point3f[] vertices, short colix, short[] colixes, Vector3f[] normals, int[][] indices, BitSet bsFaces, int nVertices, int faceVertexMax, short[] polygonColixes, int nPolygons) {
    }

    public boolean isClipped(int x, int y, int z) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth;
    }

    private boolean isClipped(int x, int y) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height;
    }

    public boolean isInDisplayRange(int x, int y) {
        return x >= this.displayMinX && x < this.displayMaxX && y >= this.displayMinY && y < this.displayMaxY;
    }

    public boolean isClippedXY(int diameter, int x, int y) {
        int r = diameter + 1 >> 1;
        return x < -r || x >= this.width + r || y < -r || y >= this.height + r;
    }

    public boolean isClippedZ(int z) {
        return z != Integer.MIN_VALUE && (z < this.slab || z > this.depth);
    }

    void plotPixelClipped(int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, this.argbCurrent);
        }
    }

    public void plotPixelClipped(Point3i screen) {
        this.plotPixelClipped(screen.x, screen.y, screen.z);
    }

    void plotPixelClipped(int argb, int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, argb);
        }
    }

    public void plotPixelClippedNoSlab(int argb, int x, int y, int z) {
        if (this.isClipped(x, y)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, argb);
        }
    }

    void plotPixelClipped(int argb, boolean isScreened, int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        if (isScreened && ((x ^ y) & 1) != 0) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, argb);
        }
    }

    void plotPixelUnclipped(int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, this.argbCurrent);
        }
    }

    void plotPixelUnclipped(int argb, int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.addPixel(offset, z, argb);
        }
    }

    void plotPixelsClipped(int count, int x, int y, int z) {
        if (y < 0 || y >= this.height || x >= this.width) {
            return;
        }
        if (x < 0) {
            count += x;
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        if (count <= 0) {
            return;
        }
        int offsetPbuf = y * this.width + x;
        int offsetMax = offsetPbuf + count;
        int step = 1;
        if (!this.addAllPixels) {
            step = 2;
            if (((x ^ y) & 1) != 0) {
                ++offsetPbuf;
            }
        }
        while (offsetPbuf < offsetMax) {
            if (z < this.zbuf[offsetPbuf]) {
                this.addPixel(offsetPbuf, z, this.argbCurrent);
            }
            offsetPbuf += step;
        }
    }

    void plotPixelsClipped(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        if (count <= 0 || y < 0 || y >= this.height || x >= this.width || zAtLeft < this.slab && zPastRight < this.slab || zAtLeft > this.depth && zPastRight > this.depth) {
            return;
        }
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = ((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count;
        if (x < 0) {
            x = -x;
            zScaled += zIncrementScaled * x;
            if ((count -= x) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        int offsetPbuf = y * this.width + x;
        if (rgb16Left == null) {
            while (--count >= 0) {
                int z;
                if ((this.addAllPixels || (flipflop = !flipflop)) && (z = zScaled >> 10) >= this.slab && z <= this.depth && z < this.zbuf[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(offsetPbuf, z, bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
            }
        } else {
            int rScaled = rgb16Left.rScaled << 8;
            int rIncrement = (rgb16Right.rScaled - rgb16Left.rScaled << 8) / count;
            int gScaled = rgb16Left.gScaled;
            int gIncrement = (rgb16Right.gScaled - gScaled) / count;
            int bScaled = rgb16Left.bScaled;
            int bIncrement = (rgb16Right.bScaled - bScaled) / count;
            while (--count >= 0) {
                int z;
                if ((this.addAllPixels || (flipflop = !flipflop)) && (z = zScaled >> 10) >= this.slab && z <= this.depth && z < this.zbuf[offsetPbuf]) {
                    this.addPixel(offsetPbuf, z, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclipped(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        if (count <= 0) {
            return;
        }
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        boolean flipflop = ((x ^ y) & 1) != 0;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = ((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count;
        int offsetPbuf = y * this.width + x;
        if (rgb16Left == null) {
            while (--count >= 0) {
                int z;
                if ((this.addAllPixels || (flipflop = !flipflop)) && (z = zScaled >> 10) < this.zbuf[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(offsetPbuf, z, bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
            }
        } else {
            int rScaled = rgb16Left.rScaled << 8;
            int rIncrement = (rgb16Right.rScaled - rgb16Left.rScaled << 8) / count;
            int gScaled = rgb16Left.gScaled;
            int gIncrement = (rgb16Right.gScaled - gScaled) / count;
            int bScaled = rgb16Left.bScaled;
            int bIncrement = (rgb16Right.bScaled - bScaled) / count;
            while (--count >= 0) {
                int z;
                if ((this.addAllPixels || (flipflop = !flipflop)) && (z = zScaled >> 10) < this.zbuf[offsetPbuf]) {
                    this.addPixel(offsetPbuf, z, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclipped(int count, int x, int y, int z) {
        int offsetPbuf = y * this.width + x;
        if (this.addAllPixels) {
            while (--count >= 0) {
                if (z < this.zbuf[offsetPbuf]) {
                    this.addPixel(offsetPbuf, z, this.argbCurrent);
                }
                ++offsetPbuf;
            }
        } else {
            int offsetMax = offsetPbuf + count;
            if (((x ^ y) & 1) != 0 && ++offsetPbuf == offsetMax) {
                return;
            }
            do {
                if (z >= this.zbuf[offsetPbuf]) continue;
                this.addPixel(offsetPbuf, z, this.argbCurrent);
            } while ((offsetPbuf += 2) < offsetMax);
        }
    }

    private void plotPoints(int count, int[] coordinates) {
        int i = count * 3;
        while (i > 0) {
            int offset;
            int y;
            int x;
            int z = coordinates[--i];
            --i;
            if (this.isClipped(x = coordinates[--i], y = coordinates[i], z)) continue;
            if (z < this.zbuf[offset = y * this.width + x++]) {
                this.addPixel(offset, z, this.argbCurrent);
            }
            if (!this.antialiasThisFrame) continue;
            offset = y * this.width + x;
            if (!this.isClipped(x, y, z) && z < this.zbuf[offset]) {
                this.addPixel(offset, z, this.argbCurrent);
            }
            offset = ++y * this.width + x;
            if (!this.isClipped(x, y, z) && z < this.zbuf[offset]) {
                this.addPixel(offset, z, this.argbCurrent);
            }
            offset = y * this.width + --x;
            if (this.isClipped(x, y, z) || z >= this.zbuf[offset]) continue;
            this.addPixel(offset, z, this.argbCurrent);
        }
    }

    public static int calcGreyscaleRgbFromRgb(int rgb) {
        int grey = (2989 * (rgb >> 16 & 0xFF) + 5870 * (rgb >> 8 & 0xFF) + 1140 * (rgb & 0xFF) + 5000) / 10000;
        int greyRgb = grey << 16 | grey << 8 | grey | 0xFF000000;
        return greyRgb;
    }

    public static short getColix(int argb) {
        return Colix3D.getColix(argb);
    }

    public static final Point3f colorPointFromInt(int color, Point3f pt) {
        pt.z = color & 0xFF;
        pt.y = color >> 8 & 0xFF;
        pt.x = color >> 16 & 0xFF;
        return pt;
    }

    public static final Point3f colorPointFromInt2(int color) {
        return new Point3f(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public static final Point3f colorPointFromString(String colorName, Point3f pt) {
        return Graphics3D.colorPointFromInt(Graphics3D.getArgbFromString(colorName), pt);
    }

    public static short getColix(String colorName) {
        int argb = Graphics3D.getArgbFromString(colorName);
        if (argb != 0) {
            return Colix3D.getColix(argb);
        }
        if ("none".equalsIgnoreCase(colorName)) {
            return 0;
        }
        if ("opaque".equalsIgnoreCase(colorName)) {
            return 1;
        }
        return 2;
    }

    private static final short applyColorTranslucencyLevel(short colix, float translucentLevel) {
        if (translucentLevel == 0.0f) {
            return (short)(colix & 0xFFFF87FF);
        }
        if (translucentLevel < 0.0f) {
            return (short)(colix | 0x7800);
        }
        if (translucentLevel >= 255.0f || (double)translucentLevel == 1.0) {
            return (short)(colix | 0x4000);
        }
        int iLevel = (int)(translucentLevel < 1.0f ? translucentLevel * 256.0f : (translucentLevel <= 9.0f ? (float)((int)(translucentLevel - 1.0f) << 5) : (translucentLevel < 15.0f ? 256.0f : translucentLevel)));
        iLevel = (iLevel >> 5) % 16;
        return (short)(colix & 0xFFFF87FF | iLevel << 11);
    }

    public static final int getColixTranslucencyLevel(short colix) {
        int logAlpha = colix >> 11 & 0xF;
        switch (logAlpha) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return logAlpha << 5;
            }
            case 15: {
                return -1;
            }
        }
        return 255;
    }

    public static short getColix(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Byte) {
            return (Byte)obj == 0 ? (short)0 : 2;
        }
        if (obj instanceof Integer) {
            return Colix3D.getColix((Integer)obj);
        }
        if (obj instanceof String) {
            return Graphics3D.getColix((String)obj);
        }
        if (Logger.debugging) {
            Logger.debug("?? getColix(" + obj + ")");
        }
        return 22;
    }

    public static final short getColixTranslucent(short colix, boolean isTranslucent, float translucentLevel) {
        if (colix == 0) {
            colix = 1;
        }
        colix = (short)(colix & 0xFFFF87FF);
        if (!isTranslucent) {
            return colix;
        }
        return Graphics3D.applyColorTranslucencyLevel(colix, translucentLevel);
    }

    public int getColixArgb(short colix) {
        if (colix < 0) {
            colix = this.changeableColixMap[colix & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getArgb(colix);
        }
        return Colix3D.getArgbGreyscale(colix);
    }

    int[] getShades(short colix) {
        if (colix < 0) {
            colix = this.changeableColixMap[colix & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getShades(colix);
        }
        return Colix3D.getShadesGreyscale(colix);
    }

    public static final short getChangeableColixIndex(short colix) {
        if (colix >= 0) {
            return -1;
        }
        return (short)(colix & 0x7FF);
    }

    public static final boolean isColixTranslucent(short colix) {
        return (colix & 0x7800) != 0;
    }

    public static final short getColixInherited(short myColix, short parentColix) {
        switch (myColix) {
            case 0: {
                return parentColix;
            }
            case 1: {
                return (short)(parentColix & 0xFFFF87FF);
            }
        }
        return (myColix & 0xFFFF87FF) == 1 ? (short)(parentColix & 0xFFFF87FF | myColix & 0x7800) : myColix;
    }

    public static final boolean isColixColorInherited(short colix) {
        switch (colix) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return (colix & 0xFFFF87FF) == 1;
    }

    public String getHexColorFromIndex(short colix) {
        int argb = this.getColixArgb(colix);
        return Graphics3D.getHexColorFromRGB(argb);
    }

    public static String getHexColorFromRGB(int argb) {
        if (argb == 0) {
            return null;
        }
        String r = "00" + Integer.toHexString(argb >> 16 & 0xFF);
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(argb >> 8 & 0xFF);
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(argb & 0xFF);
        b = b.substring(b.length() - 2);
        return r + g + b;
    }

    public short getChangeableColix(short id, int argb) {
        if (id >= this.changeableColixMap.length) {
            short[] t = new short[id + 16];
            System.arraycopy(this.changeableColixMap, 0, t, 0, this.changeableColixMap.length);
            this.changeableColixMap = t;
        }
        if (this.changeableColixMap[id] == 0) {
            this.changeableColixMap[id] = Colix3D.getColix(argb);
        }
        return (short)(id | Short.MIN_VALUE);
    }

    public void changeColixArgb(short id, int argb) {
        if (id < this.changeableColixMap.length && this.changeableColixMap[id] != 0) {
            this.changeableColixMap[id] = Colix3D.getColix(argb);
        }
    }

    public static void flushShadesAndSphereCaches() {
        Colix3D.flushShades();
        Sphere3D.flushSphereCache();
    }

    public static synchronized void setSpecular(boolean specular) {
        Graphics3D.lighting[Shade3D.SPECULAR_ON] = specular ? 1.0f : 0.0f;
    }

    public static boolean getSpecular() {
        return lighting[Shade3D.SPECULAR_ON] != 0.0f;
    }

    public static synchronized void setSpecularPower(int specularPower) {
        Graphics3D.lighting[Shade3D.SPECULAR_POWER] = specularPower;
        Graphics3D.lighting[Shade3D.INTENSE_FRACTION] = (float)specularPower / 100.0f;
    }

    public static int getSpecularPower() {
        return (int)lighting[Shade3D.SPECULAR_POWER];
    }

    public static synchronized void setSpecularPercent(int specularPercent) {
        Graphics3D.lighting[Shade3D.SPECULAR_PERCENT] = specularPercent;
        Graphics3D.lighting[Shade3D.INTENSITY_SPECULAR] = (float)specularPercent / 100.0f;
    }

    public static int getSpecularPercent() {
        return (int)lighting[Shade3D.SPECULAR_PERCENT];
    }

    public static synchronized void setSpecularExponent(int specularExponent) {
        Graphics3D.lighting[Shade3D.SPECULAR_EXPONENT] = specularExponent;
    }

    public static int getSpecularExponent() {
        return (int)lighting[Shade3D.SPECULAR_EXPONENT];
    }

    public static synchronized void setDiffusePercent(int diffusePercent) {
        Graphics3D.lighting[Shade3D.DIFFUSE_PERCENT] = diffusePercent;
        Graphics3D.lighting[Shade3D.INTENSITY_DIFFUSE] = (float)diffusePercent / 100.0f;
    }

    public static int getDiffusePercent() {
        return (int)lighting[Shade3D.DIFFUSE_PERCENT];
    }

    public static synchronized void setAmbientPercent(int ambientPercent) {
        Graphics3D.lighting[Shade3D.AMBIENT_PERCENT] = ambientPercent;
        Graphics3D.lighting[Shade3D.AMBIENT_FRACTION] = (float)ambientPercent / 100.0f;
    }

    public static int getAmbientPercent() {
        return (int)lighting[Shade3D.AMBIENT_PERCENT];
    }

    public static Point3f getLightSource() {
        return new Point3f(Shade3D.xLight, Shade3D.yLight, Shade3D.zLight);
    }

    public int calcSurfaceShade(Point3i screenA, Point3i screenB, Point3i screenC) {
        byte intensity;
        this.vectorAB.set(screenB.x - screenA.x, screenB.y - screenA.y, screenB.z - screenA.z);
        if (screenC == null) {
            intensity = Shade3D.calcIntensity(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z);
        } else {
            this.vectorAC.set(screenC.x - screenA.x, screenC.y - screenA.y, screenC.z - screenA.z);
            this.vectorAB.cross(this.vectorAB, this.vectorAC);
            byte by = intensity = this.vectorAB.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z) : Shade3D.calcIntensity(this.vectorAB.x, this.vectorAB.y, -this.vectorAB.z);
        }
        if (intensity > intensitySpecularSurfaceLimit) {
            intensity = intensitySpecularSurfaceLimit;
        }
        this.setColorNoisy(intensity);
        return this.argbCurrent;
    }

    private int calcIntensityScreen(Point3f screenA, Point3f screenB, Point3f screenC) {
        this.vectorAB.sub(screenB, screenA);
        this.vectorAC.sub(screenC, screenA);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        return this.vectorNormal.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Shade3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
    }

    public Font3D getFont3D(float fontSize) {
        return Font3D.getFont3D(0, 0, fontSize, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, float fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), 0, fontSize, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, String fontStyle, float fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), Font3D.getFontStyleID(fontStyle), fontSize, fontSize, this.platform);
    }

    public Font3D getFont3DScaled(Font3D font, float scale) {
        float newScale = font.fontSizeNominal * scale;
        return newScale == font.fontSize ? font : Font3D.getFont3D(font.idFontFace, font.idFontStyle, newScale, font.fontSizeNominal, this.platform);
    }

    public byte getFontFid(float fontSize) {
        return this.getFont3D((float)fontSize).fid;
    }

    public byte getFontFid(String fontFace, float fontSize) {
        return this.getFont3D((String)fontFace, (float)fontSize).fid;
    }

    public static int getColorArgb(int i) {
        return colorArgbs[i % colorArgbs.length];
    }

    public static int getArgbFromString(String strColor) {
        int len = 0;
        if (strColor == null || (len = strColor.length()) == 0) {
            return 0;
        }
        if (strColor.charAt(0) == '[' && strColor.charAt(len - 1) == ']') {
            String check;
            if (strColor.indexOf(",") >= 0) {
                String[] tokens = TextFormat.split(strColor.substring(1, strColor.length() - 1), ",");
                if (tokens.length != 3) {
                    return 0;
                }
                try {
                    int red = Integer.parseInt(tokens[0]);
                    int grn = Integer.parseInt(tokens[1]);
                    int blu = Integer.parseInt(tokens[2]);
                    return 0xFF000000 | (red & 0xFF) << 16 | (grn & 0xFF) << 8 | blu & 0xFF;
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            switch (len) {
                case 9: {
                    check = "x";
                    break;
                }
                case 10: {
                    check = "0x";
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (strColor.indexOf(check) != 1) {
                return 0;
            }
            strColor = "#" + strColor.substring(len - 7, len - 1);
            len = 7;
        }
        if (len == 7 && strColor.charAt(0) == '#') {
            try {
                int red = Integer.parseInt(strColor.substring(1, 3), 16);
                int grn = Integer.parseInt(strColor.substring(3, 5), 16);
                int blu = Integer.parseInt(strColor.substring(5, 7), 16);
                return 0xFF000000 | (red & 0xFF) << 16 | (grn & 0xFF) << 8 | blu & 0xFF;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        Integer boxedArgb = (Integer)mapJavaScriptColors.get(strColor.toLowerCase());
        return boxedArgb == null ? 0 : boxedArgb;
    }

    public static float distanceToPlane(Point4f plane, Point3f pt) {
        return plane == null ? Float.NaN : (plane.x * pt.x + plane.y * pt.y + plane.z * pt.z + plane.w) / (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
    }

    public static float distanceToPlane(Point4f plane, float d, Point3f pt) {
        return plane == null ? Float.NaN : (plane.x * pt.x + plane.y * pt.y + plane.z * pt.z + plane.w) / d;
    }

    public static float distanceToPlane(Vector3f norm, float w, Point3f pt) {
        return norm == null ? Float.NaN : (norm.x * pt.x + norm.y * pt.y + norm.z * pt.z + w) / (float)Math.sqrt(norm.x * norm.x + norm.y * norm.y + norm.z * norm.z);
    }

    public static void calcNormalizedNormal(Point3f pointA, Point3f pointB, Point3f pointC, Vector3f vNormNorm, Vector3f vAB, Vector3f vAC) {
        vAB.sub(pointB, pointA);
        vAC.sub(pointC, pointA);
        vNormNorm.cross(vAB, vAC);
        vNormNorm.normalize();
    }

    public static float getDirectedNormalThroughPoints(Point3f pointA, Point3f pointB, Point3f pointC, Point3f ptRef, Vector3f vNorm, Vector3f vAB, Vector3f vAC) {
        float nd = Graphics3D.getNormalThroughPoints(pointA, pointB, pointC, vNorm, vAB, vAC);
        if (ptRef != null) {
            Point3f pt0 = new Point3f(pointA);
            pt0.add(vNorm);
            float d = pt0.distance(ptRef);
            pt0.set(pointA);
            pt0.sub(vNorm);
            if (d > pt0.distance(ptRef)) {
                vNorm.scale(-1.0f);
                nd = -nd;
            }
        }
        return nd;
    }

    public static float getNormalThroughPoints(Point3f pointA, Point3f pointB, Point3f pointC, Vector3f vNorm, Vector3f vAB, Vector3f vAC) {
        Graphics3D.calcNormalizedNormal(pointA, pointB, pointC, vNorm, vAB, vAC);
        vAB.set(pointA);
        float d = -vAB.dot(vNorm);
        return d;
    }

    public static void getNormalFromCenter(Point3f ptCenter, Point3f ptA, Point3f ptB, Point3f ptC, boolean isOutward, Vector3f normal) {
        boolean doReverse;
        Point3f ptT = new Point3f();
        Point3f ptT2 = new Point3f();
        Vector3f vAB = new Vector3f();
        Vector3f vAC = new Vector3f();
        Graphics3D.calcNormalizedNormal(ptA, ptB, ptC, normal, vAB, vAC);
        ptT.set(ptA);
        ptT.add(ptB);
        ptT.add(ptC);
        ptT.scale(0.33333334f);
        ptT2.set(normal);
        ptT2.scale(0.1f);
        ptT2.add(ptT);
        boolean bl = doReverse = isOutward && ptCenter.distance(ptT2) < ptCenter.distance(ptT) || !isOutward && ptCenter.distance(ptT) < ptCenter.distance(ptT2);
        if (doReverse) {
            normal.scale(-1.0f);
        }
    }

    public void calcXYNormalToLine(Point3f pointA, Point3f pointB, Vector3f vNormNorm) {
        Vector3f axis = new Vector3f(pointA);
        axis.sub(pointB);
        float phi = axis.angle(new Vector3f(0.0f, 1.0f, 0.0f));
        if (phi == 0.0f) {
            vNormNorm.set(1.0f, 0.0f, 0.0f);
        } else {
            vNormNorm.cross(axis, new Vector3f(0.0f, 1.0f, 0.0f));
            vNormNorm.normalize();
        }
    }

    public static void projectOntoAxis(Point3f point, Point3f axisA, Vector3f axisUnitVector, Vector3f vectorProjection) {
        vectorProjection.sub(point, axisA);
        float projectedLength = vectorProjection.dot(axisUnitVector);
        point.set(axisUnitVector);
        point.scaleAdd(projectedLength, axisA);
        vectorProjection.sub(point, axisA);
    }

    public static void calcBestAxisThroughPoints(Point3f[] points, Point3f axisA, Vector3f axisUnitVector, Vector3f vectorProjection, int nTriesMax) {
        int nPoints = points.length;
        axisA.set(points[0]);
        axisUnitVector.sub(points[nPoints - 1], axisA);
        axisUnitVector.normalize();
        Graphics3D.calcAveragePointN(points, nPoints, axisA);
        int nTries = 0;
        while (nTries++ < nTriesMax && (double)Graphics3D.findAxis(points, nPoints, axisA, axisUnitVector, vectorProjection) > 0.001) {
        }
        Point3f tempA = new Point3f(points[0]);
        Graphics3D.projectOntoAxis(tempA, axisA, axisUnitVector, vectorProjection);
        axisA.set(tempA);
    }

    static float findAxis(Point3f[] points, int nPoints, Point3f axisA, Vector3f axisUnitVector, Vector3f vectorProjection) {
        Vector3f sumXiYi = new Vector3f();
        Vector3f vTemp = new Vector3f();
        Point3f pt = new Point3f();
        Point3f ptProj = new Point3f();
        Vector3f a = new Vector3f(axisUnitVector);
        float sum_Xi2 = 0.0f;
        float sum_Yi2 = 0.0f;
        int i = nPoints;
        while (--i >= 0) {
            pt.set(points[i]);
            ptProj.set(pt);
            Graphics3D.projectOntoAxis(ptProj, axisA, axisUnitVector, vectorProjection);
            vTemp.sub(pt, ptProj);
            sum_Yi2 += vTemp.lengthSquared();
            vTemp.cross(vectorProjection, vTemp);
            sumXiYi.add(vTemp);
            sum_Xi2 += vectorProjection.lengthSquared();
        }
        Vector3f m = new Vector3f(sumXiYi);
        m.scale(1.0f / sum_Xi2);
        vTemp.cross(m, axisUnitVector);
        axisUnitVector.add(vTemp);
        axisUnitVector.normalize();
        vTemp.set(axisUnitVector);
        vTemp.sub(a);
        return vTemp.length();
    }

    public static void calcAveragePoint(Point3f pointA, Point3f pointB, Point3f pointC) {
        pointC.set((pointA.x + pointB.x) / 2.0f, (pointA.y + pointB.y) / 2.0f, (pointA.z + pointB.z) / 2.0f);
    }

    public static void calcAveragePointN(Point3f[] points, int nPoints, Point3f averagePoint) {
        averagePoint.set(points[0]);
        for (int i = 1; i < nPoints; ++i) {
            averagePoint.add(points[i]);
        }
        averagePoint.scale(1.0f / (float)nPoints);
    }

    public short getNormix(Vector3f vector) {
        return this.normix3d.getNormix(vector.x, vector.y, vector.z, 3);
    }

    public short getInverseNormix(short normix) {
        if (this.normix3d.inverseNormixes == null) {
            this.normix3d.calculateInverseNormixes();
        }
        return this.normix3d.inverseNormixes[normix];
    }

    public short get2SidedNormix(Vector3f vector) {
        return ~this.normix3d.getNormix(vector.x, vector.y, vector.z, 3);
    }

    public boolean isDirectedTowardsCamera(short normix) {
        return this.normix3d.isDirectedTowardsCamera(normix);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.normix3d.getTransformedVectors();
    }

    public Vector3f getNormixVector(short normix) {
        return this.normix3d.getVector(normix);
    }

    public void renderBackground(JmolRendererInterface jmolRenderer) {
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, jmolRenderer, (short)0, 0, 0);
        }
    }

    public void endShapeBuffer() {
    }

    public void startShapeBuffer() {
    }

    public boolean canDoTriangles() {
        return true;
    }

    static {
        int i = colorNames.length;
        while (--i >= 0) {
            mapJavaScriptColors.put(colorNames[i], new Integer(colorArgbs[i]));
        }
    }
}

