/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import org.jmol.g3d.Awt3D;
import org.jmol.g3d.Swing3D;

abstract class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Image imagePixelBuffer;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int widthOffscreen;
    int heightOffscreen;
    Image imageOffscreen;
    Graphics gOffscreen;
    static final boolean forcePlatformAWT = false;
    static final boolean desireClearingThread = false;
    boolean useClearingThread = true;
    ClearingThread clearingThread;
    Graphics graphicsOffscreen;

    Platform3D() {
    }

    static Platform3D createInstance(Component awtComponent) {
        if (awtComponent == null) {
            return null;
        }
        boolean jvm12orGreater = System.getProperty("java.version").compareTo("1.2") >= 0;
        boolean useSwing = jvm12orGreater;
        Platform3D platform = useSwing ? Platform3D.allocateSwing3D() : new Awt3D(awtComponent);
        platform.initialize(false);
        platform.graphicsOffscreen = platform.allocateOffscreenImage(1, 1).getGraphics();
        return platform;
    }

    private static Platform3D allocateSwing3D() {
        return new Swing3D();
    }

    final void initialize(boolean useClearingThread) {
        this.useClearingThread = useClearingThread;
        if (useClearingThread) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    abstract Image allocateImage();

    void allocateTBuffers(boolean antialiasTranslucent) {
        this.bufferSizeT = antialiasTranslucent ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int width, int height, boolean antialias) {
        this.windowWidth = width;
        this.windowHeight = height;
        this.windowSize = width * height;
        if (antialias) {
            this.bufferWidth = width * 2;
            this.bufferHeight = height * 2;
        } else {
            this.bufferWidth = width;
            this.bufferHeight = height;
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.imagePixelBuffer = this.allocateImage();
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.imagePixelBuffer != null) {
            this.imagePixelBuffer.flush();
            this.imagePixelBuffer = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    boolean hasContent() {
        int i = this.bufferSize;
        while (--i >= 0) {
            if (this.zBuffer[i] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer() {
        int i = this.bufferSize;
        while (--i >= 0) {
            this.zBuffer[i] = Integer.MAX_VALUE;
            this.pBuffer[i] = 0;
        }
    }

    void setBackgroundColor(int bgColor) {
        if (this.pBuffer == null) {
            return;
        }
        int i = this.bufferSize;
        while (--i >= 0) {
            if (this.pBuffer[i] != 0) continue;
            this.pBuffer[i] = bgColor;
        }
    }

    void clearTBuffer() {
        int i = this.bufferSizeT;
        while (--i >= 0) {
            this.zBufferT[i] = Integer.MAX_VALUE;
            this.pBufferT[i] = 0;
        }
    }

    final void obtainScreenBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.obtainBufferForClient();
        } else {
            this.clearScreenBuffer();
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
    }

    abstract Image allocateOffscreenImage(int var1, int var2);

    abstract Graphics getGraphics(Image var1);

    boolean checkOffscreenSize(int width, int height) {
        if (width <= this.widthOffscreen && height <= this.heightOffscreen) {
            return true;
        }
        if (this.imageOffscreen != null) {
            this.gOffscreen.dispose();
            this.imageOffscreen.flush();
        }
        if (width > this.widthOffscreen) {
            this.widthOffscreen = width + 63 & 0xFFFFFFC0;
        }
        if (height > this.heightOffscreen) {
            this.heightOffscreen = height + 15 & 0xFFFFFFF0;
        }
        this.imageOffscreen = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
        this.gOffscreen = this.getGraphics(this.imageOffscreen);
        return false;
    }

    void setBackgroundTransparent(boolean tf) {
    }

    class ClearingThread
    extends Thread
    implements Runnable {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void notifyBackgroundChange(int argbBackground) {
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void obtainBufferForClient() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                this.waitForClientRelease();
                Platform3D.this.clearScreenBuffer();
                this.notifyBufferReady();
            }
        }
    }
}

