/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

final class Shade3D {
    static final int shadeMax = 64;
    static final int shadeLast = 63;
    static byte shadeNormal = (byte)52;
    private static final float xLightsource = -1.0f;
    private static final float yLightsource = -1.0f;
    private static final float zLightsource = 2.5f;
    private static final float magnitudeLight = (float)Math.sqrt(8.25);
    static final float xLight = -1.0f / magnitudeLight;
    static final float yLight = -1.0f / magnitudeLight;
    static final float zLight = 2.5f / magnitudeLight;
    static int SPECULAR_ON = 0;
    static int SPECULAR_PERCENT = 1;
    static int SPECULAR_EXPONENT = 2;
    static int SPECULAR_POWER = 3;
    static int DIFFUSE_PERCENT = 4;
    static int AMBIENT_PERCENT = 5;
    static int INTENSITY_SPECULAR = 6;
    static int INTENSE_FRACTION = 7;
    static int INTENSITY_DIFFUSE = 8;
    static int AMBIENT_FRACTION = 9;
    static final float[] lighting = new float[]{1.0f, 22.0f, 6.0f, 40.0f, 84.0f, 45.0f, 0.22f, 0.4f, 0.84f, 0.45f};
    static final byte intensitySpecularSurfaceLimit = (byte)(shadeNormal + 4);
    static boolean sphereShadingCalculated = false;
    static final byte[] sphereIntensities = new byte[65536];
    private static int seed = 305419897;

    Shade3D() {
    }

    static int[] getShades(int rgb, boolean greyScale) {
        int i;
        int[] shades = new int[64];
        if (rgb == 0) {
            return shades;
        }
        int red = rgb >> 16 & 0xFF;
        int grn = rgb >> 8 & 0xFF;
        int blu = rgb & 0xFF;
        float ambientFraction = lighting[AMBIENT_FRACTION];
        float ambientRange = 1.0f - ambientFraction;
        float intenseFraction = lighting[INTENSE_FRACTION];
        shades[Shade3D.shadeNormal] = Shade3D.rgb(red, grn, blu);
        for (int i2 = 0; i2 < shadeNormal; ++i2) {
            float fraction = ambientFraction + ambientRange * (float)i2 / (float)shadeNormal;
            shades[i2] = Shade3D.rgb((int)((float)red * fraction + 0.5f), (int)((float)grn * fraction + 0.5f), (int)((float)blu * fraction + 0.5f));
        }
        int nSteps = 64 - shadeNormal - 1;
        float redRange = (float)(255 - red) * intenseFraction;
        float grnRange = (float)(255 - grn) * intenseFraction;
        float bluRange = (float)(255 - blu) * intenseFraction;
        for (i = 1; i <= nSteps; ++i) {
            shades[Shade3D.shadeNormal + i] = Shade3D.rgb(red + (int)(redRange * (float)i / (float)nSteps + 0.5f), grn + (int)(grnRange * (float)i / (float)nSteps + 0.5f), blu + (int)(bluRange * (float)i / (float)nSteps + 0.5f));
        }
        if (greyScale) {
            i = 64;
            while (--i >= 0) {
                shades[i] = Graphics3D.calcGreyscaleRgbFromRgb(shades[i]);
            }
        }
        return shades;
    }

    private static final int rgb(int red, int grn, int blu) {
        return 0xFF000000 | red << 16 | grn << 8 | blu;
    }

    static byte calcIntensity(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (byte)(Shade3D.calcFloatIntensityNormalized((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f + 0.5f);
    }

    static byte calcIntensityNormalized(float x, float y, float z) {
        return (byte)(Shade3D.calcFloatIntensityNormalized(x, y, z) * 63.0f + 0.5f);
    }

    static int calcFp8Intensity(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (int)(Shade3D.calcFloatIntensityNormalized((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f * 256.0f);
    }

    private static float calcFloatIntensityNormalized(float x, float y, float z) {
        float dotProduct;
        float cosTheta = x * xLight + y * yLight + z * zLight;
        if (cosTheta <= 0.0f) {
            return 0.0f;
        }
        float intensity = cosTheta * lighting[INTENSITY_DIFFUSE];
        if (lighting[SPECULAR_ON] != 0.0f && (dotProduct = z * 2.0f * cosTheta - zLight) > 0.0f) {
            int n = (int)lighting[SPECULAR_EXPONENT];
            while (--n >= 0 && dotProduct > 1.0E-4f) {
                dotProduct *= dotProduct;
            }
            intensity += dotProduct * lighting[INTENSITY_SPECULAR];
        }
        if (intensity > 1.0f) {
            return 1.0f;
        }
        return intensity;
    }

    static byte calcDitheredNoisyIntensity(float x, float y, float z, float r) {
        int random16bit;
        int fp8Intensity = (int)(Shade3D.calcFloatIntensityNormalized(x / r, y / r, z / r) * 63.0f * 256.0f);
        int intensity = fp8Intensity >> 8;
        if ((fp8Intensity & 0xFF) > Shade3D.nextRandom8Bit()) {
            ++intensity;
        }
        if ((random16bit = seed & 0xFFFF) < 21845 && intensity > 0) {
            --intensity;
        } else if (random16bit > 43690 && intensity < 63) {
            ++intensity;
        }
        return (byte)intensity;
    }

    static synchronized void calcSphereShading() {
        float xF = -127.5f;
        for (int i = 0; i < 256; ++i) {
            float yF = -127.5f;
            for (int j = 0; j < 256; ++j) {
                byte intensity = 0;
                float z2 = 16900.0f - xF * xF - yF * yF;
                if (z2 > 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    intensity = Shade3D.calcDitheredNoisyIntensity(xF, yF, z, 130.0f);
                }
                Shade3D.sphereIntensities[(j << 8) + i] = intensity;
                yF += 1.0f;
            }
            xF += 1.0f;
        }
        sphereShadingCalculated = true;
    }

    static int nextRandom8Bit() {
        int t = seed;
        seed = t = (t << 16) + (t << 1) + t & Integer.MAX_VALUE;
        return t >> 23;
    }
}

