/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Quadric;

public class Sphere3D {
    Graphics3D g3d;
    private int zShift;
    private static final int maxSphereCache = 128;
    private static final int maxOddSizeSphere = 49;
    static final int maxSphereDiameter = 1000;
    static final int maxSphereDiameter2 = 2000;
    private static final int[][] sphereShapeCache = new int[128][];
    private double[] zroot = new double[2];
    private static int nOut;
    private static int nIn;
    private Matrix3f mat;
    private double[] coef;
    private Matrix4f mDeriv;
    private int selectedOctant;
    private Point3i[] octantPoints;
    private int planeShade;
    private int[] zbuf;
    private int width;
    private int height;
    private int depth;
    private int slab;
    private int offsetPbufBeginLine;
    private boolean addAllPixels;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private int x;
    private int y;
    private int z;
    private int diameter;
    private boolean tScreened;
    private int[] shades;
    private static final int SHADE_SLAB_CLIPPED;
    private final Point3f ptTemp = new Point3f();
    private final int[] planeShades = new int[3];
    private final float[][] dxyz = new float[3][3];
    private static byte[][][] ellipsoidShades;
    private static final int SLIM = 20;
    private static final int SDIM = 40;

    Sphere3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    static synchronized void flushSphereCache() {
        int i = 128;
        while (--i >= 0) {
            Sphere3D.sphereShapeCache[i] = null;
        }
        ellipsoidShades = null;
    }

    private static int[] getSphereShape(int diameter) {
        int[] ss = sphereShapeCache[diameter - 1];
        return ss == null ? Sphere3D.createSphereShape(diameter) : ss;
    }

    private static synchronized int[] createSphereShape(int diameter) {
        int countSE = 0;
        boolean oddDiameter = (diameter & 1) != 0;
        float radiusF = (float)diameter / 2.0f;
        float radiusF2 = radiusF * radiusF;
        int radius = (diameter + 1) / 2;
        float y = oddDiameter ? 0.0f : 0.5f;
        int i = 0;
        while (i < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    ++countSE;
                }
                ++j;
                x += 1.0f;
            }
            ++i;
            y += 1.0f;
        }
        int[] sphereShape = new int[countSE];
        int offset = 0;
        y = oddDiameter ? 0.0f : 0.5f;
        int i2 = 0;
        while (i2 < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    int height = (int)z;
                    byte intensitySE = Shade3D.calcDitheredNoisyIntensity(x, y, z, radiusF);
                    byte intensitySW = Shade3D.calcDitheredNoisyIntensity(-x, y, z, radiusF);
                    byte intensityNE = Shade3D.calcDitheredNoisyIntensity(x, -y, z, radiusF);
                    byte intensityNW = Shade3D.calcDitheredNoisyIntensity(-x, -y, z, radiusF);
                    int packed = height | intensitySE << 7 | intensitySW << 13 | intensityNE << 19 | intensityNW << 25;
                    sphereShape[offset++] = packed;
                }
                ++j;
                x += 1.0f;
            }
            int n = offset - 1;
            sphereShape[n] = sphereShape[n] | Integer.MIN_VALUE;
            ++i2;
            y += 1.0f;
        }
        Sphere3D.sphereShapeCache[diameter - 1] = sphereShape;
        return sphereShape;
    }

    void render(int[] shades, boolean tScreened, int diameter, int x, int y, int z, Matrix3f mat, double[] coef, Matrix4f mDeriv, int selectedOctant, Point3i[] octantPoints) {
        if (z == 1) {
            return;
        }
        this.width = this.g3d.width;
        this.height = this.g3d.height;
        if (diameter > 49) {
            diameter &= 0xFFFFFFFE;
        }
        int radius = diameter + 1 >> 1;
        this.minX = x - radius;
        this.maxX = x + radius;
        if (this.maxX < 0 || this.minX >= this.width) {
            return;
        }
        this.minY = y - radius;
        this.maxY = y + radius;
        if (this.maxY < 0 || this.minY >= this.height) {
            return;
        }
        this.slab = this.g3d.slab;
        this.depth = this.g3d.depth;
        this.minZ = z - radius;
        this.maxZ = z + radius;
        if (this.maxZ < this.slab || this.minZ > this.depth) {
            return;
        }
        nIn = 0;
        nOut = 0;
        this.zbuf = this.g3d.zbuf;
        this.addAllPixels = this.g3d.addAllPixels;
        this.offsetPbufBeginLine = this.width * y + x;
        this.x = x;
        this.y = y;
        this.z = z;
        this.diameter = diameter;
        this.tScreened = tScreened;
        this.shades = shades;
        this.mat = mat;
        if (mat != null) {
            this.coef = coef;
            this.mDeriv = mDeriv;
            this.selectedOctant = selectedOctant;
            this.octantPoints = octantPoints;
        }
        if (mat != null || diameter > 128) {
            this.renderLarge();
            if (mat != null) {
                this.mat = null;
                this.coef = null;
                this.mDeriv = null;
                this.octantPoints = null;
            }
        } else {
            this.zShift = this.g3d.getZShift(z);
            int[] ss = Sphere3D.getSphereShape(diameter);
            if (this.minX < 0 || this.maxX >= this.width || this.minY < 0 || this.maxY >= this.height || this.minZ < this.slab || z > this.depth) {
                this.renderShapeClipped(ss);
            } else {
                this.renderShapeUnclipped(ss);
            }
        }
        this.shades = null;
        this.zbuf = null;
    }

    private void renderShapeUnclipped(int[] sphereShape) {
        int offsetSphere = 0;
        int evenSizeCorrection = 1 - (this.diameter & 1);
        int offsetSouthCenter = this.offsetPbufBeginLine;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * this.width;
        int nLines = (this.diameter + 1) / 2;
        if (!this.tScreened) {
            do {
                int packed;
                int offsetSE = offsetSouthCenter;
                int offsetSW = offsetSouthCenter - evenSizeCorrection;
                int offsetNE = offsetNorthCenter;
                int offsetNW = offsetNorthCenter - evenSizeCorrection;
                do {
                    int zPixel;
                    if ((zPixel = this.z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) < this.zbuf[offsetSE]) {
                        this.g3d.addPixel(offsetSE, zPixel, this.shades[(packed >> 7 & 0x3F) >> this.zShift]);
                    }
                    if (zPixel < this.zbuf[offsetSW]) {
                        this.g3d.addPixel(offsetSW, zPixel, this.shades[(packed >> 13 & 0x3F) >> this.zShift]);
                    }
                    if (zPixel < this.zbuf[offsetNE]) {
                        this.g3d.addPixel(offsetNE, zPixel, this.shades[(packed >> 19 & 0x3F) >> this.zShift]);
                    }
                    if (zPixel < this.zbuf[offsetNW]) {
                        this.g3d.addPixel(offsetNW, zPixel, this.shades[(packed >> 25 & 0x3F) >> this.zShift]);
                    }
                    ++offsetSE;
                    --offsetSW;
                    ++offsetNE;
                    --offsetNW;
                } while (packed >= 0);
                offsetSouthCenter += this.width;
                offsetNorthCenter -= this.width;
            } while (--nLines > 0);
            return;
        }
        int flipflopSouthCenter = (this.x ^ this.y) & 1;
        int flipflopNorthCenter = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopSE = flipflopSouthCenter;
        int flipflopSW = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopNE = flipflopNorthCenter;
        int flipflopNW = flipflopNorthCenter ^ evenSizeCorrection;
        int flipflopsCenter = flipflopSE | flipflopSW << 1 | flipflopNE << 2 | flipflopNW << 3;
        do {
            int packed;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int flipflops = flipflopsCenter ^= 0xFFFFFFFF;
            do {
                packed = sphereShape[offsetSphere++];
                int zPixel = this.z - (packed & 0x7F);
                if ((flipflops & 1) != 0 && zPixel < this.zbuf[offsetSE]) {
                    this.g3d.addPixel(offsetSE, zPixel, this.shades[(packed >> 7 & 0x3F) >> this.zShift]);
                }
                if ((flipflops & 2) != 0 && zPixel < this.zbuf[offsetSW]) {
                    this.g3d.addPixel(offsetSW, zPixel, this.shades[(packed >> 13 & 0x3F) >> this.zShift]);
                }
                if ((flipflops & 4) != 0 && zPixel < this.zbuf[offsetNE]) {
                    this.g3d.addPixel(offsetNE, zPixel, this.shades[(packed >> 19 & 0x3F) >> this.zShift]);
                }
                if ((flipflops & 8) != 0 && zPixel < this.zbuf[offsetNW]) {
                    this.g3d.addPixel(offsetNW, zPixel, this.shades[(packed >> 25 & 0x3F) >> this.zShift]);
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                flipflops ^= 0xFFFFFFFF;
            } while (packed >= 0);
            offsetSouthCenter += this.width;
            offsetNorthCenter -= this.width;
        } while (--nLines > 0);
    }

    private void renderShapeClipped(int[] sphereShape) {
        int offsetSphere = 0;
        int evenSizeCorrection = 1 - (this.diameter & 1);
        int offsetSouthCenter = this.offsetPbufBeginLine;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * this.width;
        int nLines = (this.diameter + 1) / 2;
        int ySouth = this.y;
        int yNorth = this.y - evenSizeCorrection;
        int randu = (this.x << 16) + (this.y << 1) ^ 0x33333333;
        int flipflopSouthCenter = (this.x ^ this.y) & 1;
        int flipflopNorthCenter = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopSE = flipflopSouthCenter;
        int flipflopSW = flipflopSouthCenter ^ evenSizeCorrection;
        int flipflopNE = flipflopNorthCenter;
        int flipflopNW = flipflopNorthCenter ^ evenSizeCorrection;
        int flipflopsCenter = flipflopSE | flipflopSW << 1 | flipflopNE << 2 | flipflopNW << 3;
        do {
            int packed;
            boolean tSouthVisible = ySouth >= 0 && ySouth < this.height;
            boolean tNorthVisible = yNorth >= 0 && yNorth < this.height;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int flipflops = flipflopsCenter ^= 0xFFFFFFFF;
            int xEast = this.x;
            int xWest = this.x - evenSizeCorrection;
            do {
                boolean isCore;
                int zPixel;
                boolean tWestVisible = xWest >= 0 && xWest < this.width;
                boolean tEastVisible = xEast >= 0 && xEast < this.width;
                packed = sphereShape[offsetSphere++];
                int zOffset = packed & 0x7F;
                if (this.z < this.slab) {
                    zPixel = this.z + zOffset;
                    isCore = zPixel >= this.slab;
                } else {
                    zPixel = this.z - zOffset;
                    boolean bl = isCore = zPixel < this.slab;
                }
                if (isCore) {
                    zPixel = this.slab;
                }
                if (zPixel >= this.slab && zPixel <= this.depth) {
                    int i;
                    if (tSouthVisible) {
                        if (tEastVisible && (this.addAllPixels || (flipflops & 1) != 0) && zPixel < this.zbuf[offsetSE]) {
                            i = isCore ? SHADE_SLAB_CLIPPED - 3 + (randu >> 7 & 7) : packed >> 7 & 0x3F;
                            this.g3d.addPixel(offsetSE, zPixel, this.shades[i >> this.zShift]);
                        }
                        if (tWestVisible && (this.addAllPixels || (flipflops & 2) != 0) && zPixel < this.zbuf[offsetSW]) {
                            i = isCore ? SHADE_SLAB_CLIPPED - 3 + (randu >> 13 & 7) : packed >> 13 & 0x3F;
                            this.g3d.addPixel(offsetSW, zPixel, this.shades[i >> this.zShift]);
                        }
                    }
                    if (tNorthVisible) {
                        if (tEastVisible && (!this.tScreened || (flipflops & 4) != 0) && zPixel < this.zbuf[offsetNE]) {
                            i = isCore ? SHADE_SLAB_CLIPPED - 3 + (randu >> 19 & 7) : packed >> 19 & 0x3F;
                            this.g3d.addPixel(offsetNE, zPixel, this.shades[i >> this.zShift]);
                        }
                        if (tWestVisible && (!this.tScreened || (flipflops & 8) != 0) && zPixel < this.zbuf[offsetNW]) {
                            i = isCore ? SHADE_SLAB_CLIPPED - 3 + (randu >> 25 & 7) : packed >> 25 & 0x3F;
                            this.g3d.addPixel(offsetNW, zPixel, this.shades[i >> this.zShift]);
                        }
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                ++xEast;
                --xWest;
                flipflops ^= 0xFFFFFFFF;
                if (!isCore) continue;
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
            } while (packed >= 0);
            offsetSouthCenter += this.width;
            offsetNorthCenter -= this.width;
            ++ySouth;
            --yNorth;
        } while (--nLines > 0);
    }

    private void renderLarge() {
        if (this.mat != null) {
            if (ellipsoidShades == null) {
                Sphere3D.createEllipsoidShades();
            }
            if (this.octantPoints != null) {
                this.setPlaneDerivatives();
            }
        } else if (!Shade3D.sphereShadingCalculated) {
            Shade3D.calcSphereShading();
        }
        this.renderQuadrant(-1, -1);
        this.renderQuadrant(-1, 1);
        this.renderQuadrant(1, -1);
        this.renderQuadrant(1, 1);
    }

    private void renderQuadrant(int xSign, int ySign) {
        boolean unclipped;
        int radius;
        int t;
        int xStatus = (this.x < 0 ? -1 : (this.x < this.width ? 0 : 1)) + ((t = this.x + (radius = this.diameter / 2) * xSign) < 0 ? -2 : (t < this.width ? 0 : 2));
        if (xStatus == -3 || xStatus == 3) {
            return;
        }
        int yStatus = (this.y < 0 ? -1 : (this.y < this.height ? 0 : 1)) + ((t = this.y + radius * ySign) < 0 ? -2 : (t < this.height ? 0 : 2));
        if (yStatus == -3 || yStatus == 3) {
            return;
        }
        boolean bl = unclipped = this.mat == null && xStatus == 0 && yStatus == 0 && this.z - radius >= this.slab && this.z <= this.depth;
        if (unclipped) {
            this.renderQuadrantUnclipped(radius, xSign, ySign);
        } else {
            this.renderQuadrantClipped(radius, xSign, ySign);
        }
    }

    private void renderQuadrantUnclipped(int radius, int xSign, int ySign) {
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        boolean flipflopBeginLine = ((this.x ^ this.y) & 1) == 0;
        int lineIncrement = ySign < 0 ? -this.width : this.width;
        int ptLine = this.offsetPbufBeginLine;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            int offset = ptLine;
            flipflopBeginLine = !flipflopBeginLine;
            boolean flipflop = flipflopBeginLine;
            int s2 = r2 - i2;
            int z0 = this.z - radius;
            int y8 = (i * ySign + radius << 8) / dDivisor;
            int j = 0;
            int j2 = 0;
            while (j2 <= s2) {
                int k;
                if ((this.addAllPixels || (flipflop = !flipflop)) && this.zbuf[offset] > z0 && this.zbuf[offset] > (z0 = this.z - (k = (int)Math.sqrt(s2 - j2)))) {
                    int x8 = (j * xSign + radius << 8) / dDivisor;
                    this.g3d.addPixel(offset, z0, this.shades[Shade3D.sphereIntensities[(y8 << 8) + x8 >> this.zShift]]);
                }
                j2 += j++ + j;
                offset += xSign;
            }
            i2 += i++ + i;
            ptLine += lineIncrement;
        }
    }

    private void renderQuadrantClipped(int radius, int xSign, int ySign) {
        boolean isEllipsoid = this.mat != null;
        boolean checkOctant = this.selectedOctant >= 0;
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        int lineIncrement = ySign < 0 ? -this.width : this.width;
        int ptLine = this.offsetPbufBeginLine;
        int randu = (this.x << 16) + (this.y << 1) ^ 0x33333333;
        int yCurrent = this.y;
        int y8 = 0;
        int iShade = 0;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            block19: {
                block20: {
                    block18: {
                        if (yCurrent >= 0) break block18;
                        if (ySign < 0) {
                            return;
                        }
                        break block19;
                    }
                    if (yCurrent < this.height) break block20;
                    if (ySign > 0) {
                        return;
                    }
                    break block19;
                }
                int s2 = r2 - (isEllipsoid ? 0 : i2);
                int xCurrent = this.x;
                if (!isEllipsoid) {
                    y8 = (i * ySign + radius << 8) / dDivisor;
                }
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                int iRoot = -1;
                int mode = 1;
                int offset = ptLine;
                int j = 0;
                int j2 = 0;
                while (j2 <= s2) {
                    block22: {
                        boolean isCore;
                        int zPixel;
                        block26: {
                            block24: {
                                block25: {
                                    block23: {
                                        block21: {
                                            if (xCurrent >= 0) break block21;
                                            if (xSign < 0) {
                                                break;
                                            }
                                            break block22;
                                        }
                                        if (xCurrent < this.width) break block23;
                                        if (xSign > 0) {
                                            break;
                                        }
                                        break block22;
                                    }
                                    if (this.tScreened && ((xCurrent ^ yCurrent) & 1) != 0) break block22;
                                    if (!isEllipsoid) break block24;
                                    if (Quadric.getQuardricZ(xCurrent, yCurrent, this.coef, this.zroot)) break block25;
                                    if (iRoot >= 0) {
                                        break;
                                    }
                                    break block22;
                                }
                                iRoot = this.z < this.slab ? 1 : 0;
                                zPixel = (int)this.zroot[iRoot];
                                if (zPixel == 0) {
                                    zPixel = this.z;
                                }
                                mode = 2;
                                if (checkOctant) {
                                    this.ptTemp.set(xCurrent - this.x, yCurrent - this.y, zPixel - this.z);
                                    this.mat.transform(this.ptTemp);
                                    int thisOctant = Quadric.getOctant(this.ptTemp);
                                    if (thisOctant == this.selectedOctant) {
                                        iShade = this.getPlaneShade(xCurrent, yCurrent, this.zroot);
                                        zPixel = (int)this.zroot[0];
                                        mode = 3;
                                    }
                                }
                                break block26;
                            }
                            int zOffset = (int)Math.sqrt(s2 - j2);
                            zPixel = this.z + (this.z < this.slab ? zOffset : -zOffset);
                        }
                        boolean bl = this.z < this.slab ? zPixel >= this.slab : (isCore = zPixel < this.slab);
                        if (isCore) {
                            zPixel = this.slab;
                            mode = 0;
                        }
                        if (zPixel >= this.slab && zPixel <= this.depth && this.zbuf[offset] > zPixel) {
                            switch (mode) {
                                case 0: {
                                    iShade = SHADE_SLAB_CLIPPED - 3 + (randu >> 8 & 7) >> this.zShift;
                                    randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                                    mode = 1;
                                    break;
                                }
                                case 2: {
                                    iShade = Sphere3D.getEllipsoidShade(xCurrent, yCurrent, (float)this.zroot[iRoot], radius, this.mDeriv);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    int x8 = (j * xSign + radius << 8) / dDivisor;
                                    iShade = Shade3D.sphereIntensities[(y8 << 8) + x8] >> this.zShift;
                                }
                            }
                            this.g3d.addPixel(offset, zPixel, this.shades[iShade]);
                        }
                    }
                    j2 += j++ + j;
                    offset += xSign;
                    xCurrent += xSign;
                }
                randu = (randu + xCurrent + yCurrent | 1) & Integer.MAX_VALUE;
            }
            i2 += i++ + i;
            ptLine += lineIncrement;
            yCurrent += ySign;
        }
    }

    private void setPlaneDerivatives() {
        this.planeShade = -1;
        for (int i = 0; i < 3; ++i) {
            float f = this.octantPoints[i].x - this.x;
            this.dxyz[i][0] = f;
            float dx = f;
            float f2 = this.octantPoints[i].y - this.y;
            this.dxyz[i][1] = f2;
            float dy = f2;
            float f3 = this.octantPoints[i].z - this.z;
            this.dxyz[i][2] = f3;
            float dz = f3;
            this.planeShades[i] = Shade3D.calcIntensity(dx, dy, -dz);
            if (dx != 0.0f || dy != 0.0f) continue;
            this.planeShade = this.planeShades[i];
            return;
        }
    }

    private int getPlaneShade(int xCurrent, int yCurrent, double[] zroot) {
        if (this.planeShade >= 0) {
            return this.planeShade;
        }
        int iMin = 3;
        float zMin = Float.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            float ptz;
            float dz = this.dxyz[i][2];
            if (dz == 0.0f || !((ptz = (float)this.z + (-this.dxyz[i][0] * (float)(xCurrent - this.x) - this.dxyz[i][1] * (float)(yCurrent - this.y)) / dz) < zMin)) continue;
            zMin = ptz;
            iMin = i;
        }
        if (iMin == 3) {
            iMin = 0;
            zMin = this.z;
        }
        zroot[0] = zMin;
        return this.planeShades[iMin];
    }

    private static void createEllipsoidShades() {
        ellipsoidShades = new byte[40][40][40];
        for (int ii = 0; ii < 40; ++ii) {
            for (int jj = 0; jj < 40; ++jj) {
                for (int kk = 0; kk < 40; ++kk) {
                    Sphere3D.ellipsoidShades[ii][jj][kk] = Shade3D.calcIntensity(ii - 20, jj - 20, kk);
                }
            }
        }
    }

    private static int getEllipsoidShade(float x, float y, float z, int radius, Matrix4f mDeriv) {
        boolean outside;
        float tx = mDeriv.m00 * x + mDeriv.m01 * y + mDeriv.m02 * z + mDeriv.m03;
        float ty = mDeriv.m10 * x + mDeriv.m11 * y + mDeriv.m12 * z + mDeriv.m13;
        float tz = mDeriv.m20 * x + mDeriv.m21 * y + mDeriv.m22 * z + mDeriv.m23;
        float f = Math.min((float)radius / 2.0f, 45.0f) / (float)Math.sqrt(tx * tx + ty * ty + tz * tz);
        int i = (int)(-tx * f);
        int j = (int)(-ty * f);
        int k = (int)(tz * f);
        boolean bl = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        if (outside) {
            while (i % 2 == 0 && j % 2 == 0 && k % 2 == 0 && i + j + k > 0) {
                i >>= 1;
                j >>= 1;
                k >>= 1;
            }
            boolean bl2 = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        }
        if (outside) {
            ++nOut;
        } else {
            ++nIn;
        }
        return outside ? Shade3D.calcIntensity(i, j, k) : ellipsoidShades[i + 20][j + 20][k];
    }

    static {
        SHADE_SLAB_CLIPPED = Shade3D.shadeNormal - 5;
    }
}

