/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Platform3D;

public class Text3D {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private int[] bitmap;
    private boolean isInvalid;
    private static final Hashtable htFont3d = new Hashtable();
    private static final Hashtable htFont3dAntialias = new Hashtable();
    private static boolean working;

    public int getWidth() {
        return this.width;
    }

    public static int plot(int x, int y, int z, int argb, String text, Font3D font3d, Graphics3D g3d, JmolRendererInterface jmolRenderer, boolean antialias) {
        if (text.length() == 0) {
            return 0;
        }
        if (text.indexOf("<su") >= 0) {
            return Text3D.plotByCharacter(x, y, z, argb, text, font3d, g3d, jmolRenderer, antialias);
        }
        int offset = font3d.fontMetrics.getAscent();
        Text3D text3d = Text3D.getText3D(x, y -= offset, g3d, text, font3d, antialias);
        if (text3d.isInvalid) {
            return text3d.width;
        }
        if (antialias && (argb & 0xC0C0C0) == 0) {
            argb |= 0x40404;
        }
        if (jmolRenderer != null || x < 0 || x + text3d.width > g3d.width || y < 0 || y + text3d.height > g3d.height) {
            Text3D.plotClipped(x, y, z, argb, g3d, jmolRenderer, text3d.mapWidth, text3d.height, text3d.bitmap);
        } else {
            Text3D.plotUnclipped(x, y, z, argb, g3d, text3d.mapWidth, text3d.height, text3d.bitmap);
        }
        return text3d.width;
    }

    public static void plotImage(int x, int y, int z, Image image, Graphics3D g3d, JmolRendererInterface jmolRenderer, boolean antialias, int argbBackground, int width, int height) {
        int bgcolor;
        boolean isBackground = x == Integer.MIN_VALUE;
        int width0 = image.getWidth(null);
        int height0 = image.getHeight(null);
        if (isBackground) {
            x = 0;
            z = 0x7FFFFFFE;
            width = g3d.width;
            height = g3d.height;
        }
        if (x + width <= 0 || x >= g3d.width || y + height <= 0 || y >= g3d.height) {
            return;
        }
        g3d.platform.checkOffscreenSize(width, height);
        Graphics g = g3d.platform.gOffscreen;
        g.clearRect(0, 0, width, height);
        g.drawImage(image, 0, 0, width, height, 0, 0, width0, height0, null);
        PixelGrabber pixelGrabber = new PixelGrabber(g3d.platform.imageOffscreen, 0, 0, width, height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            return;
        }
        int[] buffer = (int[])pixelGrabber.getPixels();
        int n = isBackground ? 0 : (bgcolor = argbBackground == 0 ? buffer[0] : argbBackground);
        if (jmolRenderer != null || x < 0 || x + width > g3d.width || y < 0 || y + height > g3d.height) {
            Text3D.plotImageClipped(x, y, z, g3d, jmolRenderer, width, height, buffer, bgcolor);
        } else {
            Text3D.plotImageUnClipped(x, y, z, g3d, width, height, buffer, bgcolor);
        }
    }

    private static void plotImageClipped(int x, int y, int z, Graphics3D g3d, JmolRendererInterface jmolRenderer, int width, int height, int[] buffer, int bgcolor) {
        if (jmolRenderer == null) {
            jmolRenderer = g3d;
        }
        int offset = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int argb;
                if ((argb = buffer[offset++]) == bgcolor || (argb & 0xFF000000) != -16777216) continue;
                jmolRenderer.plotPixelClippedNoSlab(argb, x + j, y + i, z);
            }
        }
    }

    private static void plotImageUnClipped(int x, int y, int z, Graphics3D g3d, int textWidth, int textHeight, int[] buffer, int bgcolor) {
        int[] zbuf = g3d.zbuf;
        int renderWidth = g3d.width;
        int pbufOffset = y * renderWidth + x;
        int i = 0;
        int j = 0;
        int offset = 0;
        while (i < textHeight) {
            while (j < textWidth) {
                int argb;
                if (z < zbuf[pbufOffset] && (argb = buffer[offset]) != bgcolor && (argb & 0xFF000000) == -16777216) {
                    g3d.addPixel(pbufOffset, z, argb);
                }
                ++offset;
                ++j;
                ++pbufOffset;
            }
            ++i;
            j -= textWidth;
            pbufOffset += renderWidth - textWidth;
        }
    }

    private static int plotByCharacter(int x, int y, int z, int argb, String text, Font3D font3d, Graphics3D g3d, JmolRendererInterface jmolRenderer, boolean antialias) {
        int w = 0;
        int len = text.length();
        int suboffset = (int)((double)font3d.fontMetrics.getHeight() * 0.25);
        int supoffset = -((int)((double)font3d.fontMetrics.getHeight() * 0.3));
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == '<') {
                if (i + 4 < len && text.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    y += suboffset;
                    continue;
                }
                if (i + 4 < len && text.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    y += supoffset;
                    continue;
                }
                if (i + 5 < len && text.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    y -= suboffset;
                    continue;
                }
                if (i + 5 < len && text.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    y -= supoffset;
                    continue;
                }
            }
            int width = Text3D.plot(x + w, y, z, argb, text.substring(i, i + 1), font3d, g3d, jmolRenderer, antialias);
            w += width;
        }
        return w;
    }

    private static void plotUnclipped(int x, int y, int z, int argb, Graphics3D g3d, int textWidth, int textHeight, int[] bitmap) {
        int offset = 0;
        int shiftregister = 0;
        int i = 0;
        int j = 0;
        int[] zbuf = g3d.zbuf;
        int renderWidth = g3d.width;
        int pbufOffset = y * renderWidth + x;
        while (i < textHeight) {
            while (j < textWidth) {
                if ((offset & 0x1F) == 0) {
                    shiftregister = bitmap[offset >> 5];
                }
                if (shiftregister == 0) {
                    int skip = 32 - (offset & 0x1F);
                    j += skip;
                    offset += skip;
                    pbufOffset += skip;
                    continue;
                }
                if (shiftregister < 0 && z < zbuf[pbufOffset]) {
                    g3d.addPixel(pbufOffset, z, argb);
                }
                shiftregister <<= 1;
                ++offset;
                ++j;
                ++pbufOffset;
            }
            while (j >= textWidth) {
                ++i;
                j -= textWidth;
                pbufOffset += renderWidth - textWidth;
            }
        }
    }

    private static void plotClipped(int x, int y, int z, int argb, Graphics3D g3d, JmolRendererInterface jmolRenderer, int textWidth, int textHeight, int[] bitmap) {
        if (jmolRenderer == null) {
            jmolRenderer = g3d;
        }
        int offset = 0;
        int shiftregister = 0;
        int i = 0;
        int j = 0;
        while (i < textHeight) {
            while (j < textWidth) {
                if ((offset & 0x1F) == 0) {
                    shiftregister = bitmap[offset >> 5];
                }
                if (shiftregister == 0) {
                    int skip = 32 - (offset & 0x1F);
                    j += skip;
                    offset += skip;
                    continue;
                }
                if (shiftregister < 0) {
                    jmolRenderer.plotPixelClippedNoSlab(argb, x + j, y + i, z);
                }
                shiftregister <<= 1;
                ++offset;
                ++j;
            }
            while (j >= textWidth) {
                ++i;
                j -= textWidth;
            }
        }
    }

    private Text3D(String text, Font3D font3d, boolean antialias) {
        FontMetrics fontMetrics = font3d.fontMetrics;
        this.ascent = fontMetrics.getAscent();
        this.height = this.ascent + fontMetrics.getDescent();
        this.width = fontMetrics.stringWidth(text);
        if (this.width == 0) {
            return;
        }
        this.mapWidth = this.width;
        this.size = this.mapWidth * this.height;
    }

    private void renderOffscreen(String text, Font3D font3d, Platform3D platform, boolean antialias) {
        Graphics g = platform.gOffscreen;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.mapWidth, this.height);
        g.setColor(Color.white);
        g.setFont(font3d.font);
        g.drawString(text, 0, this.ascent);
    }

    private void rasterize(Platform3D platform, boolean antialias) {
        PixelGrabber pixelGrabber = new PixelGrabber(platform.imageOffscreen, 0, 0, this.mapWidth, this.height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            return;
        }
        int[] pixels = (int[])pixelGrabber.getPixels();
        int bitmapSize = this.size + 31 >> 5;
        this.bitmap = new int[bitmapSize];
        int shifter = 0;
        int offset = 0;
        while (offset < this.size) {
            if ((pixels[offset] & 0xFFFFFF) != 0) {
                shifter |= 1;
            }
            if ((offset & 0x1F) == 31) {
                this.bitmap[offset >> 5] = shifter;
            }
            ++offset;
            shifter <<= 1;
        }
        if ((offset & 0x1F) != 0) {
            this.bitmap[offset >> 5] = shifter <<= 31 - (offset & 0x1F);
        }
    }

    public static synchronized void clearFontCache() {
        if (working) {
            return;
        }
        htFont3d.clear();
        htFont3dAntialias.clear();
    }

    private static synchronized Text3D getText3D(int x, int y, Graphics3D g3d, String text, Font3D font3d, boolean antialias) {
        working = true;
        Hashtable ht = antialias ? htFont3dAntialias : htFont3d;
        Hashtable<String, Text3D> htForThisFont = (Hashtable<String, Text3D>)ht.get(font3d);
        Text3D text3d = null;
        boolean newFont = false;
        boolean newText = false;
        if (htForThisFont != null) {
            text3d = (Text3D)htForThisFont.get(text);
        } else {
            htForThisFont = new Hashtable<String, Text3D>();
            newFont = true;
        }
        if (text3d == null) {
            text3d = new Text3D(text, font3d, antialias);
            newText = true;
        }
        boolean bl = text3d.isInvalid = text3d.width == 0 || x + text3d.width <= 0 || x >= g3d.width || y + text3d.height <= 0 || y >= g3d.height;
        if (text3d.isInvalid) {
            return text3d;
        }
        if (newFont) {
            ht.put(font3d, htForThisFont);
        }
        if (newText) {
            text3d.setBitmap(text, font3d, g3d.platform, antialias);
            htForThisFont.put(text, text3d);
        }
        working = false;
        return text3d;
    }

    private void setBitmap(String text, Font3D font3d, Platform3D platform, boolean antialias) {
        platform.checkOffscreenSize(this.mapWidth, this.height);
        this.renderOffscreen(text, font3d, platform, antialias);
        this.rasterize(platform, antialias);
    }
}

