/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jmol.util.Logger;

public class GT {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private ResourceBundle[] translationResources = null;
    private int translationResourcesCount = 0;
    private boolean doTranslate = true;
    private String language;
    private static Language[] languageList;

    public GT(String la) {
        this.getTranslation(la);
    }

    private GT() {
        this.getTranslation(null);
    }

    public static Language[] getLanguageList() {
        return languageList != null ? languageList : GT.getTextWrapper().createLanguageList();
    }

    private synchronized Language[] createLanguageList() {
        boolean wasTranslating = this.doTranslate;
        this.doTranslate = false;
        languageList = new Language[]{new Language("ca", GT._("Catalan"), true), new Language("cs", GT._("Czech"), true), new Language("da", GT._("Danish"), false), new Language("nl", GT._("Dutch"), true), new Language("en_GB", GT._("British English"), true), new Language("en_US", GT._("American English"), true), new Language("et", GT._("Estonian"), true), new Language("fr", GT._("French"), true), new Language("de", GT._("German"), true), new Language("el", GT._("Greek"), false), new Language("hu", GT._("Hungarian"), true), new Language("it", GT._("Italian"), true), new Language("ko", GT._("Korean"), true), new Language("nb", GT._("Norwegian Bokmal"), false), new Language("pl", GT._("Polish"), false), new Language("pt_BR", GT._("Brazilian Portuguese"), true), new Language("pt", GT._("Portuguese"), true), new Language("ru", GT._("Russian"), false), new Language("sl", GT._("Slovenian"), false), new Language("es", GT._("Spanish"), true), new Language("sv", GT._("Swedish"), false), new Language("zh_TW", GT._("Traditional Chinese"), false), new Language("tr", GT._("Turkish"), true), new Language("uk", GT._("Ukrainian"), false)};
        this.doTranslate = wasTranslating;
        return languageList;
    }

    private String getSupported(String languageCode, boolean isExact) {
        if (languageCode == null) {
            return null;
        }
        if (languageList == null) {
            this.createLanguageList();
        }
        for (int i = 0; i < languageList.length; ++i) {
            if (!GT.languageList[i].code.equalsIgnoreCase(languageCode)) continue;
            return GT.languageList[i].code;
        }
        return isExact ? null : this.findClosest(languageCode);
    }

    private String findClosest(String la) {
        int i = languageList.length;
        while (--i >= 0) {
            if (!GT.languageList[i].code.startsWith(la)) continue;
            return GT.languageList[i].code;
        }
        return null;
    }

    public static String getLanguage() {
        return GT.getTextWrapper().language;
    }

    private synchronized void getTranslation(String langCode) {
        Locale locale;
        this.translationResources = null;
        this.translationResourcesCount = 0;
        getTextWrapper = this;
        if (langCode != null && langCode.length() == 0) {
            langCode = "none";
        }
        if (langCode != null) {
            this.language = langCode;
        }
        if ("none".equals(this.language)) {
            this.language = null;
        }
        if (this.language == null && (locale = Locale.getDefault()) != null) {
            this.language = locale.getLanguage();
            if (locale.getCountry() != null) {
                this.language = this.language + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    this.language = this.language + "_" + locale.getVariant();
                }
            }
        }
        if (this.language == null) {
            this.language = "en";
        }
        String la = this.language;
        String la_co = this.language;
        String la_co_va = this.language;
        int i = this.language.indexOf("_");
        if (i >= 0) {
            la = la.substring(0, i);
            ++i;
            if ((i = this.language.indexOf("_", i)) >= 0) {
                la_co = this.language.substring(0, i);
            } else {
                la_co_va = null;
            }
        } else {
            la_co = null;
            la_co_va = null;
        }
        this.language = this.getSupported(la_co_va, false);
        if (this.language == null && (this.language = this.getSupported(la_co, false)) == null && (this.language = this.getSupported(la, false)) == null) {
            this.language = "en";
            Logger.debug(this.language + " not supported -- using en");
            return;
        }
        la_co_va = null;
        la_co = null;
        switch (this.language.length()) {
            case 2: {
                la = this.language;
                break;
            }
            case 5: {
                la_co = this.language;
                la = this.language.substring(0, 2);
                break;
            }
            default: {
                la_co_va = this.language;
                la_co = this.language.substring(0, 5);
                la = this.language.substring(0, 2);
            }
        }
        la_co = this.getSupported(la_co, false);
        la = this.getSupported(la, false);
        if (la == la_co || "en_US".equals(la)) {
            la = null;
        }
        if (la_co == la_co_va) {
            la_co = null;
        }
        if ("en_US".equals(la_co)) {
            return;
        }
        if (Logger.debugging) {
            Logger.debug("Instantiating gettext wrapper for " + this.language + " using files for language:" + la + " country:" + la_co + " variant:" + la_co_va);
        }
        if (!ignoreApplicationBundle) {
            this.addBundles("Jmol", la_co_va, la_co, la);
        }
        this.addBundles("JmolApplet", la_co_va, la_co, la);
    }

    private void addBundles(String type, String la_co_va, String la_co, String la) {
        try {
            String className = "org.jmol.translation." + type + ".";
            if (la_co_va != null) {
                this.addBundle(className, la_co_va);
            }
            if (la_co != null) {
                this.addBundle(className, la_co);
            }
            if (la != null) {
                this.addBundle(className, la);
            }
        }
        catch (Exception exception) {
            Logger.error("Some exception occurred!", exception);
            this.translationResources = null;
            this.translationResourcesCount = 0;
        }
    }

    private void addBundle(String className, String name) {
        Class<?> bundleClass = null;
        className = className + name + ".Messages_" + name;
        try {
            bundleClass = Class.forName(className);
        }
        catch (Throwable e) {
            Logger.error("GT could not find the class " + className);
        }
        if (bundleClass == null || !ResourceBundle.class.isAssignableFrom(bundleClass)) {
            return;
        }
        try {
            ResourceBundle myBundle = (ResourceBundle)bundleClass.newInstance();
            if (myBundle != null) {
                if (this.translationResources == null) {
                    this.translationResources = new ResourceBundle[8];
                    this.translationResourcesCount = 0;
                }
                this.translationResources[this.translationResourcesCount] = myBundle;
                ++this.translationResourcesCount;
                Logger.debug("GT adding " + className);
            }
        }
        catch (IllegalAccessException e) {
            Logger.warn("Illegal Access Exception: " + e.getMessage());
        }
        catch (InstantiationException e) {
            Logger.warn("Instantiation Excaption: " + e.getMessage());
        }
    }

    private static GT getTextWrapper() {
        return getTextWrapper == null ? (getTextWrapper = new GT()) : getTextWrapper;
    }

    public static void ignoreApplicationBundle() {
        ignoreApplicationBundle = true;
    }

    public static void setDoTranslate(boolean TF) {
        GT.getTextWrapper().doTranslate = TF;
    }

    public static boolean getDoTranslate() {
        return GT.getTextWrapper().doTranslate;
    }

    public static String _(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String _(String string, String item) {
        return GT.getTextWrapper().getString(string, new Object[]{item});
    }

    public static String _(String string, int item) {
        return GT.getTextWrapper().getString(string, new Object[]{new Integer(item)});
    }

    public static String _(String string, Object[] objects) {
        return GT.getTextWrapper().getString(string, objects);
    }

    public static String _(String string, boolean t) {
        return GT._(string, (Object[])null, t);
    }

    public static String _(String string, String item, boolean t) {
        return GT._(string, new Object[]{item});
    }

    public static String _(String string, int item, boolean t) {
        return GT._(string, new Object[]{new Integer(item)});
    }

    public static synchronized String _(String string, Object[] objects, boolean t) {
        String str;
        boolean wasTranslating = GT.getTextWrapper().doTranslate;
        if (!wasTranslating) {
            GT.setDoTranslate(true);
        }
        String string2 = str = objects == null ? GT._(string) : GT._(string, objects);
        if (!wasTranslating) {
            GT.setDoTranslate(false);
        }
        return str;
    }

    private String getString(String string) {
        if (!this.doTranslate || this.translationResourcesCount == 0) {
            return string;
        }
        for (int bundle = 0; bundle < this.translationResourcesCount; ++bundle) {
            try {
                String trans = this.translationResources[bundle].getString(string);
                return trans;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        if (Logger.debugging) {
            Logger.info("No trans, using default: " + string);
        }
        return string;
    }

    private String getString(String string, Object[] objects) {
        String trans = null;
        if (!this.doTranslate) {
            return MessageFormat.format(string, objects);
        }
        for (int bundle = 0; bundle < this.translationResourcesCount; ++bundle) {
            try {
                trans = MessageFormat.format(this.translationResources[bundle].getString(string), objects);
                return trans;
            }
            catch (MissingResourceException e) {
                continue;
            }
        }
        trans = MessageFormat.format(string, objects);
        if (this.translationResourcesCount > 0 && Logger.debugging) {
            Logger.debug("No trans, using default: " + trans);
        }
        return trans;
    }

    public static String escapeHTML(String msg) {
        int i = msg.length();
        while (--i >= 0) {
            char ch = msg.charAt(i);
            if (ch <= '\u007f') continue;
            msg = msg.substring(0, i) + "&#" + ch + ";" + msg.substring(i + 1);
        }
        return msg;
    }

    public static void setLanguagePath(String languagePath) {
    }

    public static class Language {
        public final String code;
        public final String language;
        public final boolean display;

        public Language(String code, String language, boolean display) {
            this.code = code;
            this.language = language;
            this.display = display;
        }
    }
}

