/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;

public class MeshData {
    private static final int SEED_COUNT = 25;
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    public int polygonCount;
    public Point3f[] vertices;
    public short[] vertexColixes;
    public int vertexCount;
    public float[] vertexValues;
    public int[][] polygonIndexes;
    public short[] polygonColixes;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public Point3f[] dots;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    private int lastColor;
    private short lastColix;

    public void clear(String meshType) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.vertices = null;
        this.polygonIndexes = null;
        this.surfaceSet = null;
    }

    public int addVertexCopy(Point3f vertex, float value, int assocVertex) {
        if (assocVertex < 0) {
            this.vertexIncrement = -assocVertex;
        }
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = value;
        return this.addVertexCopy(vertex);
    }

    private int addVertexCopy(Point3f vertex) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(vertex);
        return this.vertexCount++;
    }

    public void addTriangleCheck(int vertexA, int vertexB, int vertexC, int check, int color) {
        if (this.vertexValues != null && (Float.isNaN(this.vertexValues[vertexA]) || Float.isNaN(this.vertexValues[vertexB]) || Float.isNaN(this.vertexValues[vertexC]))) {
            return;
        }
        if (Float.isNaN(this.vertices[vertexA].x) || Float.isNaN(this.vertices[vertexB].x) || Float.isNaN(this.vertices[vertexC].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        if (color != 0) {
            short s;
            if (this.polygonColixes == null) {
                this.polygonColixes = new short[25];
                this.lastColor = 0;
            } else if (this.polygonCount == this.polygonColixes.length) {
                this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
            }
            if (color == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = color;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            this.polygonColixes[this.polygonCount] = s;
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC, check};
    }

    public BitSet[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSet(0) : this.surfaceSet;
    }

    public BitSet[] getSurfaceSet(int level) {
        int i;
        if (level == 0) {
            this.surfaceSet = new BitSet[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (int i2 = 0; i2 < this.polygonCount; ++i2) {
            if (this.polygonIndexes[i2] == null) continue;
            int[] p = this.polygonIndexes[i2];
            int pt0 = this.findSet(p[0]);
            int pt1 = this.findSet(p[1]);
            int pt2 = this.findSet(p[2]);
            if (pt0 < 0 && pt1 < 0 && pt2 < 0) {
                this.createSet(p[0], p[1], p[2]);
                continue;
            }
            if (pt0 == pt1 && pt1 == pt2) continue;
            if (pt0 >= 0) {
                this.surfaceSet[pt0].set(p[1]);
                this.surfaceSet[pt0].set(p[2]);
                if (pt1 >= 0 && pt1 != pt0) {
                    this.mergeSets(pt0, pt1);
                }
                if (pt2 < 0 || pt2 == pt0 || pt2 == pt1) continue;
                this.mergeSets(pt0, pt2);
                continue;
            }
            if (pt1 >= 0) {
                this.surfaceSet[pt1].set(p[0]);
                this.surfaceSet[pt1].set(p[2]);
                if (pt2 < 0 || pt2 == pt1) continue;
                this.mergeSets(pt1, pt2);
                continue;
            }
            this.surfaceSet[pt2].set(p[0]);
            this.surfaceSet[pt2].set(p[1]);
        }
        int n = 0;
        for (int i3 = 0; i3 < this.nSets; ++i3) {
            if (this.surfaceSet[i3] == null) continue;
            ++n;
        }
        BitSet[] temp = new BitSet[100];
        n = 0;
        for (i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            temp[n++] = this.surfaceSet[i];
        }
        this.nSets = n;
        this.surfaceSet = temp;
        if (!this.setsSuccessful && level < 2) {
            this.getSurfaceSet(level + 1);
        }
        if (level == 0) {
            this.vertexSets = new int[this.vertexCount];
            for (i = 0; i < this.nSets; ++i) {
                for (int j = 0; j < this.vertexCount; ++j) {
                    if (!this.surfaceSet[i].get(j)) continue;
                    this.vertexSets[j] = i;
                }
            }
        }
        return this.surfaceSet;
    }

    private int findSet(int vertex) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(vertex)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int v1, int v2, int v3) {
        int i;
        for (i = 0; i < this.nSets && this.surfaceSet[i] != null; ++i) {
        }
        if (i >= 100) {
            this.setsSuccessful = false;
            return;
        }
        if (i == this.nSets) {
            this.nSets = i + 1;
        }
        this.surfaceSet[i] = new BitSet();
        this.surfaceSet[i].set(v1);
        this.surfaceSet[i].set(v2);
        this.surfaceSet[i].set(v3);
    }

    private void mergeSets(int a, int b) {
        this.surfaceSet[a].or(this.surfaceSet[b]);
        this.surfaceSet[b] = null;
    }

    public void invalidateSurfaceSet(int i) {
        int j = this.surfaceSet[i].length();
        while (--j >= 0) {
            if (!this.surfaceSet[i].get(j)) continue;
            this.vertexValues[j] = Float.NaN;
        }
        this.surfaceSet[i] = null;
    }

    public static boolean checkCutoff(int iA, int iB, int iC, float[] vertexValues) {
        if (iA < 0 || iB < 0 || iC < 0) {
            return false;
        }
        float val1 = vertexValues[iA];
        float val2 = vertexValues[iB];
        float val3 = vertexValues[iC];
        return val1 >= 0.0f && val2 >= 0.0f && val3 >= 0.0f || val1 <= 0.0f && val2 <= 0.0f && val3 <= 0.0f;
    }

    private boolean setABC(int i) {
        int[] vertexIndexes = this.polygonIndexes[i];
        return vertexIndexes != null && !Float.isNaN(this.vertexValues[vertexIndexes[0]]) && !Float.isNaN(this.vertexValues[vertexIndexes[1]]) && !Float.isNaN(this.vertexValues[vertexIndexes[2]]);
    }

    public void invalidateTriangles() {
        int i = this.polygonCount;
        while (--i >= 0) {
            if (this.setABC(i)) continue;
            this.polygonIndexes[i] = null;
        }
    }
}

