/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;

class ApbsReader
extends VolumeFileReader {
    ApbsReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.isApbsDx = true;
        this.jvxlData.wasCubic = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer(this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.br.readLine();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        this.isAngstroms = true;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String atomLine = this.br.readLine();
        String[] tokens = Parser.getTokens(atomLine, 0);
        this.negativeAtomCount = false;
        this.atomCount = 0;
        if (tokens.length >= 4) {
            this.volumetricOrigin.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
        }
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, tokens[0], atomLine, this.jvxlFileHeaderBuffer);
    }

    protected void readVoxelVector(int voxelVectorIndex) throws Exception {
        super.readVoxelVector(voxelVectorIndex);
        if (voxelVectorIndex == 2) {
            this.line = this.br.readLine();
            String[] tokens = this.getTokens();
            for (int i = 0; i < 3; ++i) {
                this.voxelCounts[i] = this.parseInt(tokens[i + 5]);
            }
            this.br.readLine();
        }
    }
}

