/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;

class CubeReader
extends VolumeFileReader {
    CubeReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
        this.canDownsample = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append(this.br.readLine()).append('\n');
        this.jvxlFileHeaderBuffer.append(this.br.readLine()).append('\n');
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String atomLine = this.br.readLine();
        String[] tokens = Parser.getTokens(atomLine, 0);
        this.atomCount = this.parseInt(tokens[0]);
        boolean bl = this.negativeAtomCount = this.atomCount < 0;
        if (this.negativeAtomCount) {
            this.atomCount = -this.atomCount;
        }
        this.volumetricOrigin.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, tokens[0], atomLine, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
    }
}

