/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class EfvetReader
extends PolygonFileReader {
    EfvetReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("efvet file format\nvertices and triangles only\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.hasColorData = true;
    }

    void getSurfaceData() throws Exception {
        this.getHeader();
        this.getVertices();
        this.getTriangles();
        Logger.info("efvet file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles");
    }

    private void getHeader() throws Exception {
        this.skipTo("<efvet", null);
        while ((this.line = this.br.readLine()).length() > 0 && this.line.indexOf(">") < 0) {
            this.jvxlFileHeaderBuffer.append("# " + this.line + "\n");
        }
        Logger.info(this.jvxlFileHeaderBuffer.toString());
    }

    private void getVertices() throws Exception {
        Point3f pt = new Point3f();
        float value = 0.0f;
        this.skipTo("<vertices", "count");
        this.jvxlData.vertexCount = this.nVertices = this.parseInt();
        this.skipTo("property=", null);
        this.line = this.line.replace('\"', ' ');
        String[] tokens = this.getTokens();
        int dataIndex = this.params.fileIndex;
        if (dataIndex > 0 && dataIndex < tokens.length) {
            Logger.info("property " + tokens[dataIndex]);
        } else {
            Logger.info(this.line);
        }
        for (int i = 0; i < this.nVertices; ++i) {
            this.skipTo("<vertex", "image");
            pt.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
            this.skipTo(null, "property");
            for (int j = 0; j < dataIndex; ++j) {
                value = this.parseFloat();
            }
            this.addVertexCopy(pt, value, i);
        }
    }

    private void getTriangles() throws Exception {
        this.skipTo("<triangle_array", "count");
        this.nTriangles = this.parseInt();
        for (int i = 0; i < this.nTriangles; ++i) {
            this.skipTo("<triangle", "vertex");
            this.addTriangleCheck(this.parseInt() - 1, this.parseInt() - 1, this.parseInt() - 1, 7, false, 0);
        }
    }
}

