/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;

class IsoFxyzReader
extends VolumeDataReader {
    private String functionName;
    private float[][][] data;

    IsoFxyzReader(SurfaceGenerator sg) {
        super(sg);
        this.precalculateVoxelData = false;
    }

    protected void setup() {
        this.functionName = (String)this.params.functionXYinfo.get(0);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("functionXYZ\n").append(this.functionName).append("\n");
        this.volumetricOrigin.set((Point3f)this.params.functionXYinfo.get(1));
        for (int i = 0; i < 3; ++i) {
            Point4f info = (Point4f)this.params.functionXYinfo.get(i + 2);
            this.voxelCounts[i] = Math.abs((int)info.x);
            this.volumetricVectors[i].set(info.y, info.z, info.w);
        }
        this.data = (float[][][])this.params.functionXYinfo.get(5);
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    public float getValue(int x, int y, int z) {
        return this.data[x][y][z];
    }
}

