/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.util.Logger;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private float solventRadius;
    private boolean isProperty;
    private boolean doSmoothProperty;
    final Point3f ptXyzTemp = new Point3f();
    final Point3f ptS = new Point3f();

    IsoSolventReader(SurfaceGenerator sg) {
        super(sg);
    }

    protected void setup() {
        super.setup();
        this.cavityRadius = this.params.cavityRadius;
        this.envelopeRadius = this.params.envelopeRadius;
        this.solventRadius = this.params.solventRadius;
        this.point = this.params.point;
        this.isCavity = this.params.isCavity && this.meshDataServer != null;
        this.isPocket = this.params.pocket != null && this.meshDataServer != null;
        this.isProperty = this.dataType == 181;
        this.doSmoothProperty = this.isProperty && this.params.propertySmoothing;
        this.doUseIterator = this.doCalculateTroughs = this.atomDataServer != null && !this.isCavity && this.solventRadius > 0.0f && (this.dataType == 171 || this.dataType == 179);
        this.modelIndex = this.params.modelIndex;
        this.getAtoms(Float.NaN, false, true);
        if (this.isCavity || this.isPocket) {
            this.meshData.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
        }
        this.setHeader("solvent/molecular surface", this.params.calculationType);
        this.setRangesAndAddAtoms(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, this.params.thePlane != null ? Integer.MAX_VALUE : Math.min(this.firstNearbyAtom, 100));
    }

    public void selectPocket(boolean doExclude) {
        int i;
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.fillMeshData(this.meshData, 1);
        Point3f[] v = this.meshData.vertices;
        int nVertices = this.meshData.vertexCount;
        float[] vv = this.meshData.vertexValues;
        Point3f[] dots = this.meshData.dots;
        int nDots = dots.length;
        for (int i2 = 0; i2 < nVertices; ++i2) {
            for (int j = 0; j < nDots; ++j) {
                if (!(dots[j].distance(v[i2]) < this.envelopeRadius)) continue;
                vv[i2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        int nSets = this.meshData.nSets;
        BitSet pocketSet = new BitSet(nSets);
        block2: for (i = 0; i < nSets; ++i) {
            BitSet ss = this.meshData.surfaceSet[i];
            if (ss == null) continue;
            int j = ss.length();
            while (--j >= 0) {
                if (!ss.get(j) || !Float.isNaN(this.meshData.vertexValues[j])) continue;
                pocketSet.set(i);
                continue block2;
            }
        }
        for (i = 0; i < nSets; ++i) {
            if (this.meshData.surfaceSet[i] == null || pocketSet.get(i) != doExclude) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (!doExclude) {
            this.meshData.surfaceSet = null;
        }
        this.meshDataServer.fillMeshData(this.meshData, 3);
        this.meshData = new MeshData();
    }

    protected void generateCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.voxelData = this.voxelData;
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        this.generateSolventCube(true);
        if (this.isCavity && this.dataType != 180 && this.dataType != 181) {
            this.generateSolventCavity();
            this.generateSolventCube(false);
        }
        if (this.params.doCapIsosurface) {
            Logger.info("capping isosurface using " + this.params.cappingPlane);
            this.volumeData.capData(this.params.cappingPlane, this.params.cutoff);
        }
    }

    private void generateSolventCavity() {
        int x;
        BitSet bs = new BitSet(this.nPointsX * this.nPointsY * this.nPointsZ);
        int i = 0;
        int nDots = this.meshData.dots.length;
        int n = 0;
        float r2 = this.envelopeRadius;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                int z = 0;
                while (z < this.nPointsZ) {
                    block9: {
                        float f;
                        float d = this.voxelData[x][y][z];
                        if (f < Float.MAX_VALUE && d >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
                            for (int j = 0; j < nDots; ++j) {
                                if (!(this.meshData.dots[j].distance(this.ptXyzTemp) < r2)) {
                                    continue;
                                }
                                break block9;
                            }
                            bs.set(i);
                            ++n;
                        }
                    }
                    ++z;
                    ++i;
                }
            }
        }
        Logger.info("cavities include " + n + " voxel points");
        this.atomRadius = new float[n];
        this.atomXyz = new Point3f[n];
        int ipt = 0;
        int apt = 0;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    if (!bs.get(ipt++)) continue;
                    this.atomXyz[apt] = new Point3f();
                    this.volumeData.voxelPtToXYZ(x, y, z, this.atomXyz[apt]);
                    this.atomRadius[apt++] = this.voxelData[x][y][z];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n;
    }

    void generateSolventCube(boolean isFirstPass) {
        int x;
        float rA;
        Point3f ptA;
        float value;
        float distance = this.params.distance;
        Point3f ptY0 = new Point3f();
        Point3f ptZ0 = new Point3f();
        Point3i pt0 = new Point3i();
        Point3i pt1 = new Point3i();
        float f = value = this.doSmoothProperty ? Float.NaN : Float.MAX_VALUE;
        if (Logger.debugging) {
            Logger.startTimer();
        }
        for (int x2 = 0; x2 < this.nPointsX; ++x2) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    this.voxelData[x2][y][z] = value;
                }
            }
        }
        if (this.dataType == 180) {
            return;
        }
        int atomCount = this.myAtomCount;
        float[][][] property = null;
        if (this.isProperty) {
            atomCount = this.firstNearbyAtom;
            property = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
            value = this.doSmoothProperty ? 0.0f : Float.NaN;
            for (int x3 = 0; x3 < this.nPointsX; ++x3) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        property[x3][y][z] = value;
                    }
                }
            }
        }
        float maxRadius = 0.0f;
        float r0 = isFirstPass && this.isCavity ? this.cavityRadius : 0.0f;
        boolean isWithin = isFirstPass && distance != Float.MAX_VALUE && this.point != null;
        for (int iAtom = 0; iAtom < atomCount; ++iAtom) {
            ptA = this.atomXyz[iAtom];
            rA = this.atomRadius[iAtom];
            if (rA > maxRadius) {
                maxRadius = rA;
            }
            if (isWithin && (double)ptA.distance(this.point) > (double)(distance + rA) + 0.5) continue;
            boolean isNearby = iAtom >= this.firstNearbyAtom;
            this.setGridLimitsForAtom(ptA, rA + r0, pt0, pt1);
            this.volumeData.voxelPtToXYZ(pt0.x, pt0.y, pt0.z, this.ptXyzTemp);
            for (int i = pt0.x; i < pt1.x; ++i) {
                ptY0.set(this.ptXyzTemp);
                for (int j = pt0.y; j < pt1.y; ++j) {
                    ptZ0.set(this.ptXyzTemp);
                    for (int k = pt0.z; k < pt1.z; ++k) {
                        float v = this.ptXyzTemp.distance(ptA) - rA;
                        if (this.doSmoothProperty) {
                            v = 1.0f / (v + rA);
                            v *= v;
                            v *= v;
                            if (Float.isNaN(this.voxelData[i][j][k])) {
                                this.voxelData[i][j][k] = 0.0f;
                            }
                            float[] fArray = property[i][j];
                            int n = k;
                            fArray[n] = fArray[n] + this.atomProp[iAtom] * v;
                            float[] fArray2 = this.voxelData[i][j];
                            int n2 = k;
                            fArray2[n2] = fArray2[n2] + v;
                        } else if (v < this.voxelData[i][j][k]) {
                            float f2 = this.voxelData[i][j][k] = isNearby || isWithin && this.ptXyzTemp.distance(this.point) > distance ? Float.NaN : v;
                            if (this.isProperty) {
                                property[i][j][k] = this.atomProp[iAtom];
                            }
                        }
                        this.ptXyzTemp.add(this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.set(ptZ0);
                    this.ptXyzTemp.add(this.volumetricVectors[1]);
                }
                this.ptXyzTemp.set(ptY0);
                this.ptXyzTemp.add(this.volumetricVectors[0]);
            }
        }
        if (this.isCavity && isFirstPass) {
            return;
        }
        if (this.doCalculateTroughs) {
            Point3i ptA0 = new Point3i();
            Point3i ptB0 = new Point3i();
            Point3i ptA1 = new Point3i();
            Point3i ptB1 = new Point3i();
            for (int iAtom = 0; iAtom < this.firstNearbyAtom - 1; ++iAtom) {
                if (this.atomNo[iAtom] <= 0) continue;
                ptA = this.atomXyz[iAtom];
                rA = this.atomRadius[iAtom] + this.solventRadius;
                int iatomA = this.atomIndex[iAtom];
                if (isWithin && (double)ptA.distance(this.point) > (double)(distance + rA) + 0.5) continue;
                this.setGridLimitsForAtom(ptA, rA - this.solventRadius, ptA0, ptA1);
                AtomIndexIterator iter = this.atomDataServer.getWithinAtomSetIterator(iatomA, rA + this.solventRadius + maxRadius, this.bsMySelected, true, true);
                while (iter.hasNext()) {
                    float dAB;
                    int iatomB = iter.next();
                    Point3f ptB = this.atomXyz[this.myIndex[iatomB]];
                    float rB = this.atomData.atomRadius[iatomB] + this.solventRadius;
                    if (isWithin && (double)ptB.distance(this.point) > (double)(distance + rB) + 0.5 || this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(ptB)) > 2.0f * rB || (dAB = ptA.distance(ptB)) >= rA + rB) continue;
                    this.setGridLimitsForAtom(ptB, rB - this.solventRadius, ptB0, ptB1);
                    pt0.x = Math.min(ptA0.x, ptB0.x);
                    pt0.y = Math.min(ptA0.y, ptB0.y);
                    pt0.z = Math.min(ptA0.z, ptB0.z);
                    pt1.x = Math.max(ptA1.x, ptB1.x);
                    pt1.y = Math.max(ptA1.y, ptB1.y);
                    pt1.z = Math.max(ptA1.z, ptB1.z);
                    this.volumeData.voxelPtToXYZ(pt0.x, pt0.y, pt0.z, this.ptXyzTemp);
                    for (int i = pt0.x; i < pt1.x; ++i) {
                        ptY0.set(this.ptXyzTemp);
                        for (int j = pt0.y; j < pt1.y; ++j) {
                            ptZ0.set(this.ptXyzTemp);
                            for (int k = pt0.z; k < pt1.z; ++k) {
                                float v;
                                float dVS = this.checkSpecialVoxel(ptA, rA, ptB, rB, dAB, this.ptXyzTemp);
                                if (!Float.isNaN(dVS) && (v = this.solventRadius - dVS) < this.voxelData[i][j][k]) {
                                    this.voxelData[i][j][k] = isWithin && this.ptXyzTemp.distance(this.point) > distance ? Float.NaN : v;
                                }
                                this.ptXyzTemp.add(this.volumetricVectors[2]);
                            }
                            this.ptXyzTemp.set(ptZ0);
                            this.ptXyzTemp.add(this.volumetricVectors[1]);
                        }
                        this.ptXyzTemp.set(ptY0);
                        this.ptXyzTemp.add(this.volumetricVectors[0]);
                    }
                }
            }
        }
        if (this.doSmoothProperty) {
            for (x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (Float.isNaN(this.voxelData[x][y][z])) continue;
                        this.voxelData[x][y][z] = property[x][y][z] / this.voxelData[x][y][z];
                    }
                }
            }
            return;
        }
        if (this.isProperty) {
            this.volumeData.voxelData = property;
            this.setVolumeData(this.volumeData);
            this.initializeVolumetricData();
        }
        if (this.params.thePlane == null) {
            for (x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] != Float.MAX_VALUE) continue;
                        this.voxelData[x][y][z] = Float.NaN;
                    }
                }
            }
        } else {
            value = 0.001f;
            for (x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] < value) continue;
                        this.voxelData[x][y][z] = value;
                    }
                }
            }
        }
        if (Logger.debugging) {
            Logger.checkTimer("solvent surface time");
        }
    }

    void setGridLimitsForAtom(Point3f ptA, float rA, Point3i pt0, Point3i pt1) {
        this.volumeData.xyzToVoxelPt(ptA.x - rA, ptA.y - rA, ptA.z - rA, pt0);
        --pt0.x;
        --pt0.y;
        --pt0.z;
        if (pt0.x < 0) {
            pt0.x = 0;
        }
        if (pt0.y < 0) {
            pt0.y = 0;
        }
        if (pt0.z < 0) {
            pt0.z = 0;
        }
        this.volumeData.xyzToVoxelPt(ptA.x + rA, ptA.y + rA, ptA.z + rA, pt1);
        pt1.x += 2;
        pt1.y += 2;
        pt1.z += 2;
        if (pt1.x >= this.nPointsX) {
            pt1.x = this.nPointsX;
        }
        if (pt1.y >= this.nPointsY) {
            pt1.y = this.nPointsY;
        }
        if (pt1.z >= this.nPointsZ) {
            pt1.z = this.nPointsZ;
        }
    }

    float checkSpecialVoxel(Point3f ptA, float rAS, Point3f ptB, float rBS, float dAB, Point3f ptV) {
        float dAV = ptA.distance(ptV);
        float dBV = ptB.distance(ptV);
        float dVS = Float.NaN;
        float f = rAS / dAV;
        if (f > 1.0f) {
            this.ptS.set(ptA.x + (ptV.x - ptA.x) * f, ptA.y + (ptV.y - ptA.y) * f, ptA.z + (ptV.z - ptA.z) * f);
            if (ptB.distance(this.ptS) < rBS && !this.voxelIsInTrough(dVS = this.solventDistance(ptV, ptA, ptB, rAS, rBS, dAB, dAV, dBV), rAS * rAS, rBS, dAB, dAV, dBV)) {
                return Float.NaN;
            }
            return dVS;
        }
        f = rBS / dBV;
        if (f <= 1.0f) {
            return dVS;
        }
        this.ptS.set(ptB.x + (ptV.x - ptB.x) * f, ptB.y + (ptV.y - ptB.y) * f, ptB.z + (ptV.z - ptB.z) * f);
        if (ptA.distance(this.ptS) < rAS && !this.voxelIsInTrough(dVS = this.solventDistance(ptV, ptB, ptA, rBS, rAS, dAB, dBV, dAV), rAS * rAS, rBS, dAB, dAV, dBV)) {
            return Float.NaN;
        }
        return dVS;
    }

    boolean voxelIsInTrough(float dVS, float rAS2, float rBS, float dAB, float dAV, float dBV) {
        float cosASBf = (rAS2 + rBS * rBS - dAB * dAB) / rBS;
        float cosASVf = (rAS2 + dVS * dVS - dAV * dAV) / dVS;
        return cosASBf < cosASVf;
    }

    float solventDistance(Point3f ptV, Point3f ptA, Point3f ptB, float rAS, float rBS, float dAB, float dAV, float dBV) {
        double angleVAB = Math.acos((dAV * dAV + dAB * dAB - dBV * dBV) / (2.0f * dAV * dAB));
        double angleBAS = Math.acos((dAB * dAB + rAS * rAS - rBS * rBS) / (2.0f * dAB * rAS));
        float dVS = (float)Math.sqrt((double)(rAS * rAS + dAV * dAV) - (double)(2.0f * rAS * dAV) * Math.cos(angleBAS - angleVAB));
        return dVS;
    }
}

