/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class JaguarReader
extends VolumeFileReader {
    private float[] extents = new float[3];

    JaguarReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("Jaguar data\n");
        this.jvxlFileHeaderBuffer.append("\n");
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String atomLine;
        this.atomCount = 0;
        this.negativeAtomCount = false;
        while ((atomLine = this.br.readLine()) != null && atomLine.indexOf("origin=") < 0) {
        }
        String[] tokens = Parser.getTokens(atomLine, 0);
        if (tokens.length == 4 && tokens[0].equals("origin=")) {
            this.volumetricOrigin.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
            JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, "0", "0 " + tokens[1] + " " + tokens[2] + " " + tokens[3], this.jvxlFileHeaderBuffer);
            if (!this.isAngstroms) {
                this.volumetricOrigin.scale(0.5291772f);
            }
        }
    }

    protected void readVoxelVector(int voxelVectorIndex) throws Exception {
        String[] tokens = Parser.getTokens(this.br.readLine());
        this.extents[voxelVectorIndex] = this.parseFloat(tokens[voxelVectorIndex + 1]);
        if (voxelVectorIndex < 2) {
            return;
        }
        tokens = Parser.getTokens(this.br.readLine());
        this.voxelCounts[0] = this.parseInt(tokens[1]);
        this.voxelCounts[1] = this.parseInt(tokens[2]);
        this.voxelCounts[2] = this.parseInt(tokens[3]);
        float factor = this.isAngstroms ? 1.0f : 0.5291772f;
        float d = this.extents[0] / (float)(this.voxelCounts[0] - 1);
        this.volumetricVectors[0].set(d * factor, 0.0f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[0] + " " + d + " 0.0 0.0\n");
        d = this.extents[1] / (float)(this.voxelCounts[1] - 1);
        this.volumetricVectors[1].set(0.0f, d * factor, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[1] + " 0.0 " + d + " 0.0\n");
        d = this.extents[2] / (float)(this.voxelCounts[2] - 1);
        this.volumetricVectors[2].set(0.0f, 0.0f, d * factor);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[2] + " 0.0 0.0 " + d + "\n");
        this.br.readLine();
    }

    protected float nextVoxel() throws Exception {
        float voxelValue;
        if (this.endOfData || (this.line = this.br.readLine()) == null || Float.isNaN(voxelValue = this.parseFloat(this.line))) {
            if (!this.endOfData) {
                Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
            }
            this.endOfData = true;
            return 0.0f;
        }
        return voxelValue;
    }
}

