/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JvxlReader
extends VolumeFileReader {
    private static final String JVXL_VERSION = "2.0";
    public static final int defaultEdgeFractionBase = 35;
    public static final int defaultEdgeFractionRange = 90;
    public static final int defaultColorFractionBase = 35;
    public static final int defaultColorFractionRange = 90;
    private int surfaceDataCount;
    private int edgeDataCount;
    private int colorDataCount;
    private boolean haveContourData;
    private int nThisValue;
    private boolean thisInside;
    private int fractionPtr;
    private String strFractionTemp = "";

    JvxlReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.isXLowToHigh = false;
    }

    protected static void jvxlUpdateInfo(JvxlData jvxlData, String[] title, int nBytes) {
        jvxlData.title = title;
        jvxlData.nBytes = nBytes;
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }

    public static void jvxlUpdateInfoLines(JvxlData jvxlData) {
        jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, false);
        jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, true);
    }

    protected boolean readVolumeData(boolean isMapData) {
        if (!super.readVolumeData(isMapData)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    protected boolean gotoAndReadVoxelData(boolean isMapData) {
        this.initializeVolumetricData();
        if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
            return true;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (this.vertexDataOnly) {
                return true;
            }
            this.readSurfaceData(isMapData);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.edgeDataCount);
            }
            if (this.colorDataCount > 0) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.colorDataCount);
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.getXmlData("jvxlContourData", null, false));
            }
        }
        catch (Exception e) {
            Logger.error(e.toString());
            try {
                this.br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    protected void initializeVoxelData() {
        this.thisInside = !this.params.isContoured;
        this.nThisValue = 0;
    }

    protected void readSurfaceData(boolean isMapDataIgnored) throws Exception {
        this.initializeVoxelData();
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return;
        }
        if (this.params.thePlane == null) {
            super.readSurfaceData(false);
            return;
        }
        this.volumeData.setDataDistanceToPlane(this.params.thePlane);
        this.setVolumeData(this.volumeData);
        this.params.cutoff = 0.0f;
        JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, 0, new StringBuffer());
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer(this.skipComments(false));
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 1";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
        this.line = this.br.readLine();
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 2";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
    }

    protected static boolean jvxlCheckAtomLine(boolean isXLowToHigh, boolean isAngstroms, String strAtomCount, String atomLine, StringBuffer bs) {
        if (strAtomCount != null) {
            int atomCount = Parser.parseInt(strAtomCount);
            if (atomCount == Integer.MIN_VALUE) {
                atomCount = 0;
                atomLine = " " + atomLine.substring(atomLine.indexOf(" ") + 1);
            } else {
                String s = "" + atomCount;
                atomLine = atomLine.substring(atomLine.indexOf(s) + s.length());
            }
            bs.append((isXLowToHigh ? "+" : "-") + Math.abs(atomCount));
        }
        int i = atomLine.indexOf("ANGSTROM");
        if (isAngstroms && i < 0) {
            atomLine = atomLine + " ANGSTROMS";
        } else if (atomLine.indexOf("ANGSTROMS") >= 0) {
            isAngstroms = true;
        }
        i = atomLine.indexOf("BOHR");
        if (!isAngstroms && i < 0) {
            atomLine = atomLine + " BOHR";
        }
        bs.append(atomLine).append('\n');
        return isAngstroms;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.jvxlFileHeaderBuffer.append(this.skipComments(false));
        String atomLine = this.line;
        String[] tokens = Parser.getTokens(atomLine, 0);
        this.isXLowToHigh = false;
        this.negativeAtomCount = true;
        this.atomCount = 0;
        if (tokens[0] != "-0") {
            if (tokens[0].charAt(0) == '+') {
                this.isXLowToHigh = true;
                this.atomCount = this.parseInt(tokens[0].substring(1));
            } else {
                this.atomCount = -this.parseInt(tokens[0]);
            }
        }
        if (this.atomCount == Integer.MIN_VALUE) {
            return;
        }
        this.volumetricOrigin.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
        this.isAngstroms = JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, null, atomLine, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
    }

    protected static void jvxlReadAtoms(BufferedReader br, StringBuffer bs, int atomCount, VolumeData v) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            bs.append(br.readLine() + "\n");
        }
    }

    protected int readExtraLine() throws Exception {
        this.skipComments(true);
        Logger.info("Reading extra JVXL information line: " + this.line);
        int nSurfaces = this.parseInt(this.line);
        this.isJvxl = nSurfaces < 0;
        if (!this.isJvxl) {
            return nSurfaces;
        }
        nSurfaces = -nSurfaces;
        Logger.info("jvxl file surfaces: " + nSurfaces);
        int ich = this.parseInt();
        if (ich == Integer.MIN_VALUE) {
            Logger.info("using default edge fraction base and range");
        } else {
            this.edgeFractionBase = ich;
            this.edgeFractionRange = this.parseInt();
        }
        ich = this.parseInt();
        if (ich == Integer.MIN_VALUE) {
            Logger.info("using default color fraction base and range");
        } else {
            this.colorFractionBase = ich;
            this.colorFractionRange = this.parseInt();
        }
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
        return nSurfaces;
    }

    private void jvxlReadDefinitionLine(boolean showMsg) throws Exception {
        String comment = this.skipComments(true);
        if (showMsg) {
            Logger.info("reading jvxl data set: " + comment + this.line);
        }
        this.haveContourData = comment.indexOf("+contourlines") >= 0;
        this.jvxlCutoff = this.parseFloat(this.line);
        Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        int param1 = this.parseInt();
        int param2 = this.parseInt();
        int param3 = this.parseInt();
        if (param3 == Integer.MIN_VALUE || param3 == -1) {
            param3 = 0;
        }
        if (param1 == -1) {
            try {
                this.params.thePlane = new Point4f(this.parseFloat(), this.parseFloat(), this.parseFloat(), this.parseFloat());
            }
            catch (Exception e) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            Logger.info("JVXL read: {" + this.params.thePlane.x + " " + this.params.thePlane.y + " " + this.params.thePlane.z + " " + this.params.thePlane.w + "}");
            if (param2 == -1 && param3 < 0) {
                param3 = -param3;
            }
        } else {
            this.params.thePlane = null;
        }
        if (param1 < 0 && param2 != -1) {
            this.params.isContoured = param3 != 0;
            int nContoursRead = this.parseInt();
            if (nContoursRead != Integer.MIN_VALUE) {
                if (nContoursRead < 0) {
                    nContoursRead = -1 - nContoursRead;
                    this.params.contourFromZero = false;
                }
                if (nContoursRead != 0 && this.params.nContours == 0) {
                    this.params.nContours = nContoursRead;
                    Logger.info("JVXL read: contours " + this.params.nContours);
                }
            }
        } else {
            this.params.isContoured = false;
        }
        this.jvxlDataIsPrecisionColor = param1 == -1 && param2 == -2 || param3 < 0;
        this.params.isBicolorMap = param1 > 0 && param2 < 0;
        this.jvxlDataIsColorMapped = param3 != 0;
        boolean bl = this.jvxlDataIs2dContour = this.jvxlDataIsColorMapped && this.params.isContoured;
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        int n = param1 < -1 ? -1 - param1 : (this.surfaceDataCount = param1 > 0 ? param1 : 0);
        if (param1 == -1) {
            this.edgeDataCount = 0;
        } else {
            int n2 = param2 < -1 ? -param2 : (this.edgeDataCount = param2 > 0 ? param2 : 0);
        }
        int n3 = this.params.isBicolorMap ? -param2 : (param3 < -1 ? -param3 : (this.colorDataCount = param3 > 0 ? param3 : 0));
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.jvxlDataIsColorMapped) {
            float dataMin = this.parseFloat();
            float dataMax = this.parseFloat();
            float red = this.parseFloat();
            float blue = this.parseFloat();
            if (!Float.isNaN(dataMin) && !Float.isNaN(dataMax)) {
                if (dataMax == 0.0f && dataMin == 0.0f) {
                    dataMin = -1.0f;
                    dataMax = 1.0f;
                }
                this.params.mappedDataMin = dataMin;
                this.params.mappedDataMax = dataMax;
                Logger.info("JVXL read: data min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(red) && !Float.isNaN(blue)) {
                    if (red == 0.0f && blue == 0.0f) {
                        red = -1.0f;
                        blue = 1.0f;
                    }
                    this.params.valueMappedToRed = red;
                    this.params.valueMappedToBlue = blue;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        boolean bl2 = this.jvxlData.insideOut = this.line.indexOf("insideOut") >= 0;
        if (this.params.insideOut) {
            this.jvxlData.insideOut = !this.jvxlData.insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
    }

    private String jvxlReadData(String type, int nPoints) {
        String str = "";
        try {
            while (str.length() < nPoints) {
                this.line = this.br.readLine();
                str = str + JvxlReader.jvxlUncompressString(this.line);
            }
        }
        catch (Exception e) {
            Logger.error("Error reading " + type + " data " + e);
            throw new NullPointerException();
        }
        return str;
    }

    public static String jvxlCompressString(String data) {
        StringBuffer dataOut = new StringBuffer();
        char chLast = '\u0000';
        data = data + '\u0000';
        int nLast = 0;
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '\n' || ch == '\r') continue;
            if (ch == chLast) {
                ++nLast;
                if (ch != '~') {
                    ch = '\u0000';
                }
            } else if (nLast > 0) {
                if (nLast < 4 || chLast == '~' || chLast == ' ' || chLast == '\t') {
                    while (--nLast >= 0) {
                        dataOut.append(chLast);
                    }
                } else {
                    dataOut.append("~" + nLast + " ");
                }
                nLast = 0;
            }
            if (ch == '\u0000') continue;
            dataOut.append(ch);
            chLast = ch;
        }
        return dataOut.toString();
    }

    private static String jvxlUncompressString(String data) {
        if (data.indexOf("~") < 0) {
            return data;
        }
        StringBuffer dataOut = new StringBuffer();
        char chLast = '\u0000';
        int[] next = new int[1];
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '~') {
                next[0] = ++i;
                int nChar = Parser.parseInt(data, next);
                if (nChar == Integer.MIN_VALUE) {
                    if (chLast == '~') {
                        dataOut.append('~');
                        while ((ch = data.charAt(++i)) == '~') {
                            dataOut.append('~');
                        }
                        continue;
                    }
                    Logger.error("Error uncompressing string " + data.substring(0, i) + "?");
                    continue;
                }
                for (int c = 0; c < nChar; ++c) {
                    dataOut.append(chLast);
                }
                i = next[0];
                continue;
            }
            dataOut.append(ch);
            chLast = ch;
        }
        return dataOut.toString();
    }

    protected BitSet getVoxelBitSet(int nPoints) throws Exception {
        BitSet bs = new BitSet();
        if (this.surfaceDataCount <= 0) {
            return bs;
        }
        int nThisValue = 0;
        for (int bsVoxelPtr = 0; bsVoxelPtr < nPoints; bsVoxelPtr += nThisValue) {
            nThisValue = this.parseInt();
            if (nThisValue == Integer.MIN_VALUE) {
                this.line = this.br.readLine();
                if (this.line == null || (nThisValue = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    nThisValue = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (!this.thisInside) continue;
            bs.set(bsVoxelPtr, bsVoxelPtr + nThisValue);
        }
        return bs;
    }

    protected float getNextVoxelValue(StringBuffer sb) throws Exception {
        if (this.surfaceDataCount <= 0) {
            return 0.0f;
        }
        while (this.nThisValue == 0) {
            this.nThisValue = this.parseInt();
            if (this.nThisValue == Integer.MIN_VALUE) {
                this.line = this.br.readLine();
                if (this.line == null || (this.nThisValue = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    this.nThisValue = 10000;
                } else if (sb != null) {
                    sb.append(this.line).append('\n');
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
        }
        --this.nThisValue;
        return this.thisInside ? 1.0f : 0.0f;
    }

    public static void setSurfaceInfoFromBitSet(JvxlData jvxlData, BitSet bs, Point4f thePlane) {
        StringBuffer sb = new StringBuffer();
        int nPoints = jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ;
        int nSurfaceInts = JvxlReader.jvxlEncodeBitSet(bs, nPoints, sb);
        JvxlReader.setSurfaceInfo(jvxlData, thePlane, nSurfaceInts, sb);
    }

    private static int jvxlEncodeBitSet(BitSet bs, int nPoints, StringBuffer sb) {
        int dataCount = 0;
        int n = 0;
        boolean isset = false;
        for (int i = 0; i < nPoints; ++i) {
            if (isset == bs.get(i)) {
                ++dataCount;
                continue;
            }
            sb.append(' ').append(dataCount);
            ++n;
            dataCount = 1;
            isset = !isset;
        }
        sb.append(' ').append(dataCount).append('\n');
        return n;
    }

    private static BitSet jvxlDecodeBitSet(String data) {
        BitSet bs = new BitSet();
        int dataCount = 0;
        int ptr = 0;
        boolean isset = false;
        int[] next = new int[1];
        while ((dataCount = Parser.parseInt(data, next)) != Integer.MIN_VALUE) {
            if (isset) {
                bs.set(ptr, ptr + dataCount);
            }
            ptr += dataCount;
            isset = !isset;
        }
        return bs;
    }

    protected static void setSurfaceInfo(JvxlData jvxlData, Point4f thePlane, int nSurfaceInts, StringBuffer surfaceData) {
        jvxlData.jvxlSurfaceData = surfaceData.toString();
        if (jvxlData.jvxlSurfaceData.indexOf("--") == 0) {
            jvxlData.jvxlSurfaceData = jvxlData.jvxlSurfaceData.substring(2);
        }
        jvxlData.jvxlPlane = thePlane;
        jvxlData.nSurfaceInts = nSurfaceInts;
    }

    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, Point3f pointA, Vector3f edgeVector, float[] fReturn, Point3f ptReturn) {
        if (this.edgeDataCount <= 0) {
            return super.getSurfacePointAndFraction(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, fReturn, ptReturn);
        }
        fReturn[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        ptReturn.scaleAdd(fReturn[0], edgeVector, pointA);
        return fReturn[0];
    }

    private float jvxlGetNextFraction(int base, int range, float fracOffset) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)base;
            this.fractionPtr = 0;
        }
        return JvxlReader.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), base, range, fracOffset);
    }

    protected String readColorData() {
        this.fractionPtr = 0;
        int vertexCount = this.jvxlData.vertexCount = this.meshData.vertexCount;
        short[] colixes = this.meshData.vertexColixes;
        float[] vertexValues = this.meshData.vertexValues;
        String string = this.strFractionTemp = this.isJvxl ? this.jvxlColorDataRead : "";
        if (this.isJvxl && this.strFractionTemp.length() == 0) {
            Logger.error("You cannot use JVXL data to map onto OTHER data, because it only contains the data for one surface. Use ISOSURFACE \"file.jvxl\" not ISOSURFACE .... MAP \"file.jvxl\".");
            return "";
        }
        this.fractionPtr = 0;
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + vertexCount + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlDataIsPrecisionColor);
        float min = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin;
        float range = (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax) - min;
        float colorRange = this.params.valueMappedToBlue - this.params.valueMappedToRed;
        float contourPlaneMinimumValue = Float.MAX_VALUE;
        float contourPlaneMaximumValue = -3.4028235E38f;
        if (colixes == null || colixes.length < vertexCount) {
            this.meshData.vertexColixes = colixes = new short[vertexCount];
        }
        String data = this.jvxlColorDataRead;
        int cpt = 0;
        short colixNeg = 0;
        short colixPos = 0;
        if (this.params.colorBySign) {
            colixPos = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            colixNeg = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int vertexIncrement = this.meshData.vertexIncrement;
        for (int i = 0; i < vertexCount; i += vertexIncrement) {
            float value;
            float fraction;
            if (this.jvxlDataIsPrecisionColor) {
                fraction = JvxlReader.jvxlFractionFromCharacter2(data.charAt(cpt), data.charAt(cpt + vertexCount), this.colorFractionBase, this.colorFractionRange);
                value = min + fraction * range;
            } else {
                fraction = JvxlReader.jvxlFractionFromCharacter(data.charAt(cpt), this.colorFractionBase, this.colorFractionRange, 0.5f);
                value = this.params.valueMappedToRed + fraction * colorRange;
            }
            vertexValues[i] = value;
            ++cpt;
            if (value < contourPlaneMinimumValue) {
                contourPlaneMinimumValue = value;
            }
            if (value > contourPlaneMaximumValue) {
                contourPlaneMaximumValue = value;
            }
            if (this.params.isContoured) {
                this.marchingSquares.setContourData(i, value);
                continue;
            }
            colixes[i] = this.params.colorBySign ? ((this.params.isColorReversed ? value > 0.0f : value <= 0.0f) ? colixNeg : colixPos) : this.getColorIndexFromPalette(value);
        }
        if (this.params.mappedDataMin == Float.MAX_VALUE) {
            this.params.mappedDataMin = contourPlaneMinimumValue;
            this.params.mappedDataMax = contourPlaneMaximumValue;
        }
        return data + "\n";
    }

    protected void gotoData(int n, int nPoints) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + nPoints + " points each");
        }
        this.jvxlData.vertexDataOnly = nPoints == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlReadDefinitionLine(true);
            Logger.info("JVXL skipping: jvxlSurfaceDataCount=" + this.surfaceDataCount + " jvxlEdgeDataCount=" + this.edgeDataCount + " jvxlDataIsColorMapped=" + this.jvxlDataIsColorMapped);
            this.jvxlSkipData(nPoints, true);
        }
        this.jvxlReadDefinitionLine(true);
    }

    private void jvxlSkipData(int nPoints, boolean doSkipColorData) throws Exception {
        if (this.surfaceDataCount > 0) {
            this.jvxlSkipDataBlock(nPoints, true);
        }
        if (this.edgeDataCount > 0) {
            this.jvxlSkipDataBlock(this.edgeDataCount, false);
        }
        if (this.jvxlDataIsColorMapped && doSkipColorData) {
            this.jvxlSkipDataBlock(this.colorDataCount, false);
        }
    }

    private void jvxlSkipDataBlock(int nPoints, boolean isInt) throws Exception {
        for (int n = 0; n < nPoints; n += isInt ? this.countData(this.line) : JvxlReader.jvxlUncompressString(this.line).length()) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String str) {
        int count = 0;
        int n = this.parseInt(str);
        while (n != Integer.MIN_VALUE) {
            count += n;
            n = this.parseIntNext(str);
        }
        return count;
    }

    protected static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData v, StringBuffer bs) {
        JvxlReader.jvxlCreateHeader(v, Integer.MAX_VALUE, null, null, bs);
    }

    protected static void jvxlCreateHeader(VolumeData v, int nAtoms, Point3f[] atomXyz, int[] atomNo, StringBuffer sb) {
        int i;
        if (sb.length() == 0) {
            sb.append("Line 1\nLine 2\n");
        }
        sb.append(nAtoms == Integer.MAX_VALUE ? -2 : -nAtoms).append(' ').append(v.volumetricOrigin.x).append(' ').append(v.volumetricOrigin.y).append(' ').append(v.volumetricOrigin.z).append(" ANGSTROMS\n");
        for (i = 0; i < 3; ++i) {
            sb.append(v.voxelCounts[i]).append(' ').append(v.volumetricVectors[i].x).append(' ').append(v.volumetricVectors[i].y).append(' ').append(v.volumetricVectors[i].z).append('\n');
        }
        if (nAtoms == Integer.MAX_VALUE) {
            JvxlReader.jvxlAddDummyAtomList(v, sb);
            return;
        }
        nAtoms = Math.abs(nAtoms);
        int n = 0;
        for (i = 0; i < nAtoms; ++i) {
            n = Math.abs(atomNo[i]);
            sb.append(n + " " + n + ".0 " + atomXyz[i].x + " " + atomXyz[i].y + " " + atomXyz[i].z + "\n");
        }
    }

    private static void jvxlAddDummyAtomList(VolumeData v, StringBuffer bs) {
        Point3f pt = new Point3f(v.volumetricOrigin);
        bs.append("1 1.0 ").append(pt.x).append(' ').append(pt.y).append(' ').append(pt.z).append(" //BOGUS H ATOM ADDED FOR JVXL FORMAT\n");
        for (int i = 0; i < 3; ++i) {
            pt.scaleAdd(v.voxelCounts[i] - 1, v.volumetricVectors[i], pt);
        }
        bs.append("2 2.0 ").append(pt.x).append(' ').append(pt.y).append(' ').append(pt.z).append(" //BOGUS He ATOM ADDED FOR JVXL FORMAT\n");
    }

    public static String jvxlGetDefinitionLine(JvxlData jvxlData, boolean isInfo) {
        float min;
        String definitionLine = (jvxlData.vContours == null ? "" : "#+contourlines\n") + jvxlData.cutoff + " ";
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        StringBuffer info = new StringBuffer();
        int nSurfaceInts = jvxlData.nSurfaceInts;
        int bytesUncompressedEdgeData = jvxlData.vertexDataOnly ? 0 : jvxlData.jvxlEdgeData.length() - 1;
        int nColorData = jvxlData.jvxlColorData.length() - 1;
        if (isInfo && !jvxlData.vertexDataOnly) {
            info.append("\n  cutoff=\"" + jvxlData.cutoff + "\"");
            info.append("\n  pointsPerAngstrom=\"" + jvxlData.pointsPerAngstrom + "\"");
            info.append("\n  nSurfaceInts=\"" + nSurfaceInts + "\"");
            info.append("\n  nBytesData=\"" + (jvxlData.jvxlSurfaceData.length() + bytesUncompressedEdgeData + jvxlData.jvxlColorData.length()) + "\"");
        }
        if (jvxlData.jvxlPlane == null) {
            if (jvxlData.isContoured) {
                if (isInfo) {
                    info.append("\n  contoured=\"true\"");
                } else {
                    definitionLine = definitionLine + (-1 - nSurfaceInts) + " " + bytesUncompressedEdgeData;
                }
            } else if (jvxlData.isBicolorMap) {
                if (isInfo) {
                    info.append("\n  bicolorMap=\"true\"");
                } else {
                    definitionLine = definitionLine + nSurfaceInts + " " + -bytesUncompressedEdgeData;
                }
            } else if (!isInfo) {
                definitionLine = definitionLine + nSurfaceInts + " " + bytesUncompressedEdgeData;
            } else if (nColorData > 0) {
                info.append("\n  colorMapped=\"true\"");
            }
            if (!isInfo) {
                definitionLine = definitionLine + " " + (jvxlData.isJvxlPrecisionColor && nColorData != -1 ? -nColorData : nColorData);
            }
        } else {
            String s = " " + jvxlData.jvxlPlane.x + " " + jvxlData.jvxlPlane.y + " " + jvxlData.jvxlPlane.z + " " + jvxlData.jvxlPlane.w;
            if (!isInfo) {
                definitionLine = definitionLine + (jvxlData.isContoured ? "-1 -2 " + -nColorData : "-1 -1 " + nColorData) + s;
            } else if (nColorData > 0) {
                info.append("\n  colorMapped=\"true\"");
            }
            if (isInfo) {
                info.append("\n  plane=\"{ " + s + " }\"");
            }
        }
        if (jvxlData.isContoured) {
            if (isInfo) {
                info.append("\n  nContours=\"" + Math.abs(jvxlData.nContours) + "\"");
            } else {
                definitionLine = definitionLine + " " + jvxlData.nContours;
            }
        }
        float f = min = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        if (!isInfo) {
            definitionLine = definitionLine + " " + min + " " + jvxlData.mappedDataMax + " " + jvxlData.valueMappedToRed + " " + jvxlData.valueMappedToBlue;
        }
        if (isInfo && jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            info.append("\n  dataMinimum=\"" + min + "\"");
            info.append("\n  dataMaximum=\"" + jvxlData.mappedDataMax + "\"");
            info.append("\n  valueMappedToRed=\"" + jvxlData.valueMappedToRed + "\"");
            info.append("\n  valueMappedToBlue=\"" + jvxlData.valueMappedToBlue + "\"");
        }
        if (isInfo && jvxlData.jvxlCompressionRatio > 0) {
            info.append("\n  approximateCompressionRatio=\"" + jvxlData.jvxlCompressionRatio + ":1\"");
        }
        if (isInfo && jvxlData.isXLowToHigh) {
            info.append("\n  note=\"progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")\"");
        }
        if (jvxlData.insideOut) {
            if (isInfo) {
                info.append("\n  insideOut=\"true\"");
            } else {
                definitionLine = definitionLine + " insideOut";
            }
        }
        if (!isInfo) {
            return definitionLine;
        }
        info.append("\n  precisionColor=\"" + jvxlData.isJvxlPrecisionColor + "\"");
        info.append("\n  nColorData=\"" + nColorData + "\"");
        info.append("\n  version=\"" + jvxlData.version + "\"");
        return "<jvxlSurfaceInfo>" + info.toString() + "\n</jvxlSurfaceInfo>";
    }

    protected static String jvxlExtraLine(JvxlData jvxlData, int n) {
        return -n + " " + jvxlData.edgeFractionBase + " " + jvxlData.edgeFractionRange + " " + jvxlData.colorFractionBase + " " + jvxlData.colorFractionRange + " Jmol voxel format version " + JVXL_VERSION + "\n";
    }

    public static String jvxlGetFile(MeshDataServer meshDataServer, JvxlData jvxlData, MeshData meshData, String[] title, String msg, boolean includeHeader, int nSurfaces, String state, String comment) {
        StringBuffer data = new StringBuffer();
        if (includeHeader) {
            String s = jvxlData.jvxlFileHeader + (nSurfaces > 0 ? -nSurfaces + jvxlData.jvxlExtraLine.substring(2) : jvxlData.jvxlExtraLine);
            if (s.indexOf("#JVXL") != 0) {
                data.append("#JVXL").append(jvxlData.isXLowToHigh ? "+" : "").append(" VERSION ").append(JVXL_VERSION).append("\n");
            }
            data.append(s);
        }
        data.append("# ").append(msg).append('\n');
        if (title != null) {
            for (int i = 0; i < title.length; ++i) {
                data.append("# ").append(title[i]).append('\n');
            }
        }
        data.append(jvxlData.jvxlDefinitionLine + " rendering:" + state).append('\n');
        StringBuffer sb = new StringBuffer();
        if (jvxlData.vertexDataOnly && meshData != null) {
            int[] vertexIdNew = new int[meshData.vertexCount];
            sb.append("<jvxlSurfaceData>\n");
            sb.append(JvxlReader.jvxlEncodeTriangleData(meshData.polygonIndexes, meshData.polygonCount, vertexIdNew));
            sb.append(JvxlReader.jvxlEncodeVertexData(meshDataServer, jvxlData, vertexIdNew, meshData.vertices, meshData.vertexValues, meshData.vertexCount, meshData.polygonColixes, meshData.polygonCount, jvxlData.jvxlColorData.length() > 0));
            sb.append("</jvxlSurfaceData>\n");
        } else if (jvxlData.jvxlPlane == null) {
            sb.append(jvxlData.jvxlSurfaceData);
            sb.append(JvxlReader.jvxlCompressString(jvxlData.jvxlEdgeData)).append('\n').append(JvxlReader.jvxlCompressString(jvxlData.jvxlColorData)).append('\n');
        } else {
            sb.append(JvxlReader.jvxlCompressString(jvxlData.jvxlColorData)).append('\n');
        }
        int len = sb.length();
        if (len > 0) {
            jvxlData.jvxlCompressionRatio = jvxlData.wasCubic && jvxlData.nBytes > 0 ? (int)((float)jvxlData.nBytes / (float)len) : (int)((float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)len);
        }
        data.append(sb);
        if (msg != null && !jvxlData.vertexDataOnly) {
            data.append("#-------end of jvxl file data-------\n");
        }
        data.append(jvxlData.jvxlInfoLine).append('\n');
        if (jvxlData.vContours != null) {
            data.append("<jvxlContourData>\n");
            JvxlReader.jvxlEncodeContourData(jvxlData.vContours, data);
            data.append("</jvxlContourData>\n");
        }
        if (comment != null) {
            data.append("<jvxlSurfaceCommand>\n  ").append(comment).append("\n</jvxlSurfaceCommand>\n");
        }
        if (state != null) {
            data.append("<jvxlSurfaceState>\n  ").append(state).append("\n</jvxlSurfaceState>\n");
        }
        if (includeHeader) {
            data.append("<jvxlFileTitle>\n").append(jvxlData.jvxlFileTitle).append("</jvxlFileTitle>\n");
        }
        return data.toString();
    }

    private static void jvxlEncodeContourData(Vector[] contours, StringBuffer sb) {
        for (int i = 0; i < contours.length; ++i) {
            if (contours[i].size() < 5) continue;
            int nPolygons = (Integer)contours[i].get(0);
            sb.append("<jvxlContour i=\"" + i + "\"");
            sb.append(" value=\"" + contours[i].get(2) + "\"");
            sb.append(" color=\"" + Escape.escapeColor(((int[])contours[i].get(3))[0]) + "\"");
            sb.append(" npolygons=\"" + nPolygons + "\"");
            StringBuffer sb1 = new StringBuffer();
            JvxlReader.jvxlEncodeBitSet((BitSet)contours[i].get(1), nPolygons, sb1);
            sb.append(" data=\"" + contours[i].get(4) + "\">\n");
            sb.append(sb1);
            sb.append("</jvxlContour>\n");
        }
    }

    protected static float jvxlFractionFromCharacter(int ich, int base, int range, float fracOffset) {
        float fraction;
        if (ich == base + range) {
            return Float.NaN;
        }
        if (ich < base) {
            ich = 92;
        }
        if ((fraction = ((float)(ich - base) + fracOffset) / (float)range) < 0.0f) {
            return 0.0f;
        }
        if (fraction > 1.0f) {
            return 0.999999f;
        }
        return fraction;
    }

    protected static float jvxlValueFromCharacter2(int ich, int ich2, float min, float max, int base, int range) {
        float fraction = JvxlReader.jvxlFractionFromCharacter2(ich, ich2, base, range);
        return max == min ? fraction : min + fraction * (max - min);
    }

    protected static float jvxlFractionFromCharacter2(int ich1, int ich2, int base, int range) {
        float fraction = JvxlReader.jvxlFractionFromCharacter(ich1, base, range, 0.0f);
        float remains = JvxlReader.jvxlFractionFromCharacter(ich2, base, range, 0.5f);
        return fraction + remains / (float)range;
    }

    protected static char jvxlValueAsCharacter(float value, float min, float max, int base, int range) {
        float fraction = min == max ? value : (value - min) / (max - min);
        return JvxlReader.jvxlFractionAsCharacter(fraction, base, range);
    }

    public static char jvxlFractionAsCharacter(float fraction) {
        return JvxlReader.jvxlFractionAsCharacter(fraction, 35, 90);
    }

    protected static char jvxlFractionAsCharacter(float fraction, int base, int range) {
        if (fraction > 0.9999f) {
            fraction = 0.9999f;
        } else if (Float.isNaN(fraction)) {
            fraction = 1.0001f;
        }
        int ich = (int)(fraction * (float)range + (float)base);
        if (ich < base) {
            return (char)base;
        }
        if (ich == 92) {
            return '!';
        }
        return (char)ich;
    }

    private static void jvxlAppendCharacter2(float value, float min, float max, int base, int range, StringBuffer list1, StringBuffer list2) {
        float fraction = min == max ? value : (value - min) / (max - min);
        char ch1 = JvxlReader.jvxlFractionAsCharacter(fraction, base, range);
        list1.append(ch1);
        list2.append(JvxlReader.jvxlFractionAsCharacter((fraction -= JvxlReader.jvxlFractionFromCharacter(ch1, base, range, 0.0f)) * (float)range, base, range));
    }

    public static void jvxlUpdateSurfaceData(JvxlData jvxlData, float[] vertexValues, int vertexCount, int vertexIncrement, char isNaN) {
        char[] chars = jvxlData.jvxlEdgeData.toCharArray();
        int i = 0;
        int ipt = 0;
        while (i < vertexCount) {
            if (Float.isNaN(vertexValues[i])) {
                chars[ipt] = isNaN;
            }
            i += vertexIncrement;
            ++ipt;
        }
        jvxlData.jvxlEdgeData = String.copyValueOf(chars);
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] vertexValues) {
        if (vertexValues == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean writePrecisionColor = jvxlData.isJvxlPrecisionColor;
        boolean doTruncate = jvxlData.isTruncated;
        int colorFractionBase = jvxlData.colorFractionBase;
        int colorFractionRange = jvxlData.colorFractionRange;
        float valueBlue = jvxlData.valueMappedToBlue;
        float valueRed = jvxlData.valueMappedToRed;
        int vertexCount = jvxlData.vertexCount;
        float min = jvxlData.mappedDataMin;
        float max = jvxlData.mappedDataMax;
        StringBuffer list1 = new StringBuffer();
        StringBuffer list2 = new StringBuffer();
        for (int i = 0; i < vertexCount; ++i) {
            float value = vertexValues[i];
            if (doTruncate) {
                float f = value = value > 0.0f ? 0.999f : -0.999f;
            }
            if (writePrecisionColor) {
                JvxlReader.jvxlAppendCharacter2(value, min, max, colorFractionBase, colorFractionRange, list1, list2);
                continue;
            }
            list1.append(JvxlReader.jvxlValueAsCharacter(value, valueRed, valueBlue, colorFractionBase, colorFractionRange));
        }
        jvxlData.jvxlColorData = list1.append(list2).append('\n').toString();
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }

    public static String jvxlEncodeTriangleData(int[][] triangles, int nData, int[] vertexIdNew) {
        StringBuffer list = new StringBuffer();
        StringBuffer list1 = new StringBuffer();
        int ilast = 1;
        int p = 0;
        int inew = 0;
        boolean addPlus = false;
        int i = 0;
        while (i < nData) {
            int idata = triangles[i][p];
            idata = vertexIdNew[idata] > 0 ? vertexIdNew[idata] : (vertexIdNew[idata] = ++inew);
            if (++p % 3 == 0) {
                ++i;
                p = 0;
            }
            int diff = idata - ilast;
            ilast = idata;
            if (diff == 0) {
                list1.append('!');
                addPlus = false;
                continue;
            }
            if (diff > 32) {
                if (addPlus) {
                    list1.append('+');
                }
                list1.append(diff);
                addPlus = true;
                continue;
            }
            if (diff < -32) {
                list1.append(diff);
                addPlus = true;
                continue;
            }
            list1.append((char)(92 + diff));
            addPlus = false;
        }
        return list.append("  <jvxlTriangleData len=\"" + list1.length() + "\" count=\"" + nData + "\">\n    ").append(list1).append("\n  </jvxlTriangleData>\n").toString();
    }

    public static String jvxlEncodeVertexData(MeshDataServer meshDataServer, JvxlData jvxlData, int[] vertexIdNew, Point3f[] vertices, float[] vertexValues, int vertexCount, short[] polygonColixes, int polygonCount, boolean addColorData) {
        int i;
        Point3f p;
        Point3f min = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f max = new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        int colorFractionBase = jvxlData.colorFractionBase;
        int colorFractionRange = jvxlData.colorFractionRange;
        for (int i2 = 0; i2 < vertexCount; ++i2) {
            p = vertices[i2];
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (!(p.z > max.z)) continue;
            max.z = p.z;
        }
        StringBuffer list = new StringBuffer();
        StringBuffer list1 = new StringBuffer();
        StringBuffer list2 = new StringBuffer();
        int[] vertexIdOld = new int[vertexCount];
        for (i = 0; i < vertexCount; ++i) {
            if (vertexIdNew[i] <= 0) continue;
            vertexIdOld[vertexIdNew[i] - 1] = i;
        }
        for (i = 0; i < vertexCount; ++i) {
            p = vertices[vertexIdOld[i]];
            JvxlReader.jvxlAppendCharacter2(p.x, min.x, max.x, colorFractionBase, colorFractionRange, list1, list2);
            JvxlReader.jvxlAppendCharacter2(p.y, min.y, max.y, colorFractionBase, colorFractionRange, list1, list2);
            JvxlReader.jvxlAppendCharacter2(p.z, min.z, max.z, colorFractionBase, colorFractionRange, list1, list2);
        }
        list1.append(list2);
        list.append("  <jvxlVertexData len=\"" + list1.length() + "\" count=\"" + vertexCount + "\" min=\"" + min + "\" max=\"" + max + "\">\n    ");
        list.append(list1).append("\n  </jvxlVertexData>\n");
        if (polygonColixes != null) {
            list1 = new StringBuffer();
            int count = 0;
            short colix = 0;
            boolean done = false;
            int i3 = 0;
            while (true) {
                if (i3 >= polygonCount) {
                    done = true;
                    if (!true) break;
                }
                if (done || polygonColixes[i3] != colix) {
                    if (count != 0) {
                        list1.append(" ").append(count).append(" ").append(colix == 0 ? 0 : meshDataServer.getColixArgb(colix));
                    }
                    if (done) break;
                    colix = polygonColixes[i3];
                    count = 1;
                } else {
                    ++count;
                }
                ++i3;
            }
            list.append("  <jvxlPolygonColorData len=\"" + list1.length() + "\" count=\"" + polygonCount + "\">\n    ").append(list1).append("\n  </jvxlPolygonColorData>\n");
        }
        if (!addColorData) {
            return list.toString();
        }
        list1 = new StringBuffer();
        list2 = new StringBuffer();
        for (i = 0; i < vertexCount; ++i) {
            float value = vertexValues[vertexIdOld[i]];
            JvxlReader.jvxlAppendCharacter2(value, jvxlData.mappedDataMin, jvxlData.mappedDataMax, colorFractionBase, colorFractionRange, list1, list2);
        }
        String s = JvxlReader.jvxlCompressString(list1.append(list2).toString());
        return list.append("  <jvxlColorData len=\"" + s.length() + "\" count=\"" + vertexCount + "\" compressed=\"1\" precision=\"true\">\n    ").append(s).append("\n  </jvxlColorData>\n").toString();
    }

    private void getEncodedVertexData() throws Exception {
        String data = this.getXmlData("jvxlSurfaceData", null, true);
        this.jvxlDecodeVertexData(this.getXmlData("jvxlVertexData", data, true), false);
        String polygonColorData = this.getXmlData("jvxlPolygonColorData", data, false);
        this.jvxlDecodeTriangleData(this.getXmlData("jvxlTriangleData", data, true), polygonColorData, false);
        Logger.info("Checking for vertex values");
        this.jvxlColorDataRead = JvxlReader.jvxlUncompressString(this.getXmlData("jvxlColorData", data, false));
        this.jvxlDataIsColorMapped = this.jvxlColorDataRead.length() > 0;
        this.jvxlDataIsPrecisionColor = data.indexOf("precision=\"true\"") >= 0;
        this.jvxlDecodeContourData(this.getXmlData("jvxlContourData", null, false));
        Logger.info("Done");
    }

    private void jvxlDecodeContourData(String data) throws Exception {
        Vector vs = new Vector();
        int pt = -1;
        this.vContours = null;
        if (data == null) {
            return;
        }
        while ((pt = data.indexOf("<jvxlContour", pt + 1)) >= 0) {
            Vector v = new Vector();
            String s = this.getXmlData("jvxlContour", data.substring(pt), true);
            int n = this.parseInt(JvxlReader.getXmlAttrib(s, "npolygons"));
            float value = this.parseFloat(JvxlReader.getXmlAttrib(s, "value"));
            int color = Escape.unescapeColor(JvxlReader.getXmlAttrib(s, "color"));
            String fData = JvxlReader.getXmlAttrib(s, "data");
            BitSet bs = JvxlReader.jvxlDecodeBitSet(s.substring(s.lastIndexOf("\">") + 2));
            IsosurfaceMesh.setContourVector(v, n, bs, value, color, new StringBuffer(fData));
            vs.add(v);
        }
        this.vContours = new Vector[vs.size()];
        for (int i = 0; i < vs.size(); ++i) {
            this.vContours[i] = (Vector)vs.get(i);
        }
    }

    public static void set3dContourVector(Vector v, int[][] polygonIndexes, Point3f[] vertices) {
        if (v.size() < 5) {
            return;
        }
        String fData = ((StringBuffer)v.get(4)).toString();
        BitSet bs = (BitSet)v.get(1);
        int nPolygons = (Integer)v.get(0);
        int pt = 0;
        for (int i = 0; i < nPolygons; ++i) {
            int i4;
            int i2;
            int i3;
            int i1;
            if (!bs.get(i)) continue;
            int[] vertexIndexes = polygonIndexes[i];
            int type = fData.charAt(pt++) - 48;
            char c1 = fData.charAt(pt++);
            char c2 = fData.charAt(pt++);
            float f1 = JvxlReader.jvxlFractionFromCharacter(c1, 35, 90, 0.0f);
            float f2 = JvxlReader.jvxlFractionFromCharacter(c2, 35, 90, 0.0f);
            if ((type & 1) == 0) {
                i1 = vertexIndexes[1];
                i2 = i3 = vertexIndexes[2];
                i4 = vertexIndexes[0];
            } else {
                i1 = vertexIndexes[0];
                i2 = vertexIndexes[1];
                if ((type & 2) != 0) {
                    i3 = i2;
                    i4 = vertexIndexes[2];
                } else {
                    i3 = vertexIndexes[2];
                    i4 = i1;
                }
            }
            Point3f pa = IsosurfaceMesh.getContourPoint(vertices, i1, i2, f1);
            Point3f pb = IsosurfaceMesh.getContourPoint(vertices, i3, i4, f2);
            v.add(pa);
            v.add(pb);
        }
        v.add(new Point3f(Float.NaN, Float.NaN, Float.NaN));
    }

    private String getXmlData(String name, String data, boolean withTag) throws Exception {
        String closer = "</" + name + ">";
        String tag = "<" + name;
        if (data == null) {
            StringBuffer sb = new StringBuffer();
            try {
                while (this.line.indexOf(tag) < 0) {
                    this.line = this.br.readLine();
                }
            }
            catch (Exception e) {
                return null;
            }
            sb.append(this.line);
            while (this.line.indexOf(closer) < 0) {
                this.line = this.br.readLine();
                sb.append(this.line);
            }
            data = sb.toString();
        }
        int pt1 = data.indexOf(tag);
        int pt2 = data.indexOf(closer);
        if (pt1 >= 0 && !withTag) {
            pt1 = data.indexOf(">", pt1) + 1;
            while (Character.isWhitespace(data.charAt(pt1))) {
                ++pt1;
            }
        }
        if (pt1 < 0 || pt1 > pt2) {
            return "";
        }
        return data.substring(pt1, pt2);
    }

    public Point3f[] jvxlDecodeVertexData(String data, boolean asArray) {
        int[] next = new int[1];
        JvxlReader.setNext(data, "count", next, 2);
        int vertexCount = Parser.parseInt(data, next);
        if (!asArray) {
            Logger.info("Reading " + vertexCount + " vertices");
        }
        next[0] = next[0] + 1;
        Point3f min = new Point3f();
        Point3f range = new Point3f();
        JvxlReader.setNext(data, "min", next, 3);
        min.x = Parser.parseFloat(data, next);
        next[0] = next[0] + 1;
        min.y = Parser.parseFloat(data, next);
        next[0] = next[0] + 1;
        min.z = Parser.parseFloat(data, next);
        JvxlReader.setNext(data, "max", next, 3);
        range.x = Parser.parseFloat(data, next) - min.x;
        next[0] = next[0] + 1;
        range.y = Parser.parseFloat(data, next) - min.y;
        next[0] = next[0] + 1;
        range.z = Parser.parseFloat(data, next) - min.z;
        int colorFractionBase = this.jvxlData.colorFractionBase;
        int colorFractionRange = this.jvxlData.colorFractionRange;
        int ptCount = vertexCount * 3;
        Point3f[] vertices = asArray ? new Point3f[vertexCount] : null;
        Point3f p = asArray ? null : new Point3f();
        JvxlReader.setNext(data, ">", next, 0);
        int pt = next[0];
        while (Character.isWhitespace(data.charAt(pt))) {
            ++pt;
        }
        --pt;
        for (int i = 0; i < vertexCount; ++i) {
            if (asArray) {
                p = vertices[i] = new Point3f();
            }
            float fraction = JvxlReader.jvxlFractionFromCharacter2(data.charAt(++pt), data.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
            p.x = min.x + fraction * range.x;
            fraction = JvxlReader.jvxlFractionFromCharacter2(data.charAt(++pt), data.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
            p.y = min.y + fraction * range.y;
            fraction = JvxlReader.jvxlFractionFromCharacter2(data.charAt(++pt), data.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
            p.z = min.z + fraction * range.z;
            if (asArray) continue;
            this.addVertexCopy(p, 0.0f, i);
        }
        return vertices;
    }

    int[][] jvxlDecodeTriangleData(String data, String colorData, boolean asArray) {
        int[] next = new int[1];
        int[] nextc = new int[1];
        int nColors = colorData == null ? -1 : 0;
        int color = 0;
        JvxlReader.setNext(data, "count", next, 2);
        int nData = Parser.parseInt(data, next);
        if (!asArray) {
            Logger.info("Reading " + nData + " triangles");
        }
        int[][] triangles = asArray ? new int[nData][3] : (int[][])null;
        int[] triangle = asArray ? triangles[0] : new int[3];
        int ilast = 0;
        int p = 0;
        int b0 = 92;
        JvxlReader.setNext(data, ">", next, -1);
        int pt = next[0];
        int i = 0;
        block5: while (i < nData) {
            int idiff;
            char ch = data.charAt(++pt);
            switch (ch) {
                case '!': {
                    idiff = 0;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '+': 
                case ',': 
                case '.': {
                    continue block5;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    next[0] = pt;
                    idiff = Parser.parseInt(data, next);
                    pt = next[0] - 1;
                    break;
                }
                default: {
                    idiff = ch - b0;
                }
            }
            ilast += idiff;
            if (asArray) {
                triangles[i][p] = ilast;
            } else {
                triangle[p] = ilast;
            }
            if (++p % 3 != 0) continue;
            ++i;
            p = 0;
            if (asArray) continue;
            if (nColors >= 0) {
                if (nColors == 0) {
                    nColors = Parser.parseInt(colorData, nextc);
                    color = Parser.parseInt(colorData, nextc);
                    if (color == Integer.MIN_VALUE) {
                        nColors = 0;
                        color = 0;
                    }
                }
                --nColors;
            }
            this.addTriangleCheck(triangle[0], triangle[1], triangle[2], 7, false, color);
        }
        return triangles;
    }

    private static String getXmlAttrib(String data, String what) {
        int[] next = new int[1];
        int pt = JvxlReader.setNext(data, what, next, 2);
        if (pt < 2) {
            return "";
        }
        int pt1 = JvxlReader.setNext(data, "\"", next, -1);
        return pt1 <= 0 ? "" : data.substring(pt, pt1);
    }

    private static int setNext(String data, String what, int[] next, int offset) {
        next[0] = data.indexOf(what, next[0]) + what.length() + offset;
        return next[0];
    }
}

