/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.LimitedLineReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Parser;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected BinaryDocument binarydoc;
    String line;
    int[] next = new int[1];

    SurfaceFileReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg);
        this.br = br;
    }

    static String determineFileType(BufferedReader bufferedReader) {
        LimitedLineReader br = new LimitedLineReader(bufferedReader, 16000);
        String line = br.info();
        if (line.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (line.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (line.indexOf("&plot") == 0) {
            return "Jaguar";
        }
        if (line.indexOf("!NTITLE") >= 0 || line.indexOf("REMARKS ") >= 0) {
            return "Xplor";
        }
        if (line.indexOf("MAP ") == 208) {
            return "MRC" + line.substring(67, 68);
        }
        if (line.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (line.indexOf("PM\u0001\u0000") == 0) {
            return "Pmesh";
        }
        line = br.readNonCommentLine();
        if (line.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] tokens = Parser.getTokens(line);
        line = br.readNonCommentLine();
        if (tokens.length == 2 && Parser.parseInt(tokens[0]) == 3 && Parser.parseInt(tokens[1]) != Integer.MIN_VALUE && (tokens = Parser.getTokens(line)).length == 3 && Parser.parseInt(tokens[0]) != Integer.MIN_VALUE && Parser.parseInt(tokens[1]) != Integer.MIN_VALUE && Parser.parseInt(tokens[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        line = br.readNonCommentLine();
        int nAtoms = Parser.parseInt(line);
        if (nAtoms == Integer.MIN_VALUE) {
            return line.indexOf("+") == 0 ? "Jvxl+" : "UNKNOWN";
        }
        if (nAtoms >= 0) {
            return "Cube";
        }
        nAtoms = -nAtoms;
        int i = 4 + nAtoms;
        while (--i >= 0) {
            line = br.readNonCommentLine();
            if (line != null) continue;
            return "UNKNOWN";
        }
        int nSurfaces = Parser.parseInt(line);
        if (nSurfaces == Integer.MIN_VALUE) {
            return "UNKNOWN";
        }
        return nSurfaces < 0 ? "Jvxl" : "Cube";
    }

    void discardTempData(boolean discardAll) {
        try {
            if (this.br != null) {
                this.br.close();
            }
            if (this.binarydoc != null) {
                this.binarydoc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.discardTempData(discardAll);
    }

    String[] getTokens() {
        return Parser.getTokens(this.line, 0);
    }

    float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    float parseFloat(String s) {
        this.next[0] = 0;
        return Parser.parseFloat(s, this.next);
    }

    int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    int parseInt(String s) {
        this.next[0] = 0;
        return Parser.parseInt(s, this.next);
    }

    int parseIntNext(String s) {
        return Parser.parseInt(s, this.next);
    }

    protected void skipTo(String info, String what) throws Exception {
        if (info != null) {
            while ((this.line = this.br.readLine()).indexOf(info) < 0) {
            }
        }
        if (what != null) {
            this.next[0] = this.line.indexOf(what) + what.length() + 2;
        }
    }
}

