/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.ApbsReader;
import org.jmol.jvxl.readers.CubeReader;
import org.jmol.jvxl.readers.EfvetReader;
import org.jmol.jvxl.readers.IsoFxyReader;
import org.jmol.jvxl.readers.IsoFxyzReader;
import org.jmol.jvxl.readers.IsoMOReader;
import org.jmol.jvxl.readers.IsoMepReader;
import org.jmol.jvxl.readers.IsoPlaneReader;
import org.jmol.jvxl.readers.IsoShapeReader;
import org.jmol.jvxl.readers.IsoSolventReader;
import org.jmol.jvxl.readers.JaguarReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.MrcBinaryReader;
import org.jmol.jvxl.readers.ObjReader;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.PltFormattedReader;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.jvxl.readers.XplorReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;

public class SurfaceGenerator {
    private ColorEncoder colorEncoder;
    private JvxlData jvxlData;
    private MeshData meshData;
    private Parameters params;
    private VolumeData volumeData;
    private MeshDataServer meshDataServer;
    private AtomDataServer atomDataServer;
    private MarchingSquares marchingSquares;
    private String version;
    private String fileType;
    SurfaceReader surfaceReader;
    int colorPtr;
    private boolean rangeDefined;
    final Vector3f vAC = new Vector3f();
    final Vector3f vAB = new Vector3f();
    final Vector3f vNorm = new Vector3f();
    final Point3f ptRef = new Point3f(0.0f, 0.0f, 1.0E15f);

    public void setVersion(String version) {
        this.version = version;
    }

    public SurfaceGenerator() {
        this.setup(null, null, null, null, null);
    }

    public SurfaceGenerator(AtomDataServer atomDataServer, MeshDataServer meshDataServer, ColorEncoder colorEncoder, MeshData meshData, JvxlData jvxlData) {
        this.setup(atomDataServer, meshDataServer, colorEncoder, meshData, jvxlData);
    }

    private void setup(AtomDataServer atomDataServer, MeshDataServer meshDataServer, ColorEncoder colorEncoder, MeshData meshData, JvxlData jvxlData) {
        this.atomDataServer = atomDataServer;
        this.meshDataServer = meshDataServer;
        this.params = new Parameters();
        this.colorEncoder = colorEncoder == null ? new ColorEncoder() : colorEncoder;
        this.meshData = meshData == null ? new MeshData() : meshData;
        this.jvxlData = jvxlData == null ? new JvxlData() : jvxlData;
        this.volumeData = new VolumeData();
        this.initializeIsosurface();
    }

    public boolean isStateDataRead() {
        return this.params.state == 2;
    }

    MeshDataServer getMeshDataServer() {
        return this.meshDataServer;
    }

    AtomDataServer getAtomDataServer() {
        return this.atomDataServer;
    }

    ColorEncoder getColorEncoder() {
        return this.colorEncoder;
    }

    public void setJvxlData(JvxlData jvxlData) {
        this.jvxlData = jvxlData;
        if (jvxlData != null) {
            jvxlData.version = this.version;
        }
    }

    public JvxlData getJvxlData() {
        return this.jvxlData;
    }

    MeshData getMeshData() {
        return this.meshData;
    }

    void setMarchingSquares(MarchingSquares marchingSquares) {
        this.marchingSquares = marchingSquares;
    }

    MarchingSquares getMarchingSquares() {
        return this.marchingSquares;
    }

    public Parameters getParams() {
        return this.params;
    }

    public String getScript() {
        return this.params.script;
    }

    public String[] getTitle() {
        return this.params.title;
    }

    public BitSet getBsSelected() {
        return this.params.bsSelected;
    }

    public BitSet getBsIgnore() {
        return this.params.bsIgnore;
    }

    public Vector getFunctionXYinfo() {
        return this.params.functionXYinfo;
    }

    VolumeData getVolumeData() {
        return this.volumeData;
    }

    public Point4f getPlane() {
        return this.params.thePlane;
    }

    public int getColor(int which) {
        switch (which) {
            case -1: {
                return this.params.colorNeg;
            }
            case 1: {
                return this.params.colorPos;
            }
        }
        return 0;
    }

    public void setModelIndex(int modelIndex) {
        this.params.modelIndex = modelIndex;
    }

    public boolean getIUseBitSets() {
        return this.params.iUseBitSets;
    }

    public boolean getIAddGridPoints() {
        return this.params.iAddGridPoints;
    }

    public boolean getIsPositiveOnly() {
        return this.params.isPositiveOnly;
    }

    public boolean isInsideOut() {
        return this.params.insideOut;
    }

    public float getCutoff() {
        return this.params.cutoff;
    }

    public Hashtable getMoData() {
        return this.params.moData;
    }

    public boolean isCubeData() {
        return this.jvxlData.wasCubic;
    }

    public boolean setParameter(String propertyName, Object value) {
        return this.setParameter(propertyName, value, null);
    }

    public boolean setParameter(String propertyName, Object value, BitSet bs) {
        if ("debug" == propertyName) {
            boolean TF;
            this.params.logMessages = TF = ((Boolean)value).booleanValue();
            this.params.logCube = TF;
            return true;
        }
        if ("init" == propertyName) {
            this.initializeIsosurface();
            this.params.script = (String)value;
            return false;
        }
        if ("finalize" == propertyName) {
            this.initializeIsosurface();
            return true;
        }
        if ("commandOption" == propertyName) {
            String s = " # " + (String)value;
            if (this.params.script.indexOf(s) < 0) {
                this.params.script = this.params.script + s;
            }
            return true;
        }
        if ("clear" == propertyName) {
            if (this.surfaceReader != null) {
                this.surfaceReader.discardTempData(true);
            }
            return false;
        }
        if ("fileIndex" == propertyName) {
            this.params.fileIndex = (Integer)value;
            if (this.params.fileIndex < 1) {
                this.params.fileIndex = 1;
            }
            this.params.readAllData = false;
            return true;
        }
        if ("blockData" == propertyName) {
            this.params.blockCubeData = (Boolean)value;
            return true;
        }
        if ("bsSolvent" == propertyName) {
            this.params.bsSolvent = (BitSet)value;
            return true;
        }
        if ("propertySmoothing" == propertyName) {
            this.params.propertySmoothing = (Boolean)value;
            return true;
        }
        if ("title" == propertyName) {
            if (value == null) {
                this.params.title = null;
                return true;
            }
            if (value instanceof String[]) {
                this.params.title = (String[])value;
                for (int i = 0; i < this.params.title.length; ++i) {
                    if (this.params.title[i].length() <= 0) continue;
                    Logger.info(this.params.title[i]);
                }
            }
            return true;
        }
        if ("cutoff" == propertyName) {
            this.params.cutoff = ((Float)value).floatValue();
            this.params.isPositiveOnly = false;
            return true;
        }
        if ("cutoffPositive" == propertyName) {
            this.params.cutoff = ((Float)value).floatValue();
            this.params.isPositiveOnly = true;
            return true;
        }
        if ("cappingPlane" == propertyName) {
            this.params.cappingPlane = (Point4f)value;
            this.params.doCapIsosurface = this.params.cappingPlane != null;
            return true;
        }
        if ("select" == propertyName) {
            this.params.bsSelected = (BitSet)value;
            return true;
        }
        if ("ignore" == propertyName) {
            this.params.bsIgnore = (BitSet)value;
            return true;
        }
        if ("scale" == propertyName) {
            this.params.scale = ((Float)value).floatValue();
            return true;
        }
        if ("angstroms" == propertyName) {
            this.params.isAngstroms = true;
            return true;
        }
        if ("resolution" == propertyName) {
            float resolution = ((Float)value).floatValue();
            this.params.resolution = resolution > 0.0f ? resolution : Float.MAX_VALUE;
            return true;
        }
        if ("downsample" == propertyName) {
            int rate = (Integer)value;
            this.params.downsampleFactor = rate >= 0 ? rate : 0;
            return true;
        }
        if ("anisotropy" == propertyName) {
            if ((this.params.dataType & 0x20) == 0) {
                this.params.setAnisotropy((Point3f)value);
            }
            return true;
        }
        if ("eccentricity" == propertyName) {
            this.params.setEccentricity((Point4f)value);
            return true;
        }
        if ("addHydrogens" == propertyName) {
            this.params.addHydrogens = (Boolean)value;
            return true;
        }
        if ("squareData" == propertyName) {
            this.params.isSquared = (Boolean)value;
            return true;
        }
        if ("gridPoints" == propertyName) {
            this.params.iAddGridPoints = true;
            return true;
        }
        if ("atomIndex" == propertyName) {
            this.params.atomIndex = (Integer)value;
            return true;
        }
        if ("remappable" == propertyName) {
            this.params.remappable = true;
            return true;
        }
        if ("insideOut" == propertyName) {
            this.params.insideOut = true;
            return true;
        }
        if ("sign" == propertyName) {
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.colorPtr = 0;
            return true;
        }
        if ("colorRGB" == propertyName) {
            int rgb;
            this.params.colorPos = this.params.colorPosLCAO = (rgb = ((Integer)value).intValue());
            if (this.colorPtr++ == 0) {
                this.params.colorNeg = this.params.colorNegLCAO = rgb;
            }
            return true;
        }
        if ("rangeAll" == propertyName) {
            this.params.rangeAll = true;
            return true;
        }
        if ("red" == propertyName) {
            this.params.valueMappedToRed = ((Float)value).floatValue();
            return true;
        }
        if ("blue" == propertyName) {
            this.params.valueMappedToBlue = ((Float)value).floatValue();
            this.params.rangeDefined = true;
            this.params.rangeAll = false;
            return true;
        }
        if ("reverseColor" == propertyName) {
            this.params.isColorReversed = true;
            return true;
        }
        if ("setColorScheme" == propertyName) {
            String colorScheme = (String)value;
            if (colorScheme.equals("sets")) {
                propertyName = "mapColor";
            } else {
                this.colorEncoder.setColorScheme(colorScheme);
                if (this.surfaceReader != null && this.params.state == 3) {
                    this.surfaceReader.applyColorScale();
                }
                return true;
            }
        }
        if ("center" == propertyName) {
            this.params.center.set((Point3f)value);
            return true;
        }
        if ("withinDistance" == propertyName) {
            this.params.distance = ((Float)value).floatValue();
            return true;
        }
        if ("withinPoint" == propertyName) {
            this.params.point = (Point3f)value;
            return true;
        }
        if ("progressive" == propertyName) {
            this.params.isXLowToHigh = true;
            return true;
        }
        if ("phase" == propertyName) {
            String color = (String)value;
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.params.colorByPhase = true;
            this.params.colorPhase = SurfaceReader.getColorPhaseIndex(color);
            if (this.params.colorPhase < 0) {
                Logger.warn(" invalid color phase: " + color);
                this.params.colorPhase = 0;
            }
            boolean bl = this.params.colorByPhase = this.params.colorPhase != 0;
            if (this.params.state >= 2) {
                this.params.dataType = this.params.surfaceType;
                this.params.state = 3;
                this.params.isBicolorMap = true;
                this.surfaceReader.applyColorScale();
            }
            return true;
        }
        boolean useIonic = "ionicRadius" == propertyName;
        if (useIonic || "vdwRadius" == propertyName) {
            this.params.setRadius(useIonic, ((Float)value).floatValue());
            return true;
        }
        if ("envelopeRadius" == propertyName) {
            this.params.envelopeRadius = ((Float)value).floatValue();
            return true;
        }
        if ("cavityRadius" == propertyName) {
            this.params.cavityRadius = ((Float)value).floatValue();
            return true;
        }
        if ("cavity" == propertyName) {
            this.params.isCavity = true;
            return true;
        }
        if ("pocket" == propertyName) {
            this.params.pocket = (Boolean)value;
            return true;
        }
        if ("minset" == propertyName) {
            this.params.minSet = (Integer)value;
            return true;
        }
        if ("maxset" == propertyName) {
            this.params.maxSet = (Integer)value;
            return true;
        }
        if ("plane" == propertyName) {
            this.params.setPlane((Point4f)value);
            return true;
        }
        if ("contour" == propertyName) {
            this.params.isContoured = true;
            int n = (Integer)value;
            if (n == 0) {
                this.params.nContours = 9;
            } else if (n > 0) {
                this.params.nContours = n;
            } else {
                this.params.thisContour = -n;
            }
            return true;
        }
        if ("property" == propertyName) {
            this.params.dataType = 181;
            this.params.theProperty = (float[])value;
            this.mapSurface(null);
            return true;
        }
        if ("sphere" == propertyName) {
            this.params.setSphere(((Float)value).floatValue());
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("ellipsoid" == propertyName) {
            if (value instanceof Point4f) {
                this.params.setEllipsoid((Point4f)value);
            } else if (value instanceof float[]) {
                this.params.setEllipsoid((float[])value);
            } else {
                return true;
            }
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("ellipsoid3" == propertyName) {
            this.params.setEllipsoid((float[])value);
            this.surfaceReader = new IsoShapeReader(this, this.params.distance);
            this.generateSurface();
            return true;
        }
        if ("lobe" == propertyName) {
            this.params.setLobe((Point4f)value);
            this.surfaceReader = new IsoShapeReader(this, 3, 2, 0, 15.0f);
            this.generateSurface();
            return true;
        }
        if ("hydrogenOrbital" == propertyName) {
            if (!this.params.setAtomicOrbital((float[])value)) {
                return true;
            }
            this.surfaceReader = new IsoShapeReader(this, this.params.psi_n, this.params.psi_l, this.params.psi_m, this.params.psi_Znuc);
            this.processState();
            return true;
        }
        if ("functionXY" == propertyName) {
            this.params.setFunctionXY((Vector)value);
            if (this.params.isContoured) {
                this.volumeData.setPlaneParameters(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            if (((String)this.params.functionXYinfo.get(0)).indexOf("_xyz") >= 0) {
                this.getFunctionZfromXY();
            }
            this.processState();
            return true;
        }
        if ("functionXYZ" == propertyName) {
            this.params.setFunctionXYZ((Vector)value);
            this.processState();
            return true;
        }
        if ("lcaoType" == propertyName) {
            this.params.setLcao((String)value, this.colorPtr);
            return true;
        }
        if ("lcaoCartoonCenter" == propertyName) {
            if (++this.params.state != 2) {
                return true;
            }
            if (this.params.center.x == Float.MAX_VALUE) {
                this.params.center.set((Vector3f)value);
            }
            return false;
        }
        if ("molecular" == propertyName || "solvent" == propertyName || "sasurface" == propertyName || "nomap" == propertyName) {
            this.params.setSolvent(propertyName, ((Float)value).floatValue());
            Logger.info(this.params.calculationType);
            if (this.params.state < 2) {
                this.params.cutoff = 0.0f;
            }
            this.processState();
            return true;
        }
        if ("moData" == propertyName) {
            this.params.moData = (Hashtable)value;
            return true;
        }
        if ("mep" == propertyName) {
            this.params.setMep((float[])value, this.rangeDefined);
            this.processState();
            return true;
        }
        if ("charges" == propertyName) {
            this.params.theProperty = (float[])value;
            return true;
        }
        if ("molecularOrbital" == propertyName) {
            int iMo = (Integer)value;
            this.params.setMO(iMo, this.rangeDefined);
            Logger.info(this.params.calculationType);
            this.processState();
            return true;
        }
        if ("fileType" == propertyName) {
            this.fileType = (String)value;
            return true;
        }
        if ("fileName" == propertyName) {
            this.params.fileName = (String)value;
            return true;
        }
        if ("readFile" == propertyName) {
            this.surfaceReader = this.setFileData(value);
            if (this.surfaceReader == null) {
                Logger.error("Could not set the data");
                return true;
            }
            this.generateSurface();
            return true;
        }
        if ("mapColor" == propertyName) {
            if (value instanceof String && ((String)value).equalsIgnoreCase("sets")) {
                if (this.meshDataServer == null) {
                    this.meshData.getSurfaceSet(0);
                } else {
                    this.meshDataServer.fillMeshData(this.meshData, 1);
                    this.meshData.getSurfaceSet(0);
                    this.meshDataServer.fillMeshData(this.meshData, 3);
                }
                this.params.colorBySets = true;
            } else {
                this.surfaceReader = this.setFileData(value);
                if (this.surfaceReader == null) {
                    Logger.error("Could not set the mapping data");
                    return true;
                }
            }
            this.mapSurface(value);
            return true;
        }
        return false;
    }

    private void processState() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (this.params.state >= 2) {
            this.mapSurface(null);
        } else {
            this.generateSurface();
        }
    }

    private boolean setReader() {
        if (this.surfaceReader != null) {
            return !this.surfaceReader.vertexDataOnly;
        }
        switch (this.params.dataType) {
            case 180: {
                this.surfaceReader = new IsoPlaneReader(this);
                break;
            }
            case 171: 
            case 172: 
            case 179: 
            case 181: {
                this.surfaceReader = new IsoSolventReader(this);
                break;
            }
            case 301: {
                this.surfaceReader = new IsoMOReader(this);
                break;
            }
            case 518: {
                this.surfaceReader = new IsoFxyReader(this);
                break;
            }
            case 7: {
                this.surfaceReader = new IsoFxyzReader(this);
                break;
            }
            case 304: {
                this.surfaceReader = new IsoMepReader(this);
            }
        }
        return true;
    }

    private void generateSurface() {
        boolean haveMeshDataServer;
        if (++this.params.state != 2) {
            return;
        }
        this.setReader();
        boolean bl = haveMeshDataServer = this.meshDataServer != null;
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.surfaceReader == null) {
            Logger.error("surfaceReader is null for " + this.params.dataType);
            return;
        }
        if (!this.surfaceReader.createIsosurface(false)) {
            Logger.error("Could not create isosurface");
            return;
        }
        if (this.params.pocket != null && haveMeshDataServer) {
            this.surfaceReader.selectPocket(this.params.pocket == false);
        }
        if (this.params.minSet > 0) {
            this.surfaceReader.excludeMinimumSet();
        }
        if (this.params.maxSet > 0) {
            this.surfaceReader.excludeMaximumSet();
        }
        if (haveMeshDataServer) {
            this.meshDataServer.notifySurfaceGenerationCompleted();
        }
        if (this.jvxlData.jvxlDataIs2dContour) {
            this.surfaceReader.colorIsosurface();
            this.params.state = 3;
        }
        if (this.params.colorBySign || this.params.isBicolorMap) {
            this.params.state = 3;
            this.surfaceReader.applyColorScale();
        }
        this.surfaceReader.jvxlUpdateInfo();
        this.setMarchingSquares(this.surfaceReader.marchingSquares);
        this.surfaceReader.discardTempData(false);
        this.params.mappedDataMin = Float.MAX_VALUE;
        if (this.surfaceReader.hasColorData) {
            this.colorIsosurface();
        }
        this.surfaceReader = null;
    }

    private void mapSurface(Object value) {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (++this.params.state != 3) {
            return;
        }
        if (!this.setReader()) {
            return;
        }
        this.params.doCapIsosurface = false;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
            this.surfaceReader.createIsosurface(true);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            if (this.params.dataType == 180) {
                this.surfaceReader.discardTempData(true);
                return;
            }
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        } else if (!this.params.colorBySets) {
            this.surfaceReader.readVolumeParameters();
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        }
        this.colorIsosurface();
    }

    void colorIsosurface() {
        this.surfaceReader.colorIsosurface();
        this.surfaceReader.jvxlUpdateInfo();
        this.surfaceReader.updateTriangles();
        this.surfaceReader.discardTempData(true);
        if (this.meshDataServer != null) {
            this.meshDataServer.notifySurfaceMappingCompleted();
        }
    }

    public Object getProperty(String property, int index) {
        if (property == "jvxlFileData") {
            return JvxlReader.jvxlGetFile(this.meshDataServer, this.jvxlData, null, this.params.title, "", true, index, null, null);
        }
        if (property == "jvxlFileInfo") {
            return this.jvxlData.jvxlInfoLine;
        }
        return null;
    }

    private SurfaceReader setFileData(Object value) {
        String fileType = this.fileType;
        this.fileType = null;
        if (value instanceof VolumeData) {
            this.volumeData = (VolumeData)value;
            return new VolumeDataReader(this);
        }
        if (value instanceof Hashtable) {
            this.volumeData = (VolumeData)((Hashtable)value).get("volumeData");
            return new VolumeDataReader(this);
        }
        BufferedReader br = (BufferedReader)value;
        if (fileType == null) {
            fileType = SurfaceFileReader.determineFileType(br);
        }
        Logger.info("data file type was determined to be " + fileType);
        if (fileType.equals("Jvxl+")) {
            return new JvxlReader(this, br);
        }
        if (fileType.equals("Jvxl")) {
            return new JvxlReader(this, br);
        }
        if (fileType.equals("Apbs")) {
            return new ApbsReader(this, br);
        }
        if (fileType.equals("Cube")) {
            return new CubeReader(this, br);
        }
        if (fileType.equals("Jaguar")) {
            return new JaguarReader(this, br);
        }
        if (fileType.equals("Xplor")) {
            return new XplorReader(this, br);
        }
        if (fileType.equals("PltFormatted")) {
            return new PltFormattedReader(this, br);
        }
        if (fileType.startsWith("MRC")) {
            br = null;
            return new MrcBinaryReader(this, this.params.fileName, fileType.charAt(3) != '\u0000');
        }
        if (fileType.equals("Efvet")) {
            return new EfvetReader(this, br);
        }
        if (fileType.equals("Pmesh")) {
            return new PmeshReader(this, this.params.fileName, br);
        }
        if (fileType.equals("Obj")) {
            return new ObjReader(this, this.params.fileName, br);
        }
        return null;
    }

    void initializeIsosurface() {
        this.params.initialize();
        this.colorPtr = 0;
        this.surfaceReader = null;
        this.marchingSquares = null;
        this.initState();
    }

    public void initState() {
        this.params.state = 1;
        this.params.surfaceType = 0;
        this.params.dataType = 0;
    }

    public String setLcao() {
        this.params.colorPos = this.params.colorPosLCAO;
        this.params.colorNeg = this.params.colorNegLCAO;
        return this.params.lcaoType;
    }

    private void getFunctionZfromXY() {
        Point3f origin = (Point3f)this.params.functionXYinfo.get(1);
        int[] counts = new int[3];
        int[] nearest = new int[3];
        Vector3f[] vectors = new Vector3f[3];
        for (int i = 0; i < 3; ++i) {
            Point4f info = (Point4f)this.params.functionXYinfo.get(i + 2);
            counts[i] = Math.abs((int)info.x);
            vectors[i] = new Vector3f(info.y, info.z, info.w);
        }
        int nx = counts[0];
        int ny = counts[1];
        Point3f pt = new Point3f();
        Point3f pta = new Point3f();
        Point3f ptb = new Point3f();
        Point3f ptc = new Point3f();
        float[][] data = (float[][])this.params.functionXYinfo.get(5);
        float[][] data2 = new float[nx][ny];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                pt.scaleAdd(i, vectors[0], origin);
                pt.scaleAdd(j, vectors[1], pt);
                float dist = SurfaceGenerator.findNearestThreePoints(pt.x, pt.y, data, nearest);
                float[] d = data[nearest[0]];
                pta.set(d[0], d[1], d[2]);
                if ((double)dist < 1.0E-5) {
                    pt.z = d[2];
                } else {
                    d = data[nearest[1]];
                    ptb.set(d[0], d[1], d[2]);
                    d = data[nearest[2]];
                    ptc.set(d[0], d[1], d[2]);
                    pt.z = this.distanceVerticalToPlane(pt.x, pt.y, pta, ptb, ptc);
                }
                data2[i][j] = pt.z;
            }
        }
        this.params.functionXYinfo.setElementAt(data2, 5);
    }

    private float distanceVerticalToPlane(float x, float y, Point3f pta, Point3f ptb, Point3f ptc) {
        float d = Graphics3D.getDirectedNormalThroughPoints(pta, ptb, ptc, this.ptRef, this.vNorm, this.vAB, this.vAC);
        return (this.vNorm.x * x + this.vNorm.y * y + d) / -this.vNorm.z;
    }

    private static float findNearestThreePoints(float x, float y, float[][] xyz, int[] result) {
        int i3 = -1;
        int i2 = -1;
        int i1 = -1;
        float dist3 = Float.MAX_VALUE;
        float dist2 = Float.MAX_VALUE;
        float dist1 = Float.MAX_VALUE;
        int i = xyz.length;
        while (--i >= 0) {
            float d = xyz[i][0] - x;
            float f = d * d;
            d = xyz[i][1] - y;
            if ((d = f + d * d) < dist1) {
                dist3 = dist2;
                dist2 = dist1;
                dist1 = d;
                i3 = i2;
                i2 = i1;
                i1 = i;
                continue;
            }
            if (d < dist2) {
                dist3 = dist2;
                dist2 = d;
                i3 = i2;
                i2 = i;
                continue;
            }
            if (!(d < dist3)) continue;
            dist3 = d;
            i3 = i;
        }
        result[0] = i1;
        result[1] = i2;
        result[2] = i3;
        return dist1;
    }
}

