/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;

public abstract class SurfaceReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected ColorEncoder colorEncoder;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    protected VolumeData volumeData;
    private String edgeData;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private float assocCutoff = 0.3f;
    boolean vertexDataOnly;
    boolean hasColorData;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    private int edgeCount;
    protected Point3f volumetricOrigin;
    protected Vector3f[] volumetricVectors;
    protected int[] voxelCounts;
    protected float[][][] voxelData;
    protected int nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected boolean isApbsDx;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected StringBuffer jvxlFileHeaderBuffer;
    protected StringBuffer fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected BitSet jvxlVoxelBitSet;
    protected Vector[] vContours;
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected float jvxlCutoff;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN;
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    private MarchingCubes marchingCubes;
    protected final Point3f ptTemp = new Point3f();
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};

    SurfaceReader(SurfaceGenerator sg) {
        this.sg = sg;
        this.colorEncoder = sg.getColorEncoder();
        this.params = sg.getParams();
        this.marchingSquares = sg.getMarchingSquares();
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.meshData = sg.getMeshData();
        this.jvxlData = sg.getJvxlData();
        this.setVolumeData(sg.getVolumeData());
        this.meshDataServer = sg.getMeshDataServer();
        this.cJvxlEdgeNaN = (char)125;
    }

    void setVolumeData(VolumeData v) {
        this.nBytes = 0;
        this.volumetricOrigin = v.volumetricOrigin;
        this.volumetricVectors = v.volumetricVectors;
        this.voxelCounts = v.voxelCounts;
        this.voxelData = v.voxelData;
        this.volumeData = v;
    }

    abstract boolean readVolumeParameters();

    abstract boolean readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        JvxlReader.jvxlUpdateInfo(this.jvxlData, this.params.title, this.nBytes);
    }

    boolean createIsosurface(boolean justForPlane) {
        this.resetIsosurface();
        if (!this.readVolumeParameters()) {
            return false;
        }
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.jvxlData.insideOut = this.params.insideOut;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        if (justForPlane) {
            float[][][] voxelDataTemp = this.volumeData.voxelData;
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1);
            }
            this.params.setMapRanges(this);
            this.generateSurfaceData();
            this.volumeData.voxelData = voxelDataTemp;
        } else {
            if (!this.readVolumeData(false)) {
                return false;
            }
            this.generateSurfaceData();
        }
        String s = this.jvxlFileHeaderBuffer.toString();
        int i = s.indexOf(10, s.indexOf(10, s.indexOf(10) + 1) + 1) + 1;
        this.jvxlData.jvxlFileTitle = s.substring(0, i);
        this.jvxlData.jvxlFileHeader = s;
        this.jvxlData.cutoff = this.isJvxl ? this.jvxlCutoff : this.params.cutoff;
        this.jvxlData.pointsPerAngstrom = 1.0f / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.edgeData;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.vContours = this.vContours;
        if (this.vContours != null) {
            this.params.nContours = this.vContours.length;
        }
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.vertexDataOnly = this.vertexDataOnly;
        if (this.jvxlDataIsColorMapped) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1);
                this.meshDataServer.fillMeshData(this.meshData, 2);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceMappingCompleted();
            }
        }
        this.jvxlData.jvxlExtraLine = JvxlReader.jvxlExtraLine(this.jvxlData, 1);
        return true;
    }

    void resetIsosurface() {
        this.meshData.clear("isosurface");
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Float.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    void discardTempData(boolean discardAll) {
        if (!discardAll) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.setMarchingSquares(null);
        this.marchingCubes = null;
    }

    protected void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.volumeData.setUnitVectors();
        this.setVolumeData(this.volumeData);
    }

    protected abstract void readSurfaceData(boolean var1) throws Exception;

    protected boolean gotoAndReadVoxelData(boolean isMapData) {
        this.initializeVolumetricData();
        if (this.nPointsX > 0 && this.nPointsY > 0 && this.nPointsZ > 0) {
            try {
                this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
                this.readSurfaceData(isMapData);
            }
            catch (Exception e) {
                Logger.error(e.toString());
                return false;
            }
        }
        return true;
    }

    protected void gotoData(int n, int nPoints) throws Exception {
    }

    protected String readColorData() {
        return "";
    }

    public float getValue(int x, int y, int z) {
        return this.volumeData.voxelData[x][y][z];
    }

    private void generateSurfaceData() {
        this.edgeData = "";
        if (this.vertexDataOnly) {
            try {
                this.readSurfaceData(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error("Exception in SurfaceReader::readSurfaceData: " + e.getMessage());
            }
            return;
        }
        this.contourVertexCount = 0;
        int contourType = -1;
        this.marchingSquares = null;
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            contourType = this.marchingSquares.getContourType();
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.jvxlVoxelBitSet, this.params.isContoured, contourType, this.params.cutoff, this.params.isCutoffAbsolute, this.params.isSquared, this.isXLowToHigh);
        this.edgeData = this.marchingCubes.getEdgeData();
        JvxlReader.setSurfaceInfoFromBitSet(this.jvxlData, this.marchingCubes.getBsVoxels(), this.params.thePlane);
        if (this.isJvxl) {
            this.edgeData = this.jvxlEdgeDataRead;
        }
    }

    public int getSurfacePointIndexAndFraction(float cutoff, boolean isCutoffAbsolute, int x, int y, int z, Point3i offset, int vA, int vB, float valueA, float valueB, Point3f pointA, Vector3f edgeVector, boolean isContourType, float[] fReturn) {
        int assocVertex;
        float thisValue = this.getSurfacePointAndFraction(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, fReturn, this.ptTemp);
        if (this.marchingSquares != null && this.params.isContoured) {
            return isContourType ? this.marchingSquares.addContourVertex(x, y, z, offset, this.ptTemp, cutoff) : Integer.MAX_VALUE;
        }
        int n = this.assocCutoff > 0.0f ? (fReturn[0] < this.assocCutoff ? vA : (fReturn[0] > 1.0f - this.assocCutoff ? vB : -1)) : (assocVertex = -1);
        if (assocVertex >= 0) {
            assocVertex = this.marchingCubes.getLinearOffset(x, y, z, assocVertex);
        }
        int n2 = this.addVertexCopy(this.ptTemp, thisValue, assocVertex);
        if (this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(x, y, z, vB, this.ptTemp);
            this.addVertexCopy(valueA < valueB ? pointA : this.ptTemp, Float.NaN, -3);
            this.addVertexCopy(valueA < valueB ? this.ptTemp : pointA, Float.NaN, -3);
        }
        return n2;
    }

    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, Point3f pointA, Vector3f edgeVector, float[] fReturn, Point3f ptReturn) {
        float diff = valueB - valueA;
        float fraction = (cutoff - valueA) / diff;
        if (isCutoffAbsolute && (fraction < 0.0f || fraction > 1.0f)) {
            fraction = (-cutoff - valueA) / diff;
        }
        if (fraction < 0.0f || fraction > 1.0f) {
            fraction = Float.NaN;
        }
        fReturn[0] = fraction;
        ptReturn.scaleAdd(fraction, edgeVector, pointA);
        return valueA + fraction * diff;
    }

    public int addVertexCopy(Point3f vertexXYZ, float value, int assocVertex) {
        if (this.meshDataServer == null) {
            return this.meshData.addVertexCopy(vertexXYZ, value, assocVertex);
        }
        return this.meshDataServer.addVertexCopy(vertexXYZ, value, assocVertex);
    }

    public void addTriangleCheck(int iA, int iB, int iC, int check, boolean isAbsolute, int color) {
        if (this.meshDataServer == null) {
            if (isAbsolute && !MeshData.checkCutoff(iA, iB, iC, this.meshData.vertexValues)) {
                return;
            }
            this.meshData.addTriangleCheck(iA, iB, iC, check, color);
        } else {
            this.meshDataServer.addTriangleCheck(iA, iB, iC, check, isAbsolute, color);
        }
    }

    void colorIsosurface() {
        if (this.params.isSquared) {
            this.volumeData.filterData(true, Float.NaN);
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1);
        }
        if (this.params.isContoured && this.marchingSquares != null) {
            this.params.setMapRanges(this);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.jvxlExtraLine = JvxlReader.jvxlExtraLine(this.jvxlData, 1);
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        boolean useMeshDataValues;
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vertexColixes = new short[this.meshData.vertexCount];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1);
            this.meshDataServer.fillMeshData(this.meshData, 2);
        }
        this.params.setMapRanges(this);
        boolean saveColorData = this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        this.jvxlData.isJvxlPrecisionColor = true;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign) {
            this.jvxlData.minColorIndex = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
            this.jvxlData.maxColorIndex = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        boolean bl = useMeshDataValues = this.vertexDataOnly || this.params.isBicolorMap && !this.params.isContoured;
        if (!useMeshDataValues) {
            int i = this.meshData.vertexCount;
            while (--i >= 0) {
                float value = this.params.colorBySets ? (float)this.meshData.vertexSets[i] : (this.params.colorByPhase ? this.getPhase(this.meshData.vertices[i]) : (this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(this.meshData.vertices[i]) : this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vertices[i])));
                this.meshData.vertexValues[i] = value;
            }
        }
        this.colorData();
        JvxlReader.jvxlCreateColorData(this.jvxlData, saveColorData ? this.meshData.vertexValues : null);
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3);
        }
    }

    private void colorData() {
        float[] vertexValues = this.meshData.vertexValues;
        short[] vertexColixes = this.meshData.vertexColixes;
        this.meshData.polygonColixes = null;
        float valueBlue = this.jvxlData.valueMappedToBlue;
        float valueRed = this.jvxlData.valueMappedToRed;
        short minColorIndex = this.jvxlData.minColorIndex;
        short maxColorIndex = this.jvxlData.maxColorIndex;
        int i = this.meshData.vertexCount;
        while (--i >= 0) {
            float value = vertexValues[i];
            if (minColorIndex >= 0) {
                if (value <= 0.0f) {
                    vertexColixes[i] = minColorIndex;
                    continue;
                }
                if (!(value > 0.0f)) continue;
                vertexColixes[i] = maxColorIndex;
                continue;
            }
            if (value < valueRed) {
                value = valueRed;
            }
            if (value >= valueBlue) {
                value = valueBlue;
            }
            vertexColixes[i] = this.getColorIndexFromPalette(value);
        }
        if (this.params.nContours > 0) {
            int n = this.params.nContours;
            this.jvxlData.contourColors = new int[n];
            int[] colors = this.jvxlData.contourColors;
            float dv = (valueBlue - valueRed) / (float)(n + 1);
            for (int i2 = 0; i2 < n; ++i2) {
                colors[i2] = this.getArgbFromPalette(valueRed + (float)(i2 + 1) * dv);
            }
        }
    }

    static int getColorPhaseIndex(String color) {
        int colorPhase = -1;
        int i = colorPhases.length;
        while (--i >= 0) {
            if (!color.equalsIgnoreCase(colorPhases[i])) continue;
            colorPhase = i;
            break;
        }
        return colorPhase;
    }

    private float getPhase(Point3f pt) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return pt.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return pt.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return pt.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return pt.x * pt.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return pt.y * pt.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return pt.x * pt.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return pt.z * pt.z * 2.0f - pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    float getMinMappedValue() {
        if (this.params.colorBySets) {
            return 0.0f;
        }
        int vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        Point3f[] vertexes = this.meshData.vertices;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < vertexCount; ++i) {
            float challenger = this.vertexDataOnly ? this.meshData.vertexValues[i] : (this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(vertexes[i]) : this.volumeData.lookupInterpolatedVoxelValue(vertexes[i]));
            if (!(challenger < min)) continue;
            min = challenger;
        }
        return min;
    }

    float getMaxMappedValue() {
        if (this.params.colorBySets) {
            return Math.max(this.meshData.nSets - 1, 0);
        }
        int vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        Point3f[] vertexes = this.meshData.vertices;
        float max = -3.4028235E38f;
        int incr = 1;
        for (int i = 0; i < vertexCount; i += incr) {
            float challenger = this.vertexDataOnly ? this.meshData.vertexValues[i] : (this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(vertexes[i]) : this.volumeData.lookupInterpolatedVoxelValue(vertexes[i]));
            if (challenger == Float.MAX_VALUE) {
                challenger = 0.0f;
            }
            if (!(challenger > max) || challenger == Float.MAX_VALUE) continue;
            max = challenger;
        }
        return max;
    }

    protected short getColorIndexFromPalette(float value) {
        if (this.params.isColorReversed) {
            return this.colorEncoder.getColorIndexFromPalette(-value, -this.params.valueMappedToBlue, -this.params.valueMappedToRed);
        }
        return this.colorEncoder.getColorIndexFromPalette(value, this.params.valueMappedToRed, this.params.valueMappedToBlue);
    }

    protected int getArgbFromPalette(float value) {
        if (this.params.isColorReversed) {
            return this.colorEncoder.getArgbFromPalette(-value, -this.params.valueMappedToBlue, -this.params.valueMappedToRed);
        }
        return this.colorEncoder.getArgbFromPalette(value, this.params.valueMappedToRed, this.params.valueMappedToBlue);
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidateTriangles();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.updateTriangles();
        JvxlReader.jvxlUpdateSurfaceData(this.jvxlData, this.meshData.vertexValues, this.meshData.vertexCount, this.meshData.vertexIncrement, this.cJvxlEdgeNaN);
    }

    public void selectPocket(boolean doExclude) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BitSet bs = this.meshData.surfaceSet[i];
            if (bs == null) continue;
            int n = 0;
            int j = bs.size();
            while (--j >= 0) {
                if (!bs.get(j)) continue;
                ++n;
            }
            if (n >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3);
        }
    }

    void excludeMaximumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BitSet bs = this.meshData.surfaceSet[i];
            if (bs == null) continue;
            int n = 0;
            int j = bs.size();
            while (--j >= 0) {
                if (!bs.get(j)) continue;
                ++n;
            }
            if (n <= this.params.maxSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3);
        }
    }
}

