/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class XplorReader
extends VolumeFileReader {
    int nBlock;
    int linePt = Integer.MAX_VALUE;
    int nRead;

    XplorReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
    }

    protected int readVolumetricHeader() {
        try {
            this.readTitleLines();
            Logger.info(this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            this.readVoxelVectors();
            for (int i = 0; i < 3; ++i) {
                Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
            }
            JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
            return this.readExtraLine();
        }
        catch (Exception e) {
            Logger.error(e.toString());
            throw new NullPointerException();
        }
    }

    protected void readTitleLines() throws Exception {
        int nLines;
        this.jvxlFileHeaderBuffer = new StringBuffer();
        int i = nLines = this.parseInt(this.getLine());
        while (--i >= 0) {
            this.line = this.br.readLine().trim();
            this.jvxlFileHeaderBuffer.append("# ").append(this.line).append('\n');
        }
        this.jvxlFileHeaderBuffer.append("Xplor data\nJmol " + Viewer.getJmolVersion() + '\n');
    }

    protected void readVoxelVectors() throws Exception {
        int nA = this.parseInt(this.getLine());
        int minA = this.parseInt();
        int maxA = this.parseInt();
        int nB = this.parseInt();
        int minB = this.parseInt();
        int maxB = this.parseInt();
        int nC = this.parseInt();
        int minC = this.parseInt();
        int maxC = this.parseInt();
        this.voxelCounts[0] = maxC - minC + 1;
        this.voxelCounts[1] = maxB - minB + 1;
        this.voxelCounts[2] = maxA - minA + 1;
        this.nBlock = this.voxelCounts[2] * this.voxelCounts[1];
        float a = this.parseFloat(this.getLine());
        float b = this.parseFloat();
        float c = this.parseFloat();
        float alpha = this.parseFloat();
        float beta = this.parseFloat();
        float gamma = this.parseFloat();
        SymmetryInterface symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        symmetry.setUnitCell(new float[]{a, b, c, alpha, beta, gamma});
        Point3f pt = new Point3f(0.0f, 0.0f, 1.0f / (float)nC);
        symmetry.toCartesian(pt);
        this.volumetricVectors[0].set(pt);
        pt = new Point3f(0.0f, 1.0f / (float)nB, 0.0f);
        symmetry.toCartesian(pt);
        this.volumetricVectors[1].set(pt);
        pt = new Point3f(1.0f / (float)nA, 0.0f, 0.0f);
        symmetry.toCartesian(pt);
        this.volumetricVectors[2].set(pt);
        this.getLine();
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.atomCount = 0;
        this.negativeAtomCount = false;
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
    }

    private String getLine() throws IOException {
        this.line = this.br.readLine();
        while (this.line != null && (this.line.length() == 0 || this.line.indexOf("REMARKS") >= 0 || this.line.indexOf("XPLOR:") >= 0)) {
            this.line = this.br.readLine();
        }
        return this.line;
    }

    protected float nextVoxel() throws Exception {
        if (this.linePt >= this.line.length()) {
            this.line = this.br.readLine();
            this.linePt = 0;
            if (this.nRead % this.nBlock == 0) {
                System.out.println("block " + this.line);
                this.line = this.br.readLine();
            }
        }
        if (this.line == null) {
            return 0.0f;
        }
        float val = this.parseFloat(this.line.substring(this.linePt, this.linePt + 12));
        this.linePt += 12;
        ++this.nRead;
        return val;
    }
}

