/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.MinimizerInterface;
import org.jmol.i18n.GT;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

public class Minimizer
implements MinimizerInterface {
    public Viewer viewer;
    public Atom[] atoms;
    public MinAtom[] minAtoms;
    public MinBond[] minBonds;
    public BitSet bsMinFixed;
    private int atomCount;
    private int bondCount;
    private int atomCountFull;
    private int[] atomMap;
    public int[][] angles;
    public int[][] torsions;
    public double[] partialCharges;
    private int steps = 50;
    private double crit = 0.001;
    private static Vector atomTypes;
    private ForceField pFF;
    private String ff = "UFF";
    private BitSet bsTaint;
    private BitSet bsSelected;
    private BitSet bsAtoms;
    private BitSet bsFixed;
    public Vector constraints;
    Hashtable constraintMap;
    static final int TOKEN_ELEMENT_ONLY = 0;
    static final int TOKEN_ELEMENT_CHARGED = 1;
    static final int TOKEN_ELEMENT_CONNECTED = 2;
    static final int TOKEN_ELEMENT_AROMATIC = 3;
    static final int TOKEN_ELEMENT_SP = 4;
    static final int TOKEN_ELEMENT_SP2 = 5;
    static final int PT_ELEMENT = 2;
    static final int PT_CHARGE = 5;
    static final int PT_CONNECT = 6;
    static final Token[][] tokenTypes;
    boolean minimizationOn;
    private MinimizationThread minimizationThread;
    double[][] coordSaved;

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("cancel")) {
            this.stopMinimization(false);
            return;
        }
        if (propertyName.equals("clear")) {
            this.stopMinimization(false);
            this.clear();
            return;
        }
        if (propertyName.equals("constraint")) {
            this.addConstraint((Object[])value);
            return;
        }
        if (propertyName.equals("fixed")) {
            this.bsFixed = (BitSet)value;
            return;
        }
        if (propertyName.equals("stop")) {
            this.stopMinimization(true);
            return;
        }
        if (propertyName.equals("viewer")) {
            this.viewer = (Viewer)value;
            return;
        }
    }

    public Object getProperty(String propertyName, int param) {
        if (propertyName.equals("log")) {
            return this.pFF == null ? "" : this.pFF.getLogData();
        }
        return null;
    }

    private void addConstraint(Object[] c) {
        String id;
        Object[] c1;
        if (c == null) {
            return;
        }
        int[] atoms = (int[])c[0];
        int nAtoms = atoms[0];
        if (nAtoms == 0) {
            this.constraints = null;
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Vector();
            this.constraintMap = new Hashtable();
        }
        if (atoms[1] > atoms[nAtoms]) {
            ArrayUtil.swap(atoms, 1, nAtoms);
            if (nAtoms == 4) {
                ArrayUtil.swap(atoms, 2, 3);
            }
        }
        if ((c1 = (Object[])this.constraintMap.get(id = Escape.escape(atoms))) != null) {
            c1[2] = c[2];
            return;
        }
        this.constraintMap.put(id, c);
        this.constraints.addElement(c);
    }

    private void clear() {
        this.setMinimizationOn(false);
        this.atomCount = 0;
        this.bondCount = 0;
        this.atoms = null;
        this.viewer = null;
        this.minAtoms = null;
        this.minBonds = null;
        this.angles = null;
        this.torsions = null;
        this.partialCharges = null;
        this.coordSaved = null;
        this.atomMap = null;
        this.bsTaint = null;
        this.bsAtoms = null;
        this.bsFixed = null;
        this.bsMinFixed = null;
        this.bsSelected = null;
        this.constraints = null;
        this.constraintMap = null;
        this.pFF = null;
    }

    public boolean minimize(int steps, double crit, BitSet bsSelected) {
        Object val;
        if (this.minimizationOn) {
            return false;
        }
        if (steps == Integer.MAX_VALUE && (val = this.viewer.getParameter("minimizationSteps")) != null && val instanceof Integer) {
            steps = (Integer)val;
        }
        this.steps = steps;
        if (crit <= 0.0 && (val = this.viewer.getParameter("minimizationCriterion")) != null && val instanceof Float) {
            crit = ((Float)val).floatValue();
        }
        this.crit = Math.max(crit, 1.0E-4);
        Logger.info("minimize: initializing (steps = " + steps + " criterion = " + crit + ") ...");
        this.getForceField();
        if (this.pFF == null) {
            Logger.error(GT._("Could not get class for force field {0}", this.ff));
            return false;
        }
        if (this.atoms == null) {
            this.atomCountFull = this.viewer.getAtomCount();
            this.atoms = this.viewer.getModelSet().getAtoms();
        }
        this.bsAtoms = BitSetUtil.copy(bsSelected);
        this.atomCount = BitSetUtil.cardinalityOf(this.bsAtoms);
        if (this.atomCount == 0) {
            Logger.error(GT._("No atoms selected -- nothing to do!"));
            return false;
        }
        if (!BitSetUtil.compareBits(bsSelected, this.bsSelected) && !this.setupMinimization()) {
            this.clear();
            return false;
        }
        this.setAtomPositions();
        this.bsSelected = bsSelected;
        if (this.constraints != null) {
            int i = this.constraints.size();
            block0: while (--i >= 0) {
                Object[] constraint = (Object[])this.constraints.elementAt(i);
                int[] aList = (int[])constraint[0];
                int[] minList = (int[])constraint[1];
                int nAtoms = aList[0] = Math.abs(aList[0]);
                for (int j = 1; j <= nAtoms; ++j) {
                    if (steps <= 0 || !this.bsAtoms.get(aList[j])) {
                        aList[0] = -nAtoms;
                        continue block0;
                    }
                    minList[j - 1] = this.atomMap[aList[j]];
                }
            }
        }
        this.pFF.setConstraints(this);
        if (steps > 0 && !this.viewer.useMinimizationThread()) {
            this.minimizeWithoutThread();
        } else if (steps > 0) {
            this.setMinimizationOn(true);
        } else {
            this.getEnergyOnly();
        }
        return true;
    }

    private boolean setupMinimization() {
        int i;
        this.atomMap = new int[this.atomCountFull];
        this.minAtoms = new MinAtom[this.atomCount];
        int elemnoMax = 0;
        BitSet bsElements = new BitSet();
        int pt = 0;
        for (int i2 = 0; i2 < this.atomCountFull; ++i2) {
            Atom atom = this.atoms[i2];
            if (!this.bsAtoms.get(i2)) continue;
            this.atomMap[i2] = pt;
            short atomicNo = this.atoms[i2].getElementNumber();
            elemnoMax = Math.max(elemnoMax, atomicNo);
            bsElements.set(atomicNo);
            this.minAtoms[pt] = new MinAtom(pt, atom, new double[]{atom.x, atom.y, atom.z}, null);
            ++pt;
        }
        Logger.info(GT._("{0} atoms will be minimized.", "" + this.atomCount));
        Logger.info("minimize: creating bonds...");
        Vector<int[]> bondInfo = new Vector<int[]>();
        this.bondCount = 0;
        for (int i3 = 0; i3 < this.atomCountFull; ++i3) {
            Bond[] bonds;
            if (!this.bsAtoms.get(i3) || (bonds = this.atoms[i3].getBonds()) == null) continue;
            for (int j = 0; j < bonds.length; ++j) {
                int i2 = bonds[j].getOtherAtom(this.atoms[i3]).getAtomIndex();
                if (i2 <= i3 || !this.bsAtoms.get(i2)) continue;
                int bondOrder = bonds[j].getOrder();
                switch (bondOrder) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 515: {
                        bondOrder = 5;
                        break;
                    }
                    default: {
                        bondOrder = 1;
                    }
                }
                ++this.bondCount;
                bondInfo.addElement(new int[]{this.atomMap[i3], this.atomMap[i2], bondOrder});
            }
        }
        this.minBonds = new MinBond[this.bondCount];
        for (i = 0; i < this.bondCount; ++i) {
            int[] atomIndexes = (int[])bondInfo.elementAt(i);
            MinBond bond = this.minBonds[i] = new MinBond(atomIndexes, false, false);
            int atom1 = atomIndexes[0];
            int atom2 = atomIndexes[1];
            this.minAtoms[atom1].bonds.addElement(bond);
            this.minAtoms[atom2].bonds.addElement(bond);
            ++this.minAtoms[atom1].nBonds;
            ++this.minAtoms[atom2].nBonds;
        }
        for (i = 0; i < this.atomCount; ++i) {
            int[] atomIndexes = this.minAtoms[i].getBondedAtomIndexes();
        }
        Logger.info("minimize: setting atom types...");
        if (atomTypes == null) {
            atomTypes = this.getAtomTypes();
        }
        if (atomTypes == null) {
            return false;
        }
        int nElements = atomTypes.size();
        bsElements.clear(0);
        for (int i4 = 0; i4 < nElements; ++i4) {
            String[] data = (String[])atomTypes.get(i4);
            String smarts = data[0];
            if (smarts == null) continue;
            BitSet search = this.getSearch(smarts, elemnoMax, bsElements);
            if (bsElements.get(0)) {
                bsElements.clear(0);
                continue;
            }
            if (search == null) break;
            int pt2 = 0;
            for (int j = 0; j < this.atomCountFull; ++j) {
                if (!this.bsAtoms.get(j)) continue;
                if (search.get(j)) {
                    this.minAtoms[pt2].type = data[1];
                }
                ++pt2;
            }
        }
        Logger.info("minimize: getting angles...");
        this.getAngles();
        Logger.info("minimize: getting torsions...");
        this.getTorsions();
        this.pFF.setModel(this);
        if (!this.pFF.setup()) {
            Logger.error(GT._("could not setup force field {0}", this.ff));
            return false;
        }
        if (this.steps > 0) {
            this.bsTaint = BitSetUtil.copy(this.bsAtoms);
            if (this.bsFixed != null) {
                BitSetUtil.andNot(this.bsTaint, this.bsFixed);
            }
            this.viewer.setTaintedAtoms(this.bsTaint, (byte)2);
        }
        return true;
    }

    private void setAtomPositions() {
        int i;
        for (i = 0; i < this.atomCount; ++i) {
            this.minAtoms[i].set();
        }
        this.bsMinFixed = null;
        if (this.bsFixed != null) {
            this.bsMinFixed = new BitSet();
            int pt = 0;
            for (i = 0; i < this.atomCountFull; ++i) {
                if (!this.bsAtoms.get(i)) continue;
                if (this.bsFixed.get(i)) {
                    this.bsMinFixed.set(pt);
                }
                ++pt;
            }
        }
    }

    private BitSet getSearch(String smarts, int elemnoMax, BitSet bsElements) {
        Token[] search = null;
        int len = smarts.length();
        search = tokenTypes[0];
        int n = smarts.charAt(len - 2) - 48;
        int elemNo = 0;
        if (n >= 10) {
            n = 0;
        }
        if (smarts.charAt(1) == '#') {
            elemNo = Parser.parseInt(smarts.substring(2, len - 1));
        } else {
            String s = smarts.substring(1, n > 0 ? len - 3 : len - 1);
            if (s.equals(s.toLowerCase())) {
                s = s.toUpperCase();
                search = tokenTypes[3];
            }
            elemNo = JmolConstants.elementNumberFromSymbol(s);
        }
        if (elemNo > elemnoMax) {
            return null;
        }
        if (!bsElements.get(elemNo)) {
            bsElements.set(0);
            return null;
        }
        switch (smarts.charAt(len - 3)) {
            case 'D': {
                search = tokenTypes[2];
                search[6].intValue = n;
                break;
            }
            case '^': {
                search = tokenTypes[4 + (n - 1)];
                break;
            }
            case '+': {
                search = tokenTypes[1];
                search[5].intValue = n;
            }
        }
        search[2].intValue = elemNo;
        Object v = this.viewer.evaluateExpression(search);
        return v instanceof BitSet ? (BitSet)v : null;
    }

    public void getAngles() {
        Vector<int[]> vAngles = new Vector<int[]>();
        for (int ib = 0; ib < this.atomCount; ++ib) {
            MinAtom atomB = this.minAtoms[ib];
            int n = atomB.nBonds;
            if (n < 2) continue;
            int[] atomList = atomB.getBondedAtomIndexes();
            for (int ia = 0; ia < n - 1; ++ia) {
                for (int ic = ia + 1; ic < n; ++ic) {
                    vAngles.addElement(new int[]{atomList[ia], ib, atomList[ic]});
                }
            }
        }
        this.angles = new int[vAngles.size()][];
        int i = vAngles.size();
        while (--i >= 0) {
            this.angles[i] = (int[])vAngles.elementAt(i);
        }
        Logger.info(this.angles.length + " angles");
    }

    public void getTorsions() {
        Vector<int[]> vTorsions = new Vector<int[]>();
        int i = this.angles.length;
        while (--i >= 0) {
            int id;
            int j;
            int[] atomList;
            int[] angle = this.angles[i];
            int ia = angle[0];
            int ic = angle[2];
            int ib = angle[1];
            if (ic > ib && this.minAtoms[ic].nBonds != 1) {
                atomList = this.minAtoms[ic].getBondedAtomIndexes();
                for (j = 0; j < atomList.length; ++j) {
                    id = atomList[j];
                    if (id == ia || id == ib) continue;
                    vTorsions.addElement(new int[]{ia, ib, ic, id});
                }
            }
            if (ia <= ib || this.minAtoms[ia].nBonds == 1) continue;
            atomList = this.minAtoms[ia].getBondedAtomIndexes();
            for (j = 0; j < atomList.length; ++j) {
                id = atomList[j];
                if (id == ic || id == ib) continue;
                vTorsions.addElement(new int[]{ic, ib, ia, id});
            }
        }
        this.torsions = new int[vTorsions.size()][];
        i = vTorsions.size();
        while (--i >= 0) {
            this.torsions[i] = (int[])vTorsions.elementAt(i);
        }
        Logger.info(this.torsions.length + " torsions");
    }

    public ForceField getForceField() {
        if (this.pFF == null) {
            try {
                String className = this.getClass().getName();
                className = className.substring(0, className.lastIndexOf(".")) + ".forcefield.ForceField" + this.ff;
                Logger.info("minimize: using " + className);
                this.pFF = (ForceField)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("minimize: forcefield = " + this.pFF);
        return this.pFF;
    }

    public Vector getAtomTypes() {
        this.getForceField();
        return this.pFF == null ? null : this.pFF.getAtomTypes();
    }

    private void setMinimizationOn(boolean minimizationOn) {
        this.minimizationOn = minimizationOn;
        if (!minimizationOn) {
            if (this.minimizationThread != null) {
                this.minimizationThread = null;
            }
            return;
        }
        if (this.minimizationThread == null) {
            this.minimizationThread = new MinimizationThread();
            this.minimizationThread.start();
        }
    }

    private void getEnergyOnly() {
        if (this.pFF == null || this.viewer == null) {
            return;
        }
        this.pFF.steepestDescentInitialize(this.steps, this.crit);
        this.viewer.setFloatProperty("_minimizationEnergyDiff", 0.0f);
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setStringProperty("_minimizationStatus", "calculate");
        this.viewer.notifyMinimizationStatus();
    }

    public boolean startMinimization() {
        try {
            Logger.info("minimizer: startMinimization");
            this.viewer.setIntProperty("_minimizationStep", 0);
            this.viewer.setStringProperty("_minimizationStatus", "starting");
            this.viewer.setFloatProperty("_minimizationEnergy", 0.0f);
            this.viewer.setFloatProperty("_minimizationEnergyDiff", 0.0f);
            this.viewer.notifyMinimizationStatus();
            this.viewer.saveCoordinates("minimize", this.bsTaint);
            this.pFF.steepestDescentInitialize(this.steps, this.crit);
            this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
            this.saveCoordinates();
        }
        catch (Exception e) {
            System.out.println("minimization error viwer=" + this.viewer + " pFF = " + this.pFF);
            return false;
        }
        return true;
    }

    boolean stepMinimization() {
        if (!this.minimizationOn) {
            return false;
        }
        boolean doRefresh = this.viewer.getBooleanProperty("minimizationRefresh");
        this.viewer.setStringProperty("_minimizationStatus", "running");
        boolean going = this.pFF.steepestDescentTakeNSteps(1);
        int currentStep = this.pFF.getCurrentStep();
        this.viewer.setIntProperty("_minimizationStep", currentStep);
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setFloatProperty("_minimizationEnergyDiff", (float)this.pFF.getEnergyDiff());
        this.viewer.notifyMinimizationStatus();
        if (doRefresh) {
            this.updateAtomXYZ();
            this.viewer.refresh(3, "minimization step " + currentStep);
        }
        return going;
    }

    void endMinimization() {
        this.updateAtomXYZ();
        this.setMinimizationOn(false);
        boolean failed = this.pFF.detectExplosion();
        if (failed) {
            this.restoreCoordinates();
        }
        this.viewer.setIntProperty("_minimizationStep", this.pFF.getCurrentStep());
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setStringProperty("_minimizationStatus", failed ? "failed" : "done");
        this.viewer.notifyMinimizationStatus();
        this.viewer.refresh(3, "Minimizer:done" + (failed ? " EXPLODED" : "OK"));
        Logger.info("minimizer: endMinimization");
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.atomCount][3];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        if (this.coordSaved == null) {
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
        this.updateAtomXYZ();
    }

    private void stopMinimization(boolean coordAreOK) {
        this.setMinimizationOn(false);
        if (coordAreOK) {
            this.endMinimization();
        } else {
            this.restoreCoordinates();
        }
    }

    void updateAtomXYZ() {
        if (this.steps <= 0) {
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            MinAtom minAtom = this.minAtoms[i];
            Atom atom = minAtom.atom;
            atom.x = (float)minAtom.coord[0];
            atom.y = (float)minAtom.coord[1];
            atom.z = (float)minAtom.coord[2];
        }
        this.viewer.refreshMeasures();
    }

    private void minimizeWithoutThread() {
        if (!this.startMinimization()) {
            return;
        }
        while (this.stepMinimization()) {
        }
        this.endMinimization();
    }

    static {
        tokenTypes = new Token[][]{{Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenAnd, new Token(269484420, 558891272), Token.intToken(0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenAnd, new Token(135268866, "connected"), Token.tokenLeftParen, Token.intToken(0), Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenAnd, new Token(0x100009, "isaromatic"), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenAnd, Token.tokenLeftParen, new Token(135268866, "connected"), Token.tokenLeftParen, Token.intToken(1), Token.tokenComma, new Token(4, "triple"), Token.tokenRightParen, Token.tokenOr, new Token(135268866, "connected"), Token.tokenLeftParen, Token.intToken(2), Token.tokenComma, new Token(4, "double"), Token.tokenRightParen, Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 22020359), Token.intToken(0), Token.tokenAnd, new Token(135268866, "connected"), Token.tokenLeftParen, Token.intToken(1), Token.tokenComma, new Token(4, "double"), Token.tokenRightParen, Token.tokenExpressionEnd}};
    }

    class MinimizationThread
    extends Thread
    implements Runnable {
        MinimizationThread() {
            this.setName("MinimizationThread");
        }

        public void run() {
            block6: {
                long startTime;
                long lastRepaintTime = startTime = System.currentTimeMillis();
                if (!Minimizer.this.startMinimization()) {
                    return;
                }
                try {
                    do {
                        long currentTime;
                        int elapsed;
                        int sleepTime;
                        if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                            Thread.sleep(sleepTime);
                        }
                        lastRepaintTime = currentTime = System.currentTimeMillis();
                        if (!Minimizer.this.stepMinimization()) {
                            Minimizer.this.endMinimization();
                        }
                        elapsed = (int)(currentTime - startTime);
                    } while (Minimizer.this.minimizationOn && !this.isInterrupted());
                }
                catch (Exception e) {
                    if (!Minimizer.this.minimizationOn) break block6;
                    System.out.println(" minimization thread interrupted");
                }
            }
        }
    }
}

