/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;

class BondIteratorSelected
implements BondIterator {
    private Bond[] bonds;
    private int bondCount;
    private short bondType;
    private int iBond;
    private BitSet bsSelected;
    private boolean bondSelectionModeOr;
    private boolean isBondBitSet;

    BondIteratorSelected(Bond[] bonds, int bondCount, short bondType, BitSet bsSelected, boolean bondSelectionModeOr) {
        this.bonds = bonds;
        this.bondCount = bondCount;
        this.bondType = bondType;
        this.bsSelected = bsSelected;
        this.bondSelectionModeOr = bondSelectionModeOr;
        this.isBondBitSet = false;
        this.iBond = 0;
    }

    BondIteratorSelected(Bond[] bonds, int bondCount, BitSet bsSelected) {
        this.bonds = bonds;
        this.bondCount = bondCount;
        this.bsSelected = bsSelected;
        this.isBondBitSet = true;
        this.iBond = 0;
    }

    public boolean hasNext() {
        while (this.iBond < this.bondCount) {
            Bond bond = this.bonds[this.iBond];
            if (this.isBondBitSet) {
                if (this.bsSelected.get(this.iBond)) {
                    return true;
                }
            } else if (this.bondType == 16383 || (bond.order & this.bondType) != 0) {
                boolean isSelected1 = this.bsSelected.get(bond.atom1.atomIndex);
                boolean isSelected2 = this.bsSelected.get(bond.atom2.atomIndex);
                if (!this.bondSelectionModeOr && isSelected1 && isSelected2 || this.bondSelectionModeOr && (isSelected1 || isSelected2)) {
                    return true;
                }
            }
            ++this.iBond;
        }
        return false;
    }

    public int nextIndex() {
        return this.iBond;
    }

    public Bond next() {
        return this.bonds[this.iBond++];
    }
}

