/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;

public final class Chain {
    ModelSet modelSet;
    Model model;
    char chainID;
    int groupCount;
    int selectedGroupCount;
    private boolean isDna;
    private boolean isRna;
    BitSet bsSelectedGroups;
    Group[] groups = new Group[16];

    public Chain(ModelSet modelSet, Model model, char chainID) {
        this.modelSet = modelSet;
        this.model = model;
        this.chainID = chainID;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public char getChainID() {
        return this.chainID;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isDna() {
        return this.isDna;
    }

    public boolean isRna() {
        return this.isRna;
    }

    public void setIsDna(boolean TF) {
        this.isDna = TF;
    }

    public void setIsRna(boolean TF) {
        this.isRna = TF;
    }

    public Group getGroup(int groupIndex) {
        return this.groups[groupIndex];
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getAtomCount() {
        return this.groups[this.groupCount - 1].lastAtomIndex + 1 - this.groups[0].firstAtomIndex;
    }

    public Atom getAtom(int index) {
        return this.modelSet.atoms[index];
    }

    public void calcSelectedGroupsCount(BitSet bsSelected) {
        this.selectedGroupCount = 0;
        if (this.bsSelectedGroups == null) {
            this.bsSelectedGroups = new BitSet();
        }
        BitSetUtil.clear(this.bsSelectedGroups);
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.groups[i].isSelected(bsSelected)) {
                ++this.selectedGroupCount;
                this.groups[i].selectedIndex = this.groups[i].selectedIndex;
                this.bsSelectedGroups.set(i);
                continue;
            }
            this.groups[i].selectedIndex = -1;
        }
    }

    public int selectSeqcodeRange(int index0, int seqcodeA, int seqcodeB, BitSet bs) {
        int indexB;
        int seqcode;
        int i;
        int minDiff;
        int indexA;
        boolean isInexact = false;
        for (indexA = index0; indexA < this.groupCount && this.groups[indexA].seqcode != seqcodeA; ++indexA) {
        }
        if (indexA == this.groupCount) {
            if (index0 > 0) {
                return -1;
            }
            isInexact = true;
            minDiff = Integer.MAX_VALUE;
            i = this.groupCount;
            while (--i >= 0) {
                seqcode = this.groups[i].seqcode;
                if (seqcode <= seqcodeA || seqcode - seqcodeA >= minDiff) continue;
                indexA = i;
                minDiff = seqcode - seqcodeA;
            }
            if (minDiff == Integer.MAX_VALUE) {
                return -1;
            }
        }
        if (seqcodeB == Integer.MAX_VALUE) {
            indexB = this.groupCount - 1;
            isInexact = true;
        } else {
            for (indexB = indexA; indexB < this.groupCount && this.groups[indexB].seqcode != seqcodeB; ++indexB) {
            }
            if (indexB == this.groupCount) {
                if (index0 > 0) {
                    return -1;
                }
                isInexact = true;
                minDiff = Integer.MAX_VALUE;
                for (i = indexA; i < this.groupCount; ++i) {
                    seqcode = this.groups[i].seqcode;
                    if (seqcode >= seqcodeB || seqcodeB - seqcode >= minDiff) continue;
                    indexB = i;
                    minDiff = seqcodeB - seqcode;
                }
                if (minDiff == Integer.MAX_VALUE) {
                    return -1;
                }
            }
        }
        for (i = indexA; i <= indexB; ++i) {
            this.groups[i].selectAtoms(bs);
        }
        return isInexact ? -1 : indexB + 1;
    }

    int getSelectedGroupCount() {
        return this.selectedGroupCount;
    }

    public final void updateOffsetsForAlternativeLocations(BitSet bsSelected, int nAltLocInModel, byte[] offsets, int firstAtomIndex, int lastAtomIndex) {
        String[] atomNames = this.modelSet.getAtomNames();
        int offsetIndex = offsets.length;
        block0: while (--offsetIndex >= 0) {
            int iThis;
            Atom atom;
            int offset = offsets[offsetIndex] & 0xFF;
            if (offset == 255 || (atom = this.getAtom(iThis = firstAtomIndex + offset)).getAlternateLocationID() == '\u0000') continue;
            int nScan = lastAtomIndex - firstAtomIndex;
            for (int i = 1; i <= nScan; ++i) {
                int offsetNew;
                int iNew = iThis + i;
                if (iNew > lastAtomIndex) {
                    iNew -= nScan + 1;
                }
                if ((offsetNew = iNew - firstAtomIndex) < 0 || offsetNew > 255 || iNew == iThis || atomNames[iNew] != atomNames[iThis] || !bsSelected.get(iNew)) continue;
                offsets[offsetIndex] = (byte)offsetNew;
                continue block0;
            }
        }
    }

    public void fixIndices(int atomsDeleted) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].firstAtomIndex -= atomsDeleted;
            this.groups[i].lastAtomIndex -= atomsDeleted;
        }
    }
}

